/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.registry.network.packet;

import com.acheli.registry.network.ACHMessages;
import com.acheli.registry.network.ACHeliPacketType;
import com.acheli.registry.network.ICustomSyncable;
import com.acheli.registry.network.packet.CustomSyncableS2CPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class CustomSyncableC2SPacket {
    private final CompoundTag tag;

    public CustomSyncableC2SPacket(FriendlyByteBuf buf) {
        this.tag = buf.m_130260_();
    }

    public CustomSyncableC2SPacket(int originId, UUID senderUUID, CompoundTag data, ACHeliPacketType packetType) {
        this.tag = data;
        this.tag.m_128405_("originId", originId);
        this.tag.m_128362_("senderUUID", senderUUID);
        this.tag.m_128359_("packetType", packetType.name());
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.tag);
    }

    private boolean handle(Supplier<NetworkEvent.Context> supplier) {
        UUID senderUUID = this.tag.m_128342_("senderUUID");
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerLevel level;
            Entity patt1954$temp;
            ServerPlayer player = context.getSender();
            if (player != null && (patt1954$temp = (level = player.m_284548_()).m_8791_(senderUUID)) instanceof ICustomSyncable) {
                ICustomSyncable syncable = (ICustomSyncable)patt1954$temp;
                ACHeliPacketType packetType = ACHeliPacketType.valueOf(this.tag.m_128461_("packetType"));
                CompoundTag serverTag = syncable.serverReceiveAndSending(this.tag, player, packetType);
                CustomSyncableS2CPacket packet = new CustomSyncableS2CPacket(((Entity)syncable).m_19879_(), serverTag, packetType);
                ACHMessages.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
            }
        });
        return true;
    }

    public static void register(SimpleChannel channel) {
        channel.messageBuilder(CustomSyncableC2SPacket.class, ACHMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(CustomSyncableC2SPacket::new).encoder(CustomSyncableC2SPacket::toBytes).consumerMainThread(CustomSyncableC2SPacket::handle).add();
    }
}

