/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.registry.network.packet;

import com.acheli.registry.event.CustomDynamicEntityPool;
import com.acheli.registry.network.ACHMessages;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class EntityLeaveC2SPacket {
    private final CompoundTag tag;

    public EntityLeaveC2SPacket(FriendlyByteBuf buf) {
        this.tag = buf.m_130260_();
    }

    public EntityLeaveC2SPacket(int entityId) {
        this.tag = new CompoundTag();
        this.tag.m_128405_("entityId", entityId);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.tag);
    }

    private boolean handle(Supplier<NetworkEvent.Context> supplier) {
        int entityId = this.tag.m_128451_("entityId");
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                Entity entity = player.m_9236_().m_6815_(entityId);
                CustomDynamicEntityPool.leave(entity);
            }
        });
        return true;
    }

    public static void register(SimpleChannel channel) {
        channel.messageBuilder(EntityLeaveC2SPacket.class, ACHMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(EntityLeaveC2SPacket::new).encoder(EntityLeaveC2SPacket::toBytes).consumerMainThread(EntityLeaveC2SPacket::handle).add();
    }
}

