/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.registry.network.packet;

import com.acheli.ACHeli;
import com.acheli.registry.config.CustomDataBus;
import com.acheli.registry.event.CustomDynamicEntityPool;
import com.acheli.registry.network.ACHMessages;
import com.acheli.rideable.entites.RideableEntity;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class VehiclePackRloadEventC2SPacket {
    private final CompoundTag tag;

    public VehiclePackRloadEventC2SPacket(FriendlyByteBuf buf) {
        this.tag = buf.m_130260_();
    }

    public VehiclePackRloadEventC2SPacket() {
        this.tag = new CompoundTag();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.tag);
    }

    private boolean handle(Supplier<NetworkEvent.Context> supplier) {
        ACHeli.LOGGER.info("VehiclePackRloadEventC2SPacket");
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            CustomDataBus.load();
            List<Entity> list = CustomDynamicEntityPool.entityMap.get(RideableEntity.class);
            for (Entity entity : list) {
                if (!(entity instanceof RideableEntity)) continue;
                RideableEntity rideableEntity = (RideableEntity)entity;
                rideableEntity.reloadData();
            }
        });
        return true;
    }

    public static void register(SimpleChannel channel) {
        channel.messageBuilder(VehiclePackRloadEventC2SPacket.class, ACHMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(VehiclePackRloadEventC2SPacket::new).encoder(VehiclePackRloadEventC2SPacket::toBytes).consumerMainThread(VehiclePackRloadEventC2SPacket::handle).add();
    }
}

