/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.rideable.entites;

import com.acheli.registry.factories.ACHFactories;
import com.acheli.registry.network.ACHeliPacketType;
import com.acheli.registry.network.ICustomSyncable;
import com.acheli.rideable.entites.ComponentEntity;
import com.acheli.rideable.factory.ACHeliEntitiesFactory;
import com.acheli.rideable.factory.SafetyFactoryProvider;
import com.acheli.rideable.functionLathes.ComponentFL;
import com.acheli.rideable.functionLathes.RideableFL;
import com.acheli.rideable.functionLathes.component.SeatFL;
import com.acheli.utils.rotate.RotateWith;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class RideableEntity
extends Entity
implements ICustomSyncable {
    public ACHeliEntitiesFactory<RideableEntity, RideableFL> factory;
    private boolean renderInitiated = false;
    private boolean haveSetup = false;
    private final RideableEntity thisRideable = this;
    private static final EntityDataAccessor<String> factoryName = SynchedEntityData.m_135353_(RideableEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public RideableEntity(EntityType<?> entityType, Level level, ACHeliEntitiesFactory<RideableEntity, RideableFL> factory) {
        super(entityType, level);
        this.factory = factory;
        this.doFactory(new SafetyFactoryProvider<ACHeliEntitiesFactory<RideableEntity, RideableFL>>(){

            @Override
            public void getFct(ACHeliEntitiesFactory<RideableEntity, RideableFL> factory) {
                factory.getProductFunction().INIT();
            }
        });
    }

    public RideableEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public void setUp() {
        String get = (String)this.f_19804_.m_135370_(factoryName);
        if (!get.isEmpty()) {
            ACHeliEntitiesFactory<?, ?> f = ACHFactories.getFactoryFromMap(get, this);
            this.factory = f;
            if (this.factory != null) {
                this.factory.getProductFunction().INIT();
            }
        }
        this.haveSetup = true;
    }

    public void setUp(String factoryName) {
        ACHeliEntitiesFactory<?, ?> f = ACHFactories.getFactoryFromMap(factoryName, this);
        this.factory = f;
        this.factory.getProductFunction().INIT();
        this.f_19804_.m_135381_(RideableEntity.factoryName, (Object)factoryName);
        this.haveSetup = true;
    }

    public boolean doFactory(SafetyFactoryProvider<ACHeliEntitiesFactory<RideableEntity, RideableFL>> factoryProvider) {
        boolean notNull;
        boolean bl = notNull = this.factory != null;
        if (notNull) {
            factoryProvider.getFct(this.factory);
        }
        return notNull;
    }

    public boolean m_6783_(final double distance) {
        this.doFactory(new SafetyFactoryProvider<ACHeliEntitiesFactory<RideableEntity, RideableFL>>(){

            @Override
            public void getFct(ACHeliEntitiesFactory<RideableEntity, RideableFL> factory) {
                factory.getProductFunction().renderDistance(distance);
            }
        });
        return super.m_6783_(distance);
    }

    public boolean shouldRender() {
        return this.doFactory(new SafetyFactoryProvider<ACHeliEntitiesFactory<RideableEntity, RideableFL>>(){

            @Override
            public void getFct(ACHeliEntitiesFactory<RideableEntity, RideableFL> factory) {
                factory.getProductFunction().shouldRender();
            }
        });
    }

    public void reloadData() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.haveSetup) {
            this.setUp();
        }
        this.doFactory(new SafetyFactoryProvider<ACHeliEntitiesFactory<RideableEntity, RideableFL>>(){

            @Override
            public void getFct(ACHeliEntitiesFactory<RideableEntity, RideableFL> factory) {
                if (!RideableEntity.this.renderInitiated) {
                    factory.getProductFunction().getFL().requestMountComponents(RideableEntity.this.thisRideable);
                }
                RideableEntity.this.renderInitiated = true;
                factory.getProductFunction().tick();
            }
        });
    }

    public void m_6074_() {
        for (Entity entity : this.m_20197_().stream().toList()) {
            entity.m_6074_();
        }
        super.m_6074_();
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        boolean hasSet = false;
        if (passenger instanceof ComponentEntity) {
            ComponentEntity componentEntity = (ComponentEntity)passenger;
            Quaternionf totalRotation = this.factory.getProductFunction().getFL().totalRotation;
            componentEntity.setRotation(RotateWith.translateRotation(totalRotation));
            ComponentFL componentFL = componentEntity.getComponentFL();
            if (componentFL != null) {
                componentFL.setVehicle(this);
                Entity everyPassenger = componentEntity.m_146895_();
                if (everyPassenger != null) {
                    RotateWith.rotateEntity(everyPassenger, totalRotation);
                }
                Vec3 pos = componentFL.getRelativePosition();
                double eyeH = componentFL instanceof SeatFL ? (double)1.62f : 0.0;
                Vec3 resultRelativePos = RotateWith.rotatePoint((double)componentFL.pivotX() + pos.f_82479_, (double)componentFL.pivotY() + pos.f_82480_ + eyeH, (double)componentFL.pivotZ() + pos.f_82481_, totalRotation);
                resultRelativePos = new Vec3(resultRelativePos.f_82479_, resultRelativePos.f_82480_ - eyeH, resultRelativePos.f_82481_);
                callback.m_20372_((Entity)componentEntity, this.m_20182_().f_82479_ + resultRelativePos.f_82479_, this.m_20182_().f_82480_ + resultRelativePos.f_82480_, this.m_20182_().f_82481_ + resultRelativePos.f_82481_);
                hasSet = true;
            }
        }
        if (!hasSet) {
            super.m_19956_(passenger, callback);
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean m_271807_() {
        return true;
    }

    public boolean m_6097_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    @NotNull
    public InteractionResult m_6096_(final Player player, final InteractionHand hand) {
        this.doFactory(new SafetyFactoryProvider<ACHeliEntitiesFactory<RideableEntity, RideableFL>>(){

            @Override
            public void getFct(ACHeliEntitiesFactory<RideableEntity, RideableFL> factory) {
                factory.getProductFunction().interact(player, hand);
            }
        });
        return super.m_6096_(player, hand);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(factoryName, (Object)"");
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128441_("factoryName")) {
            this.f_19804_.m_135381_(factoryName, (Object)pCompound.m_128461_("factoryName"));
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128359_("factoryName", (String)this.f_19804_.m_135370_(factoryName));
    }

    @Override
    public CompoundTag serverReceiveAndSending(CompoundTag serverOriginNbt, ServerPlayer executingPlayer, ACHeliPacketType packetType) {
        if (this.factory != null) {
            return this.factory.getProductFunction().serverReceiveAndSending(serverOriginNbt, executingPlayer, packetType);
        }
        return null;
    }

    @Override
    public void clientReceive(CompoundTag receivedNbt, boolean fromSelf, ACHeliPacketType packetType) {
        if (this.factory != null) {
            this.factory.getProductFunction().clientReceive(receivedNbt, fromSelf, packetType);
        }
    }
}

