/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.rideable.factory.instance;

import com.acheli.registry.entity.model.OBJModelRegistry;
import com.acheli.registry.keybind.KeyBinding;
import com.acheli.registry.network.ACHMessages;
import com.acheli.registry.network.ACHeliPacketType;
import com.acheli.registry.network.packet.CustomSyncableC2SPacket;
import com.acheli.rideable.entites.RideableEntity;
import com.acheli.rideable.factory.ACHeliEntitiesFactory;
import com.acheli.rideable.functionLathes.ComponentFL;
import com.acheli.rideable.functionLathes.EntityFLProvider;
import com.acheli.rideable.functionLathes.RideableFL;
import com.acheli.rideable.functionLathes.component.SeatFL;
import com.acheli.rideable.functionLathes.component.TestFL;
import com.acheli.rideable.functionLathes.component.engine.EngineFL;
import com.acheli.rideable.functionLathes.component.engine.ModTestEngine;
import com.acheli.rideable.functionLathes.component.propeller.PropellerBase;
import com.acheli.rideable.functionLathes.component.stabilizer.StabilizerBase;
import com.acheli.utils.air.Aerodynamics;
import com.acheli.utils.math.angle.AbstractAngle;
import com.acheli.utils.math.angle.Angle;
import com.acheli.utils.physics.PhysicsEngine;
import com.acheli.utils.rotate.EntityDirectionUtils;
import com.acheli.utils.rotate.RotateWith;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class UH_1D_SAR
extends ACHeliEntitiesFactory<RideableEntity, RideableFL> {
    public static ItemStack completeItemStack = new ItemStack((ItemLike)OBJModelRegistry.uh_1d_body.get());

    public UH_1D_SAR(RideableEntity entity) {
        super(entity, new Func(new RideableFL()));
    }

    private static class Func
    extends EntityFLProvider<RideableEntity, RideableFL> {
        double[] testing = new double[]{0.0, 0.0, 0.0};
        int chosenIndex = 0;
        Vec3 lastPos;
        double speed = 0.0;
        PropellerBase mainPropeller = new PropellerBase("mainPropeller", (RideableEntity)this.cachedEntity, new Vec3(0.0, 4.7, 0.0), new Angle(0.01, new Angle(0.28), new Angle(0.01)));
        SeatFL seat = new SeatFL("seat01", (RideableEntity)this.cachedEntity, true, 90.0, ComponentFL.Orientation.North, new Vec3(0.8, 1.035, 4.3), 1.0, 1.0, 1.0);
        TestFL testFL = new TestFL("test", (RideableEntity)this.cachedEntity, new Vec3(0.0, -20.0, 0.0), 1.0, 1.0, 1.0);
        EngineFL engine = new ModTestEngine((RideableEntity)this.cachedEntity, "engine", new Vec3(0.0, 2.7, -1.6));

        public Func(RideableFL fl) {
            super(fl);
        }

        @Override
        public void INIT() {
            super.INIT();
            ((RideableFL)this.fl).setMass(300.0);
            ((RideableFL)this.fl).pivotPos = new Vec3(-0.1, 1.0, 0.5);
            this.engine.setRelativeAABB(0.7, 1.1, 2.6);
            this.engine.setMass(500.0);
            this.mainPropeller.setRelativeAABB(20.0, 0.2, 20.0);
            this.mainPropeller.setMass(100.0);
            ((RideableFL)this.fl).addComponent(this.mainPropeller);
            ((RideableFL)this.fl).addComponent(this.seat);
            ((RideableFL)this.fl).addComponent(this.testFL);
            ((RideableFL)this.fl).addComponent(this.engine);
            ((RideableFL)this.fl).addComponent(new StabilizerBase("vertical_stabilizer", (RideableEntity)this.cachedEntity, new Vec3(0.0, 2.8, -17.0), 0.03, 2.0, 1.0));
            ((RideableFL)this.fl).addComponent(new StabilizerBase("horizontal_stabilizer", (RideableEntity)this.cachedEntity, new Vec3(0.0, 1.8, -12.0), 4.0, 0.03, 0.7));
            ((RideableFL)this.fl).rideablePhysicsObject.setMass(((RideableFL)this.fl).getMass());
            ((RideableFL)this.fl).rideablePhysicsObject.setCurrentPos(((RideableEntity)this.cachedEntity).m_20182_());
        }

        @Override
        public void tick() {
            super.tick();
            this.mainPropeller.setRevolutionSpeed(this.engine.getRevolutionSpeed());
            if (((RideableEntity)this.cachedEntity).m_9236_().f_46443_) {
                CompoundTag nbt = new CompoundTag();
                Vec3 pos = ((RideableEntity)this.cachedEntity).m_20182_();
                nbt.m_128347_("x", pos.f_82479_);
                nbt.m_128347_("y", pos.f_82480_);
                nbt.m_128347_("z", pos.f_82481_);
                ACHMessages.sendToServer(new CustomSyncableC2SPacket(((RideableEntity)this.cachedEntity).m_19879_(), ((RideableEntity)this.cachedEntity).m_20148_(), nbt, ACHeliPacketType.Active));
            }
            ((RideableEntity)this.cachedEntity).m_6478_(MoverType.SELF, ((RideableEntity)this.cachedEntity).m_20184_());
        }

        @Override
        public void renderTick(PoseStack matrices, float tickDelta) {
            super.renderTick(matrices, tickDelta);
            RideableFL fl = (RideableFL)this.fl;
            Quaternionf target = fl.totalRotation;
            target.rotateY((float)fl.totalYMomentum);
            target.rotateX((float)fl.totalXMomentum);
            target.rotateZ((float)fl.totalZMomentum);
            fl.totalRotation.slerp((Quaternionfc)target, 0.1f * tickDelta);
            double dragRatio = 2.0E-7 * this.speed;
            double rotateRatio = 0.998 * this.revRatio();
            double rotateYawRatio = 0.998;
            if (((RideableEntity)this.cachedEntity).m_20096_()) {
                double groundDragRatio = 0.99;
                ((RideableEntity)this.cachedEntity).m_20256_(((RideableEntity)this.cachedEntity).m_20184_().m_82542_(groundDragRatio, 1.0, groundDragRatio));
                target.rotateZ((float)(-(Math.toDegrees(EntityDirectionUtils.getRoll(fl.totalRotation)) / 77.0)));
                target.rotateX((float)(-(Math.toDegrees(EntityDirectionUtils.getPitch(fl.totalRotation)) / 77.0)));
                rotateYawRatio *= 0.3;
            }
            fl.totalYMomentum *= rotateYawRatio;
            fl.totalXMomentum *= rotateRatio;
            fl.totalZMomentum *= rotateRatio;
            double liftForceNum = this.mainPropeller.getForce().f_82480_;
            Vec3 liftDirection = EntityDirectionUtils.getUpDirection(RotateWith.translateForRiseRotation(fl.totalRotation));
            liftDirection = new Vec3(liftDirection.m_7096_(), liftDirection.m_7098_(), liftDirection.m_7094_());
            Vec3 outputForce = Vec3.f_82478_;
            Vec3 dragForce = Vec3.f_82478_;
            Vec3 gravity = new Vec3(0.0, 230.0, 0.0);
            Vec3 v = ((RideableEntity)this.cachedEntity).m_20184_();
            this.speed = v.m_82553_() * 100.0;
            Vec3 horizontalVelocity = v.m_82542_(1.0, 0.0, 1.0);
            double horizontalSpeed = horizontalVelocity.m_82553_() * 100.0;
            float attackRadians = Aerodynamics.getAngleOfAttack(v, RotateWith.translateForRiseRotation(fl.totalRotation));
            double attackAngle = Math.toDegrees(attackRadians);
            double upDownRatio = Math.cos(attackRadians);
            double noAttackRatio = 1.0;
            if (horizontalSpeed > 30.0) {
                noAttackRatio = 1.212 - Math.abs(upDownRatio);
            }
            if (horizontalSpeed > 50.0) {
                noAttackRatio = 1.3 - Math.abs(upDownRatio);
            }
            if (horizontalSpeed > 90.0) {
                noAttackRatio = 1.34 - Math.abs(upDownRatio);
            }
            if (horizontalSpeed > 150.0) {
                noAttackRatio = 1.37 - Math.abs(upDownRatio);
            }
            Vec3 liftForce = liftDirection.m_82559_(PhysicsEngine.every(liftForceNum * noAttackRatio));
            Vec3 f1 = liftForce.m_82546_(gravity);
            Vec3 nowPos = ((RideableEntity)this.cachedEntity).m_20182_();
            if (this.lastPos != null) {
                dragForce = EntityDirectionUtils.getDirectionVector(this.lastPos, nowPos);
                dragForce = dragForce.m_82559_(PhysicsEngine.every(dragRatio));
            }
            this.lastPos = nowPos;
            outputForce = outputForce.m_82549_(f1);
            outputForce = outputForce.m_82549_(dragForce);
            Vec3 attackAngleLiftForce = Aerodynamics.calculateLift(v, fl.totalRotation).m_82559_(PhysicsEngine.every(2.0));
            Vec3 attackAngleDragForce = Vec3.f_82478_;
            attackAngleDragForce = upDownRatio > 0.0 ? Aerodynamics.calculateDrag(v, fl.totalRotation).m_82559_(PhysicsEngine.every(100.0)) : Aerodynamics.calculateDrag(v, fl.totalRotation).m_82559_(PhysicsEngine.every(70.0));
            outputForce = outputForce.m_82549_(attackAngleLiftForce);
            outputForce = outputForce.m_82549_(attackAngleDragForce);
            if (upDownRatio > 0.0) {
                outputForce = outputForce.m_82546_(dragForce.m_82559_(PhysicsEngine.every(this.speed * 13.7 * upDownRatio)));
            } else {
                double vortexRatio = 1.0;
                outputForce = outputForce.m_82546_(liftForce.m_82559_(PhysicsEngine.every(0.005 + this.speed / 30.0)).m_82559_(PhysicsEngine.every(vortexRatio * upDownRatio * this.revRatio())));
                outputForce = outputForce.m_82546_(dragForce.m_82559_(PhysicsEngine.every(7.0 + this.speed / 70.0)).m_82559_(PhysicsEngine.every(vortexRatio * upDownRatio * this.revRatio())));
            }
            fl.rideablePhysicsObject.setCurrentForce(outputForce);
            fl.rideablePhysicsObject.setCurrentVelocity(((RideableEntity)this.cachedEntity).m_20184_());
            fl.rideablePhysicsObject.physicsObjTick(30.0f / (float)Minecraft.m_91087_().m_260875_());
            Vec3 velocity = fl.rideablePhysicsObject.getCurrentVelocity(((RideableEntity)this.cachedEntity).m_20184_());
            if (!fl.rideablePhysicsObject.getDisabled()) {
                ((RideableEntity)this.cachedEntity).m_20256_(velocity);
            }
        }

        public void bladeChange(float delta) {
            AbstractAngle angle = this.mainPropeller.getAttackAngle();
            angle.setAngle(new Angle(angle.getAngleNum() + (double)delta));
            this.mainPropeller.setAttackAngle(angle);
        }

        public void bladeSet(float num) {
            float real = (float)(this.mainPropeller.getAttackAngle().getUpperLimit().getAngleNum() * (double)num);
            AbstractAngle angle = this.mainPropeller.getAttackAngle();
            angle.setAngle(new Angle(real));
            this.mainPropeller.setAttackAngle(angle);
        }

        @Override
        public void keyEvent() {
            if (KeyBinding.ENGINE_BUTTON_RIGHT.m_90857_()) {
                this.engine.engineSwitch();
            }
            if (KeyBinding.CYCLIC_PUSH.m_90857_()) {
                ((RideableFL)this.getFL()).totalZMomentum += 2.0E-4;
            }
            if (KeyBinding.CYCLIC_PULL.m_90857_()) {
                ((RideableFL)this.getFL()).totalZMomentum -= 2.0E-4;
            }
            if (KeyBinding.CYCLIC_LEFT.m_90857_()) {
                ((RideableFL)this.getFL()).totalXMomentum += 2.0E-4;
            }
            if (KeyBinding.CYCLIC_RIGHT.m_90857_()) {
                ((RideableFL)this.getFL()).totalXMomentum -= 2.0E-4;
            }
            if (KeyBinding.RUDDER_LEFT.m_90857_()) {
                ((RideableFL)this.getFL()).totalYMomentum += 2.0E-4;
            }
            if (KeyBinding.RUDDER_RIGHT.m_90857_()) {
                ((RideableFL)this.getFL()).totalYMomentum -= 2.0E-4;
            }
            if (KeyBinding.COLLECTIVE_UP.m_90857_()) {
                this.bladeChange(0.001f);
            }
            if (KeyBinding.COLLECTIVE_DOWN.m_90857_()) {
                this.bladeChange(-0.001f);
            }
            if (KeyBinding.TEST_X.m_90857_()) {
                this.chosenIndex = 0;
            }
            if (KeyBinding.TEST_Y.m_90857_()) {
                this.chosenIndex = 1;
            }
            if (KeyBinding.TEST_Z.m_90857_()) {
                this.chosenIndex = 2;
            }
            if (KeyBinding.TEST_DOWN.m_90857_()) {
                int n = this.chosenIndex;
                this.testing[n] = this.testing[n] - 0.1;
            }
            if (KeyBinding.TEST_UP.m_90857_()) {
                int n = this.chosenIndex;
                this.testing[n] = this.testing[n] + 0.1;
            }
        }

        public Vec3 getTestPos() {
            Vec3 pos = new Vec3(this.testing[0], this.testing[1], this.testing[2]);
            if (((RideableEntity)this.cachedEntity).m_9236_().f_46443_) {
                Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)("testPos: " + pos)));
            }
            return pos;
        }

        public double revRatio() {
            double maxRev = this.engine.getMaximumRevSpeed();
            double propellerRev = this.mainPropeller.getRevolutionSpeed();
            return propellerRev / maxRev;
        }

        @Override
        public void interact(Player player, InteractionHand hand) {
        }

        @Override
        public CompoundTag serverReceiveAndSending(CompoundTag serverOriginNbt, ServerPlayer executingPlayer, ACHeliPacketType packetType) {
            if (packetType == ACHeliPacketType.Active) {
                ((RideableEntity)this.cachedEntity).m_6034_(serverOriginNbt.m_128459_("x"), serverOriginNbt.m_128459_("y"), serverOriginNbt.m_128459_("z"));
            }
            return super.serverReceiveAndSending(serverOriginNbt, executingPlayer, packetType);
        }

        @Override
        public void clientReceive(CompoundTag receivedNbt, boolean fromSelf, ACHeliPacketType packetType) {
            super.clientReceive(receivedNbt, fromSelf, packetType);
        }

        @Override
        public void render(EntityRendererProvider.Context context, RideableEntity entity, float yaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
            ItemRenderer itemRenderer = context.m_174025_();
            poseStack.m_85841_(1.8f, 1.8f, 1.8f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            ((RideableFL)this.fl).applyRotation(poseStack);
            super.render(context, entity, yaw, partialTick, poseStack, buffer, packedLight);
            poseStack.m_252880_(((RideableFL)this.fl).pivotX(), ((RideableFL)this.fl).pivotY(), ((RideableFL)this.fl).pivotZ());
            itemRenderer.m_269128_(completeItemStack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.f_118083_, poseStack, buffer, entity.m_9236_(), 0);
            poseStack.m_252880_(-((RideableFL)this.fl).pivotX(), -((RideableFL)this.fl).pivotY(), -((RideableFL)this.fl).pivotZ());
        }
    }
}

