/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.rideable.functionLathes;

import com.acheli.registry.network.ACHMessages;
import com.acheli.registry.network.ACHeliPacketType;
import com.acheli.registry.network.packet.CustomSyncableC2SPacket;
import com.acheli.rideable.entites.ComponentEntity;
import com.acheli.rideable.entites.RideableEntity;
import com.acheli.rideable.functionLathes.RotateAbleEntityFL;
import com.acheli.rideable.model.AbstractComponent;
import com.acheli.utils.rotate.EntityDirectionUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class ComponentFL
extends RotateAbleEntityFL
implements AbstractComponent {
    private double mass = 0.0;
    private double revolutionSpeed = 0.0;
    public final String ID;
    protected boolean enableVelocity = false;
    private Vec3 velocity = Vec3.f_82478_;
    private Vec3 lastPos;
    private Vec3 relativePosition = Vec3.f_82478_;
    private Vec3 relativeAABB_Position = Vec3.f_82478_;
    private double relativeAABB_X_Length = 1.0;
    private double relativeAABB_Y_Length = 1.0;
    private double relativeAABB_Z_Length = 1.0;
    protected RideableEntity vehicle;
    protected Orientation orientation = Orientation.North;
    private ComponentEntity body;

    @Override
    public void setMass(double mass) {
        this.mass = mass;
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    public CompoundTag clientSending(ACHeliPacketType packetType) {
        return new CompoundTag();
    }

    public CompoundTag serverReceiveAndSending(MinecraftServer server, CompoundTag serverOriginNbt, RideableEntity serverRideable, ServerPlayer sender, ServerPlayer executingPlayer, ACHeliPacketType packetType, String componentTypeName) {
        return new CompoundTag();
    }

    @Override
    public void setRevolutionSpeed(double revolutionSpeed) {
        this.revolutionSpeed = revolutionSpeed;
    }

    @Override
    public double getRevolutionSpeed() {
        return this.revolutionSpeed;
    }

    public void onGround(boolean v) {
    }

    public void interact(Player player, InteractionHand hand) {
    }

    public ComponentFL(String ID, RideableEntity vehicle, Vec3 relativePosition) {
        this.ID = ID;
        this.vehicle = vehicle;
        this.setRelativePosition(relativePosition);
    }

    public ComponentFL(String ID, RideableEntity vehicle, Vec3 relativePosition, double relativeBoxXLength, double relativeBoxYLength, double relativeBoxZLength) {
        this.ID = ID;
        this.vehicle = vehicle;
        this.setRelativePosition(relativePosition);
        this.setRelativeAABB(relativeBoxXLength, relativeBoxYLength, relativeBoxZLength);
    }

    public ComponentFL(String ID, RideableEntity vehicle, Vec3 relativePosition, Vec3 relativeBoxPosition, double relativeBoxXLength, double relativeBoxYLength, double relativeBoxZLength) {
        this.ID = ID;
        this.vehicle = vehicle;
        this.setRelativePosition(relativePosition);
        this.setRelativeAABB(relativeBoxPosition, relativeBoxXLength, relativeBoxYLength, relativeBoxZLength);
    }

    public void setRelativeAABB(double relativeAABBXLength, double relativeAABBYLength, double relativeAABBZLength) {
        this.relativeAABB_X_Length = relativeAABBXLength;
        this.relativeAABB_Y_Length = relativeAABBYLength;
        this.relativeAABB_Z_Length = relativeAABBZLength;
    }

    public void setRelativeAABB(Vec3 relativeAABBPosition, double relativeAABBXLength, double relativeAABBYLength, double relativeAABBZLength) {
        this.relativeAABB_Position = relativeAABBPosition;
        this.relativeAABB_X_Length = relativeAABBXLength;
        this.relativeAABB_Y_Length = relativeAABBYLength;
        this.relativeAABB_Z_Length = relativeAABBZLength;
    }

    public Vec3 getRelativeAABB_Position() {
        return this.relativeAABB_Position;
    }

    public double getRelativeAABB_X_Length() {
        return this.relativeAABB_X_Length;
    }

    public double getRelativeAABB_Y_Length() {
        return this.relativeAABB_Y_Length;
    }

    public double getRelativeAABB_Z_Length() {
        return this.relativeAABB_Z_Length;
    }

    public AABB getVisibilityBoundingAABB(AABB box) {
        return AABB.m_165882_((Vec3)box.m_82399_().m_82549_(this.relativeAABB_Position), (double)(box.m_82362_() * this.relativeAABB_X_Length), (double)(box.m_82376_() * this.relativeAABB_Y_Length), (double)(box.m_82385_() * this.relativeAABB_Z_Length));
    }

    public ComponentEntity getBody() {
        return this.body;
    }

    public void setBody(ComponentEntity body) {
        this.body = body;
    }

    @Override
    public void tick() {
        if (this.getBody().m_9236_().f_46443_) {
            ACHMessages.sendToServer(new CustomSyncableC2SPacket(this.getBody().m_19879_(), this.getBody().m_20148_(), this.clientSending(ACHeliPacketType.ComponentActive), ACHeliPacketType.ComponentActive));
        }
    }

    @Override
    public void bodyTick(ComponentEntity dynamicBody) {
    }

    @Override
    public void renderTick(ComponentEntity dynamicBody, PoseStack matrices, float tickDelta) {
        if (this.enableVelocity) {
            Vec3 nowPos = dynamicBody.m_20182_();
            if (this.lastPos != null) {
                this.velocity = EntityDirectionUtils.getDirectionVector(this.lastPos, nowPos);
            }
            this.lastPos = nowPos;
        }
    }

    @Override
    public void setRelativePosition(Vec3 pos) {
        this.relativePosition = pos;
    }

    @Override
    public Vec3 getRelativePosition() {
        return this.relativePosition;
    }

    @Override
    public Vec3 getPos(double x, double y, double z) {
        return new Vec3(x + this.relativePosition.m_7096_(), y + this.relativePosition.m_7098_(), z + this.relativePosition.m_7094_());
    }

    @Override
    public Vec3 getPos(Vec3 inputPos) {
        return new Vec3(inputPos.f_82479_ + this.relativePosition.m_7096_(), inputPos.f_82480_ + this.relativePosition.m_7098_(), inputPos.f_82481_ + this.relativePosition.m_7094_());
    }

    @Override
    public Vec3 getPos() {
        Vec3 originPos = this.vehicle.m_20182_();
        return new Vec3(originPos.m_7096_() + this.relativePosition.m_7096_(), originPos.m_7098_() + this.relativePosition.m_7098_(), originPos.m_7094_() + this.relativePosition.m_7094_());
    }

    public Vec3 getVelocity() {
        return this.velocity;
    }

    public void setVehicle(RideableEntity vehicle) {
        this.vehicle = vehicle;
    }

    public RideableEntity getVehicle() {
        return this.vehicle;
    }

    public static enum Orientation {
        North,
        South,
        West,
        East;

    }
}

