/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.rideable.functionLathes.component;

import com.acheli.rideable.entites.RideableEntity;
import com.acheli.rideable.functionLathes.ComponentFL;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class SeatFL
extends ComponentFL {
    private double mouseXDelta = 0.0;
    private double mouseYDelta = 0.0;
    private float playerYaw = 0.0f;
    private float playerPitch = 0.0f;
    private final double maxRotateAngle;
    public final boolean canControl;

    public SeatFL(String ID, RideableEntity vehicle, boolean canControl, double maxRotateAngle, ComponentFL.Orientation orientation, Vec3 relativePosition, double relativeBoxXLength, double relativeBoxYLength, double relativeBoxZLength) {
        super(ID, vehicle, relativePosition, relativeBoxXLength, relativeBoxYLength, relativeBoxZLength);
        this.orientation = orientation;
        this.canControl = canControl;
        this.maxRotateAngle = maxRotateAngle;
    }

    @Override
    public void interact(Player player, InteractionHand hand) {
        super.interact(player, hand);
        player.m_20329_((Entity)this.getBody());
    }

    public void setPlayerRotate(Player player, double forwardYaw, double forwardPitch) {
        double ratio = 0.1;
        double orientAngle = 0.0;
        switch (this.orientation) {
            case North: {
                break;
            }
            case South: {
                orientAngle = 180.0;
                break;
            }
            case West: {
                orientAngle = -90.0;
                break;
            }
            case East: {
                orientAngle = 90.0;
            }
        }
        double xd = this.mouseXDelta * ratio;
        if (xd < -this.maxRotateAngle) {
            xd = -this.maxRotateAngle;
            this.mouseXDelta = xd / ratio;
        }
        if (xd > this.maxRotateAngle) {
            xd = this.maxRotateAngle;
            this.mouseXDelta = xd / ratio;
        }
        if (this.vehicle.m_9236_().f_46443_) {
            this.playerYaw = (float)(forwardYaw + xd + orientAngle);
            this.playerPitch = (float)(forwardPitch + this.mouseYDelta * ratio);
            player.m_146922_(this.playerYaw);
            player.m_146926_(this.playerPitch);
        }
    }

    public void addMouseDelta(double deltaX, double deltaY) {
        this.mouseXDelta += deltaX;
        this.mouseYDelta += deltaY;
    }

    public void cleanMouseDelta() {
        this.mouseXDelta = 0.0;
        this.mouseYDelta = 0.0;
    }
}

