/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.rideable.functionLathes.component.engine;

import com.acheli.registry.config.settings.EngineMode;
import com.acheli.registry.network.ACHeliPacketType;
import com.acheli.rideable.entites.RideableEntity;
import com.acheli.rideable.functionLathes.ComponentFL;
import com.acheli.rideable.functionLathes.component.engine.AbstractEngine;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class EngineFL
extends ComponentFL
implements AbstractEngine {
    RideableEntity masterRideable;
    public String name = "";
    private double power = 0.0;
    private double revolutionSpeed = 0.0;
    private double maximumRevSpeed = 0.0;
    private double readyRevSpeed = 0.0;
    private double revDeltaPerTick = 0.0;
    private final double defaultRevDeltaPerTick;
    private int engineTimeout = 0;
    private int engineTimeoutThreshold = 0;
    private int engineTimeoutCooldown = 0;
    private boolean engineStatus = false;
    private boolean isClosed = false;
    private boolean isReady = false;
    private boolean isMaxed = false;
    private EngineMode engineMode = EngineMode.Simulation;

    EngineFL(String name, RideableEntity masterRideable, Vec3 relativePosition, double maximumRevSpeed, double readyRevSpeed, int engineTimeoutCooldown, int engineTimeoutThreshold, double revDeltaPerTick) {
        super(name, masterRideable, relativePosition);
        this.name = name;
        this.setMaximumRevSpeed(maximumRevSpeed);
        this.setReadyRevSpeed(readyRevSpeed);
        this.setEngineTimeoutCooldown(engineTimeoutCooldown);
        this.setEngineTimeoutThreshold(engineTimeoutThreshold);
        this.defaultRevDeltaPerTick = revDeltaPerTick;
        this.setRevDeltaPerTick(revDeltaPerTick);
    }

    @Override
    public CompoundTag clientSending(ACHeliPacketType packetType) {
        CompoundTag nbt = super.clientSending(packetType);
        if (Objects.requireNonNull(packetType) == ACHeliPacketType.ComponentActive) {
            nbt.m_128359_("engineMode", this.engineMode.name());
        }
        return nbt;
    }

    @Override
    public CompoundTag serverReceiveAndSending(MinecraftServer server, CompoundTag serverOriginNbt, RideableEntity serverRideable, ServerPlayer sender, ServerPlayer executingPlayer, ACHeliPacketType packetType, String componentTypeName) {
        if (Objects.requireNonNull(packetType) == ACHeliPacketType.ComponentActive) {
            this.engineMode = EngineMode.valueOf(serverOriginNbt.m_128461_("engineMode"));
        }
        return super.serverReceiveAndSending(server, serverOriginNbt, serverRideable, sender, executingPlayer, packetType, componentTypeName);
    }

    public void setMode(EngineMode engineMode) {
        this.engineMode = engineMode;
    }

    @Override
    public void setRevolutionSpeed(double revolutionSpeed) {
        if (revolutionSpeed > 0.0) {
            double max = this.getMaximumRevSpeed();
            this.revolutionSpeed = Math.min(revolutionSpeed, max);
        } else if (revolutionSpeed <= 0.0) {
            this.revolutionSpeed = 0.0;
        }
    }

    @Override
    public double getRevolutionSpeed() {
        return this.revolutionSpeed;
    }

    @Override
    public void setReadyRevSpeed(double readyRevSpeed) {
        this.readyRevSpeed = readyRevSpeed;
    }

    @Override
    public double getReadyRevSpeed() {
        return this.readyRevSpeed;
    }

    @Override
    public void setMaximumRevSpeed(double maximumRevSpeed) {
        this.maximumRevSpeed = maximumRevSpeed;
    }

    @Override
    public double getMaximumRevSpeed() {
        return this.maximumRevSpeed;
    }

    @Override
    public void setRevDeltaPerTick(double revDeltaPerTick) {
        this.revDeltaPerTick = revDeltaPerTick;
    }

    @Override
    public double getRevDeltaPerTick() {
        return this.revDeltaPerTick;
    }

    @Override
    public void setEngineTimeout(int engineTimeout) {
        this.engineTimeout = engineTimeout;
    }

    @Override
    public int getEngineTimeout() {
        return this.engineTimeout;
    }

    @Override
    public void setEngineTimeoutThreshold(int engineTimeoutThreshold) {
        this.engineTimeoutThreshold = engineTimeoutThreshold;
    }

    @Override
    public int getEngineTimeoutThreshold() {
        return this.engineTimeoutThreshold;
    }

    @Override
    public void setEngineTimeoutCooldown(int engineTimeoutCooldown) {
        this.engineTimeoutCooldown = engineTimeoutCooldown;
    }

    @Override
    public int getEngineTimeoutCooldown() {
        return this.engineTimeoutCooldown;
    }

    public void setPower(double powerValue) {
        this.power = powerValue;
    }

    public double getPower() {
        return this.power;
    }

    @Override
    public void tick() {
        super.tick();
        switch (this.engineMode) {
            case Convenient: {
                this.setRevDeltaPerTick(this.getMaximumRevSpeed());
                break;
            }
            case Simulation: {
                this.setRevDeltaPerTick(this.defaultRevDeltaPerTick);
                break;
            }
        }
        int _timeout = this.engineTimeout;
        int _cooldown = this.engineTimeoutCooldown;
        if (_timeout > this.getEngineTimeoutThreshold()) {
            _timeout = -_cooldown;
            this.engineStatusChanging();
        } else if (_timeout < 0) {
            ++_timeout;
        }
        this.setEngineTimeout(_timeout);
        double maxRevSpeed = this.getMaximumRevSpeed();
        double readyRevSpeed = this.getReadyRevSpeed();
        if (this.engineStatus && this.getRevolutionSpeed() < maxRevSpeed) {
            double delta = this.revDeltaPerTick;
            this.setRevolutionSpeed(this.getRevolutionSpeed() + delta);
        } else if (!this.engineStatus && this.getRevolutionSpeed() > 0.0) {
            double delta = -this.revDeltaPerTick;
            this.setRevolutionSpeed(this.getRevolutionSpeed() + delta);
        }
        if (this.getRevolutionSpeed() <= 0.0) {
            if (!this.isClosed) {
                this.onEngineClosed();
                this.isClosed = true;
            }
        } else {
            this.isClosed = false;
        }
        if (this.engineStatus && this.getRevolutionSpeed() >= readyRevSpeed) {
            if (!this.isReady) {
                this.onEngineIsReady();
                this.isReady = true;
            }
        } else {
            this.isReady = false;
        }
        if (this.engineStatus && this.getRevolutionSpeed() >= maxRevSpeed) {
            if (!this.isMaxed) {
                this.onEngineMaxed();
                this.isMaxed = true;
            }
        } else {
            this.isMaxed = false;
        }
    }

    @Override
    public void engineSwitch() {
        this.setEngineTimeout(this.getEngineTimeout() + 1);
    }

    @Override
    public void engineRunning() {
        this.engineStatus = true;
    }

    @Override
    public void onEngineIsReady() {
    }

    @Override
    public void onEngineMaxed() {
    }

    @Override
    public void engineStopping() {
        this.engineStatus = false;
    }

    @Override
    public void onEngineClosed() {
    }

    @Override
    public void setEngineStatus(boolean engineStatus) {
        this.engineStatus = engineStatus;
    }

    @Override
    public boolean getEngineStatus() {
        return this.engineStatus;
    }

    @Override
    public void engineStatusChanging() {
        if (this.engineStatus) {
            this.engineStopping();
        } else {
            this.engineRunning();
        }
    }
}

