/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.rideable.functionLathes.component.propeller;

import com.acheli.rideable.entites.RideableEntity;
import com.acheli.rideable.functionLathes.ComponentFL;
import com.acheli.rideable.functionLathes.component.propeller.AbstractPropeller;
import com.acheli.rideable.functionLathes.component.propeller.PropellerBlade;
import com.acheli.utils.math.angle.AbstractAngle;
import com.acheli.utils.math.angle.Angle;
import net.minecraft.world.phys.Vec3;

public class PropellerBase
extends ComponentFL
implements AbstractPropeller {
    AbstractAngle attackAngle = new Angle(0.0);
    private double bladeSquareMeter = 0.0;
    private double bladeLength = 0.0;

    public PropellerBase(String ID, RideableEntity vehicle, Vec3 relativePosition, Angle attackAngle) {
        super(ID, vehicle, relativePosition);
        this.attackAngle = attackAngle;
    }

    public Vec3 getForce() {
        double realLift = 0.0;
        double attackAngle = this.getAttackAngle().getAngleNum();
        double dragLiftProportion = Math.tan(attackAngle);
        double width = this.getRevolutionSpeed();
        double height = width * dragLiftProportion;
        return new Vec3(0.0, realLift += height * width / 2.0, 0.0);
    }

    @Override
    public void setBlade(PropellerBlade blade) {
    }

    @Override
    public PropellerBlade getBlade() {
        return null;
    }

    @Override
    public void setAttackAngle(AbstractAngle attackAngle) {
        this.attackAngle = attackAngle;
    }

    @Override
    public AbstractAngle getAttackAngle() {
        return this.attackAngle;
    }
}

