/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.rideable.functionLathes.component.stabilizer;

import com.acheli.registry.keybind.KeyBinding;
import com.acheli.rideable.entites.ComponentEntity;
import com.acheli.rideable.entites.RideableEntity;
import com.acheli.rideable.functionLathes.ComponentFL;
import com.acheli.utils.math.angle.AbstractAngle;
import com.acheli.utils.math.angle.Angle;
import com.acheli.utils.physics.PhysicsEngine;
import com.acheli.utils.rotate.TorqueCalculator;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class StabilizerBase
extends ComponentFL {
    AbstractAngle xAxisAngle = new Angle(0.0, new Angle(45.0), new Angle(-45.0));
    AbstractAngle yAxisAngle = new Angle(0.0, new Angle(45.0), new Angle(-45.0));
    AbstractAngle zAxisAngle = new Angle(0.0, new Angle(45.0), new Angle(-45.0));

    public StabilizerBase(String ID, RideableEntity vehicle, Vec3 relativePosition, double relativeAABBXLength, double relativeAABBYLength, double relativeAABBZLength) {
        super(ID, vehicle, relativePosition);
        this.enableVelocity = true;
        this.setRelativeAABB(relativeAABBXLength, relativeAABBYLength, relativeAABBZLength);
    }

    public StabilizerBase(String ID, RideableEntity vehicle, Vec3 relativePosition, Vec3 relativeAABBPosition, double relativeAABBXLength, double relativeAABBYLength, double relativeAABBZLength) {
        super(ID, vehicle, relativePosition);
        this.enableVelocity = true;
        this.setRelativeAABB(relativeAABBPosition, relativeAABBXLength, relativeAABBYLength, relativeAABBZLength);
    }

    public void setUpAngles(AbstractAngle xAxisAngle, AbstractAngle yAxisAngle, AbstractAngle zAxisAngle) {
        this.xAxisAngle = xAxisAngle;
        this.yAxisAngle = yAxisAngle;
        this.zAxisAngle = zAxisAngle;
    }

    @Override
    public void keyEvent() {
        super.keyEvent();
        if (KeyBinding.CYCLIC_PUSH.m_90857_()) {
            this.zAxisAngle.add(new Angle(-5.0));
        }
        if (KeyBinding.CYCLIC_PULL.m_90857_()) {
            this.zAxisAngle.add(new Angle(5.0));
        }
        if (KeyBinding.CYCLIC_LEFT.m_90857_()) {
            // empty if block
        }
        if (KeyBinding.CYCLIC_RIGHT.m_90857_()) {
            // empty if block
        }
    }

    @Override
    public void renderTick(ComponentEntity dynamicBody, PoseStack matrices, float tickDelta) {
        super.renderTick(dynamicBody, matrices, tickDelta);
        if (dynamicBody.m_9236_().f_46443_) {
            Quaternionf rotate = dynamicBody.getRotation();
            rotate.rotateYXZ((float)this.yAxisAngle.getArcAngleNum(), (float)this.xAxisAngle.getArcAngleNum(), (float)this.zAxisAngle.getArcAngleNum());
            Vec3 direction = this.getVelocity().m_82559_(PhysicsEngine.every(-1.0)).m_82541_();
            Entity entity = dynamicBody.m_20202_();
            if (entity instanceof RideableEntity) {
                RideableEntity RideableEntity2 = (RideableEntity)entity;
                Vector3f angles = TorqueCalculator.calculateLocalRotationDirection(this.getRelativePosition(), RideableEntity2.m_20182_(), TorqueCalculator.fromVector3f(TorqueCalculator.CoordinateTransform.worldToLocal(direction.m_252839_(), rotate)), new Quaternionf());
                double horizontalFaceArea = this.getRelativeAABB_Y_Length() * this.getRelativeAABB_Z_Length();
                double verticalFaceArea = this.getRelativeAABB_X_Length() * this.getRelativeAABB_Z_Length();
                double rv = RideableEntity2.m_20184_().m_82553_() * 3.0;
                RideableEntity2.factory.getProductFunction().getFL().addMomentum(new Vec3((double)(angles.z / 480000.0f) * rv, (double)(angles.y / 320000.0f) * rv * horizontalFaceArea, (double)(angles.x / 480000.0f) * rv * verticalFaceArea));
            }
        }
    }
}

