/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.utils.air;

import com.acheli.utils.physics.PhysicsEngine;
import com.acheli.utils.rotate.EntityDirectionUtils;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class Aerodynamics {
    private static final double AIR_DENSITY = 1.225;
    private static final double REFERENCE_AREA = 10.0;
    private static final double CL0 = 0.1;
    private static final double CD0 = 0.01;
    private static final double KL = 0.1;
    private static final double KD = 0.05;

    public static Vec3 calculateLift(Vec3 velocity, Quaternionf rotation) {
        float angleOfAttack = Aerodynamics.getAngleOfAttack(velocity, rotation);
        double liftCoefficient = 0.1 + 0.1 * (double)angleOfAttack;
        double velocityMagnitude = velocity.m_82553_();
        double liftMagnitude = 0.6125 * velocityMagnitude * velocityMagnitude * 10.0 * liftCoefficient;
        Vec3 upDirection = EntityDirectionUtils.getUpDirection(rotation);
        Vec3 liftDirection = upDirection.m_82537_(velocity).m_82541_();
        Vec3 liftForce = liftDirection.m_82559_(PhysicsEngine.every(liftMagnitude));
        return Aerodynamics.filterNaN(liftForce);
    }

    public static Vec3 calculateDrag(Vec3 velocity, Quaternionf rotation) {
        float angleOfAttack = Aerodynamics.getAngleOfAttack(velocity, rotation);
        double dragCoefficient = 0.01 + 0.05 * (double)angleOfAttack * (double)angleOfAttack;
        double velocityMagnitude = velocity.m_82553_();
        double dragMagnitude = 0.6125 * velocityMagnitude * velocityMagnitude * 10.0 * dragCoefficient;
        Vec3 dragDirection = velocity.m_82541_().m_82559_(PhysicsEngine.every(-1.0));
        Vec3 dragForce = dragDirection.m_82559_(PhysicsEngine.every(dragMagnitude));
        return Aerodynamics.filterNaN(dragForce);
    }

    public static boolean isVortexRingState(Vec3 velocity, Quaternionf rotation) {
        Vec3 upDirection = EntityDirectionUtils.getUpDirection(rotation);
        double descentRate = -velocity.m_82526_(upDirection);
        return descentRate > 5.0 && (double)Aerodynamics.getAngleOfAttack(velocity, rotation) > Math.toRadians(20.0);
    }

    public static float getAngleOfAttack(Vec3 velocity, Quaternionf rotation) {
        Vec3 rotorNormal = EntityDirectionUtils.getUpDirection(rotation);
        double dotProduct = velocity.m_82526_(rotorNormal);
        double velocityMag = velocity.m_82553_();
        double rotorMag = rotorNormal.m_82553_();
        if (velocityMag == 0.0 || rotorMag == 0.0) {
            return 0.0f;
        }
        double cosTheta = dotProduct / (velocityMag * rotorMag);
        float angle = (float)Math.acos(cosTheta);
        return Float.isNaN(angle) ? 0.0f : angle;
    }

    public static void checkRotorWindDirection(Vec3 velocity, Quaternionf rotation) {
        Vec3 rotorNormal = EntityDirectionUtils.getUpDirection(rotation);
        double projection = velocity.m_82526_(rotorNormal) / rotorNormal.m_82553_();
        if (projection > 1.0E-6) {
            System.out.println("\u65cb\u7ffc\u4e0a\u9762\u8fce\u98ce\uff08\u722c\u5347\u72b6\u6001\uff09");
        } else if (projection < -1.0E-6) {
            System.out.println("\u65cb\u7ffc\u4e0b\u9762\u8fce\u98ce\uff08\u4fef\u51b2\u72b6\u6001\uff09");
        } else {
            System.out.println("\u901f\u5ea6\u4e0e\u65cb\u7ffc\u5e73\u9762\u5e73\u884c\uff08\u4fa7\u98de\uff09");
        }
    }

    public static Vec3 rotateVector(Quaternionf rotation, Vec3 vector) {
        float x = (float)vector.f_82479_;
        float y = (float)vector.f_82480_;
        float z = (float)vector.f_82481_;
        Quaternionf vectorQuat = new Quaternionf(x, y, z, 0.0f);
        Quaternionf rotatedQuat = new Quaternionf((Quaternionfc)rotation).mul((Quaternionfc)vectorQuat).mul((Quaternionfc)new Quaternionf((Quaternionfc)rotation).conjugate());
        Vec3 rotatedVector = new Vec3((double)rotatedQuat.x, (double)rotatedQuat.y, (double)rotatedQuat.z);
        return rotatedVector.m_82541_();
    }

    private static Vec3 filterNaN(Vec3 vector) {
        double x = Double.isNaN(vector.f_82479_) ? 0.0 : vector.f_82479_;
        double y = Double.isNaN(vector.f_82480_) ? 0.0 : vector.f_82480_;
        double z = Double.isNaN(vector.f_82481_) ? 0.0 : vector.f_82481_;
        return new Vec3(x, y, z);
    }

    public static void main(String[] args) {
        Vec3 velocity = new Vec3(50.0, 10.0, 0.0);
        Quaternionf rotation = new Quaternionf().rotateXYZ(0.5f, 0.3f, 0.2f);
        Vec3 liftForce = Aerodynamics.calculateLift(velocity, rotation);
        Vec3 dragForce = Aerodynamics.calculateDrag(velocity, rotation);
        System.out.println("Lift Force: " + liftForce);
        System.out.println("Drag Force: " + dragForce);
    }
}

