/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.utils.math.angle;

import com.acheli.utils.math.angle.AbstractAngle;
import com.acheli.utils.math.angle.ArcAngle;

public class Angle
implements AbstractAngle {
    private double angleNumber = 0.0;
    private AbstractAngle upperLimit;
    private AbstractAngle lowerLimit;

    public Angle(double angleNumber) {
        this.angleNumber = angleNumber;
    }

    public Angle(double angleNumber, AbstractAngle upperLimit, AbstractAngle lowerLimit) {
        this.angleNumber = angleNumber;
        this.upperLimit = upperLimit;
        this.lowerLimit = lowerLimit;
    }

    @Override
    public void setUpperLimit(AbstractAngle upperLimit) {
        this.upperLimit = upperLimit;
    }

    @Override
    public void setLowerLimit(AbstractAngle lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    @Override
    public AbstractAngle getUpperLimit() {
        return this.upperLimit;
    }

    @Override
    public AbstractAngle getLowerLimit() {
        return this.lowerLimit;
    }

    @Override
    public boolean upperThanLimit(AbstractAngle angle) {
        if (this.upperLimit != null) {
            return angle.getAngleNum() > this.upperLimit.getAngleNum();
        }
        return false;
    }

    @Override
    public boolean lowerThanLimit(AbstractAngle angle) {
        if (this.lowerLimit != null) {
            return angle.getAngleNum() < this.lowerLimit.getAngleNum();
        }
        return false;
    }

    @Override
    public void setAngle(AbstractAngle angle) {
        if (this.lowerThanLimit(angle) || this.upperThanLimit(angle)) {
            return;
        }
        this.angleNumber = angle.getAngleNum();
    }

    @Override
    public void setAngleNum(double angleNum) {
        Angle angle = new Angle(angleNum);
        if (this.lowerThanLimit(angle) || this.upperThanLimit(angle)) {
            return;
        }
        this.angleNumber = angleNum;
    }

    @Override
    public double getAngleNum() {
        return this.angleNumber;
    }

    @Override
    public void setArcAngleNum(double arcAngleNum) {
        ArcAngle arcAngle = new ArcAngle(arcAngleNum);
        if (this.lowerThanLimit(arcAngle) || this.upperThanLimit(arcAngle)) {
            return;
        }
        this.angleNumber = arcAngleNum * 180.0 / Math.PI;
    }

    @Override
    public double getArcAngleNum() {
        return this.angleNumber / 180.0 * Math.PI;
    }

    @Override
    public void add(AbstractAngle otherAngle) {
        this.angleNumber += otherAngle.getAngleNum();
    }
}

