/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.utils.math.angle;

import com.acheli.utils.math.angle.AbstractAngle;
import com.acheli.utils.math.angle.Angle;

public class ArcAngle
implements AbstractAngle {
    private double arcNumber = 0.0;
    private AbstractAngle upperLimit;
    private AbstractAngle lowerLimit;

    public ArcAngle(double arcNumber) {
        this.arcNumber = arcNumber;
    }

    @Override
    public void setUpperLimit(AbstractAngle upperLimit) {
        this.upperLimit = upperLimit;
    }

    @Override
    public void setLowerLimit(AbstractAngle lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    @Override
    public AbstractAngle getUpperLimit() {
        return this.upperLimit;
    }

    @Override
    public AbstractAngle getLowerLimit() {
        return this.lowerLimit;
    }

    @Override
    public boolean upperThanLimit(AbstractAngle angle) {
        if (this.upperLimit != null) {
            return angle.getArcAngleNum() > this.upperLimit.getArcAngleNum();
        }
        return false;
    }

    @Override
    public boolean lowerThanLimit(AbstractAngle angle) {
        if (this.lowerLimit != null) {
            return angle.getArcAngleNum() < this.lowerLimit.getArcAngleNum();
        }
        return false;
    }

    @Override
    public void setAngle(AbstractAngle angle) {
        if (this.lowerThanLimit(angle) || this.upperThanLimit(angle)) {
            return;
        }
        this.arcNumber = angle.getArcAngleNum();
    }

    @Override
    public void setAngleNum(double angleNum) {
        Angle angle = new Angle(angleNum);
        if (this.lowerThanLimit(angle) || this.upperThanLimit(angle)) {
            return;
        }
        this.arcNumber = angleNum / 180.0 * Math.PI;
    }

    @Override
    public double getAngleNum() {
        return this.arcNumber * 180.0 / Math.PI;
    }

    @Override
    public void setArcAngleNum(double arcAngleNum) {
        ArcAngle arcAngle = new ArcAngle(arcAngleNum);
        if (this.lowerThanLimit(arcAngle) || this.upperThanLimit(arcAngle)) {
            return;
        }
        this.arcNumber = arcAngleNum;
    }

    @Override
    public double getArcAngleNum() {
        return this.arcNumber;
    }

    @Override
    public void add(AbstractAngle otherAngle) {
        this.arcNumber += otherAngle.getArcAngleNum();
    }
}

