/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.utils.physics;

import com.acheli.utils.physics.PhysicsObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PhysicsEngine {
    private final List<PhysicsObject> objList = new ArrayList<PhysicsObject>();

    public void registryObj(PhysicsObject physicsObject) {
        this.objList.add(physicsObject);
    }

    void physicsEngineTick(float tickDelta) {
        for (PhysicsObject physicsObject : this.objList) {
            physicsObject.physicsObjTick(tickDelta);
        }
    }

    public static Vec3 every(double d) {
        return new Vec3(d, d, d);
    }

    public static float getDeltaTime(float tickDelta) {
        return tickDelta * 0.05f;
    }

    public static Vec3 getAcceleration(Vec3 force, double mass) {
        return force.m_82559_(PhysicsEngine.every(1.0 / mass));
    }

    public static Vec3 getForce(double mass, Vec3 acceleration) {
        return acceleration.m_82559_(PhysicsEngine.every(mass));
    }

    public static Vec3 getMomentum(double mass, Vec3 speed) {
        return new Vec3(speed.m_7096_() * mass, speed.m_7098_() * mass, speed.m_7094_() * mass);
    }

    public static Vec3 getSpeedFromMomentum(double mass, Vec3 momentum) {
        if (mass == 0.0) {
            return Vec3.f_82478_;
        }
        return new Vec3(momentum.m_7096_() / mass, momentum.m_7098_() / mass, momentum.m_7094_() / mass);
    }

    public static boolean isEntityInsideBlock(Entity entity) {
        Level world = entity.m_9236_();
        AABB entityAABB = entity.m_20191_();
        int minX = (int)Math.floor(entityAABB.f_82288_ - 1.0);
        int minY = (int)Math.floor(entityAABB.f_82289_ - 1.0);
        int minZ = (int)Math.floor(entityAABB.f_82290_ - 1.0);
        int maxX = (int)Math.ceil(entityAABB.f_82291_ + 1.0);
        int maxY = (int)Math.ceil(entityAABB.f_82292_ + 1.0);
        int maxZ = (int)Math.ceil(entityAABB.f_82293_ + 1.0);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = world.m_8055_(pos);
                    VoxelShape shape = state.m_60812_((BlockGetter)world, pos);
                    if (shape.m_83281_()) continue;
                    for (AABB blockAABB : shape.m_83299_()) {
                        AABB translatedAABB = blockAABB.m_82386_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                        if (!entityAABB.m_82381_(translatedAABB)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

