/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.utils.physics;

import com.acheli.utils.physics.PhysicsEngine;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PhysicsObject {
    private Vec3 currentPos = Vec3.f_82478_;
    private Vec3 currentForce = Vec3.f_82478_;
    private Vec3 currentVelocity = Vec3.f_82478_;
    private Quaternionf currentRotate = new Quaternionf();
    private boolean disabled = false;
    private double mass = 0.0;

    public Vec3 getCurrentPos() {
        return this.currentPos;
    }

    public void setCurrentPos(Vec3 currentPos) {
        this.currentPos = currentPos;
    }

    public void addForce(Vec3 force) {
        this.currentForce.m_82549_(force);
    }

    public Vec3 getCurrentForce() {
        return this.currentForce;
    }

    public void setCurrentForce(Vec3 currentForce) {
        this.currentForce = currentForce;
    }

    public Vec3 getCurrentVelocity(Vec3 input) {
        if (this.disabled) {
            return input;
        }
        return this.currentVelocity;
    }

    public void setCurrentVelocity(Vec3 currentVelocity) {
        this.currentVelocity = currentVelocity;
    }

    public Quaternionf getCurrentRotate() {
        return this.currentRotate;
    }

    public void setCurrentRotate(Quaternionf currentRotate) {
        this.currentRotate = currentRotate;
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public Vec3 getTangentVector() {
        if (this.currentVelocity.m_82556_() == 0.0) {
            return Vec3.f_82478_;
        }
        return this.currentVelocity.m_82541_();
    }

    public Quaternionf calculateRotationToTangent(Vec3 upDirection, float alpha) {
        Vec3 tangent = this.getTangentVector();
        if (tangent.equals((Object)Vec3.f_82478_)) {
            return new Quaternionf((Quaternionfc)this.currentRotate);
        }
        Vector3f jomlTangent = new Vector3f((float)tangent.f_82479_, (float)tangent.f_82480_, (float)tangent.f_82481_);
        Vector3f jomlUp = new Vector3f((float)upDirection.f_82479_, (float)upDirection.f_82480_, (float)upDirection.f_82481_);
        Quaternionf targetRotation = new Quaternionf().lookAlong((Vector3fc)jomlTangent, (Vector3fc)jomlUp);
        return this.currentRotate.slerp((Quaternionfc)targetRotation, alpha, new Quaternionf());
    }

    public void getUpdated(Vec3 pos, Vec3 velocity, Vec3 acceleration, float tickDelta) {
        float deltaTime = PhysicsEngine.getDeltaTime(tickDelta);
        Vec3 displacement = velocity.m_82559_(PhysicsEngine.every(deltaTime));
        if (!acceleration.equals((Object)Vec3.f_82478_)) {
            Vec3 accelerationDisplacement = acceleration.m_82559_(PhysicsEngine.every(0.5 * (double)deltaTime * (double)deltaTime));
            displacement = displacement.m_82549_(accelerationDisplacement);
            this.currentVelocity = velocity.m_82549_(acceleration.m_82559_(PhysicsEngine.every(deltaTime)));
        }
        this.currentPos = pos.m_82549_(displacement);
    }

    public void physicsObjTick(float tickDelta) {
        if (this.mass != 0.0) {
            this.getUpdated(this.currentPos, this.currentVelocity, PhysicsEngine.getAcceleration(this.currentForce, this.mass), tickDelta);
            if (!this.currentVelocity.equals((Object)Vec3.f_82478_)) {
                Vec3 up = new Vec3(0.0, 1.0, 0.0);
                float rotationSpeed = 0.2f;
                Quaternionf newRotation = this.calculateRotationToTangent(up, rotationSpeed);
                this.currentRotate.set((Quaternionfc)newRotation);
            }
        }
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean getDisabled() {
        return this.disabled;
    }
}

