/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.utils.rotate;

import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EntityDirectionUtils {
    public static Vector3f translateFromVec3(Vec3 input) {
        return new Vector3f((float)input.f_82479_, (float)input.f_82480_, (float)input.f_82481_);
    }

    public static float getPitch(Quaternionf rotation) {
        Vec3 forwardDirection = EntityDirectionUtils.getForwardDirection(rotation);
        return (float)Math.asin(-forwardDirection.f_82480_);
    }

    public static float getRoll(Quaternionf rotation) {
        Vec3 leftDirection = EntityDirectionUtils.getLeftDirection(rotation);
        return (float)Math.asin(leftDirection.f_82480_);
    }

    public static Vec3 getDirectionVector(Vec3 start, Vec3 end) {
        Vec3 direction = end.m_82546_(start);
        return direction.m_82541_();
    }

    public static Vec3 getForwardDirection(Quaternionf rotation) {
        Vec3 localForward = new Vec3(0.0, 0.0, 1.0);
        return EntityDirectionUtils.rotateVector(rotation, localForward);
    }

    public static Vec3 getBackwardDirection(Quaternionf rotation) {
        Vec3 localForward = new Vec3(0.0, 0.0, -1.0);
        return EntityDirectionUtils.rotateVector(rotation, localForward);
    }

    public static Vec3 getRightDirection(Quaternionf rotation) {
        Vec3 localRight = new Vec3(-1.0, 0.0, 0.0);
        return EntityDirectionUtils.rotateVector(rotation, localRight);
    }

    public static Vec3 getLeftDirection(Quaternionf rotation) {
        Vec3 localRight = new Vec3(1.0, 0.0, 0.0);
        return EntityDirectionUtils.rotateVector(rotation, localRight);
    }

    public static Vec3 getUpDirection(Quaternionf rotation) {
        Vec3 localUp = new Vec3(0.0, 1.0, 0.0);
        return EntityDirectionUtils.rotateVector(rotation, localUp).m_82542_(-1.0, 1.0, 1.0);
    }

    public static Vec3 getDownDirection(Quaternionf rotation) {
        Vec3 localUp = new Vec3(0.0, -1.0, 0.0);
        return EntityDirectionUtils.rotateVector(rotation, localUp).m_82542_(-1.0, 1.0, 1.0);
    }

    public static Vec3 rotateVector(Quaternionf rotation, Vec3 vector) {
        float x = (float)vector.f_82479_;
        float y = (float)vector.f_82480_;
        float z = (float)vector.f_82481_;
        Quaternionf vectorQuat = new Quaternionf(x, y, z, 0.0f);
        Quaternionf rotatedQuat = new Quaternionf((Quaternionfc)rotation).mul((Quaternionfc)vectorQuat).mul((Quaternionfc)new Quaternionf((Quaternionfc)rotation).conjugate());
        Vec3 rotatedVector = new Vec3((double)rotatedQuat.x, (double)rotatedQuat.y, (double)rotatedQuat.z);
        return rotatedVector.m_82541_();
    }
}

