/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.utils.rotate;

import com.acheli.rideable.entites.ComponentEntity;
import com.acheli.rideable.functionLathes.ComponentFL;
import com.acheli.rideable.functionLathes.component.SeatFL;
import com.acheli.utils.rotate.EntityDirectionUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class RotateWith {
    public static Quaternionf copy(Quaternionf rotation) {
        Quaternionf ready = new Quaternionf();
        ready.x = rotation.x;
        ready.y = rotation.y;
        ready.z = rotation.z;
        ready.w = rotation.w;
        return ready;
    }

    public static Quaternionf translateRotation(Quaternionf rotation) {
        Quaternionf ready = new Quaternionf();
        ready.x = rotation.z;
        ready.y = rotation.y;
        ready.z = -rotation.x;
        ready.w = rotation.w;
        return ready;
    }

    public static Quaternionf translateForRiseRotation(Quaternionf rotation) {
        Quaternionf ready = new Quaternionf();
        ready.x = rotation.z;
        ready.y = -rotation.y;
        ready.z = rotation.x;
        ready.w = rotation.w;
        return ready;
    }

    public static Vec3 rotatePoint(double x, double y, double z, Quaternionf rotation) {
        Vector3f point = new Vector3f((float)x, (float)y, (float)z);
        Quaternionf rY = RotateWith.translateRotation(rotation);
        rY.transform(point);
        return new Vec3((double)point.x, (double)point.y, (double)point.z);
    }

    public static void rotateEntity(Entity entity, Quaternionf rotation) {
        ComponentEntity componentEntity;
        ComponentFL componentFL;
        Player player;
        Entity entity2;
        Vec3 forward = EntityDirectionUtils.getForwardDirection(RotateWith.translateRotation(rotation));
        double angleRadians = Math.atan2(forward.m_7096_(), forward.m_7094_());
        double forwardYaw = -Math.toDegrees(angleRadians);
        double forwardPitch = -Math.toDegrees(forward.f_82480_);
        if (entity instanceof Player && (entity2 = (player = (Player)entity).m_20202_()) instanceof ComponentEntity && (componentFL = (componentEntity = (ComponentEntity)entity2).getComponentFL()) instanceof SeatFL) {
            SeatFL seatFL = (SeatFL)componentFL;
            seatFL.setPlayerRotate(player, forwardYaw, forwardPitch);
        }
    }

    public static void main(String[] args) {
        Quaternionf rotation = new Quaternionf().rotateY((float)Math.toRadians(90.0));
        Vec3 originalPoint = new Vec3(1.0, 0.0, 0.0);
        Vec3 rotatedPoint = RotateWith.rotatePoint(originalPoint.f_82479_, originalPoint.f_82480_, originalPoint.f_82481_, rotation);
        System.out.println("\u65cb\u8f6c\u540e\u7684\u5750\u6807: " + rotatedPoint);
    }
}

