/*
 * Decompiled with CFR 0.152.
 */
package com.acheli.utils.rotate;

import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TorqueCalculator {
    public static Vector3f calculateLocalRotationDirection(Vec3 localForcePoint, Vec3 pivotPoint, Vec3 localForceVector, Quaternionf rotation) {
        Vector3f worldForcePoint = TorqueCalculator.transformLocalToWorld(localForcePoint, pivotPoint, rotation);
        Vector3f worldForce = TorqueCalculator.transformLocalVectorToWorld(localForceVector, rotation);
        return TorqueCalculator.calculateRotationDirection(new Vec3(worldForcePoint), pivotPoint, new Vec3(worldForce));
    }

    public static Vector3f calculateRotationDirection(Vec3 forcePoint, Vec3 pivotPoint, Vec3 forceVector) {
        Vector3f leverArm = forcePoint.m_252839_().sub((Vector3fc)pivotPoint.m_252839_());
        Vector3f torque = new Vector3f((Vector3fc)leverArm).cross((Vector3fc)forceVector.m_252839_());
        return torque;
    }

    public static Vec3 fromVector3f(Vector3f vector3f) {
        return new Vec3((double)vector3f.x, (double)vector3f.y, (double)vector3f.z);
    }

    private static Vector3f transformLocalToWorld(Vec3 localPoint, Vec3 pivot, Quaternionf rotation) {
        Vector3f offset = localPoint.m_252839_();
        rotation.transform(offset);
        return offset.add((Vector3fc)pivot.m_252839_());
    }

    private static Vector3f transformLocalVectorToWorld(Vec3 localVector, Quaternionf rotation) {
        Vector3f vec = localVector.m_252839_();
        rotation.transform(vec);
        return vec;
    }

    public static String getRotationDescription(Vector3f torque) {
        float magnitude = torque.length();
        if (magnitude < 1.0E-5f) {
            return "No rotation";
        }
        Vector3f direction = new Vector3f((Vector3fc)torque).normalize();
        return String.format("Torque: %.2f N\u00b7m around [%.2f, %.2f, %.2f]", Float.valueOf(magnitude), Float.valueOf(direction.x), Float.valueOf(direction.y), Float.valueOf(direction.z));
    }

    public static class ContinuousRotation {
        private float lastYawRad;
        private float accumulatedYaw;

        public float update(Quaternionf rotation) {
            Vector3f euler = new Vector3f();
            rotation.getEulerAnglesYXZ(euler);
            float delta = euler.y - this.lastYawRad;
            delta = this.wrapAngle(delta);
            this.accumulatedYaw += delta;
            this.lastYawRad = euler.y;
            return this.accumulatedYaw;
        }

        private float wrapAngle(float radian) {
            return radian - (float)Math.PI * 2 * (float)Math.round(radian / ((float)Math.PI * 2));
        }
    }

    public static class CoordinateTransform {
        public static Vector3f worldToLocal(Vector3f worldVector, Quaternionf rotation) {
            Quaternionf inverseRot = new Quaternionf((Quaternionfc)rotation).conjugate();
            Vector3f localVector = new Vector3f((Vector3fc)worldVector);
            inverseRot.transform(localVector);
            return localVector;
        }

        public static Vector3f localToWorld(Vector3f localVector, Quaternionf rotation) {
            Vector3f worldVector = new Vector3f((Vector3fc)localVector);
            rotation.transform(worldVector);
            return worldVector;
        }
    }
}

