/*
 * Decompiled with CFR 0.152.
 */
package net.elytraautopilot.utils;

import java.util.Optional;
import net.elytraautopilot.config.ModConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2596;
import net.minecraft.class_2848;
import net.minecraft.class_310;
import net.minecraft.class_636;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7924;

public class ElytraManager {
    private static final int CHESTPLATE_INDEX = 6;
    private static int lastUID = -1;
    public static boolean autoSwapIsActive = false;

    public static int getElytraDurability(class_746 player) {
        class_1799 elytra = ElytraManager.getChestplateSlot(player);
        return elytra.method_7936() - elytra.method_7919();
    }

    public static boolean equipElytra(class_746 player) {
        int elytraIndex = ElytraManager.getElytraIndex((class_1657)player);
        if (elytraIndex != -1) {
            class_1799 stack = (class_1799)player.method_31548().field_7548.get(2);
            lastUID = ElytraManager.getItemUID(stack);
            ElytraManager.swapChestplateSlot(elytraIndex, player);
            autoSwapIsActive = true;
            player.field_3944.method_52787((class_2596)new class_2848((class_1297)player, class_2848.class_2849.field_12982));
            return true;
        }
        return false;
    }

    private static class_1799 getChestplateSlot(class_746 player) {
        return player.method_31548().method_7372(2);
    }

    public static boolean equipChestplate(class_746 player) {
        int chestplateIndex = ElytraManager.getLastChestplateIndex(player);
        if (chestplateIndex != -1) {
            ElytraManager.swapChestplateSlot(chestplateIndex, player);
            lastUID = -1;
            autoSwapIsActive = false;
            return true;
        }
        return false;
    }

    private static void swapChestplateSlot(int slot, class_746 player) {
        class_636 interactionManager = class_310.method_1551().field_1761;
        assert (interactionManager != null);
        interactionManager.method_2906(0, slot, 0, class_1713.field_7790, (class_1657)player);
        interactionManager.method_2906(0, 6, 0, class_1713.field_7790, (class_1657)player);
        interactionManager.method_2906(0, slot, 0, class_1713.field_7790, (class_1657)player);
        player.field_3944.method_52787((class_2596)new class_2848((class_1297)player, class_2848.class_2849.field_12982));
    }

    private static int getItemUID(class_1799 stack) {
        if (stack.method_7960()) {
            return -1;
        }
        return stack.method_7964().hashCode() + stack.method_58657().hashCode() + stack.method_7919();
    }

    private static int getLastChestplateIndex(class_746 player) {
        class_1661 inv = player.method_31548();
        if (inv == null) {
            return -1;
        }
        for (int slot : ElytraManager.slotArray()) {
            class_1799 stack = inv.method_5438(slot);
            if (ElytraManager.getItemUID(stack) != lastUID) continue;
            return ElytraManager.DataSlotToNetworkSlot(slot);
        }
        return -1;
    }

    public static int getElytraIndex(class_1657 player) {
        class_1661 inv = player.method_31548();
        if (inv == null) {
            return -1;
        }
        class_1937 world = player.method_37908();
        int bestSlot = -1;
        class_1799 bestItemStack = null;
        int bestPriority = Integer.MAX_VALUE;
        for (int slot : ElytraManager.slotArray()) {
            class_1799 stack = inv.method_5438(slot);
            if (!stack.method_31574(class_1802.field_8833) || stack.method_7919() >= stack.method_7936() - ModConfig.INSTANCE.elytraReplaceDurability) continue;
            boolean hasMending = ElytraManager.elytraHasMending(stack, world);
            int unbreakingLevel = ElytraManager.elytraGetUnbreakingLevel(stack, world);
            int priority = hasMending && unbreakingLevel > 0 ? 1 : (hasMending ? 2 : (unbreakingLevel > 0 ? 3 : 4));
            if (priority >= bestPriority && (priority != bestPriority || stack.method_7919() <= bestItemStack.method_7919())) continue;
            bestSlot = slot;
            bestItemStack = stack;
            bestPriority = priority;
        }
        return ElytraManager.DataSlotToNetworkSlot(bestSlot);
    }

    private static boolean elytraHasMending(class_1799 elytra, class_1937 world) {
        Optional registry = world.method_30349().method_46759(class_7924.field_41265);
        if (registry.isEmpty() || ((class_2378)registry.get()).method_10223(class_1893.field_9101.method_29177()).isEmpty()) {
            return false;
        }
        int res = class_1890.method_8225((class_6880)((class_6880)((class_2378)registry.get()).method_10223(class_1893.field_9101.method_29177()).get()), (class_1799)elytra);
        return res > 0;
    }

    private static int elytraGetUnbreakingLevel(class_1799 elytra, class_1937 world) {
        Optional registry = world.method_30349().method_46759(class_7924.field_41265);
        if (registry.isEmpty() || ((class_2378)registry.get()).method_10223(class_1893.field_9119.method_29177()).isEmpty()) {
            return 0;
        }
        return class_1890.method_8225((class_6880)((class_6880)((class_2378)registry.get()).method_10223(class_1893.field_9119.method_29177()).get()), (class_1799)elytra);
    }

    public static int DataSlotToNetworkSlot(int index) {
        if (index == 100) {
            index = 8;
        } else if (index == 101) {
            index = 7;
        } else if (index == 102) {
            index = 6;
        } else if (index == 103) {
            index = 5;
        } else if (index == -106 || index == 40) {
            index = 45;
        } else if (index <= 8) {
            index += 36;
        } else if (index >= 80 && index <= 83) {
            index -= 79;
        }
        return index;
    }

    public static int[] slotArray() {
        int i;
        int[] range = new int[37];
        for (i = 0; i < 9; ++i) {
            range[i] = 8 - i;
        }
        for (i = 9; i < 36; ++i) {
            range[i] = 35 - (i - 9);
        }
        range[36] = 40;
        return range;
    }
}

