/*
 * Decompiled with CFR 0.152.
 */
package net.elytraautopilot.utils;

import java.util.ArrayList;
import java.util.List;
import net.elytraautopilot.ElytraAutoPilot;
import net.elytraautopilot.config.ModConfig;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class Hud {
    private static List<Double> velocityList = new ArrayList<Double>();
    private static List<Double> velocityListHorizontal = new ArrayList<Double>();
    private static int _tick;
    private static int _index;
    public static class_2561[] hudString;

    public static void tick() {
        ++_tick;
    }

    public static void drawHud(class_1657 player) {
        if (!ModConfig.INSTANCE.showGui) {
            hudString = new class_2561[0];
            return;
        }
        double altitude = player.method_19538().field_1351;
        int gticks = Math.max(1, ModConfig.INSTANCE.groundCheckTicks);
        if (_tick >= gticks) {
            if (++_index >= 1200 / gticks) {
                _index = 0;
            }
            if (velocityList.size() < 1200 / gticks) {
                velocityList.add(ElytraAutoPilot.currentVelocity);
                velocityListHorizontal.add(ElytraAutoPilot.currentVelocityHorizontal);
            } else {
                velocityList.set(_index, ElytraAutoPilot.currentVelocity);
                velocityListHorizontal.set(_index, ElytraAutoPilot.currentVelocityHorizontal);
            }
            class_1937 world = player.method_37908();
            int l = world.method_31607();
            class_243 clientPos = player.method_19538();
            for (double i = clientPos.method_10214(); i > (double)l; i -= 1.0) {
                class_2338 blockPos = class_2338.method_49637((double)clientPos.method_10216(), (double)i, (double)clientPos.method_10215());
                if (world.method_8320(blockPos).method_26212((class_1922)world, blockPos)) {
                    ElytraAutoPilot.groundheight = clientPos.method_10214() - i;
                    break;
                }
                ElytraAutoPilot.groundheight = clientPos.method_10214();
            }
            _tick = 0;
            double avgVelocity = 0.0;
            double avgHorizontalVelocity = 0.0;
            if (velocityList.size() >= 10) {
                avgVelocity = velocityList.stream().mapToDouble(d -> d).average().orElse(0.0);
                avgHorizontalVelocity = velocityListHorizontal.stream().mapToDouble(d -> d).average().orElse(0.0);
            }
            ArrayList<class_5250> lines = new ArrayList<class_5250>();
            if (ModConfig.INSTANCE.showEnabled) {
                lines.add(class_2561.method_43471((String)"text.elytraautopilot.hud.toggleAutoFlight").method_10852((class_2561)class_2561.method_43471((String)(ElytraAutoPilot.autoFlight ? "text.elytraautopilot.hud.true" : "text.elytraautopilot.hud.false")).method_27692(ElytraAutoPilot.autoFlight ? class_124.field_1060 : class_124.field_1061)));
            }
            if (ModConfig.INSTANCE.showAltitude) {
                lines.add(class_2561.method_43469((String)"text.elytraautopilot.hud.altitude", (Object[])new Object[]{String.format("%.2f", altitude)}).method_27692(class_124.field_1075));
            }
            if (ModConfig.INSTANCE.showHeight) {
                String heightStr = ElytraAutoPilot.groundheight < 0.0 ? "???" : String.valueOf(Math.round(ElytraAutoPilot.groundheight));
                lines.add(class_2561.method_43469((String)"text.elytraautopilot.hud.heightFromGround", (Object[])new Object[]{heightStr}).method_27692(class_124.field_1075));
            }
            if (ModConfig.INSTANCE.showHeightReq) {
                boolean ready = ElytraAutoPilot.groundheight > (double)ModConfig.INSTANCE.minHeight;
                String req = ready ? "Ready" : String.valueOf(Math.round((double)ModConfig.INSTANCE.minHeight - ElytraAutoPilot.groundheight));
                lines.add(class_2561.method_43471((String)"text.elytraautopilot.hud.neededHeight").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)req).method_27692(ready ? class_124.field_1060 : class_124.field_1061)));
            }
            if (ModConfig.INSTANCE.showSpeed) {
                lines.add(class_2561.method_43469((String)"text.elytraautopilot.hud.speed", (Object[])new Object[]{String.format("%.2f", ElytraAutoPilot.currentVelocity * 20.0)}).method_27692(class_124.field_1054));
            }
            if (ModConfig.INSTANCE.showAvgSpeed) {
                if (avgVelocity == 0.0) {
                    lines.add(class_2561.method_43471((String)"text.elytraautopilot.hud.calculating").method_27692(class_124.field_1068));
                } else {
                    lines.add(class_2561.method_43469((String)"text.elytraautopilot.hud.avgSpeed", (Object[])new Object[]{String.format("%.2f", avgVelocity * 20.0)}).method_27692(class_124.field_1054));
                }
            }
            if (ModConfig.INSTANCE.showHorizontalSpeed && avgVelocity != 0.0) {
                lines.add(class_2561.method_43469((String)"text.elytraautopilot.hud.avgHSpeed", (Object[])new Object[]{String.format("%.2f", avgHorizontalVelocity * 20.0)}).method_27692(class_124.field_1054));
            }
            if (ElytraAutoPilot.isflytoActive && !ElytraAutoPilot.forceLand) {
                if (ModConfig.INSTANCE.showFlyTo) {
                    lines.add(class_2561.method_43469((String)"text.elytraautopilot.flyto", (Object[])new Object[]{ElytraAutoPilot.argXpos, ElytraAutoPilot.argZpos}).method_27692(class_124.field_1076));
                }
                if (ElytraAutoPilot.distance != 0.0 && ModConfig.INSTANCE.showEta) {
                    lines.add(class_2561.method_43469((String)"text.elytraautopilot.hud.eta", (Object[])new Object[]{String.valueOf(Math.round(ElytraAutoPilot.distance / (avgHorizontalVelocity * 20.0)))}).method_27692(class_124.field_1076));
                }
                if (ModConfig.INSTANCE.showAutoLand) {
                    lines.add(class_2561.method_43471((String)"text.elytraautopilot.hud.autoLand").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43471((String)(ModConfig.INSTANCE.autoLanding ? "text.elytraautopilot.hud.enabled" : "text.elytraautopilot.hud.disabled")).method_27692(ModConfig.INSTANCE.autoLanding ? class_124.field_1060 : class_124.field_1061)));
                }
                if (ElytraAutoPilot.isLanding && ModConfig.INSTANCE.showLandingStatus) {
                    lines.add(class_2561.method_43471((String)"text.elytraautopilot.hud.landing").method_27692(class_124.field_1076));
                }
            }
            if (ElytraAutoPilot.forceLand && ModConfig.INSTANCE.showLandingStatus) {
                lines.add(class_2561.method_43471((String)"text.elytraautopilot.hud.landing").method_27692(class_124.field_1076));
            }
            hudString = lines.toArray(new class_2561[0]);
        }
    }

    public static void clearHud() {
        velocityList.clear();
        velocityListHorizontal.clear();
    }

    static {
        _index = -1;
    }
}

