/*
 * Decompiled with CFR 0.152.
 */
package net.elytraautopilot;

import com.terraformersmc.modmenu.ModMenu;
import net.elytraautopilot.commands.ClientCommands;
import net.elytraautopilot.config.ModConfig;
import net.elytraautopilot.utils.ElytraManager;
import net.elytraautopilot.utils.Hud;
import net.elytraautopilot.utils.HudRenderer;
import net.elytraautopilot.utils.KeyBindings;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElytraAutoPilot
implements ClientModInitializer {
    public static final String MODID = "elytraautopilot";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ElytraAutoPilot");
    private static boolean configPressed = false;
    private static boolean landPressed = false;
    private static boolean takeoffPressed = false;
    public static class_310 minecraftClient;
    public static boolean calculateHud;
    public static boolean autoFlight;
    private static final int TAKEOFF_COOLDOWN_TICKS = 5;
    private static int takeoffCooldown;
    private static boolean onTakeoff;
    public static double pitchMod;
    public static class_243 previousPosition;
    public static double currentVelocity;
    public static double currentVelocityHorizontal;
    public static boolean isDescending;
    public static boolean pullUp;
    public static boolean pullDown;
    private static double velHigh;
    private static double velLow;
    public static int argXpos;
    public static int argZpos;
    public static boolean isChained;
    public static boolean isflytoActive;
    public static boolean forceLand;
    public static boolean isLanding;
    public static float GLIDE_ANGLE;
    public static boolean doGlide;
    public static double distance;
    public static double groundheight;

    public void onInitializeClient() {
        minecraftClient = class_310.method_1551();
        KeyBindings.init();
        HudElementRegistry.addLast((class_2960)class_2960.method_60655((String)MODID, (String)"hud"), (context, tickCounter) -> {
            this.onScreenTick();
            HudRenderer.drawHud(context, tickCounter);
        });
        ClientTickEvents.END_CLIENT_TICK.register(e -> this.onClientTick());
        ClientCommands.register(minecraftClient);
    }

    public static String getModId() {
        return MODID;
    }

    public static void takeoff() {
        class_746 player = ElytraAutoPilot.minecraftClient.field_1724;
        if (!onTakeoff) {
            if (player != null) {
                double c;
                if (ModConfig.INSTANCE.elytraAutoSwap) {
                    int elytraSlot = ElytraManager.getElytraIndex((class_1657)player);
                    if (elytraSlot == -100) {
                        player.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.takeoffFail.noElytraInInventory").method_27692(class_124.field_1061), true);
                        return;
                    }
                    ElytraManager.equipElytra(player);
                } else {
                    class_1799 itemStack = ElytraManager.getChestplateSlot(player);
                    if (itemStack.method_7909() != class_1802.field_8833) {
                        player.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.takeoffFail.noElytraEquipped").method_27692(class_124.field_1061), true);
                        return;
                    }
                    int elytraDamage = itemStack.method_7936() - itemStack.method_7919();
                    if (elytraDamage == 1) {
                        player.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.takeoffFail.elytraBroken").method_27692(class_124.field_1061), true);
                        return;
                    }
                }
                class_1792 itemMain = player.method_6047().method_7909();
                class_1792 itemOff = player.method_6079().method_7909();
                class_1799 chestplateSlot = ElytraManager.getChestplateSlot(player);
                class_1792 itemChest = chestplateSlot.method_7909();
                int elytraDamage = chestplateSlot.method_7936() - chestplateSlot.method_7919();
                if (itemChest != class_1802.field_8833) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.takeoffFail.noElytraEquipped").method_27692(class_124.field_1061), true);
                    return;
                }
                if (elytraDamage == 1) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.takeoffFail.elytraBroken").method_27692(class_124.field_1061), true);
                    return;
                }
                if (itemMain != class_1802.field_8639 && itemOff != class_1802.field_8639) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.takeoffFail.fireworkRequired").method_27692(class_124.field_1061), true);
                    return;
                }
                class_1937 world = player.method_73183();
                class_243 clientPos = player.method_73189();
                int l = world.method_31600();
                int n = 2;
                for (double i = c = clientPos.method_10214(); i < (double)l; i += 1.0) {
                    class_2338 blockPos = class_2338.method_49637((double)clientPos.method_10216(), (double)(clientPos.method_10214() + (double)n), (double)clientPos.method_10215());
                    if (!world.method_8320(blockPos).method_26215()) {
                        player.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.takeoffFail.clearSkyNeeded").method_27692(class_124.field_1061), true);
                        return;
                    }
                    ++n;
                }
                takeoffCooldown = 5;
                ElytraAutoPilot.minecraftClient.field_1690.field_1903.method_23481(true);
            }
            return;
        }
        if (player != null) {
            boolean hasFirework;
            if (groundheight > (double)ModConfig.INSTANCE.minHeight) {
                onTakeoff = false;
                ElytraAutoPilot.minecraftClient.field_1690.field_1904.method_23481(false);
                ElytraAutoPilot.minecraftClient.field_1690.field_1903.method_23481(false);
                autoFlight = true;
                pitchMod = 3.0;
                if (isChained) {
                    isflytoActive = true;
                    isChained = false;
                    ElytraAutoPilot.minecraftClient.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"text.elytraautopilot.flyto", (Object[])new Object[]{argXpos, argZpos}).method_27692(class_124.field_1060));
                }
                return;
            }
            if (!player.method_6128()) {
                ElytraAutoPilot.minecraftClient.field_1690.field_1903.method_23481(!ElytraAutoPilot.minecraftClient.field_1690.field_1903.method_1434());
            }
            class_1792 itemMain = player.method_6047().method_7909();
            class_1792 itemOff = player.method_6079().method_7909();
            boolean bl = hasFirework = itemMain == class_1802.field_8639 || itemOff == class_1802.field_8639;
            if (!hasFirework) {
                if (!ElytraAutoPilot.tryRestockFirework((class_1657)player)) {
                    ElytraAutoPilot.minecraftClient.field_1690.field_1904.method_23481(false);
                    ElytraAutoPilot.minecraftClient.field_1690.field_1903.method_23481(false);
                    onTakeoff = false;
                    player.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.takeoffAbort.noFirework").method_27692(class_124.field_1061), true);
                    doGlide = true;
                }
            } else {
                ElytraAutoPilot.minecraftClient.field_1690.field_1904.method_23481(currentVelocity < 0.75 && player.method_36455() == -90.0f);
            }
        }
    }

    private void onScreenTick() {
        class_746 player;
        if (minecraftClient.method_1493()) {
            doGlide = false;
            if (minecraftClient.method_1542()) {
                return;
            }
        }
        if ((player = ElytraAutoPilot.minecraftClient.field_1724) == null) {
            return;
        }
        float fps_delta = minecraftClient.method_61966().method_60636();
        float fps_result = 20.0f / fps_delta;
        double speedMod = 60.0f / fps_result;
        float pitch = player.method_36455();
        if (onTakeoff) {
            if (pitch > -90.0f) {
                player.method_36457((float)((double)pitch - ModConfig.INSTANCE.takeOffPull * speedMod));
                pitch = player.method_36455();
            }
            if (pitch <= -90.0f) {
                player.method_36457(-90.0f);
            }
        }
        if (autoFlight) {
            if (isflytoActive || forceLand) {
                if (isLanding || forceLand) {
                    if (!forceLand && !ModConfig.INSTANCE.autoLanding) {
                        isflytoActive = false;
                        isLanding = false;
                        return;
                    }
                    isDescending = true;
                    if (ModConfig.INSTANCE.riskyLanding && groundheight > 60.0) {
                        this.riskyLanding((class_1657)player, speedMod);
                    } else {
                        this.smoothLanding((class_1657)player, speedMod);
                    }
                } else {
                    class_243 playerPosition = player.method_73189();
                    double f = (double)argXpos - playerPosition.field_1352;
                    double d = (double)argZpos - playerPosition.field_1350;
                    float targetYaw = class_3532.method_15393((float)((float)(class_3532.method_15349((double)d, (double)f) * 57.2957763671875) - 90.0f));
                    float yaw = class_3532.method_15393((float)player.method_36454());
                    if ((double)Math.abs(yaw - targetYaw) < ModConfig.INSTANCE.turningSpeed * 2.0 * speedMod) {
                        player.method_36456(targetYaw);
                    } else {
                        if (yaw < targetYaw) {
                            player.method_36456((float)((double)yaw + ModConfig.INSTANCE.turningSpeed * speedMod));
                        }
                        if (yaw > targetYaw) {
                            player.method_36456((float)((double)yaw - ModConfig.INSTANCE.turningSpeed * speedMod));
                        }
                    }
                    distance = Math.sqrt(f * f + d * d);
                    if (distance < 20.0) {
                        ElytraAutoPilot.minecraftClient.field_1724.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.landing").method_27692(class_124.field_1078), true);
                        class_3414 soundEvent = class_3414.method_47908((class_2960)class_2960.method_60654((String)ModConfig.INSTANCE.playSoundOnLanding));
                        player.method_5783(soundEvent, 1.3f, 1.0f);
                        isLanding = true;
                    }
                }
            }
            if (pullUp && !isLanding && !forceLand) {
                player.method_36457((float)((double)pitch - ModConfig.INSTANCE.pullUpSpeed * speedMod));
                pitch = player.method_36455();
                if ((double)pitch <= ModConfig.INSTANCE.pullUpAngle) {
                    player.method_36457((float)ModConfig.INSTANCE.pullUpAngle);
                }
                ElytraAutoPilot.minecraftClient.field_1690.field_1904.method_23481(ModConfig.INSTANCE.poweredFlight && currentVelocity < 1.25);
            }
            if (pullDown && !isLanding && !forceLand) {
                player.method_36457((float)((double)pitch + ModConfig.INSTANCE.pullDownSpeed * pitchMod * speedMod));
                pitch = player.method_36455();
                if ((double)pitch >= ModConfig.INSTANCE.pullDownAngle) {
                    player.method_36457((float)ModConfig.INSTANCE.pullDownAngle);
                }
                ElytraAutoPilot.minecraftClient.field_1690.field_1904.method_23481(ModConfig.INSTANCE.poweredFlight && currentVelocity < 1.25);
            }
        } else {
            velHigh = 0.0;
            velLow = 0.0;
            isLanding = false;
            forceLand = false;
            isflytoActive = false;
            pullUp = false;
            pitchMod = 1.0;
            pullDown = false;
        }
    }

    private void onClientTick() {
        class_746 player;
        if (!minecraftClient.method_1493() || !minecraftClient.method_1542()) {
            Hud.tick();
        }
        if (ClientCommands.bufferSave) {
            ModConfig.INSTANCE.saveConfig(ModConfig.CONFIG_FILE.toFile());
            ClientCommands.bufferSave = false;
        }
        if ((player = ElytraAutoPilot.minecraftClient.field_1724) == null) {
            autoFlight = false;
            onTakeoff = false;
            return;
        }
        if (player.method_6128()) {
            calculateHud = true;
        } else {
            calculateHud = false;
            autoFlight = false;
            groundheight = -1.0;
        }
        if (autoFlight) {
            int durability = ElytraManager.getElytraDurability(player);
            if (ModConfig.INSTANCE.emergencyLand && durability < ModConfig.INSTANCE.elytraReplaceDurability) {
                forceLand = ModConfig.INSTANCE.elytraAutoSwap ? (ElytraAutoPilot.canRestockElytra(player) ? !ElytraAutoPilot.tryRestockElytra(player) : true) : true;
            }
            double altitude = player.method_73189().field_1351;
            if (player.method_5799() || player.method_5771()) {
                isflytoActive = false;
                isLanding = false;
                autoFlight = false;
                return;
            }
            if (isDescending) {
                pullUp = false;
                pullDown = true;
                if (altitude > (double)ModConfig.INSTANCE.maxHeight) {
                    velHigh = 0.3f;
                } else if (altitude > (double)(ModConfig.INSTANCE.maxHeight - 10)) {
                    velLow = 0.28475f;
                }
                double velMod = Math.max(velHigh, velLow);
                if (currentVelocity >= ModConfig.INSTANCE.pullDownMaxVelocity + velMod) {
                    isDescending = false;
                    pullDown = false;
                    pullUp = true;
                    pitchMod = 1.0;
                }
            } else {
                velHigh = 0.0;
                velLow = 0.0;
                pullUp = true;
                pullDown = false;
                if (currentVelocity <= ModConfig.INSTANCE.pullUpMinVelocity || altitude > (double)(ModConfig.INSTANCE.maxHeight - 10)) {
                    isDescending = true;
                    pullDown = true;
                    pullUp = false;
                }
            }
        }
        if (!takeoffPressed && KeyBindings.takeoffBinding.method_1434()) {
            if (onTakeoff) {
                onTakeoff = false;
                ElytraAutoPilot.minecraftClient.field_1690.field_1904.method_23481(false);
                ElytraAutoPilot.minecraftClient.field_1690.field_1903.method_23481(false);
                doGlide = true;
            } else {
                ElytraAutoPilot.takeoff();
            }
        }
        if (!landPressed && KeyBindings.landBinding.method_1434() && autoFlight) {
            player.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.landing").method_27692(class_124.field_1078), true);
            class_3414 soundEvent = class_3414.method_47908((class_2960)class_2960.method_60654((String)ModConfig.INSTANCE.playSoundOnLanding));
            player.method_5783(soundEvent, 1.3f, 1.0f);
            ElytraAutoPilot.minecraftClient.field_1690.field_1904.method_23481(false);
            forceLand = true;
        }
        if (!configPressed && KeyBindings.configBinding.method_1434()) {
            if (player.method_6128()) {
                if (!autoFlight && groundheight < (double)ModConfig.INSTANCE.minHeight) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.autoFlightFail.tooLow").method_27692(class_124.field_1061), true);
                    doGlide = true;
                } else {
                    autoFlight = !autoFlight;
                    ElytraAutoPilot.minecraftClient.field_1690.field_1904.method_23481(false);
                    if (autoFlight) {
                        isDescending = true;
                        pitchMod = 3.0;
                    }
                }
            } else if (FabricLoader.getInstance().isModLoaded("cloth-config")) {
                class_437 configScreen = ModMenu.getConfigScreen((String)MODID, (class_437)ElytraAutoPilot.minecraftClient.field_1755);
                minecraftClient.method_1507(configScreen);
            }
        }
        configPressed = KeyBindings.configBinding.method_1434();
        landPressed = KeyBindings.landBinding.method_1434();
        takeoffPressed = KeyBindings.takeoffBinding.method_1434();
        if (takeoffCooldown > 0 && --takeoffCooldown == 0) {
            onTakeoff = true;
        }
        if (onTakeoff) {
            ElytraAutoPilot.takeoff();
        }
        if (calculateHud) {
            this.computeVelocity();
            Hud.drawHud((class_1657)player);
        } else {
            previousPosition = null;
            Hud.clearHud();
        }
    }

    private static boolean tryRestockFirework(class_1657 player) {
        if (ModConfig.INSTANCE.fireworkHotswap) {
            class_1799 newFirework = null;
            for (class_1799 itemStack : player.method_31548().method_67533()) {
                if (itemStack.method_7909() != class_1802.field_8639) continue;
                newFirework = itemStack;
                break;
            }
            if (newFirework != null) {
                int handSlot = player.method_6079().method_7960() ? 45 : 36 + player.method_31548().method_67532();
                assert (ElytraAutoPilot.minecraftClient.field_1761 != null);
                ElytraAutoPilot.minecraftClient.field_1761.method_2906(player.field_7498.field_7763, handSlot, player.method_31548().method_67533().indexOf((Object)newFirework), class_1713.field_7791, player);
                return true;
            }
        }
        return false;
    }

    private static boolean tryRestockElytra(class_746 player) {
        if (ModConfig.INSTANCE.elytraHotswap) {
            return ElytraManager.equipElytra(player);
        }
        return false;
    }

    private static boolean canRestockElytra(class_746 player) {
        int result = ElytraManager.getElytraIndex((class_1657)player);
        return result != -1;
    }

    private void computeVelocity() {
        class_746 player = ElytraAutoPilot.minecraftClient.field_1724;
        if (!(player == null || minecraftClient.method_1493() && minecraftClient.method_1542())) {
            class_243 newPosition = player.method_73189();
            if (previousPosition == null) {
                previousPosition = newPosition;
            }
            class_243 difference = new class_243(newPosition.field_1352 - ElytraAutoPilot.previousPosition.field_1352, newPosition.field_1351 - ElytraAutoPilot.previousPosition.field_1351, newPosition.field_1350 - ElytraAutoPilot.previousPosition.field_1350);
            class_243 difference_horizontal = new class_243(newPosition.field_1352 - ElytraAutoPilot.previousPosition.field_1352, 0.0, newPosition.field_1350 - ElytraAutoPilot.previousPosition.field_1350);
            previousPosition = newPosition;
            currentVelocity = difference.method_1033();
            currentVelocityHorizontal = difference_horizontal.method_1033();
        }
    }

    private void smoothLanding(class_1657 player, double speedMod) {
        float yaw = class_3532.method_15393((float)player.method_36454());
        float pitch = class_3532.method_15393((float)player.method_36455());
        float fallPitchMax = 50.0f;
        float fallPitchMin = 30.0f;
        float fallPitch = groundheight > 50.0 ? fallPitchMax : (groundheight < 20.0 ? fallPitchMin : (float)((groundheight - 20.0) / 30.0) * 20.0f + fallPitchMin);
        pitchMod = 3.0;
        player.method_36456((float)((double)yaw + ModConfig.INSTANCE.autoLandSpeed * speedMod));
        player.method_36457((float)((double)pitch + ModConfig.INSTANCE.pullDownSpeed * pitchMod * speedMod));
        pitch = player.method_36455();
        if (pitch >= fallPitch) {
            player.method_36457(fallPitch);
        }
    }

    private void riskyLanding(class_1657 player, double speedMod) {
        float pitch = player.method_36455();
        player.method_36457((float)((double)pitch + ModConfig.INSTANCE.takeOffPull * speedMod));
        pitch = player.method_36455();
        if (pitch > 90.0f) {
            player.method_36457(90.0f);
        }
    }

    static {
        takeoffCooldown = 0;
        pitchMod = 1.0;
        velHigh = 0.0;
        velLow = 0.0;
        isChained = false;
        isflytoActive = false;
        forceLand = false;
        isLanding = false;
        GLIDE_ANGLE = 0.0f;
        doGlide = false;
        distance = 0.0;
    }
}

