/*
 * Decompiled with CFR 0.152.
 */
package net.elytraautopilot.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.elytraautopilot.ElytraAutoPilot;
import net.elytraautopilot.config.ModConfig;
import net.elytraautopilot.exceptions.InvalidLocationException;
import net.elytraautopilot.types.FlyToLocation;
import net.elytraautopilot.utils.CommandSuggestionProvider;
import net.elytraautopilot.xaeromapintegration.XaeromapWaypointReader;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_746;

public class ClientCommands {
    public static boolean bufferSave = false;
    private static final boolean isXaeroMinimapInstalled = FabricLoader.getInstance().isModLoaded("xaerominimap");

    public static void register(class_310 minecraftClient) {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"flyto").then(ClientCommandManager.argument((String)"Name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new CommandSuggestionProvider()).executes(context -> {
            int xaeroResult;
            String[] xaeroLocations;
            if (minecraftClient.field_1724 == null) {
                return 0;
            }
            String locationName = StringArgumentType.getString((CommandContext)context, (String)"Name");
            locationName = locationName.replace(";", ":");
            int result = ClientCommands.TryFlyTo(ModConfig.INSTANCE.flyLocations.toArray(new String[0]), locationName, minecraftClient, (CommandContext<FabricClientCommandSource>)context);
            if (result == 1) {
                return 1;
            }
            if (isXaeroMinimapInstalled && (xaeroLocations = XaeromapWaypointReader.GetXearomapWaypoints()) != null && (xaeroResult = ClientCommands.TryFlyTo(xaeroLocations, locationName, minecraftClient, (CommandContext<FabricClientCommandSource>)context)) == 1) {
                return 1;
            }
            minecraftClient.field_1724.method_7353((class_2561)class_2561.method_43469((String)"text.elytraautopilot.flylocationFail.notFound", (Object[])new Object[]{locationName}).method_27692(class_124.field_1061), true);
            return 0;
        }))).then(ClientCommandManager.argument((String)"X", (ArgumentType)IntegerArgumentType.integer((int)-2000000000, (int)2000000000)).then(ClientCommandManager.argument((String)"Z", (ArgumentType)IntegerArgumentType.integer((int)-2000000000, (int)2000000000)).executes(context -> {
            if (minecraftClient.field_1724 == null) {
                return 0;
            }
            if (minecraftClient.field_1724.method_6128()) {
                if (ElytraAutoPilot.groundheight > (double)ModConfig.INSTANCE.minHeight) {
                    ElytraAutoPilot.autoFlight = true;
                    ElytraAutoPilot.argXpos = IntegerArgumentType.getInteger((CommandContext)context, (String)"X");
                    ElytraAutoPilot.argZpos = IntegerArgumentType.getInteger((CommandContext)context, (String)"Z");
                    ElytraAutoPilot.isflytoActive = true;
                    ElytraAutoPilot.pitchMod = 3.0;
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"text.elytraautopilot.flyto", (Object[])new Object[]{ElytraAutoPilot.argXpos, ElytraAutoPilot.argZpos}).method_27692(class_124.field_1060));
                } else {
                    minecraftClient.field_1724.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.autoFlightFail.tooLow").method_27692(class_124.field_1061), true);
                }
            } else {
                minecraftClient.field_1724.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.flytoFail.flyingRequired").method_27692(class_124.field_1061), true);
            }
            return 1;
        })))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"takeoff").then(ClientCommandManager.argument((String)"Name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new CommandSuggestionProvider()).executes(context -> {
            int successXaeroTakeOff;
            String[] xaeroLocations;
            if (minecraftClient.field_1724 == null) {
                return 0;
            }
            String locationName = StringArgumentType.getString((CommandContext)context, (String)"Name");
            locationName = locationName.replace(";", ":");
            int successLocalTakeOff = ClientCommands.TryTakeoff(ModConfig.INSTANCE.flyLocations.toArray(new String[0]), locationName);
            if (successLocalTakeOff == 1) {
                return 1;
            }
            if (isXaeroMinimapInstalled && (xaeroLocations = XaeromapWaypointReader.GetXearomapWaypoints()) != null && (successXaeroTakeOff = ClientCommands.TryTakeoff(xaeroLocations, locationName)) == 1) {
                return 1;
            }
            minecraftClient.field_1724.method_7353((class_2561)class_2561.method_43469((String)"text.elytraautopilot.flylocationFail.notFound", (Object[])new Object[]{locationName}).method_27692(class_124.field_1061), true);
            return 0;
        }))).then(ClientCommandManager.argument((String)"X", (ArgumentType)IntegerArgumentType.integer((int)-2000000000, (int)2000000000)).then(ClientCommandManager.argument((String)"Z", (ArgumentType)IntegerArgumentType.integer((int)-2000000000, (int)2000000000)).executes(context -> {
            ElytraAutoPilot.argXpos = IntegerArgumentType.getInteger((CommandContext)context, (String)"X");
            ElytraAutoPilot.argZpos = IntegerArgumentType.getInteger((CommandContext)context, (String)"Z");
            ElytraAutoPilot.isChained = true;
            ElytraAutoPilot.takeoff();
            return 1;
        })))).executes(context -> {
            ElytraAutoPilot.takeoff();
            return 1;
        })));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"flylocation").then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"Name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new CommandSuggestionProvider()).executes(context -> {
            if (minecraftClient.field_1724 == null) {
                return 0;
            }
            String locationName = StringArgumentType.getString((CommandContext)context, (String)"Name");
            locationName = locationName.replace(";", ":");
            int index = 0;
            for (String s : ModConfig.INSTANCE.flyLocations) {
                try {
                    FlyToLocation location = FlyToLocation.ConvertStringToLocation(s);
                    if (!location.Name.equals(locationName)) continue;
                    ModConfig.INSTANCE.flyLocations.remove(index);
                    minecraftClient.field_1724.method_7353((class_2561)class_2561.method_43469((String)"text.elytraautopilot.flylocation.removed", (Object[])new Object[]{locationName}).method_27692(class_124.field_1060), true);
                    return 1;
                }
                catch (InvalidLocationException e) {
                    ElytraAutoPilot.LOGGER.error("Error in reading Fly Location list entry!");
                    break;
                }
            }
            minecraftClient.field_1724.method_7353((class_2561)class_2561.method_43469((String)"text.elytraautopilot.flylocationFail.notFound", (Object[])new Object[]{locationName}).method_27692(class_124.field_1061), true);
            return 0;
        })))).then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"Name", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"X", (ArgumentType)IntegerArgumentType.integer((int)-2000000000, (int)2000000000)).then(ClientCommandManager.argument((String)"Z", (ArgumentType)IntegerArgumentType.integer((int)-2000000000, (int)2000000000)).executes(context -> {
            if (minecraftClient.field_1724 == null) {
                return 0;
            }
            String locationName = StringArgumentType.getString((CommandContext)context, (String)"Name");
            locationName = locationName.replace(";", ":");
            int locationX = IntegerArgumentType.getInteger((CommandContext)context, (String)"X");
            int locationZ = IntegerArgumentType.getInteger((CommandContext)context, (String)"Z");
            FlyToLocation newLocation = new FlyToLocation();
            newLocation.Name = locationName;
            newLocation.X = locationX;
            newLocation.Z = locationZ;
            for (String s : ModConfig.INSTANCE.flyLocations) {
                try {
                    FlyToLocation location = FlyToLocation.ConvertStringToLocation(s);
                    if (!location.Name.equals(locationName)) continue;
                    minecraftClient.field_1724.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.flylocationFail.nameExists").method_27692(class_124.field_1061), true);
                    return 0;
                }
                catch (InvalidLocationException ignored) {
                    ElytraAutoPilot.LOGGER.error("Error in reading Fly Location list entry!");
                    break;
                }
            }
            ModConfig.INSTANCE.flyLocations.add(newLocation.ConvertLocationToString());
            minecraftClient.field_1724.method_7353((class_2561)class_2561.method_43469((String)"text.elytraautopilot.flylocation.saved", (Object[])new Object[]{locationName, locationX, locationZ}).method_27692(class_124.field_1060), true);
            bufferSave = true;
            return 1;
        })))))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"land").executes(context -> {
            if (ElytraAutoPilot.autoFlight) {
                class_746 player = minecraftClient.field_1724;
                if (player == null) {
                    return 0;
                }
                player.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.landing").method_27692(class_124.field_1078), true);
                class_3414 soundEvent = class_3414.method_47908((class_2960)class_2960.method_60654((String)ModConfig.INSTANCE.playSoundOnLanding));
                player.method_5783(soundEvent, 1.3f, 1.0f);
                minecraftClient.field_1690.field_1904.method_23481(false);
                ElytraAutoPilot.forceLand = true;
                return 1;
            }
            return 0;
        })));
    }

    private static int TryTakeoff(String[] locations, String locationName) {
        for (String s : locations) {
            try {
                FlyToLocation location = FlyToLocation.ConvertStringToLocation(s);
                if (!location.Name.equals(locationName)) continue;
                ElytraAutoPilot.argXpos = location.X;
                ElytraAutoPilot.argZpos = location.Z;
                ElytraAutoPilot.isChained = true;
                ElytraAutoPilot.takeoff();
                return 1;
            }
            catch (InvalidLocationException ignored) {
                ElytraAutoPilot.LOGGER.error("Error in reading Fly Location list entry!");
                break;
            }
        }
        return 0;
    }

    private static int TryFlyTo(String[] locations, String locationName, class_310 minecraftClient, CommandContext<FabricClientCommandSource> context) {
        for (String s : locations) {
            try {
                FlyToLocation location = FlyToLocation.ConvertStringToLocation(s);
                if (!location.Name.equals(locationName)) continue;
                assert (minecraftClient.field_1724 != null);
                if (!minecraftClient.field_1724.method_6128()) {
                    minecraftClient.field_1724.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.flytoFail.flyingRequired").method_27692(class_124.field_1061), true);
                    return 1;
                }
                if (ElytraAutoPilot.groundheight <= (double)ModConfig.INSTANCE.minHeight) {
                    minecraftClient.field_1724.method_7353((class_2561)class_2561.method_43471((String)"text.elytraautopilot.autoFlightFail.tooLow").method_27692(class_124.field_1061), true);
                    return 1;
                }
                ElytraAutoPilot.autoFlight = true;
                ElytraAutoPilot.argXpos = location.X;
                ElytraAutoPilot.argZpos = location.Z;
                ElytraAutoPilot.isflytoActive = true;
                ElytraAutoPilot.pitchMod = 3.0;
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"text.elytraautopilot.flyto", (Object[])new Object[]{ElytraAutoPilot.argXpos, ElytraAutoPilot.argZpos}).method_27692(class_124.field_1060));
                return 1;
            }
            catch (InvalidLocationException e) {
                ElytraAutoPilot.LOGGER.error(e.getMessage());
                break;
            }
        }
        return 0;
    }
}

