/*
 * Decompiled with CFR 0.152.
 */
package net.elytraautopilot.xaeromapintegration;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import net.fabricmc.loader.api.FabricLoader;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorldManager;

public class XaeromapWaypointReader {
    public static String[] GetXearomapWaypoints() {
        if (!FabricLoader.getInstance().isModLoaded("xaerominimap")) {
            return null;
        }
        ArrayList<CallSite> locations = new ArrayList<CallSite>();
        ArrayList<Waypoint> deathWaypoints = new ArrayList<Waypoint>();
        MinimapSession session = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        MinimapWorldManager manager = session.getWorldManager();
        WaypointSet waypointSet = manager.getCurrentWorld().getCurrentWaypointSet();
        Iterable waypoints = waypointSet.getWaypoints();
        for (Waypoint waypoint : waypoints) {
            String wpName = waypoint.getName();
            if ("gui.xaero_deathpoint".equals(wpName) || "gui.xaero_deathpoint_old".equals(wpName)) {
                deathWaypoints.add(waypoint);
                continue;
            }
            String name = wpName.replace(";", ":");
            locations.add((CallSite)((Object)(name + ";" + waypoint.getX() + ";" + waypoint.getZ())));
        }
        deathWaypoints.sort((a, b) -> Long.compare(b.getCreatedAt(), a.getCreatedAt()));
        for (int i = 0; i < deathWaypoints.size(); ++i) {
            Waypoint wp = (Waypoint)deathWaypoints.get(i);
            Object label = i == 0 ? "Latest death" : "Old death " + i;
            locations.add((CallSite)((Object)((String)label + ";" + wp.getX() + ";" + wp.getZ())));
        }
        return locations.toArray(new String[0]);
    }
}

