/*
 * Decompiled with CFR 0.152.
 */
package jackperry2187.gentlereminders.commands.client;

import com.mojang.brigadier.context.CommandContext;
import jackperry2187.gentlereminders.config.client.ConfigSettings;
import jackperry2187.gentlereminders.config.client.EditConfigSettings;
import jackperry2187.gentlereminders.handler.client.GRTickManager;
import jackperry2187.gentlereminders.util.Message;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class CommandInit {
    public static int help(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Thank you for downloading Gentle Reminders!").method_27692(class_124.field_1075));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Please enjoy the usage and descriptions of the commands found below.").method_27692(class_124.field_1075));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Commands are in ").method_27692(class_124.field_1075).method_27693("GOLD").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" and descriptions are in ").method_27692(class_124.field_1075).method_27693("GRAY").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Required arguments for the commands are in ").method_27692(class_124.field_1075).method_27693("GREEN").method_27692(class_124.field_1060));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Commands:").method_27692(class_124.field_1076));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" - Displays this help message.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders help").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" - Displays this help message.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Get commands:").method_27692(class_124.field_1076));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders get TimeRemaining").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" - Displays the time remaining until the next mindful message.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders get ConfigPath").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" - Displays the path to the config file.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders get ConfigVersion").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" - Displays the version of the config file.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders get DisplayStyle").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" - Displays the display style of the messages.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders get TicksBetweenMessages").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" - Displays the number of ticks between messages, as well as minutes and seconds.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders get Messages").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" [pageNumber]").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" - Displays the messages in the config file.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Set commands:").method_27692(class_124.field_1076));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders set DisplayStyle").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" [style]").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" - Sets the display style of the messages.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders set CustomDisplayStyle").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" [bgTexture] [borderTexture] [includeIcon]").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" - Sets the display style of the messages to custom, and sets the background and border textures and whether to include the icon.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders set TicksBetweenMessages").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" [ticks]").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" - Sets the number of ticks between messages. Remember there are 20 ticks per second when inputting a number.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders set Message").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" [id] [title] [message] [enabled] [titleColor] [messageColor]").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" - Overwrites the title, message, enabled status, and colors of a message by ID.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Add commands:").method_27692(class_124.field_1076));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders add Message").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" [title] [message] [enabled] [titleColor] [messageColor]").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" - Adds a message to the config file.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Remove commands:").method_27692(class_124.field_1076));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders remove Message").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" [id]").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" - Removes a message from the config file by ID.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Enable commands:").method_27692(class_124.field_1076));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders enable GentleReminders").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" - Enables the mod.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders enable Message").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" [id]").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" - Enables a message by ID.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Disable commands:").method_27692(class_124.field_1076));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders disable GentleReminders").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" - Disables the mod.").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/gentlereminders disable Message").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" [id]").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" - Disables a message by ID.").method_27692(class_124.field_1080)));
        return 1;
    }

    public static int getTimeUntilNextMessage(CommandContext<FabricClientCommandSource> context) {
        int remainingTime = ConfigSettings.ticksBetweenMessages - GRTickManager.totalTickCounter % ConfigSettings.ticksBetweenMessages;
        double remainingTimeInMinutes = (double)remainingTime / 20.0 / 60.0;
        int remainingMinutes = (int)remainingTimeInMinutes;
        int remainingSeconds = (int)((remainingTimeInMinutes - (double)remainingMinutes) * 60.0);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Remaining time until next mindful message: ").method_27692(class_124.field_1075));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)((String)(remainingMinutes > 0 ? remainingMinutes + " minutes and " : "") + remainingSeconds + " seconds")).method_27692(class_124.field_1065));
        return 1;
    }

    public static int getConfigPath(CommandContext<FabricClientCommandSource> context) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Config path:").method_27692(class_124.field_1075));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.valueOf(ConfigSettings.configPath)).method_27692(class_124.field_1065));
        return 1;
    }

    public static int getConfigVersion(CommandContext<FabricClientCommandSource> context) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Config version:").method_27692(class_124.field_1075));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("" + ConfigSettings.configVersion)).method_27692(class_124.field_1065));
        return 1;
    }

    public static int getDisplayStyle(CommandContext<FabricClientCommandSource> context) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Display style:").method_27692(class_124.field_1075));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)ConfigSettings.getDisplayStyle()).method_27692(class_124.field_1065));
        return 1;
    }

    public static int getTicksBetweenMessages(CommandContext<FabricClientCommandSource> context) {
        double remainingTimeInMinutes = (double)ConfigSettings.ticksBetweenMessages / 20.0 / 60.0;
        int remainingMinutes = (int)remainingTimeInMinutes;
        int remainingSeconds = (int)((remainingTimeInMinutes - (double)remainingMinutes) * 60.0);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Ticks between messages:").method_27692(class_124.field_1075));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(ConfigSettings.ticksBetweenMessages + ", which is " + (String)(remainingMinutes > 0 ? remainingMinutes + " minutes" : "") + (remainingMinutes > 0 && remainingSeconds > 0 ? " and " : "") + (String)(remainingSeconds > 0 ? remainingSeconds + " seconds" : ""))).method_27692(class_124.field_1065));
        return 1;
    }

    public static int getMessages(CommandContext<FabricClientCommandSource> context) {
        Integer pageNumber = (Integer)context.getArgument("pageNumber", Integer.class);
        List<Message> messages = ConfigSettings.messages;
        int totalPages = (int)Math.ceil((double)messages.size() / 5.0);
        int startIndex = (pageNumber - 1) * 5;
        int endIndex = Math.min(pageNumber * 5, messages.size());
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Messages:").method_27692(class_124.field_1075));
        for (int i = startIndex; i < endIndex; ++i) {
            Message message = messages.get(i);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"ID: ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)("" + message.ID)).method_27692(class_124.field_1075)));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Title: ").method_27692(class_124.field_1065).method_10852(message.Title));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Description: ").method_27692(class_124.field_1065).method_10852(message.Description));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Enabled: ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)("" + message.Enabled)).method_27692(message.Enabled ? class_124.field_1060 : class_124.field_1061)));
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Page ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)("" + pageNumber)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" of ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)("" + totalPages)).method_27692(class_124.field_1065))));
        return 1;
    }

    public static int setDisplayStyle(CommandContext<FabricClientCommandSource> context) {
        String style = (String)context.getArgument("style", String.class);
        if (style.equals("custom")) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Use /gentlereminders set CustomDisplayStyle instead!").method_27692(class_124.field_1061));
            return 1;
        }
        ConfigSettings.setDisplayStyle(style);
        boolean fileSuccess = EditConfigSettings.setFileValue("displayStyle", "\"" + style + "\"");
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Display style has been set to ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)style).method_27692(class_124.field_1065)));
        if (fileSuccess) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Config file has been updated!").method_27692(class_124.field_1065));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Failed to update config file! Value has still been modified for this session.").method_27692(class_124.field_1061));
        }
        return 1;
    }

    public static int setCustomDisplayStyle(CommandContext<FabricClientCommandSource> context) {
        String bgTexture = ((class_2960)context.getArgument("bgTexture", class_2960.class)).toString();
        String borderTexture = ((class_2960)context.getArgument("borderTexture", class_2960.class)).toString();
        Boolean includeIcon = (Boolean)context.getArgument("includeIcon", Boolean.class);
        class_2960 bgTextureIdentifier = class_2960.method_60656((String)("textures/block/" + bgTexture.replace("minecraft:", "") + ".png"));
        class_2960 borderTextureIdentifier = class_2960.method_60656((String)("textures/block/" + borderTexture.replace("minecraft:", "") + ".png"));
        ConfigSettings.setDisplayStyle("custom");
        ConfigSettings.setCustomBackgroundTexture(bgTextureIdentifier);
        ConfigSettings.setCustomBorderTexture(borderTextureIdentifier);
        ConfigSettings.setCustomIncludeIcon(includeIcon);
        boolean fileSuccess = EditConfigSettings.setFileValue("displayStyle", "\"custom\"");
        boolean fileSuccess2 = EditConfigSettings.setFileValue("customBGTexture", "\"" + bgTexture + "\"");
        boolean fileSuccess3 = EditConfigSettings.setFileValue("customBorderTexture", "\"" + borderTexture + "\"");
        boolean fileSuccess4 = EditConfigSettings.setFileValue("customIncludeIcon", "\"" + includeIcon + "\"");
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Display style has been set to ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)"custom").method_27692(class_124.field_1065)));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Background texture has been set to ").method_27692(class_124.field_1075).method_27693(bgTexture.toString()).method_27692(class_124.field_1065));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Border texture has been set to ").method_27692(class_124.field_1075).method_27693(borderTexture.toString()).method_27692(class_124.field_1065));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Include icon has been set to ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)("" + includeIcon)).method_27692(class_124.field_1065)));
        if (fileSuccess && fileSuccess2 && fileSuccess3 && fileSuccess4) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Config file has been updated!").method_27692(class_124.field_1065));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Failed to update config file! Value has still been modified for this session.").method_27692(class_124.field_1061));
        }
        return 1;
    }

    public static int setTicksBetweenMessages(CommandContext<FabricClientCommandSource> context) {
        Integer ticks = (Integer)context.getArgument("ticks", Integer.class);
        ConfigSettings.ticksBetweenMessages = ticks;
        boolean fileSuccess = EditConfigSettings.setFileValue("timeBetweenMessages", "" + Math.max(ticks / 20 / 60, 1));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Ticks between messages has been set to ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)("" + ticks)).method_27692(class_124.field_1065)));
        if (fileSuccess) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Config file has been updated!").method_27692(class_124.field_1065));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Failed to update config file! Value has still been modified for this session.").method_27692(class_124.field_1061));
        }
        return 1;
    }

    public static int setMessage(CommandContext<FabricClientCommandSource> context) {
        Integer id = (Integer)context.getArgument("id", Integer.class);
        String title = (String)context.getArgument("title", String.class);
        String message = (String)context.getArgument("message", String.class);
        boolean enabled = (Boolean)context.getArgument("enabled", Boolean.class);
        class_124 titleColor = (class_124)context.getArgument("titleColor", class_124.class);
        class_124 messageColor = (class_124)context.getArgument("messageColor", class_124.class);
        class_5250 formattedTitle = class_2561.method_43470((String)title).method_27692(titleColor);
        class_5250 formattedMessage = class_2561.method_43470((String)message).method_27692(messageColor);
        boolean foundMessage = false;
        for (Message m : ConfigSettings.messages) {
            if (m.ID != id) continue;
            m.Title = formattedTitle;
            m.Description = formattedMessage;
            m.Enabled = enabled;
            foundMessage = true;
            break;
        }
        if (!foundMessage) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Message with ID " + id + " not found!")).method_27692(class_124.field_1061));
            return 1;
        }
        boolean fileSuccess = EditConfigSettings.setFileMessage(id, new Message(id, (class_2561)formattedTitle, (class_2561)formattedMessage, enabled));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Message with ID ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)("" + id)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" has been updated.").method_27692(class_124.field_1075)));
        if (fileSuccess) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Config file has been updated!").method_27692(class_124.field_1065));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Failed to update config file! Value has still been modified for this session.").method_27692(class_124.field_1061));
        }
        return 1;
    }

    public static int addMessage(CommandContext<FabricClientCommandSource> context) {
        int id = ConfigSettings.highestMessageID + 1;
        String title = (String)context.getArgument("title", String.class);
        String message = (String)context.getArgument("message", String.class);
        boolean enabled = (Boolean)context.getArgument("enabled", Boolean.class);
        class_124 titleColor = (class_124)context.getArgument("titleColor", class_124.class);
        class_124 messageColor = (class_124)context.getArgument("messageColor", class_124.class);
        class_5250 formattedTitle = class_2561.method_43470((String)title).method_27692(titleColor);
        class_5250 formattedMessage = class_2561.method_43470((String)message).method_27692(messageColor);
        ConfigSettings.messages.add(new Message(id, (class_2561)formattedTitle, (class_2561)formattedMessage, enabled));
        ConfigSettings.highestMessageID = id;
        boolean fileSuccess = EditConfigSettings.addFileMessage(new Message(id, (class_2561)formattedTitle, (class_2561)formattedMessage, enabled));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Message with ID ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)("" + id)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" has been added.").method_27692(class_124.field_1075)));
        if (fileSuccess) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Config file has been updated!").method_27692(class_124.field_1065));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Failed to update config file! Value has still been modified for this session.").method_27692(class_124.field_1061));
        }
        return 1;
    }

    public static int removeMessage(CommandContext<FabricClientCommandSource> context) {
        Integer id = (Integer)context.getArgument("id", Integer.class);
        boolean foundMessage = false;
        for (Message message : ConfigSettings.messages) {
            if (message.ID != id) continue;
            ConfigSettings.messages.remove(message);
            if (ConfigSettings.highestMessageID == id) {
                --ConfigSettings.highestMessageID;
            }
            foundMessage = true;
            break;
        }
        if (!foundMessage) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Message with ID " + id + " not found!")).method_27692(class_124.field_1061));
            return 1;
        }
        boolean fileSuccess = EditConfigSettings.removeFileLine("{id", "" + id);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Message with ID ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)("" + id)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" has been removed.").method_27692(class_124.field_1075)));
        if (fileSuccess) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Config file has been updated!").method_27692(class_124.field_1065));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Failed to update config file! Value has still been modified for this session.").method_27692(class_124.field_1061));
        }
        return 1;
    }

    public static int enableMod(CommandContext<FabricClientCommandSource> context) {
        ConfigSettings.enabled = true;
        boolean fileSuccess = EditConfigSettings.setFileValue("enabled", "true");
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Gentle Reminders has been enabled.").method_27692(class_124.field_1075));
        if (fileSuccess) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Config file has been updated!").method_27692(class_124.field_1065));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Failed to update config file! Value has still been modified for this session.").method_27692(class_124.field_1061));
        }
        return 1;
    }

    public static int enableMessage(CommandContext<FabricClientCommandSource> context) {
        Integer id = (Integer)context.getArgument("id", Integer.class);
        List<Message> messages = ConfigSettings.messages;
        Message message = null;
        for (Message m : messages) {
            if (m.ID != id) continue;
            message = m;
            break;
        }
        if (message == null) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Message with ID " + String.valueOf(context.getArgument("id", Integer.class)) + " not found!")).method_27692(class_124.field_1061));
            return 1;
        }
        message.Enabled = true;
        boolean fileSuccess = EditConfigSettings.setMessageValue(message.ID, "enabled", "true");
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Message with ID ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)("" + id)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" has been enabled.").method_27692(class_124.field_1075)));
        if (fileSuccess) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Config file has been updated!").method_27692(class_124.field_1065));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Failed to update config file! Value has still been modified for this session.").method_27692(class_124.field_1061));
        }
        return 1;
    }

    public static int disableMod(CommandContext<FabricClientCommandSource> context) {
        ConfigSettings.enabled = false;
        boolean fileSuccess = EditConfigSettings.setFileValue("enabled", "false");
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Gentle Reminders has been disabled.").method_27692(class_124.field_1075));
        if (fileSuccess) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Config file has been updated!").method_27692(class_124.field_1065));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Failed to update config file! Value has still been modified for this session.").method_27692(class_124.field_1061));
        }
        return 1;
    }

    public static int disableMessage(CommandContext<FabricClientCommandSource> context) {
        Integer id = (Integer)context.getArgument("id", Integer.class);
        List<Message> messages = ConfigSettings.messages;
        Message message = null;
        for (Message m : messages) {
            if (m.ID != id) continue;
            message = m;
            break;
        }
        if (message == null) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Message with ID " + String.valueOf(context.getArgument("id", Integer.class)) + " not found!")).method_27692(class_124.field_1061));
            return 1;
        }
        message.Enabled = false;
        boolean fileSuccess = EditConfigSettings.setMessageValue(message.ID, "enabled", "false");
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Message with ID ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)("" + id)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" has been disabled.").method_27692(class_124.field_1075)));
        if (fileSuccess) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Config file has been updated!").method_27692(class_124.field_1065));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Failed to update config file! Value has still been modified for this session.").method_27692(class_124.field_1061));
        }
        return 1;
    }
}

