/*
 * Decompiled with CFR 0.152.
 */
package jackperry2187.gentlereminders.config;

import jackperry2187.gentlereminders.GentleReminders;
import jackperry2187.gentlereminders.config.ConfigLines;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class InitializeConfig {
    private static final Path configPath = FabricLoader.getInstance().getConfigDir();
    private static final Path modConfigFile = configPath.resolve("gentlereminders-config.toml");

    public static void generateConfigFile() {
        try {
            if (Files.exists(modConfigFile, new LinkOption[0])) {
                GentleReminders.LOGGER.info("Config file already exists!");
                if (!InitializeConfig.checkConfigVersion()) {
                    GentleReminders.LOGGER.info("Config version is different, overwriting config file!");
                    Files.write(modConfigFile, ConfigLines.getBaseConfigLines(), StandardOpenOption.TRUNCATE_EXISTING);
                }
                GentleReminders.LOGGER.info("Config version is correct!");
            } else {
                GentleReminders.LOGGER.info("Creating config file!");
                Files.createFile(modConfigFile, new FileAttribute[0]);
                Files.write(modConfigFile, ConfigLines.getBaseConfigLines(), StandardOpenOption.APPEND);
            }
        }
        catch (IOException e) {
            GentleReminders.LOGGER.error("Failed to create config file!");
            throw new RuntimeException(e);
        }
    }

    public static boolean checkConfigVersion() throws IOException {
        if (!Files.exists(modConfigFile, new LinkOption[0])) {
            Files.createFile(modConfigFile, new FileAttribute[0]);
        }
        boolean isCorrectVersion = false;
        for (String line : Files.readAllLines(modConfigFile)) {
            String version;
            if (line.startsWith("#") || !line.startsWith("configVersion=") || Integer.parseInt(version = line.split("=")[1]) != 5) continue;
            isCorrectVersion = true;
            break;
        }
        return isCorrectVersion;
    }
}

