/*
 * Decompiled with CFR 0.152.
 */
package jackperry2187.gentlereminders.config.client;

import jackperry2187.gentlereminders.GentleReminders;
import jackperry2187.gentlereminders.util.Message;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

@Environment(value=EnvType.CLIENT)
public class ConfigSettings {
    private static boolean isInitialized = false;
    public static final Path configPath = FabricLoader.getInstance().getConfigDir();
    public static final Path modConfigFile = configPath.resolve("gentlereminders-config.toml");
    public static int configVersion;
    public static boolean enabled;
    public static int ticksBetweenMessages;
    public static List<Message> messages;
    public static int highestMessageID;
    private static String displayStyle;
    private static final class_2960 DEFAULT_CUSTOM_TOAST;
    private static final class_2960 LIGHT_MODE;
    private static final class_2960 DARK_MODE;
    public static class_2960 CUSTOM_BG_TEXTURE;
    public static class_2960 CUSTOM_BORDER_TEXTURE;
    public static Boolean CUSTOM_INCLUDE_ICON;
    public static class_2960 toastTexture;
    private static final boolean isDebug = false;
    private static final int debugTicksBetweenMessages = 140;

    public static void initialize() {
        if (isInitialized) {
            GentleReminders.LOGGER.error("ConfigSettings have already been initialized!");
            return;
        }
        if (!Files.exists(modConfigFile, new LinkOption[0])) {
            GentleReminders.LOGGER.error("Config file does not exist!");
            throw new RuntimeException("Config file does not exist!");
        }
        ConfigSettings.readConfigFile();
        messages.sort(Comparator.comparingInt(m -> m.ID));
        highestMessageID = ConfigSettings.messages.get((int)(ConfigSettings.messages.size() - 1)).ID;
        isInitialized = true;
    }

    private static void logConfigSettings() {
        GentleReminders.LOGGER.info("Config Version: {}", (Object)configVersion);
        GentleReminders.LOGGER.info("Enabled: {}", (Object)enabled);
        GentleReminders.LOGGER.info("Display Style: {}", (Object)displayStyle);
        GentleReminders.LOGGER.info("Time Between Messages: {} ticks, {} minutes", (Object)ticksBetweenMessages, (Object)(ticksBetweenMessages / 20 / 60));
    }

    private static void readConfigFile() {
        try {
            boolean isReadingMessages = false;
            for (String line : Files.readAllLines(modConfigFile)) {
                if (line.startsWith("#")) continue;
                if (line.startsWith("configVersion=")) {
                    configVersion = Integer.parseInt(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("enabled=")) {
                    enabled = Boolean.parseBoolean(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("displayStyle=")) {
                    String got;
                    switch (got = line.split("=")[1].strip().replace("\"", "")) {
                        case "default": {
                            toastTexture = DEFAULT_CUSTOM_TOAST;
                            displayStyle = "default";
                            break;
                        }
                        case "light": {
                            toastTexture = LIGHT_MODE;
                            displayStyle = "light";
                            break;
                        }
                        case "dark": {
                            toastTexture = DARK_MODE;
                            displayStyle = "dark";
                            break;
                        }
                        case "custom": {
                            toastTexture = CUSTOM_BG_TEXTURE;
                            displayStyle = "custom";
                            break;
                        }
                        case "chat": {
                            displayStyle = "chat";
                            break;
                        }
                        default: {
                            GentleReminders.LOGGER.error("Invalid display style: {}! Should be default, light, dark, or chat; setting to default", (Object)got);
                            displayStyle = "default";
                            break;
                        }
                    }
                    continue;
                }
                if (line.startsWith("timeBetweenMessages=")) {
                    ticksBetweenMessages = Integer.parseInt(line.split("=")[1]) * 20 * 60;
                    continue;
                }
                if (line.startsWith("messages=[")) {
                    isReadingMessages = true;
                    continue;
                }
                if (!isReadingMessages) continue;
                if (line.startsWith("]")) {
                    isReadingMessages = false;
                    continue;
                }
                messages.add(ConfigSettings.parseMessage(line));
            }
        }
        catch (Exception e) {
            GentleReminders.LOGGER.error("Failed to read config file!");
            throw new RuntimeException(e);
        }
    }

    private static Message parseMessage(String line) {
        String[][] parts = (String[][])Arrays.stream(line.split(",")).map(s -> s.trim().replace("\"", "").split("=")).toArray(x$0 -> new String[x$0][]);
        int id = Integer.parseInt(parts[0][1]);
        String title = parts[1][1];
        String message = parts[2][1];
        boolean enabled = Boolean.parseBoolean(parts[3][1]);
        String titleColor = parts[4][1];
        String messageColor = parts[5][1];
        class_5250 titleText = class_5250.method_43477((class_7417)class_2561.method_30163((String)title).method_10851()).method_27692(class_124.method_533((String)titleColor));
        class_5250 messageText = class_5250.method_43477((class_7417)class_2561.method_30163((String)message).method_10851()).method_27692(class_124.method_533((String)messageColor));
        return new Message(id, (class_2561)titleText, (class_2561)messageText, enabled);
    }

    public static String getDisplayStyle() {
        return displayStyle;
    }

    public static void setDisplayStyle(String style) {
        switch (style) {
            case "default": {
                toastTexture = DEFAULT_CUSTOM_TOAST;
                displayStyle = "default";
                break;
            }
            case "light": {
                toastTexture = LIGHT_MODE;
                displayStyle = "light";
                break;
            }
            case "dark": {
                toastTexture = DARK_MODE;
                displayStyle = "dark";
                break;
            }
            case "custom": {
                toastTexture = CUSTOM_BG_TEXTURE;
                displayStyle = "custom";
                break;
            }
            case "chat": {
                displayStyle = "chat";
                break;
            }
            default: {
                GentleReminders.LOGGER.error("Invalid display style: {}! Should be default or chat, setting to default", (Object)style);
                displayStyle = "default";
            }
        }
    }

    public static void setCustomBackgroundTexture(class_2960 texture) {
        CUSTOM_BG_TEXTURE = texture;
    }

    public static void setCustomBorderTexture(class_2960 texture) {
        CUSTOM_BORDER_TEXTURE = texture;
    }

    public static void setCustomIncludeIcon(Boolean include) {
        CUSTOM_INCLUDE_ICON = include;
    }

    static {
        messages = new ArrayList<Message>();
        highestMessageID = 0;
        displayStyle = "default";
        DEFAULT_CUSTOM_TOAST = class_2960.method_43902((String)"minecraft", (String)"textures/gui/sprites/toast/system.png");
        LIGHT_MODE = class_2960.method_43902((String)"gentlereminders", (String)"custom_toasts/system_light.png");
        DARK_MODE = class_2960.method_43902((String)"gentlereminders", (String)"custom_toasts/system_dark.png");
        CUSTOM_BG_TEXTURE = class_2960.method_43902((String)"minecraft", (String)"textures/block/dark_oak_planks.png");
        CUSTOM_BORDER_TEXTURE = class_2960.method_43902((String)"minecraft", (String)"textures/block/amethyst_block.png");
        CUSTOM_INCLUDE_ICON = true;
        toastTexture = DEFAULT_CUSTOM_TOAST;
    }
}

