/*
 * Decompiled with CFR 0.152.
 */
package com.bacco;

import io.github.cottonmc.cotton.gui.widget.data.Color;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ColourVector {
    public int r;
    public int g;
    public int b;

    public ColourVector(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public ColourVector(String hex) {
        hex = "#" + ((String)hex).replace("#", "");
        Color c = Color.decode((String)hex);
        this.r = c.getRed();
        this.g = c.getGreen();
        this.b = c.getBlue();
    }

    public ColourVector(int colour) {
        String hex = String.format("#%06X", 0xFFFFFF & colour);
        Color c = Color.decode(hex);
        this.r = c.getRed();
        this.g = c.getGreen();
        this.b = c.getBlue();
    }

    public void fromHSV(int hue, int sat, int val) {
        float s = (float)sat / 100.0f;
        float v = (float)val / 100.0f;
        float h = (float)hue / 60.0f;
        float chroma = v * s;
        float X = chroma * (1.0f - Math.abs(h % 2.0f - 1.0f));
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (h < 1.0f) {
            r = chroma;
            g = X;
        } else if (h < 2.0f) {
            r = X;
            g = chroma;
        } else if (h < 3.0f) {
            g = chroma;
            b = X;
        } else if (h < 4.0f) {
            g = X;
            b = chroma;
        } else if (h < 5.0f) {
            r = X;
            b = chroma;
        } else if (h <= 6.0f) {
            r = chroma;
            b = X;
        }
        float m = v - chroma;
        this.r = Math.round((r += m) * 255.0f);
        this.g = Math.round((g += m) * 255.0f);
        this.b = Math.round((b += m) * 255.0f);
    }

    public void fromHSL(int hue, int sat, int light) {
        float s = (float)sat / 100.0f;
        float l = (float)light / 100.0f;
        float h = (float)hue / 60.0f;
        float chroma = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float X = chroma * (1.0f - Math.abs(h % 2.0f - 1.0f));
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (h < 1.0f) {
            r = chroma;
            g = X;
        } else if (h < 2.0f) {
            r = X;
            g = chroma;
        } else if (h < 3.0f) {
            g = chroma;
            b = X;
        } else if (h < 4.0f) {
            g = X;
            b = chroma;
        } else if (h < 5.0f) {
            r = X;
            b = chroma;
        } else if (h <= 6.0f) {
            r = chroma;
            b = X;
        }
        float m = l - chroma / 2.0f;
        this.r = Math.round((r += m) * 255.0f);
        this.g = Math.round((g += m) * 255.0f);
        this.b = Math.round((b += m) * 255.0f);
    }

    public String getHex() {
        Object hexR = this.r < 16 ? "0" + Integer.toHexString(this.r) : Integer.toHexString(this.r);
        Object hexG = this.g < 16 ? "0" + Integer.toHexString(this.g) : Integer.toHexString(this.g);
        Object hexB = this.b < 16 ? "0" + Integer.toHexString(this.b) : Integer.toHexString(this.b);
        return ("#" + (String)hexR + (String)hexG + (String)hexB).toUpperCase();
    }

    public int getHue() {
        float min;
        float max = Math.max(Math.max(this.r, this.g), this.b);
        float chroma = max - (min = (float)Math.min(Math.min(this.r, this.g), this.b));
        float h = chroma == 0.0f ? 0.0f : (max == (float)this.r ? (float)(this.g - this.b) / chroma % 6.0f : (max == (float)this.g ? (float)(this.b - this.r) / chroma + 2.0f : (max == (float)this.b ? (float)(this.r - this.g) / chroma + 4.0f : 0.0f)));
        if ((h *= 60.0f) < 0.0f) {
            h += 360.0f;
        }
        return Math.round(h);
    }

    public int getSatV() {
        return Math.round(new Color.RGB(this.r, this.g, this.b).getHSVSaturation() * 100.0f);
    }

    public int getVal() {
        return Math.round(100.0f * ((float)new Color.RGB(this.r, this.g, this.b).getValue() / 255.0f));
    }

    public int getVal255() {
        return new Color.RGB(this.r, this.g, this.b).getValue();
    }

    public int getSatL() {
        float r = (float)this.r / 255.0f;
        float g = (float)this.g / 255.0f;
        float b = (float)this.b / 255.0f;
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float c = max - min;
        float s = c / (1.0f - Math.abs(2.0f * max - c - 1.0f));
        return Math.round(s * 100.0f);
    }

    public int getLight() {
        return Math.round(100.0f * ((float)new Color.RGB(this.r, this.g, this.b).getLightness() / 255.0f));
    }

    public int asInt() {
        this.r = Math.max(0, Math.min(255, this.r));
        this.g = Math.max(0, Math.min(255, this.g));
        this.b = Math.max(0, Math.min(255, this.b));
        return 0xFF000000 | this.r << 16 | this.g << 8 | this.b;
    }

    public double distance(ColourVector otherVector) {
        return Math.sqrt(Math.pow(this.r - otherVector.r, 2.0) + Math.pow(this.g - otherVector.g, 2.0) + Math.pow(this.b - otherVector.b, 2.0));
    }

    public ColourVector add(ColourVector otherVector) {
        this.r += otherVector.r;
        this.g += otherVector.g;
        this.b += otherVector.b;
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColourVector other = (ColourVector)obj;
        return this.r == other.r && this.g == other.g && this.b == other.b;
    }

    public ColourVector div(int i) {
        this.r /= i;
        this.g /= i;
        this.b /= i;
        return this;
    }
}

