/*
 * Decompiled with CFR 0.152.
 */
package com.bacco;

import com.bacco.BlockColourStorage;
import com.bacco.ColourGroup;
import com.bacco.ColourVector;
import com.bacco.IItemBlockColourSaver;
import com.bacco.MCRGBConfig;
import com.bacco.Palette;
import com.bacco.SpriteDetails;
import com.bacco.event.KeyInputHandler;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.opengl.GlStateManager;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1058;
import net.minecraft.class_10868;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import net.minecraft.class_9848;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class MCRGBClient
implements ClientModInitializer {
    static Type listType = new TypeToken<ArrayList<Palette>>(){}.getType();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mcrgb");
    public static final boolean readMode = false;
    public class_310 client;
    int totalBlocks = 0;
    int fails = 0;
    int successes = 0;
    boolean scanned = false;
    public ArrayList<Palette> palettes = new ArrayList();

    public void onInitializeClient() {
        KeyInputHandler.register(this);
        MCRGBConfig.load();
        ClientPlayConnectionEvents.JOIN.register((handler, sender, _client) -> {
            this.client = _client;
            if (this.scanned) {
                return;
            }
            try {
                BlockColourStorage[] loadedBlockColourArray = (BlockColourStorage[])new Gson().fromJson(MCRGBClient.readJson("./mcrgb_colours/file.json"), BlockColourStorage[].class);
                class_7923.field_41175.forEach(block -> {
                    for (BlockColourStorage storage : loadedBlockColourArray) {
                        if (!storage.block.equals(block.method_8389().method_7876())) continue;
                        storage.spriteDetails.forEach(details -> ((IItemBlockColourSaver)block.method_8389()).addSpriteDetails((SpriteDetails)details));
                        break;
                    }
                });
                this.scanned = true;
            }
            catch (Exception e) {
                this.RefreshColours();
            }
        });
        this.LoadPalettes();
        ItemTooltipCallback.EVENT.register((stack, context, type, lines) -> {
            if (!MCRGBConfig.instance.alwaysShowToolTips) {
                return;
            }
            IItemBlockColourSaver item = (IItemBlockColourSaver)stack.method_7909();
            for (int i = 0; i < item.getLength(); ++i) {
                ArrayList<String> strings = item.getSpriteDetails(i).getStrings();
                ArrayList<Integer> colours = item.getSpriteDetails(i).getTextColours();
                if (strings.size() <= 0) continue;
                if (class_310.method_1551().method_74187()) {
                    for (int j = 0; j < strings.size(); ++j) {
                        class_5250 text = class_2561.method_43470((String)strings.get(j)).method_27692(class_124.field_1080);
                        class_5250 text2 = (class_5250)class_2561.method_43470((String)"\u2b1b").method_36136(class_2583.field_24360.method_36139(colours.get(j).intValue())).get(0);
                        if (j > 0) {
                            text2.method_10852((class_2561)text);
                        } else {
                            text2 = text.method_27692(class_124.field_1063);
                        }
                        lines.add(text2);
                    }
                    continue;
                }
                class_5250 text = class_2561.method_43471((String)"tooltip.mcrgb.shift_prompt");
                class_5250 message = text.method_27692(class_124.field_1080);
                lines.add(message);
                break;
            }
        });
    }

    public static void writeJson(String str, String path, String fileName) throws IOException {
        try {
            File dir = new File(path);
            File file = new File(dir, fileName);
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file);
            for (int i = 0; i < str.length(); ++i) {
                fw.write(str.charAt(i));
            }
            fw.close();
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    public static String readJson(String path) {
        try {
            int i;
            FileReader fileReader = new FileReader(path);
            Object str = "";
            while ((i = fileReader.read()) != -1) {
                str = (String)str + (char)i;
            }
            fileReader.close();
            return str;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Set<ColourGroup> GroupColours(ArrayList<ColourVector> rgblist) {
        HashSet<ColourGroup> groups = new HashSet<ColourGroup>();
        for (int i = 0; i < rgblist.size(); ++i) {
            ColourVector iPix = new ColourVector(rgblist.get((int)i).r, rgblist.get((int)i).g, rgblist.get((int)i).b);
            boolean iInGroup = false;
            for (ColourGroup group : groups) {
                if (!group.pixels.contains(iPix)) continue;
                iInGroup = true;
                break;
            }
            if (iInGroup) continue;
            ColourGroup newGroup = new ColourGroup();
            newGroup.pixels.add(iPix);
            for (int j = i + 1; j < rgblist.size(); ++j) {
                ColourVector jPix = new ColourVector(rgblist.get((int)j).r, rgblist.get((int)j).g, rgblist.get((int)j).b);
                if (!(jPix.distance(iPix) < 100.0)) continue;
                boolean jInGroup = false;
                for (ColourGroup group : groups) {
                    if (!group.pixels.contains(jPix)) continue;
                    jInGroup = true;
                    break;
                }
                if (jInGroup) continue;
                newGroup.pixels.add(jPix);
            }
            groups.add(newGroup);
        }
        for (ColourGroup group : groups) {
            ColourVector sum = new ColourVector(0, 0, 0);
            int counter = 0;
            for (ColourVector colour : group.pixels) {
                sum.add(colour);
                ++counter;
            }
            if (counter == 0) {
                return null;
            }
            ColourVector avg = sum.div(counter);
            group.meanColour = new ColourVector(avg.r, avg.g, avg.b);
            group.meanHex = group.meanColour.getHex();
            group.weight = (int)((float)counter / (float)rgblist.size() * 100.0f);
        }
        return groups;
    }

    public void RefreshColours() {
        if (this.client == null) {
            return;
        }
        class_1058 defSprite = ((class_777)((class_10889)this.client.method_1554().method_4743().method_3335(class_2246.field_10340.method_9564()).method_68512(class_5819.method_43047()).get(0)).method_68509(class_2350.field_11036).getFirst()).comp_3724();
        class_2960 atlas = defSprite.method_45852();
        class_10868 glTexture = (class_10868)this.client.method_1531().method_4619(atlas).method_68004();
        int width = glTexture.getWidth(0);
        int height = glTexture.getHeight(0);
        int size = width * height;
        GlStateManager._bindTexture((int)glTexture.method_68427());
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(size * 4));
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        byte[] pixels = new byte[size * 4];
        buffer.get(pixels);
        ArrayList blockColourList = new ArrayList();
        class_7923.field_41175.forEach(block -> {
            if (block.method_8389().method_7876() == class_1802.field_8162.method_7876()) {
                return;
            }
            ((IItemBlockColourSaver)block.method_8389()).clearSpriteDetails();
            BlockColourStorage storage = new BlockColourStorage();
            ++this.totalBlocks;
            HashSet sprites = new HashSet();
            class_2350[] directions = new class_2350[]{class_2350.field_11036, class_2350.field_11033, class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039, null};
            block.method_9595().method_11662().forEach(state -> {
                for (int i = 0; i < directions.length; ++i) {
                    try {
                        class_1087 model = this.client.method_1554().method_4743().method_3335(state);
                        sprites.add(((class_777)((class_10889)model.method_68512(class_5819.method_43047()).getFirst()).method_68509(directions[i]).get(0)).comp_3724());
                        ++this.successes;
                        continue;
                    }
                    catch (Exception e) {
                        ++this.fails;
                    }
                }
            });
            if (sprites.size() < 1) {
                return;
            }
            sprites.forEach(sprite -> {
                String name;
                if (sprite.method_45851().method_45816().method_12832().equals("block/grass_block_side")) {
                    return;
                }
                int spriteX = sprite.method_35806();
                int spriteY = sprite.method_35807();
                int spriteW = sprite.method_45851().method_45807();
                int spriteH = sprite.method_45851().method_45815();
                int firstPixel = (spriteY * width + spriteX) * 4;
                ArrayList<ColourVector> rgbList = new ArrayList<ColourVector>();
                int biomeColour = 0xFFFFFF;
                try {
                    biomeColour = this.client.method_1505().method_1697(block.method_9564(), null, null, 0);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not find biome colour for block: " + String.valueOf(block.method_9518()) + ". Please report this logfile to https://github.com/bacco-bacco/MCRGB/issues");
                }
                for (int row = 0; row < spriteH; ++row) {
                    int firstInRow;
                    for (int pos = firstInRow = firstPixel + row * width * 4; pos < firstInRow + 4 * spriteW; pos += 4) {
                        int pixelColour = class_9848.method_61324((int)pixels[pos + 3], (int)(pixels[pos] & 0xFF), (int)(pixels[pos + 1] & 0xFF), (int)(pixels[pos + 2] & 0xFF));
                        int alpha = class_9848.method_61320((int)pixelColour);
                        if (biomeColour != -1 & (!block.method_9564().method_27852(class_2246.field_10219) || sprite.method_45851().method_45816().method_12832().equals("block/grass_block_top"))) {
                            pixelColour = class_9848.method_61322((int)biomeColour, (int)pixelColour);
                        }
                        if (alpha <= 0) continue;
                        ColourVector c = new ColourVector(class_9848.method_61327((int)pixelColour), class_9848.method_61329((int)pixelColour), class_9848.method_61331((int)pixelColour));
                        rgbList.add(c);
                    }
                }
                Set<ColourGroup> colourGroups = MCRGBClient.GroupColours(rgbList);
                if (colourGroups == null) {
                    return;
                }
                SpriteDetails spriteDetails = new SpriteDetails();
                String[] namesplit = sprite.method_45851().method_45816().toString().split("/");
                spriteDetails.name = name = namesplit[namesplit.length - 1];
                colourGroups.forEach(cg -> {
                    spriteDetails.colourinfo.add(cg.meanColour);
                    spriteDetails.weights.add(cg.weight);
                });
                storage.block = block.method_8389().method_7876();
                storage.spriteDetails.add(spriteDetails);
            });
            storage.spriteDetails.forEach(details -> ((IItemBlockColourSaver)block.method_8389()).addSpriteDetails((SpriteDetails)details));
            blockColourList.add(storage);
        });
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String blockColoursJson = gson.toJson(blockColourList);
        try {
            MCRGBClient.writeJson(blockColoursJson, "./mcrgb_colours/", "file.json");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"message.mcrgb.reloaded"), false);
    }

    public void SavePalettes() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String blockColoursJson = gson.toJson(this.palettes);
        try {
            MCRGBClient.writeJson(blockColoursJson, "./mcrgb_colours/", "palettes.json");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void LoadPalettes() {
        ArrayList loadedPalettes = new ArrayList();
        try {
            loadedPalettes = (ArrayList)new Gson().fromJson(MCRGBClient.readJson("./mcrgb_colours/palettes.json"), listType);
        }
        catch (Exception e) {
            loadedPalettes = new ArrayList();
        }
        if (loadedPalettes == null) {
            loadedPalettes = new ArrayList();
        }
        this.palettes = loadedPalettes;
    }
}

