/*
 * Decompiled with CFR 0.152.
 */
package com.bacco.gui;

import com.bacco.ClothConfigIntegration;
import com.bacco.ColourVector;
import com.bacco.IItemBlockColourSaver;
import com.bacco.MCRGBClient;
import com.bacco.MCRGBConfig;
import com.bacco.SpriteDetails;
import com.bacco.gui.BlockInfoGui;
import com.bacco.gui.ColourScreen;
import com.bacco.gui.MCRGBBaseGui;
import com.bacco.gui.WBlockInfoBox;
import com.bacco.gui.WColourGuiSlot;
import com.bacco.gui.WColourWheel;
import com.bacco.gui.WGradientSlider;
import com.bacco.gui.WSavedPalettesArea;
import com.bacco.gui.WSliderArea;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.widget.TooltipBuilder;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlainPanel;
import io.github.cottonmc.cotton.gui.widget.WScrollBar;
import io.github.cottonmc.cotton.gui.widget.WSlider;
import io.github.cottonmc.cotton.gui.widget.WTextField;
import io.github.cottonmc.cotton.gui.widget.WToggleButton;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import io.github.cottonmc.cotton.gui.widget.data.Texture;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import io.github.cottonmc.cotton.gui.widget.icon.TextureIcon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11909;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.minecraft.class_9848;

@Environment(value=EnvType.CLIENT)
public class ColourGui
extends MCRGBBaseGui {
    ColourGui cg = this;
    static int slotsHeight = 7;
    static int slotsWidth = 9;
    WLabel label = new WLabel((class_2561)class_2561.method_43471((String)"ui.mcrgb.header"));
    public WBlockInfoBox infoBox;
    WScrollBar scrollBar = new WScrollBar(Axis.VERTICAL){

        @Environment(value=EnvType.CLIENT)
        public InputResult onMouseDrag(class_11909 click, double deltaX, double deltaY) {
            ColourGui.this.PlaceSlots();
            return super.onMouseDrag(click, deltaX, deltaY);
        }

        @Environment(value=EnvType.CLIENT)
        public InputResult onMouseScroll(int x, int y, double hAmount, double vAmount) {
            ColourGui.this.PlaceSlots();
            this.setValue(this.getValue() + (int)(-vAmount));
            return InputResult.PROCESSED;
        }
    };
    WPlainPanel labels = new WPlainPanel();
    WLabel rLabel = new WLabel((class_2561)class_2561.method_43471((String)"ui.mcrgb.r_for_red"), -65536);
    WLabel gLabel = new WLabel((class_2561)class_2561.method_43471((String)"ui.mcrgb.g_for_green"), -16711936);
    WLabel bLabel = new WLabel((class_2561)class_2561.method_43471((String)"ui.mcrgb.b_for_blue"), -16776961);
    WSlider rSlider = new WSlider(0, 255, Axis.VERTICAL);
    WSlider gSlider = new WSlider(0, 255, Axis.VERTICAL);
    WSlider bSlider = new WSlider(0, 255, Axis.VERTICAL);
    WPlainPanel inputs = new WPlainPanel();
    WTextField rInput;
    WTextField gInput;
    WTextField bInput;
    class_2960 refreshIdentifier;
    TextureIcon refreshIcon;
    WButton refreshButton;
    class_2960 settingsIdentifier;
    TextureIcon settingsIcon;
    WButton settingsButton;
    WButton rgbButton;
    WButton hsvButton;
    WButton hslButton;
    private ArrayList<class_1799> stacks;
    private ArrayList<WColourGuiSlot> wColourGuiSlots;
    class_1799 helmet;
    class_1799 chestplate;
    class_1799 leggings;
    class_1799 boots;
    class_1799 horse;
    class_1799 wolf;
    WGridPanel armourSlots;
    WColourGuiSlot helmSlot;
    WColourGuiSlot chestSlot;
    WColourGuiSlot legsSlot;
    WColourGuiSlot bootSlot;
    WColourGuiSlot horseSlot;
    WColourGuiSlot wolfSlot;
    WToggleButton colourWheelToggle;
    WPlainPanel sliderArea;
    class_2960 wheelIdentifier;
    WColourWheel colourWheel;
    class_2960 wheelIconIdentifier;
    Texture wheelTex;
    WGradientSlider wheelValueSlider;
    class_2960 sliderIconIdentifier;
    Texture sliderTex;
    WTextField searchField;
    boolean enableSliderListeners;
    ColourMode mode;

    @Environment(value=EnvType.CLIENT)
    public ColourGui(class_310 client, MCRGBClient mcrgbClient, ColourVector launchColour) {
        this.rInput = new WTextField((class_2561)class_2561.method_43470((String)Integer.toString(this.inputColour.r)));
        this.gInput = new WTextField((class_2561)class_2561.method_43470((String)Integer.toString(this.inputColour.g)));
        this.bInput = new WTextField((class_2561)class_2561.method_43470((String)Integer.toString(this.inputColour.b)));
        this.refreshIdentifier = class_2960.method_60655((String)"mcrgb", (String)"refresh.png");
        this.refreshIcon = new TextureIcon(this.refreshIdentifier);
        this.refreshButton = new WButton(this, (Icon)this.refreshIcon){

            @Environment(value=EnvType.CLIENT)
            public void addTooltip(TooltipBuilder tooltip) {
                tooltip.add(new class_2561[]{class_2561.method_43471((String)"ui.mcrgb.refresh_info")});
                super.addTooltip(tooltip);
            }
        };
        this.settingsIdentifier = class_2960.method_60655((String)"mcrgb", (String)"settings.png");
        this.settingsIcon = new TextureIcon(this.settingsIdentifier);
        this.settingsButton = new WButton((Icon)this.settingsIcon);
        this.rgbButton = new WButton((class_2561)class_2561.method_43471((String)"ui.mcrgb.rgb"));
        this.hsvButton = new WButton((class_2561)class_2561.method_43471((String)"ui.mcrgb.hsv"));
        this.hslButton = new WButton((class_2561)class_2561.method_43471((String)"ui.mcrgb.hsl"));
        this.stacks = new ArrayList();
        this.wColourGuiSlots = new ArrayList();
        this.helmet = new class_1799((class_1935)class_1802.field_8267);
        this.chestplate = new class_1799((class_1935)class_1802.field_8577);
        this.leggings = new class_1799((class_1935)class_1802.field_8570);
        this.boots = new class_1799((class_1935)class_1802.field_8370);
        this.horse = new class_1799((class_1935)class_1802.field_18138);
        this.wolf = new class_1799((class_1935)class_1802.field_47831);
        this.armourSlots = new WGridPanel();
        this.helmSlot = new WColourGuiSlot(this.helmet, this.cg);
        this.chestSlot = new WColourGuiSlot(this.chestplate, this.cg);
        this.legsSlot = new WColourGuiSlot(this.leggings, this.cg);
        this.bootSlot = new WColourGuiSlot(this.boots, this.cg);
        this.horseSlot = new WColourGuiSlot(this.horse, this.cg);
        this.wolfSlot = new WColourGuiSlot(this.wolf, this.cg);
        this.colourWheelToggle = new WToggleButton();
        this.sliderArea = new WSliderArea();
        this.wheelIdentifier = class_2960.method_60655((String)"mcrgb", (String)"wheel.png");
        this.wheelIconIdentifier = class_2960.method_60655((String)"mcrgb", (String)"wheel_small.png");
        this.wheelTex = new Texture(this.wheelIconIdentifier);
        this.wheelValueSlider = new WGradientSlider(0, 255, Axis.VERTICAL);
        this.sliderIconIdentifier = class_2960.method_60655((String)"mcrgb", (String)"sliders.png");
        this.sliderTex = new Texture(this.sliderIconIdentifier);
        this.searchField = new WTextField(this, (class_2561)class_2561.method_43471((String)"ui.mcrgb.refine")){

            public void setSize(int x, int y) {
                this.width = x;
                this.height = y;
            }

            @Environment(value=EnvType.CLIENT)
            protected void renderText(class_332 context, int x, int y, String visibleText) {
                super.renderText(context, x, y - 4, visibleText);
            }

            @Environment(value=EnvType.CLIENT)
            protected void renderCursor(class_332 context, int x, int y, String visibleText) {
                super.renderCursor(context, x, y - 4, visibleText);
            }

            @Environment(value=EnvType.CLIENT)
            protected void renderSelection(class_332 context, int x, int y, String visibleText) {
                super.renderSelection(context, x, y - 4, visibleText);
            }

            @Environment(value=EnvType.CLIENT)
            protected void renderSuggestion(class_332 context, int x, int y) {
                super.renderSuggestion(context, x, y - 4);
            }
        };
        this.enableSliderListeners = true;
        this.mode = ColourMode.RGB;
        this.client = client;
        this.mcrgbClient = mcrgbClient;
        this.colourWheel = new WColourWheel(this.wheelIdentifier, 0.0f, 0.0f, 1.0f, 1.0f, client, this);
        this.savedPalettesArea = new WSavedPalettesArea(this, slotsWidth, slotsHeight, mcrgbClient);
        this.ColourSort();
        this.setRootPanel((WPanel)this.root);
        this.root.add((WWidget)this.mainPanel, 0, 0);
        this.mainPanel.setSize(320, 220);
        this.mainPanel.setInsets(Insets.ROOT_PANEL);
        this.mainPanel.add((WWidget)this.hexInput, 11, 1, 5, 1);
        this.mainPanel.add((WWidget)this.colourDisplay, 16, 1, 2, 2);
        this.colourDisplay.setLocation(this.colourDisplay.getAbsoluteX() + 1, this.colourDisplay.getAbsoluteY() - 1);
        this.mainPanel.add((WWidget)this.scrollBar, 9, 1, 1, slotsHeight - 1);
        this.mainPanel.add((WWidget)this.refreshButton, 17, 11, 1, 1);
        this.refreshButton.setSize(20, 20);
        this.refreshButton.setIconSize(18);
        this.refreshButton.setAlignment(HorizontalAlignment.LEFT);
        this.mainPanel.add((WWidget)this.searchField, 6, 0, 4, 1);
        this.searchField.setSize(72, 11);
        this.mainPanel.add((WWidget)this.settingsButton, 17, 0, 1, 1);
        this.settingsButton.setSize(20, 20);
        this.settingsButton.setIconSize(18);
        this.settingsButton.setAlignment(HorizontalAlignment.LEFT);
        this.mainPanel.add((WWidget)this.rgbButton, 10, 11, 1, 1);
        this.rgbButton.setLocation(201, 205);
        this.rgbButton.setSize(26, 20);
        this.rgbButton.setEnabled(false);
        this.rgbButton.setAlignment(HorizontalAlignment.CENTER);
        this.mainPanel.add((WWidget)this.hsvButton, 13, 11, 1, 1);
        this.hsvButton.setLocation(237, 205);
        this.hsvButton.setSize(26, 20);
        this.hsvButton.setAlignment(HorizontalAlignment.CENTER);
        this.mainPanel.add((WWidget)this.hslButton, 15, 11, 1, 1);
        this.hslButton.setLocation(273, 205);
        this.hslButton.setSize(26, 20);
        this.hslButton.setAlignment(HorizontalAlignment.CENTER);
        this.mainPanel.add((WWidget)this.label, 0, 0, 2, 1);
        this.mainPanel.add((WWidget)this.savedPalettesArea, 0, slotsHeight);
        this.mainPanel.add((WWidget)this.sliderArea, 11, 2, 6, 7);
        this.mainPanel.add((WWidget)this.rLabel, 1, 0, 1, 1);
        this.mainPanel.add((WWidget)this.gLabel, 2, 0, 1, 1);
        this.mainPanel.add((WWidget)this.bLabel, 3, 0, 1, 1);
        this.rLabel.setLocation(211, 50);
        this.gLabel.setLocation(247, 50);
        this.bLabel.setLocation(283, 50);
        this.sliderArea.add((WWidget)this.rSlider, 0, 18, 18, 108);
        this.rSlider.setValue(this.inputColour.r);
        this.sliderArea.add((WWidget)this.gSlider, 36, 18, 18, 108);
        this.gSlider.setValue(this.inputColour.g);
        this.sliderArea.add((WWidget)this.bSlider, 72, 18, 18, 108);
        this.bSlider.setValue(this.inputColour.b);
        this.mainPanel.add((WWidget)this.inputs, 10, 9, 2, 1);
        this.inputs.add((WWidget)this.rInput, 14, 9, 26, 1);
        this.inputs.add((WWidget)this.gInput, 50, 9, 26, 1);
        this.inputs.add((WWidget)this.bInput, 86, 9, 26, 1);
        this.rSlider.setValueChangeListener(value -> {
            if (this.enableSliderListeners) {
                this.SliderAdjust('r', value);
            }
        });
        this.gSlider.setValueChangeListener(value -> {
            if (this.enableSliderListeners) {
                this.SliderAdjust('g', value);
            }
        });
        this.bSlider.setValueChangeListener(value -> {
            if (this.enableSliderListeners) {
                this.SliderAdjust('b', value);
            }
        });
        this.rSlider.setDraggingFinishedListener(value -> {
            if (!MCRGBConfig.instance.sliderConstantUpdate) {
                this.ColourSort();
            }
        });
        this.gSlider.setDraggingFinishedListener(value -> {
            if (!MCRGBConfig.instance.sliderConstantUpdate) {
                this.ColourSort();
            }
        });
        this.bSlider.setDraggingFinishedListener(value -> {
            if (!MCRGBConfig.instance.sliderConstantUpdate) {
                this.ColourSort();
            }
        });
        this.wheelValueSlider.setValueChangeListener(value -> {
            this.colourWheel.setOpaqueTint(class_9848.method_61324((int)255, (int)value, (int)value, (int)value));
            this.colourWheel.pickAtCursor();
        });
        this.rInput.setChangedListener(value -> this.RGBTyped('r', (String)value));
        this.gInput.setChangedListener(value -> this.RGBTyped('g', (String)value));
        this.bInput.setChangedListener(value -> this.RGBTyped('b', (String)value));
        this.hexInput.setChangedListener(value -> this.HexTyped((String)value, false));
        this.searchField.setChangedListener(value -> this.ColourSort());
        this.refreshButton.setOnClick(() -> {
            mcrgbClient.RefreshColours();
            this.ColourSort();
        });
        this.rgbButton.setOnClick(() -> this.SetColourMode(ColourMode.RGB));
        this.hsvButton.setOnClick(() -> this.SetColourMode(ColourMode.HSV));
        this.hslButton.setOnClick(() -> this.SetColourMode(ColourMode.HSL));
        this.colourWheelToggle.setOnToggle(isToggled -> this.ToggleColourWheel((Boolean)isToggled));
        if (FabricLoader.getInstance().isModLoaded("cloth-config2")) {
            this.settingsButton.setOnClick(() -> class_310.method_1551().method_1507(ClothConfigIntegration.getConfigScreen(client.field_1755)));
        } else {
            this.settingsButton.setOnClick(() -> client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"warning.mcrgb.noclothconfig"), false));
        }
        this.UpdateArmour();
        this.mainPanel.add((WWidget)this.armourSlots, 17, 3);
        this.armourSlots.add((WWidget)this.helmSlot, 0, 0);
        this.armourSlots.add((WWidget)this.chestSlot, 0, 1);
        this.armourSlots.add((WWidget)this.legsSlot, 0, 2);
        this.armourSlots.add((WWidget)this.bootSlot, 0, 3);
        this.armourSlots.add((WWidget)this.horseSlot, 0, 4);
        this.armourSlots.add((WWidget)this.wolfSlot, 0, 5);
        this.colourWheelToggle.setOffImage(this.wheelTex);
        this.colourWheelToggle.setOnImage(this.sliderTex);
        this.mainPanel.add((WWidget)this.colourWheelToggle, 17, 10);
        this.colourWheelToggle.setLocation(314, 180);
        this.SetColour(launchColour);
        this.mainPanel.validate((GuiDescription)this);
        this.root.validate((GuiDescription)this);
    }

    public void SetColourMode(ColourMode cm) {
        this.enableSliderListeners = false;
        this.mode = cm;
        ColourVector colour = new ColourVector(this.inputColour.getHex());
        switch (this.mode.ordinal()) {
            case 0: {
                this.rLabel.setText((class_2561)class_2561.method_43471((String)"ui.mcrgb.r_for_red"));
                this.rLabel.setColor(-65536);
                this.gLabel.setText((class_2561)class_2561.method_43471((String)"ui.mcrgb.g_for_green"));
                this.gLabel.setColor(-16711936);
                this.bLabel.setText((class_2561)class_2561.method_43471((String)"ui.mcrgb.b_for_blue"));
                this.bLabel.setColor(-16776961);
                this.rSlider.setMinValue(0);
                this.gSlider.setMinValue(0);
                this.bSlider.setMinValue(0);
                this.rSlider.setMaxValue(255);
                this.gSlider.setMaxValue(255);
                this.bSlider.setMaxValue(255);
                this.rgbButton.setEnabled(false);
                this.hsvButton.setEnabled(true);
                this.hslButton.setEnabled(true);
                break;
            }
            case 1: {
                this.rLabel.setText((class_2561)class_2561.method_43471((String)"ui.mcrgb.h_for_hue_hsv"));
                this.rLabel.setColor(-12632257);
                this.gLabel.setText((class_2561)class_2561.method_43471((String)"ui.mcrgb.s_for_sat_hsv"));
                this.gLabel.setColor(-12632257);
                this.bLabel.setText((class_2561)class_2561.method_43471((String)"ui.mcrgb.v_for_val_hsv"));
                this.bLabel.setColor(-12632257);
                this.rSlider.setMinValue(0);
                this.gSlider.setMinValue(0);
                this.bSlider.setMinValue(0);
                this.rSlider.setMaxValue(360);
                this.gSlider.setMaxValue(100);
                this.bSlider.setMaxValue(100);
                this.rgbButton.setEnabled(true);
                this.hsvButton.setEnabled(false);
                this.hslButton.setEnabled(true);
                break;
            }
            case 2: {
                this.rLabel.setText((class_2561)class_2561.method_43471((String)"ui.mcrgb.h_for_hue_hsl"));
                this.rLabel.setColor(-12632257);
                this.gLabel.setText((class_2561)class_2561.method_43471((String)"ui.mcrgb.s_for_sat_hsl"));
                this.gLabel.setColor(-12632257);
                this.bLabel.setText((class_2561)class_2561.method_43471((String)"ui.mcrgb.l_for_lit_hsl"));
                this.bLabel.setColor(-12632257);
                this.rSlider.setMinValue(0);
                this.gSlider.setMinValue(0);
                this.bSlider.setMinValue(0);
                this.rSlider.setMaxValue(360);
                this.gSlider.setMaxValue(100);
                this.bSlider.setMaxValue(100);
                this.rgbButton.setEnabled(true);
                this.hsvButton.setEnabled(true);
                this.hslButton.setEnabled(false);
            }
        }
        this.HexTyped(colour.getHex(), true);
        this.inputColour = colour;
        this.enableSliderListeners = true;
    }

    public void SliderAdjust(char d, int value) {
        switch (this.mode.ordinal()) {
            case 0: {
                if (d == 'r') {
                    if (this.inputColour.r == value) {
                        return;
                    }
                    this.inputColour.r = value;
                    this.rInput.setText(Integer.toString(this.inputColour.r));
                }
                if (d == 'g') {
                    if (this.inputColour.g == value) {
                        return;
                    }
                    this.inputColour.g = value;
                    this.gInput.setText(Integer.toString(this.inputColour.g));
                }
                if (d != 'b') break;
                if (this.inputColour.b == value) {
                    return;
                }
                this.inputColour.b = value;
                this.bInput.setText(Integer.toString(this.inputColour.b));
                break;
            }
            case 1: {
                this.inputColour.fromHSV(this.rSlider.getValue(), this.gSlider.getValue(), this.bSlider.getValue());
                this.rInput.setText(Integer.toString(this.rSlider.getValue()));
                this.gInput.setText(Integer.toString(this.gSlider.getValue()));
                this.bInput.setText(Integer.toString(this.bSlider.getValue()));
                break;
            }
            case 2: {
                this.inputColour.fromHSL(this.rSlider.getValue(), this.gSlider.getValue(), this.bSlider.getValue());
                this.rInput.setText(Integer.toString(this.rSlider.getValue()));
                this.gInput.setText(Integer.toString(this.gSlider.getValue()));
                this.bInput.setText(Integer.toString(this.bSlider.getValue()));
            }
        }
        this.hexInput.setText(this.inputColour.getHex());
        this.UpdateArmour();
        if (MCRGBConfig.instance.sliderConstantUpdate) {
            this.ColourSort();
        }
    }

    public void RGBTyped(char d, String value) {
        try {
            switch (this.mode.ordinal()) {
                case 0: {
                    if (!this.rInput.isFocused() & !this.gInput.isFocused() & !this.bInput.isFocused()) {
                        return;
                    }
                    if (Integer.valueOf(value) > 255 || Integer.valueOf(value) < 0) {
                        return;
                    }
                    if (d == 'r') {
                        if (this.inputColour.r == Integer.valueOf(value)) {
                            return;
                        }
                        this.inputColour.r = Integer.valueOf(value);
                        this.rSlider.setValue(this.inputColour.r);
                    }
                    if (d == 'g') {
                        if (this.inputColour.g == Integer.valueOf(value)) {
                            return;
                        }
                        this.inputColour.g = Integer.valueOf(value);
                        this.gSlider.setValue(this.inputColour.g);
                    }
                    if (d != 'b') break;
                    if (this.inputColour.b == Integer.valueOf(value)) {
                        return;
                    }
                    this.inputColour.b = Integer.valueOf(value);
                    this.bSlider.setValue(this.inputColour.b);
                    break;
                }
                case 1: {
                    if (!this.rInput.isFocused() & !this.gInput.isFocused() & !this.bInput.isFocused()) {
                        return;
                    }
                    if (d == 'r' ? Integer.valueOf(value) > 360 || Integer.valueOf(value) < 0 : Integer.valueOf(value) > 100 || Integer.valueOf(value) < 0) {
                        return;
                    }
                    if (d == 'r') {
                        if (this.inputColour.r == Integer.valueOf(value)) {
                            return;
                        }
                        this.rSlider.setValue(Integer.valueOf(value).intValue());
                    }
                    if (d == 'g') {
                        if (this.inputColour.g == Integer.valueOf(value)) {
                            return;
                        }
                        this.gSlider.setValue(Integer.valueOf(value).intValue());
                    }
                    if (d == 'b') {
                        if (this.inputColour.b == Integer.valueOf(value)) {
                            return;
                        }
                        this.bSlider.setValue(Integer.valueOf(value).intValue());
                    }
                    this.inputColour.fromHSV(this.rSlider.getValue(), this.gSlider.getValue(), this.bSlider.getValue());
                    break;
                }
                case 2: {
                    if (!this.rInput.isFocused() & !this.gInput.isFocused() & !this.bInput.isFocused()) {
                        return;
                    }
                    if (d == 'r' ? Integer.valueOf(value) > 360 || Integer.valueOf(value) < 0 : Integer.valueOf(value) > 100 || Integer.valueOf(value) < 0) {
                        return;
                    }
                    if (d == 'r') {
                        if (this.inputColour.r == Integer.valueOf(value)) {
                            return;
                        }
                        this.rSlider.setValue(Integer.valueOf(value).intValue());
                    }
                    if (d == 'g') {
                        if (this.inputColour.g == Integer.valueOf(value)) {
                            return;
                        }
                        this.gSlider.setValue(Integer.valueOf(value).intValue());
                    }
                    if (d == 'b') {
                        if (this.inputColour.b == Integer.valueOf(value)) {
                            return;
                        }
                        this.bSlider.setValue(Integer.valueOf(value).intValue());
                    }
                    this.inputColour.fromHSL(this.rSlider.getValue(), this.gSlider.getValue(), this.bSlider.getValue());
                }
            }
            this.hexInput.setText(this.inputColour.getHex());
            this.UpdateArmour();
            if (this.colourWheelToggle.getToggle()) {
                int val = Math.max(Math.max(this.inputColour.r, this.inputColour.g), this.inputColour.b);
                this.colourWheel.setOpaqueTint(new ColourVector(val, val, val).asInt());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void HexTyped(String value, boolean modeChanged) {
        this.enableSliderListeners = false;
        try {
            ColourVector colour = new ColourVector(value);
            if (!modeChanged && !this.hexInput.isFocused()) {
                this.enableSliderListeners = true;
                return;
            }
            if (!modeChanged && value == this.inputColour.getHex()) {
                this.enableSliderListeners = true;
                return;
            }
            switch (this.mode.ordinal()) {
                case 0: {
                    this.rSlider.setValue(colour.r);
                    this.rInput.setText(Integer.toString(colour.r));
                    this.gSlider.setValue(colour.g);
                    this.gInput.setText(Integer.toString(colour.g));
                    this.bSlider.setValue(colour.b);
                    this.bInput.setText(Integer.toString(colour.b));
                    break;
                }
                case 1: {
                    this.rSlider.setValue(colour.getHue());
                    this.rInput.setText(Integer.toString(colour.getHue()));
                    this.gSlider.setValue(colour.getSatV());
                    this.gInput.setText(Integer.toString(colour.getSatV()));
                    this.bSlider.setValue(colour.getVal());
                    this.bInput.setText(Integer.toString(colour.getVal()));
                    break;
                }
                case 2: {
                    this.rSlider.setValue(colour.getHue());
                    this.rInput.setText(Integer.toString(colour.getHue()));
                    this.gSlider.setValue(colour.getSatL());
                    this.gInput.setText(Integer.toString(colour.getSatL()));
                    this.bSlider.setValue(colour.getLight());
                    this.bInput.setText(Integer.toString(colour.getLight()));
                }
            }
            this.inputColour = colour;
            this.UpdateArmour();
            this.ColourSort();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enableSliderListeners = true;
    }

    public void UpdateArmour() {
        int hexint = this.GetColour();
        class_9282 dyedColorComponent = new class_9282(hexint);
        this.helmet.method_57379(class_9334.field_49644, (Object)dyedColorComponent);
        this.chestplate.method_57379(class_9334.field_49644, (Object)dyedColorComponent);
        this.leggings.method_57379(class_9334.field_49644, (Object)dyedColorComponent);
        this.boots.method_57379(class_9334.field_49644, (Object)dyedColorComponent);
        this.horse.method_57379(class_9334.field_49644, (Object)dyedColorComponent);
        this.wolf.method_57379(class_9334.field_49644, (Object)dyedColorComponent);
        this.colourDisplay.setOpaqueTint(hexint);
    }

    public void ColourSort() {
        this.stacks.clear();
        ColourVector query = this.inputColour;
        class_7923.field_41175.forEach(block -> {
            try {
                for (int j = 0; j < ((IItemBlockColourSaver)block.method_8389()).getLength(); ++j) {
                    double distance = 0.0;
                    double weightless = 0.0;
                    double weight = 0.0;
                    SpriteDetails sprite = ((IItemBlockColourSaver)block.method_8389()).getSpriteDetails(j);
                    for (int i = 0; i < sprite.colourinfo.size(); ++i) {
                        ColourVector colour = sprite.colourinfo.get(i);
                        if (colour == null) {
                            return;
                        }
                        weightless = query.distance(colour) + 1.0E-6;
                        if (!(weightless / Math.pow(weight = Double.valueOf(sprite.weights.get(i).intValue()).doubleValue(), 5.0) < distance) && i != 0) continue;
                        distance = weightless / Math.pow(weight, 5.0);
                    }
                    if (!(distance < ((IItemBlockColourSaver)block.method_8389()).getScore()) && j != 0) continue;
                    ((IItemBlockColourSaver)block.method_8389()).setScore(distance);
                }
                if (block.method_9518().getString().toUpperCase().contains(this.searchField.getText().toUpperCase()) && block.method_8389() != null && ((IItemBlockColourSaver)block.method_8389()).getLength() > 0 && block.method_45382(this.client.field_1687.method_45162())) {
                    this.stacks.add(new class_1799((class_1935)block));
                }
            }
            catch (Exception e) {
                return;
            }
        });
        this.scrollBar.setMaxValue(this.stacks.size() / slotsWidth + slotsWidth);
        Collections.sort(this.stacks, new Comparator<class_1799>(this){

            @Override
            public int compare(class_1799 is1, class_1799 is2) {
                double x = ((IItemBlockColourSaver)is1.method_7909()).getScore();
                double y = ((IItemBlockColourSaver)is2.method_7909()).getScore();
                return Double.compare(x, y);
            }
        });
        this.PlaceSlots();
    }

    public void PlaceSlots() {
        this.wColourGuiSlots.forEach(slot -> this.mainPanel.remove((WWidget)slot));
        int index = slotsWidth * this.scrollBar.getValue();
        for (int j = 1; j < slotsHeight; ++j) {
            for (int i = 0; i < slotsWidth && index < this.stacks.size(); ++index, ++i) {
                WColourGuiSlot colourGuiSlot = new WColourGuiSlot(this.stacks.get(index), this.cg);
                if (this.wColourGuiSlots.size() <= index) {
                    this.wColourGuiSlots.add(colourGuiSlot);
                } else {
                    this.wColourGuiSlots.set(index, colourGuiSlot);
                }
                this.mainPanel.add((WWidget)colourGuiSlot, i, j);
            }
        }
        this.mainPanel.validate((GuiDescription)this);
    }

    @Override
    void SetColour(ColourVector colour) {
        switch (this.mode.ordinal()) {
            case 0: {
                this.rSlider.setValue(colour.r);
                this.rInput.setText(Integer.toString(colour.r));
                this.gSlider.setValue(colour.g);
                this.gInput.setText(Integer.toString(colour.g));
                this.bSlider.setValue(colour.b);
                this.bInput.setText(Integer.toString(colour.b));
                break;
            }
            case 1: {
                this.rSlider.setValue(colour.getHue());
                this.rInput.setText(Integer.toString(colour.getHue()));
                this.gSlider.setValue(colour.getSatV());
                this.gInput.setText(Integer.toString(colour.getSatV()));
                this.bSlider.setValue(colour.getVal());
                this.bInput.setText(Integer.toString(colour.getVal()));
                break;
            }
            case 2: {
                this.rSlider.setValue(colour.getHue());
                this.rInput.setText(Integer.toString(colour.getHue()));
                this.gSlider.setValue(colour.getSatL());
                this.gInput.setText(Integer.toString(colour.getSatL()));
                this.bSlider.setValue(colour.getLight());
                this.bInput.setText(Integer.toString(colour.getLight()));
            }
        }
        this.inputColour = colour;
        this.hexInput.setText(this.inputColour.getHex());
        this.UpdateArmour();
        this.ColourSort();
        this.scrollBar.setValue(0);
        this.PlaceSlots();
    }

    public void OpenBlockInfoGui(class_310 client, MCRGBClient mcrgbClient, class_1799 stack) {
        client.method_1507((class_437)new ColourScreen((GuiDescription)new BlockInfoGui(client, mcrgbClient, stack, this.inputColour)));
    }

    public void ToggleColourWheel(Boolean isToggled) {
        if (isToggled.booleanValue()) {
            this.mainPanel.remove((WWidget)this.sliderArea);
            this.mainPanel.remove((WWidget)this.armourSlots);
            this.mainPanel.add((WWidget)this.colourWheel, 11, 2, 6, 6);
            this.mainPanel.add((WWidget)this.wheelValueSlider, 17, 2, 1, 6);
            this.wheelValueSlider.setValue(this.wheelValueSlider.getMaxValue());
            this.colourWheel.setLocation(198, 47);
            this.wheelValueSlider.setLocation(314, 47);
            this.wheelValueSlider.setSize(18, 128);
            this.rLabel.setLocation(211, 165);
            this.gLabel.setLocation(247, 165);
            this.bLabel.setLocation(283, 165);
        } else {
            this.mainPanel.add((WWidget)this.sliderArea, 11, 2, 6, 7);
            this.mainPanel.add((WWidget)this.armourSlots, 17, 3);
            this.mainPanel.remove((WWidget)this.colourWheel);
            this.mainPanel.remove((WWidget)this.wheelValueSlider);
            this.rLabel.setLocation(211, 50);
            this.gLabel.setLocation(247, 50);
            this.bLabel.setLocation(283, 50);
        }
        this.root.validate((GuiDescription)this);
    }

    @Environment(value=EnvType.CLIENT)
    static enum ColourMode {
        RGB,
        HSV,
        HSL;

    }
}

