/*
 * Decompiled with CFR 0.152.
 */
package com.bacco.gui;

import com.bacco.ColourVector;
import com.bacco.gui.MCRGBBaseGui;
import com.mojang.blaze3d.opengl.GlStateManager;
import io.github.cottonmc.cotton.gui.widget.WSprite;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import java.nio.ByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10868;
import net.minecraft.class_11909;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9848;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class WPickableTexture
extends WSprite {
    float texU1;
    float texV1;
    float texU2;
    float texV2;
    int atlasWidth;
    int atlasHeight;
    int tint = 0xFFFFFF;
    int pixelColour = -1;
    Boolean isTransparent = false;
    MCRGBBaseGui gui;
    class_10868 gpuTexture;
    int glID;

    public WPickableTexture(class_2960 image, float u1, float v1, float u2, float v2, class_310 client, MCRGBBaseGui gui) {
        super(image, u1, v1, u2, v2);
        this.gpuTexture = (class_10868)client.method_1531().method_4619(image).method_68004();
        this.glID = this.gpuTexture.method_68427();
        this.atlasWidth = this.gpuTexture.getWidth(0);
        this.atlasHeight = this.gpuTexture.getHeight(0);
        this.texU1 = u1 * (float)this.atlasWidth;
        this.texV1 = v1 * (float)this.atlasHeight;
        this.texU2 = u2 * (float)this.atlasWidth;
        this.texV2 = v2 * (float)this.atlasHeight;
        this.gui = gui;
    }

    public InputResult onClick(class_11909 click, boolean doubled) {
        this.isTransparent = this.pickColour((int)click.comp_4798(), (int)click.comp_4799());
        return super.onClick(click, doubled);
    }

    public InputResult onMouseDrag(class_11909 click, double deltaX, double deltaY) {
        this.isTransparent = this.pickColour((int)click.comp_4798(), (int)click.comp_4799());
        return super.onMouseDrag(click, deltaX, deltaY);
    }

    public WSprite setOpaqueTint(int tint) {
        this.tint = tint;
        return super.setOpaqueTint(tint);
    }

    public Boolean pickColour(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return false;
        }
        double trueX = (double)this.texU1 + Math.floor((float)x / (float)this.width * (this.texU2 - this.texU1));
        double trueY = (double)this.texV1 + Math.floor((float)y / (float)this.height * (this.texV2 - this.texV1));
        int size = this.atlasHeight * this.atlasWidth;
        GlStateManager._bindTexture((int)this.glID);
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(size * 4));
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        byte[] pixels = new byte[size * 4];
        buffer.get(pixels);
        int pos = ((int)trueY * this.atlasWidth + (int)trueX) * 4;
        if (pixels[pos + 3] == 0) {
            return true;
        }
        this.pixelColour = class_9848.method_61324((int)pixels[pos + 3], (int)(pixels[pos] & 0xFF), (int)(pixels[pos + 1] & 0xFF), (int)(pixels[pos + 2] & 0xFF));
        this.pixelColour = class_9848.method_61322((int)this.pixelColour, (int)this.tint);
        this.gui.SetColour(new ColourVector(this.pixelColour));
        return false;
    }

    public WSprite setUv(float u1, float v1, float u2, float v2) {
        this.texU1 = u1 * (float)this.atlasWidth;
        this.texV1 = v1 * (float)this.atlasHeight;
        this.texU2 = u2 * (float)this.atlasWidth;
        this.texV2 = v2 * (float)this.atlasHeight;
        return super.setUv(u1, v1, u2, v2);
    }

    public void paint(class_332 context, int x, int y, int mouseX, int mouseY) {
        super.paint(context, x, y, mouseX, mouseY);
    }
}

