/*
 * Decompiled with CFR 0.152.
 */
package com.bacco.gui;

import com.bacco.ColourVector;
import com.bacco.MCRGBClient;
import com.bacco.Palette;
import com.bacco.gui.MCRGBBaseGui;
import com.bacco.gui.WColourPreviewIcon;
import com.bacco.gui.WPaletteWidget;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WListPanel;
import io.github.cottonmc.cotton.gui.widget.WPlainPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.VerticalAlignment;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import io.github.cottonmc.cotton.gui.widget.icon.TextureIcon;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class WSavedPalettesArea
extends WPlainPanel {
    WLabel savedColoursLabel = new WLabel((class_2561)class_2561.method_43471((String)"ui.mcrgb.saved_colours"));
    class_2960 colourIdentifier = class_2960.method_60655((String)"mcrgb", (String)"square.png");
    ArrayList<WColourPreviewIcon> SavedColours = new ArrayList();
    class_2960 savePaletteIdentifier = class_2960.method_60655((String)"mcrgb", (String)"save.png");
    TextureIcon savePaletteIcon = new TextureIcon(this.savePaletteIdentifier);
    WButton savePaletteButton = new WButton((Icon)this.savePaletteIcon);
    WPaletteWidget editingPalette = null;
    WListPanel<Palette, WPaletteWidget> paletteList;
    MCRGBBaseGui cg;
    MCRGBClient mcrgbClient;

    WSavedPalettesArea(MCRGBBaseGui gui, int slotsWidth, int slotsHeight, MCRGBClient mcrgbClient) {
        this.cg = gui;
        this.mcrgbClient = mcrgbClient;
        BiConsumer<Palette, WPaletteWidget> configurator = (p, pwig) -> {
            pwig.cg = this.cg;
            pwig.palette = p;
            pwig.buildPaletteWidget(this.cg);
            for (int i = 0; i < pwig.SavedColours.size(); ++i) {
                String hex = p.getColour(i).getHex().replace("#", "");
                int c = Integer.parseInt(hex, 16);
                pwig.SavedColours.get(i).setColour(c);
            }
        };
        this.add((WWidget)this.savedColoursLabel, 0, slotsHeight, 2, 1);
        this.savedColoursLabel.setVerticalAlignment(VerticalAlignment.BOTTOM);
        for (int i = 0; i < slotsWidth; ++i) {
            this.SavedColours.add(new WColourPreviewIcon(this.colourIdentifier, this.cg));
            this.add((WWidget)this.SavedColours.get(i), i * 17, slotsHeight + 5, 18, 18);
        }
        this.add((WWidget)this.savePaletteButton, slotsWidth * 18, slotsHeight + 1, 20, 20);
        this.savePaletteButton.setSize(20, 20);
        this.savePaletteButton.setIconSize(18);
        this.savePaletteButton.setAlignment(HorizontalAlignment.LEFT);
        this.paletteList = new WListPanel(mcrgbClient.palettes, WPaletteWidget::new, configurator);
        this.paletteList.setBackgroundPainter(BackgroundPainter.createColorful((int)0x999999));
        this.paletteList.setListItemHeight(19);
        this.add((WWidget)this.paletteList, 0, 2, 10, 3);
        this.paletteList.setLocation(0, 36);
        this.paletteList.setSize(180, 50);
        this.savePaletteButton.setOnClick(() -> this.SavePalette());
    }

    Palette CreatePalette() {
        Palette newPallet = new Palette();
        for (int i = 0; i < this.SavedColours.size(); ++i) {
            newPallet.addColour(new ColourVector(this.SavedColours.get((int)i).colour));
        }
        return newPallet;
    }

    WPaletteWidget UpdatePalette(WPaletteWidget updatingPalette) {
        for (int i = 0; i < this.SavedColours.size(); ++i) {
            updatingPalette.SavedColours.get(i).setColour(this.SavedColours.get((int)i).colour);
            updatingPalette.palette.setColour(i, new ColourVector(this.SavedColours.get((int)i).colour));
        }
        return updatingPalette;
    }

    void SavePalette() {
        if (this.editingPalette == null) {
            this.mcrgbClient.palettes.add(this.CreatePalette());
        } else {
            this.UpdatePalette(this.editingPalette);
            this.editingPalette = null;
        }
        for (int i = 0; i < this.SavedColours.size(); ++i) {
            this.SavedColours.get(i).setColour(-1);
        }
        this.mcrgbClient.SavePalettes();
        this.cg.mainPanel.validate((GuiDescription)this.cg);
    }

    public void DeletePalette(WPaletteWidget pwig) {
        this.mcrgbClient.palettes.remove(pwig.palette);
        this.editingPalette = null;
        this.cg.root.validate((GuiDescription)this.cg);
        this.mcrgbClient.SavePalettes();
    }

    public void EditPalette(WPaletteWidget pwig) {
        if (this.editingPalette == pwig) {
            this.editingPalette = null;
            for (int i = 0; i < this.SavedColours.size(); ++i) {
                this.SavedColours.get(i).setColour(-1);
            }
            return;
        }
        for (int i = 0; i < this.SavedColours.size(); ++i) {
            this.SavedColours.get(i).setColour(pwig.SavedColours.get((int)i).colour);
        }
        this.editingPalette = pwig;
    }
}

