package com.boyonk.dyeditemframes.client.mixin;

import com.boyonk.dyeditemframes.DyedItemFrames;
import com.boyonk.dyeditemframes.client.render.entity.state.DyedEntityRenderState;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_10040;
import net.minecraft.class_1533;
import net.minecraft.class_1921;
import net.minecraft.class_4722;
import net.minecraft.class_915;
import net.minecraft.class_9282;
import net.minecraft.class_9848;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(class_915.class)
public class ItemFrameEntityRendererMixin<T extends class_1533> {


	@ModifyArgs(method = "render(Lnet/minecraft/client/render/entity/state/ItemFrameEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/command/OrderedRenderCommandQueue;Lnet/minecraft/client/render/state/CameraRenderState;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/command/OrderedRenderCommandQueue;submitBlockStateModel(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/RenderLayer;Lnet/minecraft/client/render/model/BlockStateModel;FFFIII)V"))
	void dyed_item_frames$render(Args args, @Local(argsOnly = true) class_10040 state) {
		int color = ((DyedEntityRenderState) state).dyed_item_frames$getColor();
		args.set(3, class_9848.method_61327(color) / 255f);
		args.set(4, class_9848.method_61329(color) / 255f);
		args.set(5, class_9848.method_61331(color) / 255f);
	}

	@ModifyExpressionValue(method = "render(Lnet/minecraft/client/render/entity/state/ItemFrameEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/command/OrderedRenderCommandQueue;Lnet/minecraft/client/render/state/CameraRenderState;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/RenderLayer;getEntitySolidZOffsetForward(Lnet/minecraft/util/Identifier;)Lnet/minecraft/client/render/RenderLayer;"))
	class_1921 dyed_item_frames$translucentIfGlow(class_1921 original, @Local(argsOnly = true) class_10040 state) {
		return state.field_53441 ? class_4722.method_29382() : original;
	}

	@Inject(method = "updateRenderState(Lnet/minecraft/entity/decoration/ItemFrameEntity;Lnet/minecraft/client/render/entity/state/ItemFrameEntityRenderState;F)V", at = @At("RETURN"))
	void dyed_item_frames$updateRenderState(T itemFrameEntity, class_10040 itemFrameEntityRenderState, float f, CallbackInfo ci) {
		class_9282 component = itemFrameEntity.getAttached(DyedItemFrames.ATTACHMENT);
		int color = component == null ? class_9282.field_49314 : component.comp_2384();
		((DyedEntityRenderState) itemFrameEntityRenderState).dyed_item_frames$setColor(color);
	}
}
