/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.beneaththevoid.client.renderer;

import net.mcreator.beneaththevoid.client.model.ModelWisp;
import net.mcreator.beneaththevoid.client.model.animations.WispAnimation;
import net.mcreator.beneaththevoid.entity.WispEntity;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class WispRenderer
extends MobRenderer<WispEntity, LivingEntityRenderState, ModelWisp> {
    private WispEntity entity = null;

    public WispRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelWisp.LAYER_LOCATION)), 0.5f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(WispEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"beneath_the_void:textures/entities/wisp.png");
    }

    private static final class AnimatedModel
    extends ModelWisp {
        private WispEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = WispAnimation.Float.bake(root);
        }

        public void setEntity(WispEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

