/*
 * Decompiled with CFR 0.152.
 */
package kotlin.random;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.PlatformRandomKt;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\b'\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0005H\u0016\u00a8\u0006\u0019"}, d2={"Lkotlin/random/Random;", "", "<init>", "()V", "nextBits", "", "bitCount", "nextInt", "until", "from", "nextLong", "", "nextBoolean", "", "nextDouble", "", "nextFloat", "", "nextBytes", "", "array", "fromIndex", "toIndex", "size", "Default", "kotlin-stdlib"})
@SinceKotlin(version="1.3")
@SourceDebugExtension(value={"SMAP\nRandom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Random.kt\nkotlin/random/Random\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,383:1\n1#2:384\n*E\n"})
public abstract class Random {
    @NotNull
    public static final Default Default = new Default(null);
    @NotNull
    private static final Random defaultRandom = PlatformImplementationsKt.IMPLEMENTATIONS.defaultPlatformRandom();

    public abstract int nextBits(int var1);

    public int nextInt() {
        return this.nextBits(32);
    }

    public int nextInt(int n2) {
        return this.nextInt(0, n2);
    }

    public int nextInt(int n2, int n3) {
        int n4;
        boolean bl;
        RandomKt.checkRangeBounds(n2, n3);
        int n5 = n3 - n2;
        if (n5 > 0 || n5 == Integer.MIN_VALUE) {
            int n6;
            int n7;
            if ((n5 & -n5) == n5) {
                n7 = RandomKt.fastLog2(n5);
                n6 = this.nextBits(n7);
            } else {
                int n8;
                n7 = 0;
                while ((n8 = this.nextInt() >>> 1) - (n7 = n8 % n5) + (n5 - 1) < 0) {
                }
                n6 = n7;
            }
            int n9 = n6;
            return n2 + n9;
        }
        do {
            if (n2 <= (n4 = this.nextInt())) {
                if (n4 < n3) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return n4;
    }

    public long nextLong() {
        return ((long)this.nextInt() << 32) + (long)this.nextInt();
    }

    public long nextLong(long l2) {
        return this.nextLong(0L, l2);
    }

    public long nextLong(long l2, long l3) {
        long l4;
        boolean bl;
        RandomKt.checkRangeBounds(l2, l3);
        long l5 = l3 - l2;
        if (l5 > 0L) {
            long l6 = 0L;
            if ((l5 & -l5) == l5) {
                long l7;
                int n2;
                int n3 = (int)l5;
                int n4 = (int)(l5 >>> 32);
                if (n3 != 0) {
                    n2 = RandomKt.fastLog2(n3);
                    l7 = (long)this.nextBits(n2) & 0xFFFFFFFFL;
                } else if (n4 == 1) {
                    l7 = (long)this.nextInt() & 0xFFFFFFFFL;
                } else {
                    n2 = RandomKt.fastLog2(n4);
                    l7 = ((long)this.nextBits(n2) << 32) + ((long)this.nextInt() & 0xFFFFFFFFL);
                }
                l6 = l7;
            } else {
                long l8;
                long l9 = 0L;
                while ((l8 = this.nextLong() >>> 1) - (l9 = l8 % l5) + (l5 - 1L) < 0L) {
                }
                l6 = l9;
            }
            return l2 + l6;
        }
        do {
            if (l2 <= (l4 = this.nextLong())) {
                if (l4 < l3) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return l4;
    }

    public boolean nextBoolean() {
        return this.nextBits(1) != 0;
    }

    public double nextDouble() {
        return PlatformRandomKt.doubleFromParts(this.nextBits(26), this.nextBits(27));
    }

    public double nextDouble(double d2) {
        return this.nextDouble(0.0, d2);
    }

    public double nextDouble(double d2, double d3) {
        double d4;
        double d5;
        RandomKt.checkRangeBounds(d2, d3);
        double d6 = d3 - d2;
        if (Double.isInfinite(d6) && !Double.isInfinite(d5 = d2) && !Double.isNaN(d5) && !Double.isInfinite(d5 = d3) && !Double.isNaN(d5)) {
            d5 = this.nextDouble() * (d3 / (double)2 - d2 / (double)2);
            d4 = d2 + d5 + d5;
        } else {
            d4 = d2 + this.nextDouble() * d6;
        }
        double d7 = d4;
        return d7 >= d3 ? Math.nextAfter(d3, Double.NEGATIVE_INFINITY) : d7;
    }

    public float nextFloat() {
        return (float)this.nextBits(24) / 1.6777216E7f;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public byte[] nextBytes(@NotNull byte[] var1_1, int var2_2, int var3_3) {
        Intrinsics.checkNotNullParameter(var1_1, "");
        v0 = 0 <= var2_2 ? var2_2 <= var1_1.length : false;
        if (!v0) ** GOTO lbl-1000
        v1 = 0 <= var3_3 ? var3_3 <= var1_1.length : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        if (!v2) {
            var5_4 = false;
            var5_5 = "fromIndex (" + var2_2 + ") or toIndex (" + var3_3 + ") are out of range: 0.." + var1_1.length + '.';
            throw new IllegalArgumentException(var5_5.toString());
        }
        if (!(var2_2 <= var3_3)) {
            var5_6 = false;
            var5_7 = "fromIndex (" + var2_2 + ") must be not greater than toIndex (" + var3_3 + ").";
            throw new IllegalArgumentException(var5_7.toString());
        }
        var4_9 = (var3_3 - var2_2) / 4;
        var5_8 = 0;
        var5_8 = var2_2;
        var6_10 = 0;
        while (var6_10 < var4_9) {
            var7_11 = var6_10++;
            var8_12 = 0;
            var9_13 = this.nextInt();
            var1_1[var5_8] = (byte)var9_13;
            var1_1[var5_8 + 1] = (byte)(var9_13 >>> 8);
            var1_1[var5_8 + 2] = (byte)(var9_13 >>> 16);
            var1_1[var5_8 + 3] = (byte)(var9_13 >>> 24);
            var5_8 += 4;
        }
        var6_10 = var3_3 - var5_8;
        var7_11 = this.nextBits(var6_10 * 8);
        for (var8_12 = 0; var8_12 < var6_10; ++var8_12) {
            var1_1[var5_8 + var8_12] = (byte)(var7_11 >>> var8_12 * 8);
        }
        return var1_1;
    }

    public static /* synthetic */ byte[] nextBytes$default(Random random, byte[] byArray, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: nextBytes");
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = byArray.length;
        }
        return random.nextBytes(byArray, n2, n3);
    }

    @NotNull
    public byte[] nextBytes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "");
        return this.nextBytes(byArray, 0, byArray.length);
    }

    @NotNull
    public byte[] nextBytes(int n2) {
        return this.nextBytes(new byte[n2]);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0014H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\nH\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lkotlin/random/Random$Default;", "Lkotlin/random/Random;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "<init>", "()V", "defaultRandom", "writeReplace", "", "nextBits", "", "bitCount", "nextInt", "until", "from", "nextLong", "", "nextBoolean", "", "nextDouble", "", "nextFloat", "", "nextBytes", "", "array", "size", "fromIndex", "toIndex", "Serialized", "kotlin-stdlib"})
    public static final class Default
    extends Random
    implements Serializable {
        private Default() {
        }

        private final Object writeReplace() {
            return Serialized.INSTANCE;
        }

        @Override
        public int nextBits(int n2) {
            return defaultRandom.nextBits(n2);
        }

        @Override
        public int nextInt() {
            return defaultRandom.nextInt();
        }

        @Override
        public int nextInt(int n2) {
            return defaultRandom.nextInt(n2);
        }

        @Override
        public int nextInt(int n2, int n3) {
            return defaultRandom.nextInt(n2, n3);
        }

        @Override
        public long nextLong() {
            return defaultRandom.nextLong();
        }

        @Override
        public long nextLong(long l2) {
            return defaultRandom.nextLong(l2);
        }

        @Override
        public long nextLong(long l2, long l3) {
            return defaultRandom.nextLong(l2, l3);
        }

        @Override
        public boolean nextBoolean() {
            return defaultRandom.nextBoolean();
        }

        @Override
        public double nextDouble() {
            return defaultRandom.nextDouble();
        }

        @Override
        public double nextDouble(double d2) {
            return defaultRandom.nextDouble(d2);
        }

        @Override
        public double nextDouble(double d2, double d3) {
            return defaultRandom.nextDouble(d2, d3);
        }

        @Override
        public float nextFloat() {
            return defaultRandom.nextFloat();
        }

        @Override
        @NotNull
        public byte[] nextBytes(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter(byArray, "");
            return defaultRandom.nextBytes(byArray);
        }

        @Override
        @NotNull
        public byte[] nextBytes(int n2) {
            return defaultRandom.nextBytes(n2);
        }

        @Override
        @NotNull
        public byte[] nextBytes(@NotNull byte[] byArray, int n2, int n3) {
            Intrinsics.checkNotNullParameter(byArray, "");
            return defaultRandom.nextBytes(byArray, n2, n3);
        }

        public /* synthetic */ Default(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u00c2\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkotlin/random/Random$Default$Serialized;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "<init>", "()V", "serialVersionUID", "", "readResolve", "", "kotlin-stdlib"})
        private static final class Serialized
        implements Serializable {
            @NotNull
            public static final Serialized INSTANCE = new Serialized();
            private static final long serialVersionUID = 0L;

            private Serialized() {
            }

            private final Object readResolve() {
                return Default;
            }
        }
    }
}

