/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.ExperimentalStdlibApi;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ResultKt;
import kotlin.SinceKotlin;
import kotlin.Unit;
import kotlin.WasExperimental;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.FlagEnum;
import kotlin.text.MatchResult;
import kotlin.text.MatcherMatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexKt;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 22\u00060\u0001j\u0002`\u0002:\u000212B\u0011\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\fB\u001f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0004\b\u0005\u0010\u000fJ\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0086\u0004J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010 \u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010!\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001dH\u0007J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001dH\u0007J\u0016\u0010$\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\bJ\"\u0010$\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00180'J\u0016\u0010(\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\bJ\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0*2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020\u001dJ \u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020\u001dH\u0007J\b\u0010-\u001a\u00020\bH\u0016J\u0006\u0010.\u001a\u00020\u0004J\b\u0010/\u001a\u000200H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00063"}, d2={"Lkotlin/text/Regex;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "nativePattern", "Ljava/util/regex/Pattern;", "<init>", "(Ljava/util/regex/Pattern;)V", "pattern", "", "(Ljava/lang/String;)V", "option", "Lkotlin/text/RegexOption;", "(Ljava/lang/String;Lkotlin/text/RegexOption;)V", "options", "", "(Ljava/lang/String;Ljava/util/Set;)V", "getPattern", "()Ljava/lang/String;", "_options", "getOptions", "()Ljava/util/Set;", "matches", "", "input", "", "containsMatchIn", "find", "Lkotlin/text/MatchResult;", "startIndex", "", "findAll", "Lkotlin/sequences/Sequence;", "matchEntire", "matchAt", "index", "matchesAt", "replace", "replacement", "transform", "Lkotlin/Function1;", "replaceFirst", "split", "", "limit", "splitToSequence", "toString", "toPattern", "writeReplace", "", "Serialized", "Companion", "kotlin-stdlib"})
@SourceDebugExtension(value={"SMAP\nRegex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Regex.kt\nkotlin/text/Regex\n+ 2 Regex.kt\nkotlin/text/RegexKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,397:1\n22#2,3:398\n1#3:401\n*S KotlinDebug\n*F\n+ 1 Regex.kt\nkotlin/text/Regex\n*L\n103#1:398,3\n*E\n"})
public final class Regex
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Pattern nativePattern;
    @Nullable
    private Set<? extends RegexOption> _options;

    @PublishedApi
    public Regex(@NotNull Pattern pattern) {
        Intrinsics.checkNotNullParameter(pattern, "");
        this.nativePattern = pattern;
    }

    public Regex(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "");
        Pattern pattern = Pattern.compile(string);
        Intrinsics.checkNotNullExpressionValue(pattern, "");
        this(pattern);
    }

    public Regex(@NotNull String string, @NotNull RegexOption regexOption) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(regexOption, "");
        Pattern pattern = Pattern.compile(string, Regex.Companion.ensureUnicodeCase(regexOption.getValue()));
        Intrinsics.checkNotNullExpressionValue(pattern, "");
        this(pattern);
    }

    public Regex(@NotNull String string, @NotNull Set<? extends RegexOption> set2) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(set2, "");
        Pattern pattern = Pattern.compile(string, Regex.Companion.ensureUnicodeCase(RegexKt.access$toInt(set2)));
        Intrinsics.checkNotNullExpressionValue(pattern, "");
        this(pattern);
    }

    @NotNull
    public final String getPattern() {
        String string = this.nativePattern.pattern();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    @NotNull
    public final Set<RegexOption> getOptions() {
        Set<RegexOption> set2 = this._options;
        if (set2 == null) {
            Set set3;
            EnumSet<RegexOption> enumSet;
            int n2 = this.nativePattern.flags();
            boolean bl = false;
            EnumSet<RegexOption> enumSet2 = enumSet = EnumSet.allOf(RegexOption.class);
            boolean bl2 = false;
            Intrinsics.checkNotNull(enumSet2);
            CollectionsKt.retainAll((Iterable)enumSet2, (Function1)new Function1<RegexOption, Boolean>(n2){
                final /* synthetic */ int $value;
                {
                    this.$value = n2;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Boolean invoke(Enum enum_) {
                    return (this.$value & ((FlagEnum)((Object)enum_)).getMask()) == ((FlagEnum)((Object)enum_)).getValue();
                }
            });
            Set set4 = Collections.unmodifiableSet((Set)enumSet);
            Intrinsics.checkNotNullExpressionValue(set4, "");
            Set set5 = set3 = set4;
            boolean bl3 = false;
            this._options = set5;
            set2 = set3;
        }
        return set2;
    }

    public final boolean matches(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        return this.nativePattern.matcher(charSequence).matches();
    }

    public final boolean containsMatchIn(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        return this.nativePattern.matcher(charSequence).find();
    }

    @Nullable
    public final MatchResult find(@NotNull CharSequence charSequence, int n2) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Matcher matcher = this.nativePattern.matcher(charSequence);
        Intrinsics.checkNotNullExpressionValue(matcher, "");
        return RegexKt.access$findNext(matcher, n2, charSequence);
    }

    public static /* synthetic */ MatchResult find$default(Regex regex, CharSequence charSequence, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return regex.find(charSequence, n2);
    }

    @NotNull
    public final Sequence<MatchResult> findAll(@NotNull CharSequence charSequence, int n2) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        if (n2 < 0 || n2 > charSequence.length()) {
            throw new IndexOutOfBoundsException("Start index out of bounds: " + n2 + ", input length: " + charSequence.length());
        }
        return SequencesKt.generateSequence(() -> Regex.findAll$lambda$1(this, charSequence, n2), (Function1)findAll.2.INSTANCE);
    }

    public static /* synthetic */ Sequence findAll$default(Regex regex, CharSequence charSequence, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return regex.findAll(charSequence, n2);
    }

    @Nullable
    public final MatchResult matchEntire(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Matcher matcher = this.nativePattern.matcher(charSequence);
        Intrinsics.checkNotNullExpressionValue(matcher, "");
        return RegexKt.access$matchEntire(matcher, charSequence);
    }

    @SinceKotlin(version="1.7")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    @Nullable
    public final MatchResult matchAt(@NotNull CharSequence charSequence, int n2) {
        MatcherMatchResult matcherMatchResult;
        Intrinsics.checkNotNullParameter(charSequence, "");
        Matcher matcher = this.nativePattern.matcher(charSequence).useAnchoringBounds(false).useTransparentBounds(true).region(n2, charSequence.length());
        boolean bl = false;
        if (matcher.lookingAt()) {
            Intrinsics.checkNotNull(matcher);
            matcherMatchResult = new MatcherMatchResult(matcher, charSequence);
        } else {
            matcherMatchResult = null;
        }
        return matcherMatchResult;
    }

    @SinceKotlin(version="1.7")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    public final boolean matchesAt(@NotNull CharSequence charSequence, int n2) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        return this.nativePattern.matcher(charSequence).useAnchoringBounds(false).useTransparentBounds(true).region(n2, charSequence.length()).lookingAt();
    }

    @NotNull
    public final String replace(@NotNull CharSequence charSequence, @NotNull String string) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Intrinsics.checkNotNullParameter(string, "");
        String string2 = this.nativePattern.matcher(charSequence).replaceAll(string);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @NotNull
    public final String replace(@NotNull CharSequence charSequence, @NotNull Function1<? super MatchResult, ? extends CharSequence> function1) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Intrinsics.checkNotNullParameter(function1, "");
        MatchResult matchResult = Regex.find$default(this, charSequence, 0, 2, null);
        if (matchResult == null) {
            return ((Object)charSequence).toString();
        }
        MatchResult matchResult2 = matchResult;
        int n2 = 0;
        int n3 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n3);
        do {
            MatchResult matchResult3 = matchResult2;
            stringBuilder.append(charSequence, n2, (int)matchResult3.getRange().getStart());
            stringBuilder.append(function1.invoke(matchResult3));
            n2 = matchResult3.getRange().getEndInclusive() + 1;
            matchResult2 = matchResult3.next();
        } while (n2 < n3 && matchResult2 != null);
        if (n2 < n3) {
            stringBuilder.append(charSequence, n2, n3);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    @NotNull
    public final String replaceFirst(@NotNull CharSequence charSequence, @NotNull String string) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Intrinsics.checkNotNullParameter(string, "");
        String string2 = this.nativePattern.matcher(charSequence).replaceFirst(string);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @NotNull
    public final List<String> split(@NotNull CharSequence charSequence, int n2) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        StringsKt.requireNonNegativeLimit(n2);
        Matcher matcher = this.nativePattern.matcher(charSequence);
        if (n2 == 1 || !matcher.find()) {
            return CollectionsKt.listOf(((Object)charSequence).toString());
        }
        ArrayList<String> arrayList = new ArrayList<String>(n2 > 0 ? RangesKt.coerceAtMost(n2, 10) : 10);
        int n3 = 0;
        int n4 = n2 - 1;
        do {
            arrayList.add(((Object)charSequence.subSequence(n3, matcher.start())).toString());
            n3 = matcher.end();
        } while ((n4 < 0 || arrayList.size() != n4) && matcher.find());
        arrayList.add(((Object)charSequence.subSequence(n3, charSequence.length())).toString());
        return arrayList;
    }

    public static /* synthetic */ List split$default(Regex regex, CharSequence charSequence, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return regex.split(charSequence, n2);
    }

    @SinceKotlin(version="1.6")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    @NotNull
    public final Sequence<String> splitToSequence(@NotNull CharSequence charSequence, int n2) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        StringsKt.requireNonNegativeLimit(n2);
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(this, charSequence, n2, null){
            Object L$1;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Regex this$0;
            final /* synthetic */ CharSequence $input;
            final /* synthetic */ int $limit;
            {
                this.this$0 = regex;
                this.$input = charSequence;
                this.$limit = n2;
                super(2, continuation);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        var2_3 = (SequenceScope)this.L$0;
                        var3_4 = Regex.access$getNativePattern$p(this.this$0).matcher(this.$input);
                        if (this.$limit != 1 && var3_4.find()) break;
                        this.label = 1;
                        v0 = var2_3.yield(this.$input.toString(), this);
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        ResultKt.throwOnFailure(var1_1);
                        v0 = var1_1;
lbl16:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                var4_5 = 0;
                var5_6 = 0;
                while (true) {
                    this.L$0 = var2_3;
                    this.L$1 = var3_4;
                    this.I$0 = var5_6;
                    this.label = 2;
                    v1 = var2_3.yield(this.$input.subSequence(var4_5, var3_4.start()).toString(), this);
                    if (v1 == var6_2) {
                        return var6_2;
                    }
                    ** GOTO lbl34
                    break;
                }
                {
                    case 2: {
                        var5_6 = this.I$0;
                        var3_4 = (Matcher)this.L$1;
                        var2_3 = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure(var1_1);
                        v1 = var1_1;
lbl34:
                        // 2 sources

                        var4_5 = var3_4.end();
                        if (++var5_6 != this.$limit - 1 && var3_4.find()) ** continue;
                        this.L$0 = null;
                        this.L$1 = null;
                        this.label = 3;
                        v2 = var2_3.yield(this.$input.subSequence(var4_5, this.$input.length()).toString(), this);
                        if (v2 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl46
                    }
                    case 3: {
                        ResultKt.throwOnFailure(var1_1);
                        v2 = var1_1;
lbl46:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = object;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super String> sequenceScope, Continuation<? super Unit> continuation) {
                return (this.create(sequenceScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public static /* synthetic */ Sequence splitToSequence$default(Regex regex, CharSequence charSequence, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return regex.splitToSequence(charSequence, n2);
    }

    @NotNull
    public String toString() {
        String string = this.nativePattern.toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    @NotNull
    public final Pattern toPattern() {
        return this.nativePattern;
    }

    private final Object writeReplace() {
        String string = this.nativePattern.pattern();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return new Serialized(string, this.nativePattern.flags());
    }

    private static final MatchResult findAll$lambda$1(Regex regex, CharSequence charSequence, int n2) {
        return regex.find(charSequence, n2);
    }

    public static final /* synthetic */ Pattern access$getNativePattern$p(Regex regex) {
        return regex.nativePattern;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lkotlin/text/Regex$Companion;", "", "<init>", "()V", "fromLiteral", "Lkotlin/text/Regex;", "literal", "", "escape", "escapeReplacement", "ensureUnicodeCase", "", "flags", "kotlin-stdlib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex fromLiteral(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "");
            return new Regex(string, RegexOption.LITERAL);
        }

        @NotNull
        public final String escape(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "");
            String string2 = Pattern.quote(string);
            Intrinsics.checkNotNullExpressionValue(string2, "");
            return string2;
        }

        @NotNull
        public final String escapeReplacement(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "");
            String string2 = Matcher.quoteReplacement(string);
            Intrinsics.checkNotNullExpressionValue(string2, "");
            return string2;
        }

        private final int ensureUnicodeCase(int n2) {
            return (n2 & 2) != 0 ? n2 | 0x40 : n2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000f2\u00060\u0001j\u0002`\u0002:\u0001\u000fB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lkotlin/text/Regex$Serialized;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "pattern", "", "flags", "", "<init>", "(Ljava/lang/String;I)V", "getPattern", "()Ljava/lang/String;", "getFlags", "()I", "readResolve", "", "Companion", "kotlin-stdlib"})
    private static final class Serialized
    implements Serializable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String pattern;
        private final int flags;
        private static final long serialVersionUID = 0L;

        public Serialized(@NotNull String string, int n2) {
            Intrinsics.checkNotNullParameter(string, "");
            this.pattern = string;
            this.flags = n2;
        }

        @NotNull
        public final String getPattern() {
            return this.pattern;
        }

        public final int getFlags() {
            return this.flags;
        }

        private final Object readResolve() {
            Pattern pattern = Pattern.compile(this.pattern, this.flags);
            Intrinsics.checkNotNullExpressionValue(pattern, "");
            return new Regex(pattern);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkotlin/text/Regex$Serialized$Companion;", "", "<init>", "()V", "serialVersionUID", "", "kotlin-stdlib"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }
        }
    }
}

