/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.encoding;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.collections.AbstractList;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.encoding.Base64Kt;
import kotlin.io.encoding.ExperimentalEncodingApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\t\b\u0017\u0018\u0000 >2\u00020\u0001:\u0002=>B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0006H\u0007J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J4\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u00142\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J=\u0010\u001b\u001a\u0002H\u001c\"\f\b\u0000\u0010\u001c*\u00060\u001dj\u0002`\u001e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u0002H\u001c2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u001fJ\"\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J4\u0010!\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u00142\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J\"\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J4\u0010!\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u00142\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J%\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b$J5\u0010%\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b)J\b\u0010*\u001a\u00020\u0003H\u0002J0\u0010+\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J%\u0010,\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b-J%\u0010.\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b/J\u0015\u00100\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b1J(\u00102\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u0014H\u0002J\u0010\u00105\u001a\u0002062\u0006\u00103\u001a\u00020\u0014H\u0002J \u00107\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J%\u00108\u001a\u0002062\u0006\u0010(\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b9J \u0010:\u001a\u0002062\u0006\u0010;\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\u0014H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006?"}, d2={"Lkotlin/io/encoding/Base64;", "", "isUrlSafe", "", "isMimeScheme", "paddingOption", "Lkotlin/io/encoding/Base64$PaddingOption;", "<init>", "(ZZLkotlin/io/encoding/Base64$PaddingOption;)V", "isUrlSafe$kotlin_stdlib", "()Z", "isMimeScheme$kotlin_stdlib", "getPaddingOption$kotlin_stdlib", "()Lkotlin/io/encoding/Base64$PaddingOption;", "withPadding", "option", "encodeToByteArray", "", "source", "startIndex", "", "endIndex", "encodeIntoByteArray", "destination", "destinationOffset", "encode", "", "encodeToAppendable", "A", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "([BLjava/lang/Appendable;II)Ljava/lang/Appendable;", "decode", "decodeIntoByteArray", "", "encodeToByteArrayImpl", "encodeToByteArrayImpl$kotlin_stdlib", "encodeIntoByteArrayImpl", "encodeIntoByteArrayImpl$kotlin_stdlib", "encodeSize", "sourceSize", "encodeSize$kotlin_stdlib", "shouldPadOnEncode", "decodeImpl", "decodeSize", "decodeSize$kotlin_stdlib", "charsToBytesImpl", "charsToBytesImpl$kotlin_stdlib", "bytesToStringImpl", "bytesToStringImpl$kotlin_stdlib", "handlePaddingSymbol", "padIndex", "byteStart", "checkPaddingIsAllowed", "", "skipIllegalSymbolsIfMime", "checkSourceBounds", "checkSourceBounds$kotlin_stdlib", "checkDestinationBounds", "destinationSize", "capacityNeeded", "PaddingOption", "Default", "kotlin-stdlib"})
@SinceKotlin(version="1.8")
@ExperimentalEncodingApi
public class Base64 {
    @NotNull
    public static final Default Default = new Default(null);
    private final boolean isUrlSafe;
    private final boolean isMimeScheme;
    @NotNull
    private final PaddingOption paddingOption;
    private static final int bitsPerByte = 8;
    private static final int bitsPerSymbol = 6;
    public static final int bytesPerGroup = 3;
    public static final int symbolsPerGroup = 4;
    public static final byte padSymbol = 61;
    public static final int mimeLineLength = 76;
    private static final int mimeGroupsPerLine = 19;
    @NotNull
    private static final byte[] mimeLineSeparatorSymbols;
    @NotNull
    private static final Base64 UrlSafe;
    @NotNull
    private static final Base64 Mime;

    private Base64(boolean bl, boolean bl2, PaddingOption paddingOption) {
        this.isUrlSafe = bl;
        this.isMimeScheme = bl2;
        this.paddingOption = paddingOption;
        if (!(!this.isUrlSafe || !this.isMimeScheme)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final boolean isUrlSafe$kotlin_stdlib() {
        return this.isUrlSafe;
    }

    public final boolean isMimeScheme$kotlin_stdlib() {
        return this.isMimeScheme;
    }

    @NotNull
    public final PaddingOption getPaddingOption$kotlin_stdlib() {
        return this.paddingOption;
    }

    @SinceKotlin(version="2.0")
    @NotNull
    public final Base64 withPadding(@NotNull PaddingOption paddingOption) {
        Intrinsics.checkNotNullParameter((Object)paddingOption, "");
        return this.paddingOption == paddingOption ? this : new Base64(this.isUrlSafe, this.isMimeScheme, paddingOption);
    }

    @NotNull
    public final byte[] encodeToByteArray(@NotNull byte[] byArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byArray, "");
        return this.encodeToByteArrayImpl$kotlin_stdlib(byArray, n2, n3);
    }

    public static /* synthetic */ byte[] encodeToByteArray$default(Base64 base64, byte[] byArray, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeToByteArray");
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = byArray.length;
        }
        return base64.encodeToByteArray(byArray, n2, n3);
    }

    public final int encodeIntoByteArray(@NotNull byte[] byArray, @NotNull byte[] byArray2, int n2, int n3, int n4) {
        Intrinsics.checkNotNullParameter(byArray, "");
        Intrinsics.checkNotNullParameter(byArray2, "");
        return this.encodeIntoByteArrayImpl$kotlin_stdlib(byArray, byArray2, n2, n3, n4);
    }

    public static /* synthetic */ int encodeIntoByteArray$default(Base64 base64, byte[] byArray, byte[] byArray2, int n2, int n3, int n4, int n5, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeIntoByteArray");
        }
        if ((n5 & 4) != 0) {
            n2 = 0;
        }
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = byArray.length;
        }
        return base64.encodeIntoByteArray(byArray, byArray2, n2, n3, n4);
    }

    @NotNull
    public final String encode(@NotNull byte[] byArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byArray, "");
        byte[] byArray2 = this.encodeToByteArrayImpl$kotlin_stdlib(byArray, n2, n3);
        return new String(byArray2, Charsets.ISO_8859_1);
    }

    public static /* synthetic */ String encode$default(Base64 base64, byte[] byArray, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encode");
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = byArray.length;
        }
        return base64.encode(byArray, n2, n3);
    }

    @NotNull
    public final <A extends Appendable> A encodeToAppendable(@NotNull byte[] byArray, @NotNull A a2, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byArray, "");
        Intrinsics.checkNotNullParameter(a2, "");
        byte[] byArray2 = this.encodeToByteArrayImpl$kotlin_stdlib(byArray, n2, n3);
        String string = new String(byArray2, Charsets.ISO_8859_1);
        a2.append(string);
        return a2;
    }

    public static /* synthetic */ Appendable encodeToAppendable$default(Base64 base64, byte[] byArray, Appendable appendable, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeToAppendable");
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = byArray.length;
        }
        return base64.encodeToAppendable(byArray, appendable, n2, n3);
    }

    @NotNull
    public final byte[] decode(@NotNull byte[] byArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byArray, "");
        this.checkSourceBounds$kotlin_stdlib(byArray.length, n2, n3);
        int n4 = this.decodeSize$kotlin_stdlib(byArray, n2, n3);
        byte[] byArray2 = new byte[n4];
        int n5 = this.decodeImpl(byArray, byArray2, 0, n2, n3);
        if (!(n5 == byArray2.length)) {
            throw new IllegalStateException("Check failed.");
        }
        return byArray2;
    }

    public static /* synthetic */ byte[] decode$default(Base64 base64, byte[] byArray, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decode");
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = byArray.length;
        }
        return base64.decode(byArray, n2, n3);
    }

    public final int decodeIntoByteArray(@NotNull byte[] byArray, @NotNull byte[] byArray2, int n2, int n3, int n4) {
        Intrinsics.checkNotNullParameter(byArray, "");
        Intrinsics.checkNotNullParameter(byArray2, "");
        this.checkSourceBounds$kotlin_stdlib(byArray.length, n3, n4);
        this.checkDestinationBounds(byArray2.length, n2, this.decodeSize$kotlin_stdlib(byArray, n3, n4));
        return this.decodeImpl(byArray, byArray2, n2, n3, n4);
    }

    public static /* synthetic */ int decodeIntoByteArray$default(Base64 base64, byte[] byArray, byte[] byArray2, int n2, int n3, int n4, int n5, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decodeIntoByteArray");
        }
        if ((n5 & 4) != 0) {
            n2 = 0;
        }
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = byArray.length;
        }
        return base64.decodeIntoByteArray(byArray, byArray2, n2, n3, n4);
    }

    @NotNull
    public final byte[] decode(@NotNull CharSequence charSequence, int n2, int n3) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(charSequence, "");
        Base64 base64 = this;
        if (charSequence instanceof String) {
            base64.checkSourceBounds$kotlin_stdlib(((String)charSequence).length(), n2, n3);
            String string = ((String)charSequence).substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue(string, "");
            String string2 = string;
            Charset charset = Charsets.ISO_8859_1;
            Intrinsics.checkNotNull(string2);
            byte[] byArray2 = string2.getBytes(charset);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue(byArray2, "");
        } else {
            byArray = base64.charsToBytesImpl$kotlin_stdlib(charSequence, n2, n3);
        }
        byte[] byArray3 = byArray;
        return Base64.decode$default(this, byArray3, 0, 0, 6, null);
    }

    public static /* synthetic */ byte[] decode$default(Base64 base64, CharSequence charSequence, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decode");
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = charSequence.length();
        }
        return base64.decode(charSequence, n2, n3);
    }

    public final int decodeIntoByteArray(@NotNull CharSequence charSequence, @NotNull byte[] byArray, int n2, int n3, int n4) {
        byte[] byArray2;
        Intrinsics.checkNotNullParameter(charSequence, "");
        Intrinsics.checkNotNullParameter(byArray, "");
        Base64 base64 = this;
        if (charSequence instanceof String) {
            base64.checkSourceBounds$kotlin_stdlib(((String)charSequence).length(), n3, n4);
            String string = ((String)charSequence).substring(n3, n4);
            Intrinsics.checkNotNullExpressionValue(string, "");
            String string2 = string;
            Charset charset = Charsets.ISO_8859_1;
            Intrinsics.checkNotNull(string2);
            byte[] byArray3 = string2.getBytes(charset);
            byArray2 = byArray3;
            Intrinsics.checkNotNullExpressionValue(byArray3, "");
        } else {
            byArray2 = base64.charsToBytesImpl$kotlin_stdlib(charSequence, n3, n4);
        }
        byte[] byArray4 = byArray2;
        return Base64.decodeIntoByteArray$default(this, byArray4, byArray, n2, 0, 0, 24, null);
    }

    public static /* synthetic */ int decodeIntoByteArray$default(Base64 base64, CharSequence charSequence, byte[] byArray, int n2, int n3, int n4, int n5, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decodeIntoByteArray");
        }
        if ((n5 & 4) != 0) {
            n2 = 0;
        }
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = charSequence.length();
        }
        return base64.decodeIntoByteArray(charSequence, byArray, n2, n3, n4);
    }

    @NotNull
    public final byte[] encodeToByteArrayImpl$kotlin_stdlib(@NotNull byte[] byArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byArray, "");
        this.checkSourceBounds$kotlin_stdlib(byArray.length, n2, n3);
        int n4 = this.encodeSize$kotlin_stdlib(n3 - n2);
        byte[] byArray2 = new byte[n4];
        this.encodeIntoByteArrayImpl$kotlin_stdlib(byArray, byArray2, 0, n2, n3);
        return byArray2;
    }

    public final int encodeIntoByteArrayImpl$kotlin_stdlib(@NotNull byte[] byArray, @NotNull byte[] byArray2, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        Intrinsics.checkNotNullParameter(byArray, "");
        Intrinsics.checkNotNullParameter(byArray2, "");
        this.checkSourceBounds$kotlin_stdlib(byArray.length, n3, n4);
        this.checkDestinationBounds(byArray2.length, n2, this.encodeSize$kotlin_stdlib(n4 - n3));
        byte[] byArray3 = this.isUrlSafe ? Base64Kt.access$getBase64UrlEncodeMap$p() : Base64Kt.access$getBase64EncodeMap$p();
        int n9 = n3;
        int n10 = n2;
        int n11 = n8 = this.isMimeScheme ? 19 : Integer.MAX_VALUE;
        while (n9 + 2 < n4) {
            int n12 = Math.min((n4 - n9) / 3, n8);
            for (n7 = 0; n7 < n12; ++n7) {
                n6 = byArray[n9++] & 0xFF;
                n5 = byArray[n9++] & 0xFF;
                int n13 = byArray[n9++] & 0xFF;
                int n14 = n6 << 16 | n5 << 8 | n13;
                byArray2[n10++] = byArray3[n14 >>> 18];
                byArray2[n10++] = byArray3[n14 >>> 12 & 0x3F];
                byArray2[n10++] = byArray3[n14 >>> 6 & 0x3F];
                byArray2[n10++] = byArray3[n14 & 0x3F];
            }
            if (n12 != n8 || n9 == n4) continue;
            byArray2[n10++] = mimeLineSeparatorSymbols[0];
            byArray2[n10++] = mimeLineSeparatorSymbols[1];
        }
        switch (n4 - n9) {
            case 1: {
                n7 = byArray[n9++] & 0xFF;
                n6 = n7 << 4;
                byArray2[n10++] = byArray3[n6 >>> 6];
                byArray2[n10++] = byArray3[n6 & 0x3F];
                if (!this.shouldPadOnEncode()) break;
                byArray2[n10++] = 61;
                byArray2[n10++] = 61;
                break;
            }
            case 2: {
                n7 = byArray[n9++] & 0xFF;
                n6 = byArray[n9++] & 0xFF;
                n5 = n7 << 10 | n6 << 2;
                byArray2[n10++] = byArray3[n5 >>> 12];
                byArray2[n10++] = byArray3[n5 >>> 6 & 0x3F];
                byArray2[n10++] = byArray3[n5 & 0x3F];
                if (!this.shouldPadOnEncode()) break;
                byArray2[n10++] = 61;
            }
        }
        if (!(n9 == n4)) {
            throw new IllegalStateException("Check failed.");
        }
        return n10 - n2;
    }

    public final int encodeSize$kotlin_stdlib(int n2) {
        int n3 = n2 / 3;
        int n4 = n2 % 3;
        int n5 = n3 * 4;
        if (n4 != 0) {
            n5 += this.shouldPadOnEncode() ? 4 : n4 + 1;
        }
        if (this.isMimeScheme) {
            n5 += (n5 - 1) / 76 * 2;
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("Input is too big");
        }
        return n5;
    }

    private final boolean shouldPadOnEncode() {
        return this.paddingOption == PaddingOption.PRESENT || this.paddingOption == PaddingOption.PRESENT_OPTIONAL;
    }

    private final int decodeImpl(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5;
        int[] nArray = this.isUrlSafe ? Base64Kt.access$getBase64UrlDecodeMap$p() : Base64Kt.access$getBase64DecodeMap$p();
        int n6 = 0;
        int n7 = -8;
        int n8 = n3;
        int n9 = n2;
        boolean bl = false;
        while (n8 < n4) {
            int n10;
            if (n7 == -8 && n8 + 3 < n4) {
                int n11;
                int n12;
                int n13;
                n5 = nArray[byArray[n8++] & 0xFF];
                n10 = nArray[byArray[n8++] & 0xFF];
                if ((n13 = n5 << 18 | n10 << 12 | (n12 = nArray[byArray[n8++] & 0xFF]) << 6 | (n11 = nArray[byArray[n8++] & 0xFF])) >= 0) {
                    byArray2[n9++] = (byte)(n13 >> 16);
                    byArray2[n9++] = (byte)(n13 >> 8);
                    byArray2[n9++] = (byte)n13;
                    continue;
                }
                n8 -= 4;
            }
            if ((n10 = nArray[n5 = byArray[n8] & 0xFF]) < 0) {
                if (n10 == -2) {
                    bl = true;
                    n8 = this.handlePaddingSymbol(byArray, n8, n4, n7);
                    break;
                }
                if (this.isMimeScheme) {
                    ++n8;
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Invalid symbol '").append((char)n5).append("'(");
                String string = Integer.toString(n5, CharsKt.checkRadix(8));
                Intrinsics.checkNotNullExpressionValue(string, "");
                throw new IllegalArgumentException(stringBuilder.append(string).append(") at index ").append(n8).toString());
            }
            ++n8;
            n6 = n6 << 6 | n10;
            if ((n7 += 6) < 0) continue;
            byArray2[n9++] = (byte)(n6 >>> n7);
            n6 &= (1 << n7) - 1;
            n7 -= 8;
        }
        if (n7 == -2) {
            throw new IllegalArgumentException("The last unit of input does not have enough bits");
        }
        if (n7 != -8 && !bl && this.paddingOption == PaddingOption.PRESENT) {
            throw new IllegalArgumentException("The padding option is set to PRESENT, but the input is not properly padded");
        }
        if (n6 != 0) {
            throw new IllegalArgumentException("The pad bits must be zeros");
        }
        if ((n8 = this.skipIllegalSymbolsIfMime(byArray, n8, n4)) < n4) {
            n5 = byArray[n8] & 0xFF;
            StringBuilder stringBuilder = new StringBuilder().append("Symbol '").append((char)n5).append("'(");
            String string = Integer.toString(n5, CharsKt.checkRadix(8));
            Intrinsics.checkNotNullExpressionValue(string, "");
            throw new IllegalArgumentException(stringBuilder.append(string).append(") at index ").append(n8 - 1).append(" is prohibited after the pad character").toString());
        }
        return n9 - n2;
    }

    public final int decodeSize$kotlin_stdlib(@NotNull byte[] byArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byArray, "");
        int n4 = n3 - n2;
        if (n4 == 0) {
            return 0;
        }
        if (n4 == 1) {
            throw new IllegalArgumentException("Input should have at least 2 symbols for Base64 decoding, startIndex: " + n2 + ", endIndex: " + n3);
        }
        if (this.isMimeScheme) {
            for (int i2 = n2; i2 < n3; ++i2) {
                int n5 = byArray[i2] & 0xFF;
                int n6 = Base64Kt.access$getBase64DecodeMap$p()[n5];
                if (n6 >= 0) continue;
                if (n6 == -2) {
                    n4 -= n3 - i2;
                    break;
                }
                --n4;
            }
        } else if (byArray[n3 - 1] == 61) {
            --n4;
            if (byArray[n3 - 2] == 61) {
                --n4;
            }
        }
        return (int)((long)n4 * (long)6 / (long)8);
    }

    @NotNull
    public final byte[] charsToBytesImpl$kotlin_stdlib(@NotNull CharSequence charSequence, int n2, int n3) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        this.checkSourceBounds$kotlin_stdlib(charSequence.length(), n2, n3);
        byte[] byArray = new byte[n3 - n2];
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            byArray[n4++] = c2 <= '\u00ff' ? (int)c2 : 63;
        }
        return byArray;
    }

    @NotNull
    public final String bytesToStringImpl$kotlin_stdlib(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "");
        StringBuilder stringBuilder = new StringBuilder(byArray.length);
        for (byte by : byArray) {
            stringBuilder.append((char)by);
        }
        return stringBuilder.toString();
    }

    private final int handlePaddingSymbol(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        switch (n4) {
            case -8: {
                throw new IllegalArgumentException("Redundant pad character at index " + n2);
            }
            case -2: {
                n5 = n2 + 1;
                break;
            }
            case -4: {
                this.checkPaddingIsAllowed(n2);
                int n6 = this.skipIllegalSymbolsIfMime(byArray, n2 + 1, n3);
                if (n6 == n3 || byArray[n6] != 61) {
                    throw new IllegalArgumentException("Missing one pad character at index " + n6);
                }
                n5 = n6 + 1;
                break;
            }
            case -6: {
                this.checkPaddingIsAllowed(n2);
                n5 = n2 + 1;
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable".toString());
            }
        }
        return n5;
    }

    private final void checkPaddingIsAllowed(int n2) {
        if (this.paddingOption == PaddingOption.ABSENT) {
            throw new IllegalArgumentException("The padding option is set to ABSENT, but the input has a pad character at index " + n2);
        }
    }

    private final int skipIllegalSymbolsIfMime(byte[] byArray, int n2, int n3) {
        int n4;
        if (!this.isMimeScheme) {
            return n2;
        }
        for (n4 = n2; n4 < n3; ++n4) {
            int n5 = byArray[n4] & 0xFF;
            if (Base64Kt.access$getBase64DecodeMap$p()[n5] == -1) continue;
            return n4;
        }
        return n4;
    }

    public final void checkSourceBounds$kotlin_stdlib(int n2, int n3, int n4) {
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(n3, n4, n2);
    }

    private final void checkDestinationBounds(int n2, int n3, int n4) {
        if (n3 < 0 || n3 > n2) {
            throw new IndexOutOfBoundsException("destination offset: " + n3 + ", destination size: " + n2);
        }
        int n5 = n3 + n4;
        if (n5 < 0 || n5 > n2) {
            throw new IndexOutOfBoundsException("The destination array does not have enough capacity, destination offset: " + n3 + ", destination size: " + n2 + ", capacity needed: " + n4);
        }
    }

    public /* synthetic */ Base64(boolean bl, boolean bl2, PaddingOption paddingOption, DefaultConstructorMarker defaultConstructorMarker) {
        this(bl, bl2, paddingOption);
    }

    static {
        byte[] byArray = new byte[]{13, 10};
        mimeLineSeparatorSymbols = byArray;
        UrlSafe = new Base64(true, false, PaddingOption.PRESENT);
        Mime = new Base64(false, true, PaddingOption.PRESENT);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lkotlin/io/encoding/Base64$Default;", "Lkotlin/io/encoding/Base64;", "<init>", "()V", "bitsPerByte", "", "bitsPerSymbol", "bytesPerGroup", "symbolsPerGroup", "padSymbol", "", "mimeLineLength", "mimeGroupsPerLine", "mimeLineSeparatorSymbols", "", "getMimeLineSeparatorSymbols$kotlin_stdlib", "()[B", "UrlSafe", "getUrlSafe", "()Lkotlin/io/encoding/Base64;", "Mime", "getMime", "kotlin-stdlib"})
    public static final class Default
    extends Base64 {
        private Default() {
            super(false, false, PaddingOption.PRESENT, null);
        }

        @NotNull
        public final byte[] getMimeLineSeparatorSymbols$kotlin_stdlib() {
            return mimeLineSeparatorSymbols;
        }

        @NotNull
        public final Base64 getUrlSafe() {
            return UrlSafe;
        }

        @NotNull
        public final Base64 getMime() {
            return Mime;
        }

        public /* synthetic */ Default(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0087\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lkotlin/io/encoding/Base64$PaddingOption;", "", "<init>", "(Ljava/lang/String;I)V", "PRESENT", "ABSENT", "PRESENT_OPTIONAL", "ABSENT_OPTIONAL", "kotlin-stdlib"})
    @SinceKotlin(version="2.0")
    public static final class PaddingOption
    extends Enum<PaddingOption> {
        public static final /* enum */ PaddingOption PRESENT = new PaddingOption();
        public static final /* enum */ PaddingOption ABSENT = new PaddingOption();
        public static final /* enum */ PaddingOption PRESENT_OPTIONAL = new PaddingOption();
        public static final /* enum */ PaddingOption ABSENT_OPTIONAL = new PaddingOption();
        private static final /* synthetic */ PaddingOption[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PaddingOption[] values() {
            return (PaddingOption[])$VALUES.clone();
        }

        public static PaddingOption valueOf(String string) {
            return Enum.valueOf(PaddingOption.class, string);
        }

        @NotNull
        public static EnumEntries<PaddingOption> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = paddingOptionArray = new PaddingOption[]{PaddingOption.PRESENT, PaddingOption.ABSENT, PaddingOption.PRESENT_OPTIONAL, PaddingOption.ABSENT_OPTIONAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

