/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.SinceKotlin;
import kotlin.WasExperimental;
import kotlin.comparisons.ComparisonsKt;
import kotlin.internal.InlineOnly;
import kotlin.jvm.JvmInline;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationJvmKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.DurationUnitKt;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JvmInline
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0006\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087@\u0018\u0000 \u0089\u00012\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u0089\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u0010\u0010\u0016\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0005J\u0018\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\"\u0010\u001bJ\u0018\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b%\u0010&J\u0018\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020'H\u0086\u0002\u00a2\u0006\u0004\b%\u0010(J\u0018\u0010)\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b*\u0010&J\u0018\u0010)\u001a\u00020\u00002\u0006\u0010$\u001a\u00020'H\u0086\u0002\u00a2\u0006\u0004\b*\u0010(J\u0018\u0010)\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0013H\u0000\u00a2\u0006\u0004\b/\u00100J\r\u00101\u001a\u00020\r\u00a2\u0006\u0004\b2\u0010\u000fJ\r\u00103\u001a\u00020\r\u00a2\u0006\u0004\b4\u0010\u000fJ\r\u00105\u001a\u00020\r\u00a2\u0006\u0004\b6\u0010\u000fJ\r\u00107\u001a\u00020\r\u00a2\u0006\u0004\b8\u0010\u000fJ\u0018\u0010;\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b<\u0010=J\u009d\u0001\u0010>\u001a\u0002H?\"\u0004\b\u0000\u0010?2u\u0010@\u001aq\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(D\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(E\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(F\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(G\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(H\u0012\u0004\u0012\u0002H?0AH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0004\bI\u0010JJ\u0088\u0001\u0010>\u001a\u0002H?\"\u0004\b\u0000\u0010?2`\u0010@\u001a\\\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(E\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(F\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(G\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(H\u0012\u0004\u0012\u0002H?0KH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0004\bI\u0010LJs\u0010>\u001a\u0002H?\"\u0004\b\u0000\u0010?2K\u0010@\u001aG\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(F\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(G\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(H\u0012\u0004\u0012\u0002H?0MH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0004\bI\u0010NJ^\u0010>\u001a\u0002H?\"\u0004\b\u0000\u0010?26\u0010@\u001a2\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(G\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(H\u0012\u0004\u0012\u0002H?0OH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0004\bI\u0010PJ\u0015\u0010^\u001a\u00020'2\u0006\u0010.\u001a\u00020\u0013\u00a2\u0006\u0004\b_\u0010`J\u0015\u0010a\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0013\u00a2\u0006\u0004\bb\u00100J\u0015\u0010c\u001a\u00020\t2\u0006\u0010.\u001a\u00020\u0013\u00a2\u0006\u0004\bd\u0010eJ\u000f\u0010t\u001a\u00020uH\u0016\u00a2\u0006\u0004\bv\u0010wJA\u0010x\u001a\u00020y*\u00060zj\u0002`{2\u0006\u0010|\u001a\u00020\t2\u0006\u0010}\u001a\u00020\t2\u0006\u0010~\u001a\u00020\t2\u0006\u0010.\u001a\u00020u2\u0006\u0010\u007f\u001a\u00020\rH\u0002\u00a2\u0006\u0006\b\u0080\u0001\u0010\u0081\u0001J!\u0010t\u001a\u00020u2\u0006\u0010.\u001a\u00020\u00132\t\b\u0002\u0010\u0082\u0001\u001a\u00020\t\u00a2\u0006\u0005\bv\u0010\u0083\u0001J\u000f\u0010\u0084\u0001\u001a\u00020u\u00a2\u0006\u0005\b\u0085\u0001\u0010wJ\u0015\u0010\u0086\u0001\u001a\u00020\r2\t\u0010\u0019\u001a\u0005\u0018\u00010\u0087\u0001H\u00d6\u0003J\n\u0010\u0088\u0001\u001a\u00020\tH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0015\u0010\b\u001a\u00020\t8\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u00109\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0005R\u001a\u0010Q\u001a\u00020\t8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\bR\u0010S\u001a\u0004\bT\u0010\u000bR\u001a\u0010U\u001a\u00020\t8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\bV\u0010S\u001a\u0004\bW\u0010\u000bR\u001a\u0010X\u001a\u00020\t8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\bY\u0010S\u001a\u0004\bZ\u0010\u000bR\u001a\u0010[\u001a\u00020\t8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\\\u0010S\u001a\u0004\b]\u0010\u000bR\u0011\u0010f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bg\u0010\u0005R\u0011\u0010h\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bi\u0010\u0005R\u0011\u0010j\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bk\u0010\u0005R\u0011\u0010l\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bm\u0010\u0005R\u0011\u0010n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bo\u0010\u0005R\u0011\u0010p\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bq\u0010\u0005R\u0011\u0010r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bs\u0010\u0005\u0088\u0001\u0002\u0092\u0001\u00020\u0003\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u008a\u0001"}, d2={"Lkotlin/time/Duration;", "", "rawValue", "", "constructor-impl", "(J)J", "value", "getValue-impl", "unitDiscriminator", "", "getUnitDiscriminator-impl", "(J)I", "isInNanos", "", "isInNanos-impl", "(J)Z", "isInMillis", "isInMillis-impl", "storageUnit", "Lkotlin/time/DurationUnit;", "getStorageUnit-impl", "(J)Lkotlin/time/DurationUnit;", "unaryMinus", "unaryMinus-UwyO8pc", "plus", "other", "plus-LRDsOJo", "(JJ)J", "addValuesMixedRanges", "thisMillis", "otherNanos", "addValuesMixedRanges-UwyO8pc", "(JJJ)J", "minus", "minus-LRDsOJo", "times", "scale", "times-UwyO8pc", "(JI)J", "", "(JD)J", "div", "div-UwyO8pc", "div-LRDsOJo", "(JJ)D", "truncateTo", "unit", "truncateTo-UwyO8pc$kotlin_stdlib", "(JLkotlin/time/DurationUnit;)J", "isNegative", "isNegative-impl", "isPositive", "isPositive-impl", "isInfinite", "isInfinite-impl", "isFinite", "isFinite-impl", "absoluteValue", "getAbsoluteValue-UwyO8pc", "compareTo", "compareTo-LRDsOJo", "(JJ)I", "toComponents", "T", "action", "Lkotlin/Function5;", "Lkotlin/ParameterName;", "name", "days", "hours", "minutes", "seconds", "nanoseconds", "toComponents-impl", "(JLkotlin/jvm/functions/Function5;)Ljava/lang/Object;", "Lkotlin/Function4;", "(JLkotlin/jvm/functions/Function4;)Ljava/lang/Object;", "Lkotlin/Function3;", "(JLkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "Lkotlin/Function2;", "(JLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "hoursComponent", "getHoursComponent$annotations", "()V", "getHoursComponent-impl", "minutesComponent", "getMinutesComponent$annotations", "getMinutesComponent-impl", "secondsComponent", "getSecondsComponent$annotations", "getSecondsComponent-impl", "nanosecondsComponent", "getNanosecondsComponent$annotations", "getNanosecondsComponent-impl", "toDouble", "toDouble-impl", "(JLkotlin/time/DurationUnit;)D", "toLong", "toLong-impl", "toInt", "toInt-impl", "(JLkotlin/time/DurationUnit;)I", "inWholeDays", "getInWholeDays-impl", "inWholeHours", "getInWholeHours-impl", "inWholeMinutes", "getInWholeMinutes-impl", "inWholeSeconds", "getInWholeSeconds-impl", "inWholeMilliseconds", "getInWholeMilliseconds-impl", "inWholeMicroseconds", "getInWholeMicroseconds-impl", "inWholeNanoseconds", "getInWholeNanoseconds-impl", "toString", "", "toString-impl", "(J)Ljava/lang/String;", "appendFractional", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "whole", "fractional", "fractionalSize", "isoZeroes", "appendFractional-impl", "(JLjava/lang/StringBuilder;IIILjava/lang/String;Z)V", "decimals", "(JLkotlin/time/DurationUnit;I)Ljava/lang/String;", "toIsoString", "toIsoString-impl", "equals", "", "hashCode", "Companion", "kotlin-stdlib"})
@SinceKotlin(version="1.6")
@WasExperimental(markerClass={ExperimentalTime.class})
@SourceDebugExtension(value={"SMAP\nDuration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Duration.kt\nkotlin/time/Duration\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1059:1\n38#1:1060\n38#1:1061\n38#1:1062\n38#1:1063\n38#1:1064\n501#1:1065\n518#1:1073\n170#2,6:1066\n1#3:1072\n*S KotlinDebug\n*F\n+ 1 Duration.kt\nkotlin/time/Duration\n*L\n39#1:1060\n40#1:1061\n275#1:1062\n295#1:1063\n479#1:1064\n728#1:1065\n819#1:1073\n770#1:1066,6\n*E\n"})
public final class Duration
implements Comparable<Duration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long rawValue;
    private static final long ZERO = Duration.constructor-impl(0L);
    private static final long INFINITE = DurationKt.access$durationOfMillis(0x3FFFFFFFFFFFFFFFL);
    private static final long NEG_INFINITE = DurationKt.access$durationOfMillis(-4611686018427387903L);

    private static final long getValue-impl(long l2) {
        return l2 >> 1;
    }

    private static final int getUnitDiscriminator-impl(long l2) {
        boolean bl = false;
        return (int)l2 & 1;
    }

    private static final boolean isInNanos-impl(long l2) {
        boolean bl = false;
        return ((int)l2 & 1) == 0;
    }

    private static final boolean isInMillis-impl(long l2) {
        boolean bl = false;
        return ((int)l2 & 1) == 1;
    }

    private static final DurationUnit getStorageUnit-impl(long l2) {
        return Duration.isInNanos-impl(l2) ? DurationUnit.NANOSECONDS : DurationUnit.MILLISECONDS;
    }

    public static final long unaryMinus-UwyO8pc(long l2) {
        boolean bl = false;
        return DurationKt.access$durationOf(-Duration.getValue-impl(l2), (int)l2 & 1);
    }

    public static final long plus-LRDsOJo(long l2, long l3) {
        long l4;
        if (Duration.isInfinite-impl(l2)) {
            if (Duration.isFinite-impl(l3) || (l2 ^ l3) >= 0L) {
                return l2;
            }
            throw new IllegalArgumentException("Summing infinite durations of different signs yields an undefined result.");
        }
        if (Duration.isInfinite-impl(l3)) {
            return l3;
        }
        boolean bl = false;
        bl = false;
        if (((int)l2 & 1) == ((int)l3 & 1)) {
            long l5 = Duration.getValue-impl(l2) + Duration.getValue-impl(l3);
            l4 = Duration.isInNanos-impl(l2) ? DurationKt.access$durationOfNanosNormalized(l5) : DurationKt.access$durationOfMillisNormalized(l5);
        } else {
            l4 = Duration.isInMillis-impl(l2) ? Duration.addValuesMixedRanges-UwyO8pc(l2, Duration.getValue-impl(l2), Duration.getValue-impl(l3)) : Duration.addValuesMixedRanges-UwyO8pc(l2, Duration.getValue-impl(l3), Duration.getValue-impl(l2));
        }
        return l4;
    }

    private static final long addValuesMixedRanges-UwyO8pc(long l2, long l3, long l4) {
        long l5;
        long l6 = DurationKt.access$nanosToMillis(l4);
        long l7 = l3 + l6;
        boolean bl = -4611686018426L <= l7 ? l7 < 4611686018427L : false;
        if (bl) {
            long l8 = l4 - DurationKt.access$millisToNanos(l6);
            l5 = DurationKt.access$durationOfNanos(DurationKt.access$millisToNanos(l7) + l8);
        } else {
            l5 = DurationKt.access$durationOfMillis(RangesKt.coerceIn(l7, -4611686018427387903L, 0x3FFFFFFFFFFFFFFFL));
        }
        return l5;
    }

    public static final long minus-LRDsOJo(long l2, long l3) {
        return Duration.plus-LRDsOJo(l2, Duration.unaryMinus-UwyO8pc(l3));
    }

    public static final long times-UwyO8pc(long l2, int n2) {
        long l3;
        if (Duration.isInfinite-impl(l2)) {
            if (n2 == 0) {
                throw new IllegalArgumentException("Multiplying infinite duration by zero yields an undefined result.");
            }
            return n2 > 0 ? l2 : Duration.unaryMinus-UwyO8pc(l2);
        }
        if (n2 == 0) {
            return ZERO;
        }
        long l4 = Duration.getValue-impl(l2);
        long l5 = l4 * (long)n2;
        if (Duration.isInNanos-impl(l2)) {
            boolean bl = -2147483647L <= l4 ? l4 < 0x80000000L : false;
            if (bl) {
                l3 = DurationKt.access$durationOfNanos(l5);
            } else if (l5 / (long)n2 == l4) {
                l3 = DurationKt.access$durationOfNanosNormalized(l5);
            } else {
                long l6 = DurationKt.access$nanosToMillis(l4);
                long l7 = l4 - DurationKt.access$millisToNanos(l6);
                long l8 = l6 * (long)n2;
                long l9 = l8 + DurationKt.access$nanosToMillis(l7 * (long)n2);
                l3 = l8 / (long)n2 == l6 && (l9 ^ l8) >= 0L ? DurationKt.access$durationOfMillis(RangesKt.coerceIn(l9, new LongRange(-4611686018427387903L, 0x3FFFFFFFFFFFFFFFL))) : (MathKt.getSign(l4) * MathKt.getSign(n2) > 0 ? INFINITE : NEG_INFINITE);
            }
        } else {
            l3 = l5 / (long)n2 == l4 ? DurationKt.access$durationOfMillis(RangesKt.coerceIn(l5, new LongRange(-4611686018427387903L, 0x3FFFFFFFFFFFFFFFL))) : (MathKt.getSign(l4) * MathKt.getSign(n2) > 0 ? INFINITE : NEG_INFINITE);
        }
        return l3;
    }

    public static final long times-UwyO8pc(long l2, double d2) {
        int n2 = MathKt.roundToInt(d2);
        if ((double)n2 == d2) {
            return Duration.times-UwyO8pc(l2, n2);
        }
        DurationUnit durationUnit = Duration.getStorageUnit-impl(l2);
        double d3 = Duration.toDouble-impl(l2, durationUnit) * d2;
        return DurationKt.toDuration(d3, durationUnit);
    }

    public static final long div-UwyO8pc(long l2, int n2) {
        if (n2 == 0) {
            long l3;
            if (Duration.isPositive-impl(l2)) {
                l3 = INFINITE;
            } else if (Duration.isNegative-impl(l2)) {
                l3 = NEG_INFINITE;
            } else {
                throw new IllegalArgumentException("Dividing zero duration by zero yields an undefined result.");
            }
            return l3;
        }
        if (Duration.isInNanos-impl(l2)) {
            return DurationKt.access$durationOfNanos(Duration.getValue-impl(l2) / (long)n2);
        }
        if (Duration.isInfinite-impl(l2)) {
            return Duration.times-UwyO8pc(l2, MathKt.getSign(n2));
        }
        long l4 = Duration.getValue-impl(l2) / (long)n2;
        boolean bl = -4611686018426L <= l4 ? l4 < 4611686018427L : false;
        if (bl) {
            long l5 = DurationKt.access$millisToNanos(Duration.getValue-impl(l2) - l4 * (long)n2) / (long)n2;
            return DurationKt.access$durationOfNanos(DurationKt.access$millisToNanos(l4) + l5);
        }
        return DurationKt.access$durationOfMillis(l4);
    }

    public static final long div-UwyO8pc(long l2, double d2) {
        int n2 = MathKt.roundToInt(d2);
        if ((double)n2 == d2 && n2 != 0) {
            return Duration.div-UwyO8pc(l2, n2);
        }
        DurationUnit durationUnit = Duration.getStorageUnit-impl(l2);
        double d3 = Duration.toDouble-impl(l2, durationUnit) / d2;
        return DurationKt.toDuration(d3, durationUnit);
    }

    public static final double div-LRDsOJo(long l2, long l3) {
        DurationUnit durationUnit = (DurationUnit)((Object)ComparisonsKt.maxOf((Comparable)((Object)Duration.getStorageUnit-impl(l2)), (Comparable)((Object)Duration.getStorageUnit-impl(l3))));
        return Duration.toDouble-impl(l2, durationUnit) / Duration.toDouble-impl(l3, durationUnit);
    }

    public static final long truncateTo-UwyO8pc$kotlin_stdlib(long l2, @NotNull DurationUnit durationUnit) {
        Intrinsics.checkNotNullParameter((Object)durationUnit, "");
        DurationUnit durationUnit2 = Duration.getStorageUnit-impl(l2);
        if (durationUnit.compareTo((Enum)durationUnit2) <= 0 || Duration.isInfinite-impl(l2)) {
            return l2;
        }
        long l3 = DurationUnitKt.convertDurationUnit(1L, durationUnit, durationUnit2);
        long l4 = Duration.getValue-impl(l2) - Duration.getValue-impl(l2) % l3;
        return DurationKt.toDuration(l4, durationUnit2);
    }

    public static final boolean isNegative-impl(long l2) {
        return l2 < 0L;
    }

    public static final boolean isPositive-impl(long l2) {
        return l2 > 0L;
    }

    public static final boolean isInfinite-impl(long l2) {
        return l2 == INFINITE || l2 == NEG_INFINITE;
    }

    public static final boolean isFinite-impl(long l2) {
        return !Duration.isInfinite-impl(l2);
    }

    public static final long getAbsoluteValue-UwyO8pc(long l2) {
        return Duration.isNegative-impl(l2) ? Duration.unaryMinus-UwyO8pc(l2) : l2;
    }

    public static int compareTo-LRDsOJo(long l2, long l3) {
        long l4 = l2 ^ l3;
        if (l4 < 0L || ((int)l4 & 1) == 0) {
            return Intrinsics.compare(l2, l3);
        }
        boolean bl = false;
        bl = false;
        int n2 = ((int)l2 & 1) - ((int)l3 & 1);
        return Duration.isNegative-impl(l2) ? -n2 : n2;
    }

    public int compareTo-LRDsOJo(long l2) {
        return Duration.compareTo-LRDsOJo(this.rawValue, l2);
    }

    public static final <T> T toComponents-impl(long l2, @NotNull Function5<? super Long, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? extends T> function5) {
        Intrinsics.checkNotNullParameter(function5, "");
        boolean bl = false;
        return function5.invoke(Duration.getInWholeDays-impl(l2), Duration.getHoursComponent-impl(l2), Duration.getMinutesComponent-impl(l2), Duration.getSecondsComponent-impl(l2), Duration.getNanosecondsComponent-impl(l2));
    }

    public static final <T> T toComponents-impl(long l2, @NotNull Function4<? super Long, ? super Integer, ? super Integer, ? super Integer, ? extends T> function4) {
        Intrinsics.checkNotNullParameter(function4, "");
        boolean bl = false;
        return function4.invoke(Duration.getInWholeHours-impl(l2), Duration.getMinutesComponent-impl(l2), Duration.getSecondsComponent-impl(l2), Duration.getNanosecondsComponent-impl(l2));
    }

    public static final <T> T toComponents-impl(long l2, @NotNull Function3<? super Long, ? super Integer, ? super Integer, ? extends T> function3) {
        Intrinsics.checkNotNullParameter(function3, "");
        boolean bl = false;
        return function3.invoke(Duration.getInWholeMinutes-impl(l2), Duration.getSecondsComponent-impl(l2), Duration.getNanosecondsComponent-impl(l2));
    }

    public static final <T> T toComponents-impl(long l2, @NotNull Function2<? super Long, ? super Integer, ? extends T> function2) {
        Intrinsics.checkNotNullParameter(function2, "");
        boolean bl = false;
        return function2.invoke(Duration.getInWholeSeconds-impl(l2), Duration.getNanosecondsComponent-impl(l2));
    }

    public static final int getHoursComponent-impl(long l2) {
        return Duration.isInfinite-impl(l2) ? 0 : (int)(Duration.getInWholeHours-impl(l2) % (long)24);
    }

    @PublishedApi
    public static /* synthetic */ void getHoursComponent$annotations() {
    }

    public static final int getMinutesComponent-impl(long l2) {
        return Duration.isInfinite-impl(l2) ? 0 : (int)(Duration.getInWholeMinutes-impl(l2) % (long)60);
    }

    @PublishedApi
    public static /* synthetic */ void getMinutesComponent$annotations() {
    }

    public static final int getSecondsComponent-impl(long l2) {
        return Duration.isInfinite-impl(l2) ? 0 : (int)(Duration.getInWholeSeconds-impl(l2) % (long)60);
    }

    @PublishedApi
    public static /* synthetic */ void getSecondsComponent$annotations() {
    }

    public static final int getNanosecondsComponent-impl(long l2) {
        return Duration.isInfinite-impl(l2) ? 0 : (Duration.isInMillis-impl(l2) ? (int)DurationKt.access$millisToNanos(Duration.getValue-impl(l2) % (long)1000) : (int)(Duration.getValue-impl(l2) % (long)1000000000));
    }

    @PublishedApi
    public static /* synthetic */ void getNanosecondsComponent$annotations() {
    }

    public static final double toDouble-impl(long l2, @NotNull DurationUnit durationUnit) {
        Intrinsics.checkNotNullParameter((Object)durationUnit, "");
        long l3 = l2;
        return l3 == INFINITE ? Double.POSITIVE_INFINITY : (l3 == NEG_INFINITE ? Double.NEGATIVE_INFINITY : DurationUnitKt.convertDurationUnit((double)Duration.getValue-impl(l2), Duration.getStorageUnit-impl(l2), durationUnit));
    }

    public static final long toLong-impl(long l2, @NotNull DurationUnit durationUnit) {
        Intrinsics.checkNotNullParameter((Object)durationUnit, "");
        long l3 = l2;
        return l3 == INFINITE ? Long.MAX_VALUE : (l3 == NEG_INFINITE ? Long.MIN_VALUE : DurationUnitKt.convertDurationUnit(Duration.getValue-impl(l2), Duration.getStorageUnit-impl(l2), durationUnit));
    }

    public static final int toInt-impl(long l2, @NotNull DurationUnit durationUnit) {
        Intrinsics.checkNotNullParameter((Object)durationUnit, "");
        return (int)RangesKt.coerceIn(Duration.toLong-impl(l2, durationUnit), Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static final long getInWholeDays-impl(long l2) {
        return Duration.toLong-impl(l2, DurationUnit.DAYS);
    }

    public static final long getInWholeHours-impl(long l2) {
        return Duration.toLong-impl(l2, DurationUnit.HOURS);
    }

    public static final long getInWholeMinutes-impl(long l2) {
        return Duration.toLong-impl(l2, DurationUnit.MINUTES);
    }

    public static final long getInWholeSeconds-impl(long l2) {
        return Duration.toLong-impl(l2, DurationUnit.SECONDS);
    }

    public static final long getInWholeMilliseconds-impl(long l2) {
        return Duration.isInMillis-impl(l2) && Duration.isFinite-impl(l2) ? Duration.getValue-impl(l2) : Duration.toLong-impl(l2, DurationUnit.MILLISECONDS);
    }

    public static final long getInWholeMicroseconds-impl(long l2) {
        return Duration.toLong-impl(l2, DurationUnit.MICROSECONDS);
    }

    public static final long getInWholeNanoseconds-impl(long l2) {
        long l3 = Duration.getValue-impl(l2);
        return Duration.isInNanos-impl(l2) ? l3 : (l3 > 9223372036854L ? Long.MAX_VALUE : (l3 < -9223372036854L ? Long.MIN_VALUE : DurationKt.access$millisToNanos(l3)));
    }

    @NotNull
    public static String toString-impl(long l2) {
        String string;
        long l3 = l2;
        if (l3 == 0L) {
            string = "0s";
        } else if (l3 == INFINITE) {
            string = "Infinity";
        } else if (l3 == NEG_INFINITE) {
            string = "-Infinity";
        } else {
            StringBuilder stringBuilder;
            boolean bl = Duration.isNegative-impl(l2);
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            if (bl) {
                stringBuilder2.append('-');
            }
            long l4 = Duration.getAbsoluteValue-UwyO8pc(l2);
            boolean bl3 = false;
            int n2 = Duration.getNanosecondsComponent-impl(l4);
            int n3 = Duration.getSecondsComponent-impl(l4);
            int n4 = Duration.getMinutesComponent-impl(l4);
            int n5 = Duration.getHoursComponent-impl(l4);
            long l5 = Duration.getInWholeDays-impl(l4);
            boolean bl4 = false;
            boolean bl5 = l5 != 0L;
            boolean bl6 = n5 != 0;
            boolean bl7 = n4 != 0;
            boolean bl8 = n3 != 0 || n2 != 0;
            int n6 = 0;
            if (bl5) {
                stringBuilder2.append(l5).append('d');
                ++n6;
            }
            if (bl6 || bl5 && (bl7 || bl8)) {
                if (n6++ > 0) {
                    stringBuilder2.append(' ');
                }
                stringBuilder2.append(n5).append('h');
            }
            if (bl7 || bl8 && (bl6 || bl5)) {
                if (n6++ > 0) {
                    stringBuilder2.append(' ');
                }
                stringBuilder2.append(n4).append('m');
            }
            if (bl8) {
                if (n6++ > 0) {
                    stringBuilder2.append(' ');
                }
                if (n3 != 0 || bl5 || bl6 || bl7) {
                    Duration.appendFractional-impl(l2, stringBuilder2, n3, n2, 9, "s", false);
                } else if (n2 >= 1000000) {
                    Duration.appendFractional-impl(l2, stringBuilder2, n2 / 1000000, n2 % 1000000, 6, "ms", false);
                } else if (n2 >= 1000) {
                    Duration.appendFractional-impl(l2, stringBuilder2, n2 / 1000, n2 % 1000, 3, "us", false);
                } else {
                    stringBuilder2.append(n2).append("ns");
                }
            }
            if (bl && n6 > 1) {
                stringBuilder2.insert(1, '(').append(')');
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    @NotNull
    public String toString() {
        return Duration.toString-impl(this.rawValue);
    }

    private static final void appendFractional-impl(long l2, StringBuilder stringBuilder, int n2, int n3, int n4, String string, boolean bl) {
        stringBuilder.append(n2);
        if (n3 != 0) {
            StringBuilder stringBuilder2;
            int n5;
            String string2;
            block5: {
                stringBuilder.append('.');
                string2 = StringsKt.padStart(String.valueOf(n3), n4, '0');
                CharSequence charSequence = string2;
                boolean bl2 = false;
                int n6 = charSequence.length() + -1;
                if (0 <= n6) {
                    do {
                        int n7 = n6--;
                        char c2 = charSequence.charAt(n7);
                        boolean bl3 = false;
                        if (!(c2 != '0')) continue;
                        n5 = n7;
                        break block5;
                    } while (0 <= n6);
                }
                n5 = -1;
            }
            int n8 = n5 + 1;
            if (!bl && n8 < 3) {
                StringBuilder stringBuilder3 = stringBuilder.append(string2, 0, n8);
                stringBuilder2 = stringBuilder3;
                Intrinsics.checkNotNullExpressionValue(stringBuilder3, "");
            } else {
                StringBuilder stringBuilder4 = stringBuilder.append(string2, 0, (n8 + 2) / 3 * 3);
                stringBuilder2 = stringBuilder4;
                Intrinsics.checkNotNullExpressionValue(stringBuilder4, "");
            }
        }
        stringBuilder.append(string);
    }

    @NotNull
    public static final String toString-impl(long l2, @NotNull DurationUnit durationUnit, int n2) {
        Intrinsics.checkNotNullParameter((Object)durationUnit, "");
        if (!(n2 >= 0)) {
            boolean bl = false;
            String string = "decimals must be not negative, but was " + n2;
            throw new IllegalArgumentException(string.toString());
        }
        double d2 = Duration.toDouble-impl(l2, durationUnit);
        if (Double.isInfinite(d2)) {
            return String.valueOf(d2);
        }
        return DurationJvmKt.formatToExactDecimals(d2, RangesKt.coerceAtMost(n2, 12)) + DurationUnitKt.shortName(durationUnit);
    }

    public static /* synthetic */ String toString-impl$default(long l2, DurationUnit durationUnit, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return Duration.toString-impl(l2, durationUnit, n2);
    }

    @NotNull
    public static final String toIsoString-impl(long l2) {
        boolean bl;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        if (Duration.isNegative-impl(l2)) {
            stringBuilder2.append('-');
        }
        stringBuilder2.append("PT");
        long l3 = Duration.getAbsoluteValue-UwyO8pc(l2);
        boolean bl3 = false;
        int n2 = Duration.getNanosecondsComponent-impl(l3);
        int n3 = Duration.getSecondsComponent-impl(l3);
        int n4 = Duration.getMinutesComponent-impl(l3);
        long l4 = Duration.getInWholeHours-impl(l3);
        boolean bl4 = false;
        long l5 = l4;
        if (Duration.isInfinite-impl(l2)) {
            l5 = 9999999999999L;
        }
        boolean bl5 = l5 != 0L;
        boolean bl6 = n3 != 0 || n2 != 0;
        boolean bl7 = bl = n4 != 0 || bl6 && bl5;
        if (bl5) {
            stringBuilder2.append(l5).append('H');
        }
        if (bl) {
            stringBuilder2.append(n4).append('M');
        }
        if (bl6 || !bl5 && !bl) {
            Duration.appendFractional-impl(l2, stringBuilder2, n3, n2, 9, "S", true);
        }
        return stringBuilder.toString();
    }

    public static int hashCode-impl(long l2) {
        return Long.hashCode(l2);
    }

    public int hashCode() {
        return Duration.hashCode-impl(this.rawValue);
    }

    public static boolean equals-impl(long l2, Object object) {
        if (!(object instanceof Duration)) {
            return false;
        }
        long l3 = ((Duration)object).unbox-impl();
        return l2 == l3;
    }

    public boolean equals(Object object) {
        return Duration.equals-impl(this.rawValue, object);
    }

    private /* synthetic */ Duration(long l2) {
        this.rawValue = l2;
    }

    public static long constructor-impl(long l2) {
        long l3 = l2;
        if (DurationJvmKt.getDurationAssertionsEnabled()) {
            if (Duration.isInNanos-impl(l3)) {
                long l4 = Duration.getValue-impl(l3);
                if (!(-4611686018426999999L <= l4 ? l4 < 4611686018427000000L : false)) {
                    throw new AssertionError((Object)(Duration.getValue-impl(l3) + " ns is out of nanoseconds range"));
                }
            } else {
                long l5 = Duration.getValue-impl(l3);
                if (!(-4611686018427387903L <= l5 ? l5 < 0x4000000000000000L : false)) {
                    throw new AssertionError((Object)(Duration.getValue-impl(l3) + " ms is out of milliseconds range"));
                }
                l5 = Duration.getValue-impl(l3);
                boolean bl = -4611686018426L <= l5 ? l5 < 4611686018427L : false;
                if (bl) {
                    throw new AssertionError((Object)(Duration.getValue-impl(l3) + " ms is denormalized"));
                }
            }
        }
        return l3;
    }

    public static final /* synthetic */ Duration box-impl(long l2) {
        return new Duration(l2);
    }

    public final /* synthetic */ long unbox-impl() {
        return this.rawValue;
    }

    public static final boolean equals-impl0(long l2, long l3) {
        return l2 == l3;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo-LRDsOJo(((Duration)object).unbox-impl());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0007J\u0015\u00100\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u000201\u00a2\u0006\u0004\b2\u00103J\u0015\u00104\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u000201\u00a2\u0006\u0004\b5\u00103J\u0015\u00106\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u000201\u00a2\u0006\u0002\b7J\u0015\u00108\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u000201\u00a2\u0006\u0002\b9R\u0013\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\t\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\n\u0010\u0007R\u0016\u0010\u000b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\f\u0010\u0007R\u001f\u0010\u0013\u001a\u00020\u0005*\u00020\u00148\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001f\u0010\u0013\u001a\u00020\u0005*\u00020\u00198\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u001a\u001a\u0004\b\u0017\u0010\u001bR\u001f\u0010\u0013\u001a\u00020\u0005*\u00020\u000e8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u001c\u001a\u0004\b\u0017\u0010\u001dR\u001f\u0010\u001e\u001a\u00020\u0005*\u00020\u00148\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010\u0016\u001a\u0004\b \u0010\u0018R\u001f\u0010\u001e\u001a\u00020\u0005*\u00020\u00198\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010\u001a\u001a\u0004\b \u0010\u001bR\u001f\u0010\u001e\u001a\u00020\u0005*\u00020\u000e8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010\u001c\u001a\u0004\b \u0010\u001dR\u001f\u0010!\u001a\u00020\u0005*\u00020\u00148\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010\u0016\u001a\u0004\b#\u0010\u0018R\u001f\u0010!\u001a\u00020\u0005*\u00020\u00198\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010\u001a\u001a\u0004\b#\u0010\u001bR\u001f\u0010!\u001a\u00020\u0005*\u00020\u000e8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010\u001c\u001a\u0004\b#\u0010\u001dR\u001f\u0010$\u001a\u00020\u0005*\u00020\u00148\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b%\u0010\u0016\u001a\u0004\b&\u0010\u0018R\u001f\u0010$\u001a\u00020\u0005*\u00020\u00198\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b%\u0010\u001a\u001a\u0004\b&\u0010\u001bR\u001f\u0010$\u001a\u00020\u0005*\u00020\u000e8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b%\u0010\u001c\u001a\u0004\b&\u0010\u001dR\u001f\u0010'\u001a\u00020\u0005*\u00020\u00148\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b(\u0010\u0016\u001a\u0004\b)\u0010\u0018R\u001f\u0010'\u001a\u00020\u0005*\u00020\u00198\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b(\u0010\u001a\u001a\u0004\b)\u0010\u001bR\u001f\u0010'\u001a\u00020\u0005*\u00020\u000e8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b(\u0010\u001c\u001a\u0004\b)\u0010\u001dR\u001f\u0010*\u001a\u00020\u0005*\u00020\u00148\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010\u0016\u001a\u0004\b,\u0010\u0018R\u001f\u0010*\u001a\u00020\u0005*\u00020\u00198\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010\u001a\u001a\u0004\b,\u0010\u001bR\u001f\u0010*\u001a\u00020\u0005*\u00020\u000e8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010\u001c\u001a\u0004\b,\u0010\u001dR\u001f\u0010-\u001a\u00020\u0005*\u00020\u00148\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b.\u0010\u0016\u001a\u0004\b/\u0010\u0018R\u001f\u0010-\u001a\u00020\u0005*\u00020\u00198\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b.\u0010\u001a\u001a\u0004\b/\u0010\u001bR\u001f\u0010-\u001a\u00020\u0005*\u00020\u000e8\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b.\u0010\u001c\u001a\u0004\b/\u0010\u001d\u00a8\u0006:"}, d2={"Lkotlin/time/Duration$Companion;", "", "<init>", "()V", "ZERO", "Lkotlin/time/Duration;", "getZERO-UwyO8pc", "()J", "J", "INFINITE", "getINFINITE-UwyO8pc", "NEG_INFINITE", "getNEG_INFINITE-UwyO8pc$kotlin_stdlib", "convert", "", "value", "sourceUnit", "Lkotlin/time/DurationUnit;", "targetUnit", "nanoseconds", "", "getNanoseconds-UwyO8pc$annotations", "(I)V", "getNanoseconds-UwyO8pc", "(I)J", "", "(J)V", "(J)J", "(D)V", "(D)J", "microseconds", "getMicroseconds-UwyO8pc$annotations", "getMicroseconds-UwyO8pc", "milliseconds", "getMilliseconds-UwyO8pc$annotations", "getMilliseconds-UwyO8pc", "seconds", "getSeconds-UwyO8pc$annotations", "getSeconds-UwyO8pc", "minutes", "getMinutes-UwyO8pc$annotations", "getMinutes-UwyO8pc", "hours", "getHours-UwyO8pc$annotations", "getHours-UwyO8pc", "days", "getDays-UwyO8pc$annotations", "getDays-UwyO8pc", "parse", "", "parse-UwyO8pc", "(Ljava/lang/String;)J", "parseIsoString", "parseIsoString-UwyO8pc", "parseOrNull", "parseOrNull-FghU774", "parseIsoStringOrNull", "parseIsoStringOrNull-FghU774", "kotlin-stdlib"})
    public static final class Companion {
        private Companion() {
        }

        public final long getZERO-UwyO8pc() {
            return ZERO;
        }

        public final long getINFINITE-UwyO8pc() {
            return INFINITE;
        }

        public final long getNEG_INFINITE-UwyO8pc$kotlin_stdlib() {
            return NEG_INFINITE;
        }

        @ExperimentalTime
        public final double convert(double d2, @NotNull DurationUnit durationUnit, @NotNull DurationUnit durationUnit2) {
            Intrinsics.checkNotNullParameter((Object)durationUnit, "");
            Intrinsics.checkNotNullParameter((Object)durationUnit2, "");
            return DurationUnitKt.convertDurationUnit(d2, durationUnit, durationUnit2);
        }

        private final long getNanoseconds-UwyO8pc(int n2) {
            return DurationKt.toDuration(n2, DurationUnit.NANOSECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getNanoseconds-UwyO8pc$annotations(int n2) {
        }

        private final long getNanoseconds-UwyO8pc(long l2) {
            return DurationKt.toDuration(l2, DurationUnit.NANOSECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getNanoseconds-UwyO8pc$annotations(long l2) {
        }

        private final long getNanoseconds-UwyO8pc(double d2) {
            return DurationKt.toDuration(d2, DurationUnit.NANOSECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getNanoseconds-UwyO8pc$annotations(double d2) {
        }

        private final long getMicroseconds-UwyO8pc(int n2) {
            return DurationKt.toDuration(n2, DurationUnit.MICROSECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getMicroseconds-UwyO8pc$annotations(int n2) {
        }

        private final long getMicroseconds-UwyO8pc(long l2) {
            return DurationKt.toDuration(l2, DurationUnit.MICROSECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getMicroseconds-UwyO8pc$annotations(long l2) {
        }

        private final long getMicroseconds-UwyO8pc(double d2) {
            return DurationKt.toDuration(d2, DurationUnit.MICROSECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getMicroseconds-UwyO8pc$annotations(double d2) {
        }

        private final long getMilliseconds-UwyO8pc(int n2) {
            return DurationKt.toDuration(n2, DurationUnit.MILLISECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getMilliseconds-UwyO8pc$annotations(int n2) {
        }

        private final long getMilliseconds-UwyO8pc(long l2) {
            return DurationKt.toDuration(l2, DurationUnit.MILLISECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getMilliseconds-UwyO8pc$annotations(long l2) {
        }

        private final long getMilliseconds-UwyO8pc(double d2) {
            return DurationKt.toDuration(d2, DurationUnit.MILLISECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getMilliseconds-UwyO8pc$annotations(double d2) {
        }

        private final long getSeconds-UwyO8pc(int n2) {
            return DurationKt.toDuration(n2, DurationUnit.SECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getSeconds-UwyO8pc$annotations(int n2) {
        }

        private final long getSeconds-UwyO8pc(long l2) {
            return DurationKt.toDuration(l2, DurationUnit.SECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getSeconds-UwyO8pc$annotations(long l2) {
        }

        private final long getSeconds-UwyO8pc(double d2) {
            return DurationKt.toDuration(d2, DurationUnit.SECONDS);
        }

        @InlineOnly
        public static /* synthetic */ void getSeconds-UwyO8pc$annotations(double d2) {
        }

        private final long getMinutes-UwyO8pc(int n2) {
            return DurationKt.toDuration(n2, DurationUnit.MINUTES);
        }

        @InlineOnly
        public static /* synthetic */ void getMinutes-UwyO8pc$annotations(int n2) {
        }

        private final long getMinutes-UwyO8pc(long l2) {
            return DurationKt.toDuration(l2, DurationUnit.MINUTES);
        }

        @InlineOnly
        public static /* synthetic */ void getMinutes-UwyO8pc$annotations(long l2) {
        }

        private final long getMinutes-UwyO8pc(double d2) {
            return DurationKt.toDuration(d2, DurationUnit.MINUTES);
        }

        @InlineOnly
        public static /* synthetic */ void getMinutes-UwyO8pc$annotations(double d2) {
        }

        private final long getHours-UwyO8pc(int n2) {
            return DurationKt.toDuration(n2, DurationUnit.HOURS);
        }

        @InlineOnly
        public static /* synthetic */ void getHours-UwyO8pc$annotations(int n2) {
        }

        private final long getHours-UwyO8pc(long l2) {
            return DurationKt.toDuration(l2, DurationUnit.HOURS);
        }

        @InlineOnly
        public static /* synthetic */ void getHours-UwyO8pc$annotations(long l2) {
        }

        private final long getHours-UwyO8pc(double d2) {
            return DurationKt.toDuration(d2, DurationUnit.HOURS);
        }

        @InlineOnly
        public static /* synthetic */ void getHours-UwyO8pc$annotations(double d2) {
        }

        private final long getDays-UwyO8pc(int n2) {
            return DurationKt.toDuration(n2, DurationUnit.DAYS);
        }

        @InlineOnly
        public static /* synthetic */ void getDays-UwyO8pc$annotations(int n2) {
        }

        private final long getDays-UwyO8pc(long l2) {
            return DurationKt.toDuration(l2, DurationUnit.DAYS);
        }

        @InlineOnly
        public static /* synthetic */ void getDays-UwyO8pc$annotations(long l2) {
        }

        private final long getDays-UwyO8pc(double d2) {
            return DurationKt.toDuration(d2, DurationUnit.DAYS);
        }

        @InlineOnly
        public static /* synthetic */ void getDays-UwyO8pc$annotations(double d2) {
        }

        public final long parse-UwyO8pc(@NotNull String string) {
            long l2;
            Intrinsics.checkNotNullParameter(string, "");
            try {
                l2 = DurationKt.access$parseDuration(string, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Invalid duration string format: '" + string + "'.", illegalArgumentException);
            }
            return l2;
        }

        public final long parseIsoString-UwyO8pc(@NotNull String string) {
            long l2;
            Intrinsics.checkNotNullParameter(string, "");
            try {
                l2 = DurationKt.access$parseDuration(string, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Invalid ISO duration string format: '" + string + "'.", illegalArgumentException);
            }
            return l2;
        }

        @Nullable
        public final Duration parseOrNull-FghU774(@NotNull String string) {
            Duration duration;
            Intrinsics.checkNotNullParameter(string, "");
            try {
                duration = Duration.box-impl(DurationKt.access$parseDuration(string, false));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                duration = null;
            }
            return duration;
        }

        @Nullable
        public final Duration parseIsoStringOrNull-FghU774(@NotNull String string) {
            Duration duration;
            Intrinsics.checkNotNullParameter(string, "");
            try {
                duration = Duration.box-impl(DurationKt.access$parseDuration(string, true));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                duration = null;
            }
            return duration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

