/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.BuilderInference;
import kotlin.ExperimentalStdlibApi;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.SinceKotlin;
import kotlin.Unit;
import kotlin.WasExperimental;
import kotlin.collections.ArrayAsCollection;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.CollectionsKt__CollectionsJVMKt;
import kotlin.collections.EmptyList;
import kotlin.comparisons.ComparisonsKt;
import kotlin.internal.InlineOnly;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=5, xi=49, d1={"\u0000\u0090\u0001\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u001a%\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\u0003H\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u0012\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\u0004\b\u0000\u0010\u0002\u001a+\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\u0004\b\u0000\u0010\u00022\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\u0003\"\u0002H\u0002\u00a2\u0006\u0002\u0010\t\u001a\u0015\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\u0004\b\u0000\u0010\u0002H\u0087\b\u001a\u0015\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000b\"\u0004\b\u0000\u0010\u0002H\u0087\b\u001a$\u0010\f\u001a\u0012\u0012\u0004\u0012\u0002H\u00020\rj\b\u0012\u0004\u0012\u0002H\u0002`\u000e\"\u0004\b\u0000\u0010\u0002H\u0087\b\u00a2\u0006\u0002\u0010\u000f\u001a+\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000b\"\u0004\b\u0000\u0010\u00022\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\u0003\"\u0002H\u0002\u00a2\u0006\u0002\u0010\t\u001a5\u0010\f\u001a\u0012\u0012\u0004\u0012\u0002H\u00020\rj\b\u0012\u0004\u0012\u0002H\u0002`\u000e\"\u0004\b\u0000\u0010\u00022\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\u0003\"\u0002H\u0002\u00a2\u0006\u0002\u0010\u0010\u001a%\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\b\b\u0000\u0010\u0002*\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u0001H\u0002\u00a2\u0006\u0002\u0010\u0014\u001a3\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\b\b\u0000\u0010\u0002*\u00020\u00122\u0016\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u00020\u0003\"\u0004\u0018\u0001H\u0002\u00a2\u0006\u0002\u0010\t\u001aC\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0016\u001a\u00020\u00172!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u0002H\u00020\u0019H\u0087\b\u00f8\u0001\u0000\u001aC\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000b\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0016\u001a\u00020\u00172!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u0002H\u00020\u0019H\u0087\b\u00f8\u0001\u0000\u001aF\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u0006\"\u0004\b\u0000\u0010\u001f2\u001f\b\u0001\u0010 \u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001f0\u000b\u0012\u0004\u0012\u00020!0\u0019\u00a2\u0006\u0002\b\"H\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u001aN\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u0006\"\u0004\b\u0000\u0010\u001f2\u0006\u0010#\u001a\u00020\u00172\u001f\b\u0001\u0010 \u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001f0\u000b\u0012\u0004\u0012\u00020!0\u0019\u00a2\u0006\u0002\b\"H\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0001\u001a\u0019\u0010+\u001a\u00020,\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0001H\u0087\b\u001a,\u0010-\u001a\u00020,\"\u0004\b\u0000\u0010\u0002*\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0001H\u0087\b\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\b\u0003\u0010\u0000\u001a!\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0001H\u0087\b\u001a!\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0006H\u0087\b\u001aH\u0010/\u001a\u0002H0\"\u0010\b\u0000\u00101*\u0006\u0012\u0002\b\u00030\u0001*\u0002H0\"\u0004\b\u0001\u00100*\u0002H12\f\u00102\u001a\b\u0012\u0004\u0012\u0002H003H\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000\u00a2\u0006\u0002\u00104\u001a,\u00105\u001a\u00020,\"\t\b\u0000\u0010\u0002\u00a2\u0006\u0002\b6*\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001H\u0087\b\u001a&\u00107\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u0002082\u0006\u00109\u001a\u00020:H\u0007\u001a\u001e\u0010;\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0006H\u0000\u001aE\u0010<\u001a\u00020\u0017\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020=*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u0001H\u00022\b\b\u0002\u0010>\u001a\u00020\u00172\b\b\u0002\u0010?\u001a\u00020\u0017\u00a2\u0006\u0002\u0010@\u001aS\u0010<\u001a\u00020\u0017\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0006\u0010\u0013\u001a\u0002H\u00022\u001a\u0010A\u001a\u0016\u0012\u0006\b\u0000\u0012\u0002H\u00020Bj\n\u0012\u0006\b\u0000\u0012\u0002H\u0002`C2\b\b\u0002\u0010>\u001a\u00020\u00172\b\b\u0002\u0010?\u001a\u00020\u0017\u00a2\u0006\u0002\u0010D\u001ag\u0010E\u001a\u00020\u0017\"\u0004\b\u0000\u0010\u0002\"\u000e\b\u0001\u0010F*\b\u0012\u0004\u0012\u0002HF0=*\b\u0012\u0004\u0012\u0002H\u00020\u00062\b\u0010G\u001a\u0004\u0018\u0001HF2\b\b\u0002\u0010>\u001a\u00020\u00172\b\b\u0002\u0010?\u001a\u00020\u00172\u0016\b\u0004\u0010H\u001a\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0006\u0012\u0004\u0018\u0001HF0\u0019H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010I\u001a>\u0010<\u001a\u00020\u0017\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00062\b\b\u0002\u0010>\u001a\u00020\u00172\b\b\u0002\u0010?\u001a\u00020\u00172\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00170\u0019\u001a%\u0010K\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010>\u001a\u00020\u00172\u0006\u0010?\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\bL\u001a\b\u0010M\u001a\u00020!H\u0001\u001a\b\u0010N\u001a\u00020!H\u0001\u001a!\u0010O\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00032\n\u0010P\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0000\u00a2\u0006\u0002\u0010Q\u001a3\u0010O\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0003\"\u0004\b\u0000\u0010\u00022\n\u0010P\u001a\u0006\u0012\u0002\b\u00030\u00012\f\u0010R\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0003H\u0000\u00a2\u0006\u0002\u0010S\"\u0019\u0010$\u001a\u00020%*\u0006\u0012\u0002\b\u00030\u00018F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\"!\u0010(\u001a\u00020\u0017\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006T"}, d2={"asCollection", "", "T", "", "([Ljava/lang/Object;)Ljava/util/Collection;", "emptyList", "", "listOf", "elements", "([Ljava/lang/Object;)Ljava/util/List;", "mutableListOf", "", "arrayListOf", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "()Ljava/util/ArrayList;", "([Ljava/lang/Object;)Ljava/util/ArrayList;", "listOfNotNull", "", "element", "(Ljava/lang/Object;)Ljava/util/List;", "List", "size", "", "init", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "index", "MutableList", "buildList", "E", "builderAction", "", "Lkotlin/ExtensionFunctionType;", "capacity", "indices", "Lkotlin/ranges/IntRange;", "getIndices", "(Ljava/util/Collection;)Lkotlin/ranges/IntRange;", "lastIndex", "getLastIndex", "(Ljava/util/List;)I", "isNotEmpty", "", "isNullOrEmpty", "orEmpty", "ifEmpty", "R", "C", "defaultValue", "Lkotlin/Function0;", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "containsAll", "Lkotlin/internal/OnlyInputTypes;", "shuffled", "", "random", "Lkotlin/random/Random;", "optimizeReadOnlyList", "binarySearch", "", "fromIndex", "toIndex", "(Ljava/util/List;Ljava/lang/Comparable;II)I", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/util/List;Ljava/lang/Object;Ljava/util/Comparator;II)I", "binarySearchBy", "K", "key", "selector", "(Ljava/util/List;Ljava/lang/Comparable;IILkotlin/jvm/functions/Function1;)I", "comparison", "rangeCheck", "rangeCheck$CollectionsKt__CollectionsKt", "throwIndexOverflow", "throwCountOverflow", "collectionToArrayCommonImpl", "collection", "(Ljava/util/Collection;)[Ljava/lang/Object;", "array", "(Ljava/util/Collection;[Ljava/lang/Object;)[Ljava/lang/Object;", "kotlin-stdlib"}, xs="kotlin/collections/CollectionsKt")
@SourceDebugExtension(value={"SMAP\nCollections.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Collections.kt\nkotlin/collections/CollectionsKt__CollectionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,526:1\n1#2:527\n*E\n"})
class CollectionsKt__CollectionsKt
extends CollectionsKt__CollectionsJVMKt {
    @NotNull
    public static final <T> Collection<T> asCollection(@NotNull T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, "");
        return new ArrayAsCollection<T>(TArray, false);
    }

    @NotNull
    public static final <T> List<T> emptyList() {
        return EmptyList.INSTANCE;
    }

    @NotNull
    public static final <T> List<T> listOf(T ... TArray) {
        Intrinsics.checkNotNullParameter(TArray, "");
        return TArray.length > 0 ? ArraysKt.asList(TArray) : CollectionsKt.emptyList();
    }

    @InlineOnly
    private static final <T> List<T> listOf() {
        return CollectionsKt.emptyList();
    }

    @SinceKotlin(version="1.1")
    @InlineOnly
    private static final <T> List<T> mutableListOf() {
        return new ArrayList();
    }

    @SinceKotlin(version="1.1")
    @InlineOnly
    private static final <T> ArrayList<T> arrayListOf() {
        return new ArrayList();
    }

    @NotNull
    public static final <T> List<T> mutableListOf(T ... TArray) {
        Intrinsics.checkNotNullParameter(TArray, "");
        return TArray.length == 0 ? (List)new ArrayList() : (List)new ArrayList((Collection)new ArrayAsCollection<T>(TArray, true));
    }

    @NotNull
    public static final <T> ArrayList<T> arrayListOf(T ... TArray) {
        Intrinsics.checkNotNullParameter(TArray, "");
        return TArray.length == 0 ? new ArrayList() : new ArrayList((Collection)new ArrayAsCollection<T>(TArray, true));
    }

    @NotNull
    public static final <T> List<T> listOfNotNull(@Nullable T t2) {
        T t3 = t2;
        return t3 != null ? CollectionsKt.listOf(t3) : CollectionsKt.emptyList();
    }

    @NotNull
    public static final <T> List<T> listOfNotNull(T ... TArray) {
        Intrinsics.checkNotNullParameter(TArray, "");
        return ArraysKt.filterNotNull(TArray);
    }

    @SinceKotlin(version="1.1")
    @InlineOnly
    private static final <T> List<T> List(int n2, Function1<? super Integer, ? extends T> function1) {
        Intrinsics.checkNotNullParameter(function1, "");
        ArrayList<T> arrayList = new ArrayList<T>(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3++;
            arrayList.add(function1.invoke(n4));
        }
        return arrayList;
    }

    @SinceKotlin(version="1.1")
    @InlineOnly
    private static final <T> List<T> MutableList(int n2, Function1<? super Integer, ? extends T> function1) {
        Intrinsics.checkNotNullParameter(function1, "");
        ArrayList<T> arrayList = new ArrayList<T>(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3++;
            boolean bl = false;
            arrayList.add(function1.invoke(n4));
        }
        return arrayList;
    }

    @SinceKotlin(version="1.6")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    @InlineOnly
    private static final <E> List<E> buildList(@BuilderInference Function1<? super List<E>, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, "");
        List list = CollectionsKt.createListBuilder();
        function1.invoke(list);
        return CollectionsKt.build(list);
    }

    @SinceKotlin(version="1.6")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    @InlineOnly
    private static final <E> List<E> buildList(int n2, @BuilderInference Function1<? super List<E>, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, "");
        List list = CollectionsKt.createListBuilder(n2);
        function1.invoke(list);
        return CollectionsKt.build(list);
    }

    @NotNull
    public static final IntRange getIndices(@NotNull Collection<?> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        return new IntRange(0, collection.size() - 1);
    }

    public static final <T> int getLastIndex(@NotNull List<? extends T> list) {
        Intrinsics.checkNotNullParameter(list, "");
        return list.size() - 1;
    }

    @InlineOnly
    private static final <T> boolean isNotEmpty(Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        return !collection.isEmpty();
    }

    @SinceKotlin(version="1.3")
    @InlineOnly
    private static final <T> boolean isNullOrEmpty(Collection<? extends T> collection) {
        return collection == null || collection.isEmpty();
    }

    @InlineOnly
    private static final <T> Collection<T> orEmpty(Collection<? extends T> collection) {
        Collection collection2 = collection;
        if (collection2 == null) {
            collection2 = CollectionsKt.emptyList();
        }
        return collection2;
    }

    @InlineOnly
    private static final <T> List<T> orEmpty(List<? extends T> list) {
        List<Object> list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @SinceKotlin(version="1.3")
    @InlineOnly
    private static final <C extends Collection<?> & R, R> R ifEmpty(C c2, Function0<? extends R> function0) {
        Intrinsics.checkNotNullParameter(function0, "");
        return (R)(c2.isEmpty() ? function0.invoke() : c2);
    }

    @InlineOnly
    private static final <T> boolean containsAll(Collection<? extends T> collection, Collection<? extends T> collection2) {
        Intrinsics.checkNotNullParameter(collection, "");
        Intrinsics.checkNotNullParameter(collection2, "");
        return collection.containsAll(collection2);
    }

    @SinceKotlin(version="1.3")
    @NotNull
    public static final <T> List<T> shuffled(@NotNull Iterable<? extends T> iterable, @NotNull Random random) {
        List<T> list;
        Intrinsics.checkNotNullParameter(iterable, "");
        Intrinsics.checkNotNullParameter(random, "");
        List<T> list2 = list = CollectionsKt.toMutableList(iterable);
        boolean bl = false;
        CollectionsKt.shuffle(list2, random);
        return list;
    }

    @NotNull
    public static final <T> List<T> optimizeReadOnlyList(@NotNull List<? extends T> list) {
        List<T> list2;
        Intrinsics.checkNotNullParameter(list, "");
        switch (list.size()) {
            case 0: {
                list2 = CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list2 = CollectionsKt.listOf(list.get(0));
                break;
            }
            default: {
                list2 = list;
            }
        }
        return list2;
    }

    public static final <T extends Comparable<? super T>> int binarySearch(@NotNull List<? extends T> list, @Nullable T t2, int n2, int n3) {
        Intrinsics.checkNotNullParameter(list, "");
        CollectionsKt__CollectionsKt.rangeCheck$CollectionsKt__CollectionsKt(list.size(), n2, n3);
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            Comparable comparable = (Comparable)list.get(n6);
            int n7 = ComparisonsKt.compareValues(comparable, t2);
            if (n7 < 0) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > 0) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    public static /* synthetic */ int binarySearch$default(List list, Comparable comparable, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = list.size();
        }
        return CollectionsKt.binarySearch(list, comparable, n2, n3);
    }

    public static final <T> int binarySearch(@NotNull List<? extends T> list, T t2, @NotNull Comparator<? super T> comparator, int n2, int n3) {
        Intrinsics.checkNotNullParameter(list, "");
        Intrinsics.checkNotNullParameter(comparator, "");
        CollectionsKt__CollectionsKt.rangeCheck$CollectionsKt__CollectionsKt(list.size(), n2, n3);
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            T t3 = list.get(n6);
            int n7 = comparator.compare(t3, t2);
            if (n7 < 0) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > 0) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    public static /* synthetic */ int binarySearch$default(List list, Object object, Comparator comparator, int n2, int n3, int n4, Object object2) {
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = list.size();
        }
        return CollectionsKt.binarySearch(list, object, comparator, n2, n3);
    }

    public static final <T, K extends Comparable<? super K>> int binarySearchBy(@NotNull List<? extends T> list, @Nullable K k2, int n2, int n3, @NotNull Function1<? super T, ? extends K> function1) {
        Intrinsics.checkNotNullParameter(list, "");
        Intrinsics.checkNotNullParameter(function1, "");
        boolean bl = false;
        return CollectionsKt.binarySearch(list, n2, n3, new Function1<T, Integer>(function1, k2){
            final /* synthetic */ Function1<T, K> $selector;
            final /* synthetic */ K $key;
            {
                this.$selector = function1;
                this.$key = k2;
            }

            public final Integer invoke(T t2) {
                return ComparisonsKt.compareValues((Comparable)this.$selector.invoke(t2), this.$key);
            }
        });
    }

    public static /* synthetic */ int binarySearchBy$default(List list, Comparable comparable, int n2, int n3, Function1 function1, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = list.size();
        }
        Intrinsics.checkNotNullParameter(list, "");
        Intrinsics.checkNotNullParameter(function1, "");
        n4 = 0;
        return CollectionsKt.binarySearch(list, n2, n3, new /* invalid duplicate definition of identical inner class */);
    }

    public static final <T> int binarySearch(@NotNull List<? extends T> list, int n2, int n3, @NotNull Function1<? super T, Integer> function1) {
        Intrinsics.checkNotNullParameter(list, "");
        Intrinsics.checkNotNullParameter(function1, "");
        CollectionsKt__CollectionsKt.rangeCheck$CollectionsKt__CollectionsKt(list.size(), n2, n3);
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            T t2 = list.get(n6);
            int n7 = ((Number)function1.invoke(t2)).intValue();
            if (n7 < 0) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > 0) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    public static /* synthetic */ int binarySearch$default(List list, int n2, int n3, Function1 function1, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = list.size();
        }
        return CollectionsKt.binarySearch(list, n2, n3, function1);
    }

    private static final void rangeCheck$CollectionsKt__CollectionsKt(int n2, int n3, int n4) {
        if (n3 > n4) {
            throw new IllegalArgumentException("fromIndex (" + n3 + ") is greater than toIndex (" + n4 + ").");
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("fromIndex (" + n3 + ") is less than zero.");
        }
        if (n4 > n2) {
            throw new IndexOutOfBoundsException("toIndex (" + n4 + ") is greater than size (" + n2 + ").");
        }
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    public static final void throwIndexOverflow() {
        throw new ArithmeticException("Index overflow has happened.");
    }

    @PublishedApi
    @SinceKotlin(version="1.3")
    public static final void throwCountOverflow() {
        throw new ArithmeticException("Count overflow has happened.");
    }

    @NotNull
    public static final Object[] collectionToArrayCommonImpl(@NotNull Collection<?> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        if (collection.isEmpty()) {
            return new Object[0];
        }
        Object[] objectArray = new Object[collection.size()];
        Iterator<?> iterator2 = collection.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            objectArray[n2++] = iterator2.next();
        }
        return objectArray;
    }

    @NotNull
    public static final <T> T[] collectionToArrayCommonImpl(@NotNull Collection<?> collection, @NotNull T[] TArray) {
        Intrinsics.checkNotNullParameter(collection, "");
        Intrinsics.checkNotNullParameter(TArray, "");
        if (collection.isEmpty()) {
            return CollectionsKt.terminateCollectionToArray(0, TArray);
        }
        T[] TArray2 = TArray.length < collection.size() ? ArraysKt.arrayOfNulls(TArray, collection.size()) : TArray;
        Iterator<?> iterator2 = collection.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            TArray2[n2++] = iterator2.next();
        }
        return CollectionsKt.terminateCollectionToArray(collection.size(), TArray2);
    }
}

