/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections.builders;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.builders.ListBuilderKt;
import kotlin.collections.builders.MapBuilderEntries;
import kotlin.collections.builders.MapBuilderKeys;
import kotlin.collections.builders.MapBuilderValues;
import kotlin.collections.builders.SerializedMap;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b#\n\u0002\u0010&\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u0081\u0001*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00032\u00060\u0004j\u0002`\u0005:\f\u0081\u0001\u0082\u0001\u0083\u0001\u0084\u0001\u0085\u0001\u0086\u0001BG\b\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010B\t\b\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0011B\u0011\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0013J\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010&J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020!H\u0016J\u0015\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010,J\u0015\u0010-\u001a\u00020!2\u0006\u0010\u0017\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010,J\u0018\u0010.\u001a\u0004\u0018\u00018\u00012\u0006\u0010+\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010/J\u001f\u00100\u001a\u0004\u0018\u00018\u00012\u0006\u0010+\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00101J\u001e\u00102\u001a\u0002032\u0014\u00104\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010&H\u0016J\u0017\u00105\u001a\u0004\u0018\u00018\u00012\u0006\u0010+\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010/J\b\u00106\u001a\u000203H\u0016J\u0013\u0010B\u001a\u00020!2\b\u0010C\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010D\u001a\u00020\rH\u0016J\b\u0010E\u001a\u00020FH\u0016J\b\u0010K\u001a\u000203H\u0002J\r\u0010L\u001a\u000203H\u0000\u00a2\u0006\u0002\bMJ\u0010\u0010N\u001a\u0002032\u0006\u0010O\u001a\u00020\rH\u0002J\u0010\u0010P\u001a\u00020!2\u0006\u0010Q\u001a\u00020\rH\u0002J\u0010\u0010R\u001a\u0002032\u0006\u0010S\u001a\u00020\rH\u0002J\u0013\u0010T\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010UJ\u0015\u0010V\u001a\u00020\r2\u0006\u0010+\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010WJ\u0010\u0010X\u001a\u0002032\u0006\u0010Y\u001a\u00020!H\u0002J\u0010\u0010Z\u001a\u0002032\u0006\u0010[\u001a\u00020\rH\u0002J\u0010\u0010\\\u001a\u00020!2\u0006\u0010]\u001a\u00020\rH\u0002J\u0015\u0010^\u001a\u00020\r2\u0006\u0010+\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010WJ\u0015\u0010_\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010WJ\u0017\u0010`\u001a\u00020\r2\u0006\u0010+\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\ba\u0010WJ\u0017\u0010b\u001a\u00020!2\u0006\u0010+\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\bc\u0010,J\u0010\u0010d\u001a\u0002032\u0006\u0010e\u001a\u00020\rH\u0002J\u0010\u0010f\u001a\u0002032\u0006\u0010g\u001a\u00020\rH\u0002J!\u0010h\u001a\u00020!2\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010jH\u0000\u00a2\u0006\u0002\bkJ\u0018\u0010l\u001a\u00020!2\u000e\u0010C\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&H\u0002J\u0019\u0010m\u001a\u00020!2\n\u0010n\u001a\u0006\u0012\u0002\b\u00030oH\u0000\u00a2\u0006\u0002\bpJ\u001c\u0010q\u001a\u00020!2\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010jH\u0002J\"\u0010r\u001a\u00020!2\u0018\u00104\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010j0oH\u0002J!\u0010s\u001a\u00020!2\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010jH\u0000\u00a2\u0006\u0002\btJ\u0017\u0010u\u001a\u00020!2\u0006\u0010v\u001a\u00028\u0001H\u0000\u00a2\u0006\u0004\bw\u0010,J\u0019\u0010x\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010yH\u0000\u00a2\u0006\u0002\bzJ\u0019\u0010{\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010|H\u0000\u00a2\u0006\u0002\b}J\u001a\u0010~\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u007fH\u0000\u00a2\u0006\u0003\b\u0080\u0001R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020!@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u00107\u001a\b\u0012\u0004\u0012\u00028\u0000088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00010<8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R&\u0010?\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010@088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010:R\u0014\u0010G\u001a\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u001aR\u0014\u0010I\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u001a\u00a8\u0006\u0087\u0001"}, d2={"Lkotlin/collections/builders/MapBuilder;", "K", "V", "", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "keysArray", "", "valuesArray", "presenceArray", "", "hashArray", "maxProbeDistance", "", "length", "<init>", "([Ljava/lang/Object;[Ljava/lang/Object;[I[III)V", "()V", "initialCapacity", "(I)V", "[Ljava/lang/Object;", "hashShift", "modCount", "value", "size", "getSize", "()I", "keysView", "Lkotlin/collections/builders/MapBuilderKeys;", "valuesView", "Lkotlin/collections/builders/MapBuilderValues;", "entriesView", "Lkotlin/collections/builders/MapBuilderEntries;", "", "isReadOnly", "isReadOnly$kotlin_stdlib", "()Z", "build", "", "writeReplace", "", "isEmpty", "containsKey", "key", "(Ljava/lang/Object;)Z", "containsValue", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putAll", "", "from", "remove", "clear", "keys", "", "getKeys", "()Ljava/util/Set;", "values", "", "getValues", "()Ljava/util/Collection;", "entries", "", "getEntries", "equals", "other", "hashCode", "toString", "", "capacity", "getCapacity$kotlin_stdlib", "hashSize", "getHashSize", "registerModification", "checkIsMutable", "checkIsMutable$kotlin_stdlib", "ensureExtraCapacity", "n", "shouldCompact", "extraCapacity", "ensureCapacity", "minCapacity", "allocateValuesArray", "()[Ljava/lang/Object;", "hash", "(Ljava/lang/Object;)I", "compact", "updateHashArray", "rehash", "newHashSize", "putRehash", "i", "findKey", "findValue", "addKey", "addKey$kotlin_stdlib", "removeKey", "removeKey$kotlin_stdlib", "removeEntryAt", "index", "removeHashAt", "removedHash", "containsEntry", "entry", "", "containsEntry$kotlin_stdlib", "contentEquals", "containsAllEntries", "m", "", "containsAllEntries$kotlin_stdlib", "putEntry", "putAllEntries", "removeEntry", "removeEntry$kotlin_stdlib", "removeValue", "element", "removeValue$kotlin_stdlib", "keysIterator", "Lkotlin/collections/builders/MapBuilder$KeysItr;", "keysIterator$kotlin_stdlib", "valuesIterator", "Lkotlin/collections/builders/MapBuilder$ValuesItr;", "valuesIterator$kotlin_stdlib", "entriesIterator", "Lkotlin/collections/builders/MapBuilder$EntriesItr;", "entriesIterator$kotlin_stdlib", "Companion", "Itr", "KeysItr", "ValuesItr", "EntriesItr", "EntryRef", "kotlin-stdlib"})
@SourceDebugExtension(value={"SMAP\nMapBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapBuilder.kt\nkotlin/collections/builders/MapBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,747:1\n1#2:748\n*E\n"})
public final class MapBuilder<K, V>
implements Serializable,
Map<K, V>,
KMutableMap {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private K[] keysArray;
    @Nullable
    private V[] valuesArray;
    @NotNull
    private int[] presenceArray;
    @NotNull
    private int[] hashArray;
    private int maxProbeDistance;
    private int length;
    private int hashShift;
    private int modCount;
    private int size;
    @Nullable
    private MapBuilderKeys<K> keysView;
    @Nullable
    private MapBuilderValues<V> valuesView;
    @Nullable
    private MapBuilderEntries<K, V> entriesView;
    private boolean isReadOnly;
    private static final int MAGIC = -1640531527;
    private static final int INITIAL_CAPACITY = 8;
    private static final int INITIAL_MAX_PROBE_DISTANCE = 2;
    private static final int TOMBSTONE = -1;
    @NotNull
    private static final MapBuilder Empty;

    private MapBuilder(K[] KArray, V[] VArray, int[] nArray, int[] nArray2, int n2, int n3) {
        this.keysArray = KArray;
        this.valuesArray = VArray;
        this.presenceArray = nArray;
        this.hashArray = nArray2;
        this.maxProbeDistance = n2;
        this.length = n3;
        this.hashShift = MapBuilder.Companion.computeShift(this.getHashSize());
    }

    public int getSize() {
        return this.size;
    }

    public final boolean isReadOnly$kotlin_stdlib() {
        return this.isReadOnly;
    }

    public MapBuilder() {
        this(8);
    }

    public MapBuilder(int n2) {
        this(ListBuilderKt.arrayOfUninitializedElements(n2), null, new int[n2], new int[MapBuilder.Companion.computeHashSize(n2)], 2, 0);
    }

    @NotNull
    public final Map<K, V> build() {
        Map map;
        this.checkIsMutable$kotlin_stdlib();
        this.isReadOnly = true;
        if (this.size() > 0) {
            map = this;
        } else {
            MapBuilder mapBuilder = Empty;
            Intrinsics.checkNotNull(mapBuilder);
            map = mapBuilder;
        }
        return map;
    }

    private final Object writeReplace() {
        if (!this.isReadOnly) {
            throw new NotSerializableException("The map cannot be serialized while it is being built.");
        }
        return new SerializedMap(this);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.findKey(object) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.findValue(object) >= 0;
    }

    @Override
    @Nullable
    public V get(Object object) {
        int n2 = this.findKey(object);
        if (n2 < 0) {
            return null;
        }
        Intrinsics.checkNotNull(this.valuesArray);
        return this.valuesArray[n2];
    }

    @Override
    @Nullable
    public V put(K k2, V v2) {
        this.checkIsMutable$kotlin_stdlib();
        int n2 = this.addKey$kotlin_stdlib(k2);
        V[] VArray = this.allocateValuesArray();
        if (n2 < 0) {
            V v3 = VArray[-n2 - 1];
            VArray[-n2 - 1] = v2;
            return v3;
        }
        VArray[n2] = v2;
        return null;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        Intrinsics.checkNotNullParameter(map, "");
        this.checkIsMutable$kotlin_stdlib();
        this.putAllEntries((Collection)map.entrySet());
    }

    @Override
    @Nullable
    public V remove(Object object) {
        this.checkIsMutable$kotlin_stdlib();
        int n2 = this.findKey(object);
        if (n2 < 0) {
            return null;
        }
        Intrinsics.checkNotNull(this.valuesArray);
        V v2 = this.valuesArray[n2];
        this.removeEntryAt(n2);
        return v2;
    }

    @Override
    public void clear() {
        this.checkIsMutable$kotlin_stdlib();
        int n2 = 0;
        int n3 = this.length - 1;
        if (n2 <= n3) {
            while (true) {
                int n4;
                if ((n4 = this.presenceArray[n2]) >= 0) {
                    this.hashArray[n4] = 0;
                    this.presenceArray[n2] = -1;
                }
                if (n2 == n3) break;
                ++n2;
            }
        }
        ListBuilderKt.resetRange(this.keysArray, 0, this.length);
        if (this.valuesArray != null) {
            ListBuilderKt.resetRange(this.valuesArray, 0, this.length);
        }
        this.size = 0;
        this.length = 0;
        this.registerModification();
    }

    @NotNull
    public Set<K> getKeys() {
        Set set2;
        MapBuilderKeys<K> mapBuilderKeys = this.keysView;
        if (mapBuilderKeys == null) {
            MapBuilderKeys mapBuilderKeys2 = new MapBuilderKeys(this);
            this.keysView = mapBuilderKeys2;
            set2 = mapBuilderKeys2;
        } else {
            set2 = mapBuilderKeys;
        }
        return set2;
    }

    @NotNull
    public Collection<V> getValues() {
        Collection collection;
        MapBuilderValues<V> mapBuilderValues = this.valuesView;
        if (mapBuilderValues == null) {
            MapBuilderValues mapBuilderValues2 = new MapBuilderValues(this);
            this.valuesView = mapBuilderValues2;
            collection = mapBuilderValues2;
        } else {
            collection = mapBuilderValues;
        }
        return collection;
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        MapBuilderEntries<K, V> mapBuilderEntries = this.entriesView;
        if (mapBuilderEntries == null) {
            MapBuilderEntries mapBuilderEntries2 = new MapBuilderEntries(this);
            this.entriesView = mapBuilderEntries2;
            return mapBuilderEntries2;
        }
        return mapBuilderEntries;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return object == this || object instanceof Map && this.contentEquals((Map)object);
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        EntriesItr<K, V> entriesItr = this.entriesIterator$kotlin_stdlib();
        while (entriesItr.hasNext()) {
            n2 += entriesItr.nextHashCode$kotlin_stdlib();
        }
        return n2;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(2 + this.size() * 3);
        stringBuilder.append("{");
        int n2 = 0;
        EntriesItr<K, V> entriesItr = this.entriesIterator$kotlin_stdlib();
        while (entriesItr.hasNext()) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            entriesItr.nextAppendString(stringBuilder);
            ++n2;
        }
        stringBuilder.append("}");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    public final int getCapacity$kotlin_stdlib() {
        return this.keysArray.length;
    }

    private final int getHashSize() {
        return this.hashArray.length;
    }

    private final void registerModification() {
        ++this.modCount;
    }

    public final void checkIsMutable$kotlin_stdlib() {
        if (this.isReadOnly) {
            throw new UnsupportedOperationException();
        }
    }

    private final void ensureExtraCapacity(int n2) {
        if (this.shouldCompact(n2)) {
            this.compact(true);
        } else {
            this.ensureCapacity(this.length + n2);
        }
    }

    private final boolean shouldCompact(int n2) {
        int n3 = this.getCapacity$kotlin_stdlib() - this.length;
        int n4 = this.length - this.size();
        return n3 < n2 && n4 + n3 >= n2 && n4 >= this.getCapacity$kotlin_stdlib() / 4;
    }

    private final void ensureCapacity(int n2) {
        if (n2 < 0) {
            throw new OutOfMemoryError();
        }
        if (n2 > this.getCapacity$kotlin_stdlib()) {
            int n3 = AbstractList.Companion.newCapacity$kotlin_stdlib(this.getCapacity$kotlin_stdlib(), n2);
            this.keysArray = ListBuilderKt.copyOfUninitializedElements(this.keysArray, n3);
            this.valuesArray = this.valuesArray != null ? ListBuilderKt.copyOfUninitializedElements(this.valuesArray, n3) : null;
            int[] nArray = Arrays.copyOf(this.presenceArray, n3);
            Intrinsics.checkNotNullExpressionValue(nArray, "");
            this.presenceArray = nArray;
            int n4 = MapBuilder.Companion.computeHashSize(n3);
            if (n4 > this.getHashSize()) {
                this.rehash(n4);
            }
        }
    }

    private final V[] allocateValuesArray() {
        V[] VArray = this.valuesArray;
        if (VArray != null) {
            return VArray;
        }
        E[] EArray = ListBuilderKt.arrayOfUninitializedElements(this.getCapacity$kotlin_stdlib());
        this.valuesArray = EArray;
        return EArray;
    }

    private final int hash(K k2) {
        K k3 = k2;
        return (k3 != null ? k3.hashCode() : 0) * -1640531527 >>> this.hashShift;
    }

    private final void compact(boolean bl) {
        int n2 = 0;
        V[] VArray = this.valuesArray;
        for (int i2 = 0; i2 < this.length; ++i2) {
            int n3 = this.presenceArray[i2];
            if (n3 < 0) continue;
            this.keysArray[n2] = this.keysArray[i2];
            if (VArray != null) {
                VArray[n2] = VArray[i2];
            }
            if (bl) {
                this.presenceArray[n2] = n3;
                this.hashArray[n3] = n2 + 1;
            }
            ++n2;
        }
        ListBuilderKt.resetRange(this.keysArray, n2, this.length);
        if (VArray != null) {
            ListBuilderKt.resetRange(VArray, n2, this.length);
        }
        this.length = n2;
    }

    private final void rehash(int n2) {
        this.registerModification();
        if (this.length > this.size()) {
            this.compact(false);
        }
        this.hashArray = new int[n2];
        this.hashShift = MapBuilder.Companion.computeShift(n2);
        int n3 = 0;
        while (n3 < this.length) {
            if (this.putRehash(n3++)) continue;
            throw new IllegalStateException("This cannot happen with fixed magic multiplier and grow-only hash array. Have object hashCodes changed?");
        }
    }

    private final boolean putRehash(int n2) {
        int n3 = this.hash(this.keysArray[n2]);
        int n4 = this.maxProbeDistance;
        while (true) {
            int n5;
            if ((n5 = this.hashArray[n3]) == 0) {
                this.hashArray[n3] = n2 + 1;
                this.presenceArray[n2] = n3;
                return true;
            }
            if (--n4 < 0) {
                return false;
            }
            if (n3-- != 0) continue;
            n3 = this.getHashSize() - 1;
        }
    }

    private final int findKey(K k2) {
        int n2 = this.hash(k2);
        int n3 = this.maxProbeDistance;
        int n4;
        while ((n4 = this.hashArray[n2]) != 0) {
            if (n4 > 0 && Intrinsics.areEqual(this.keysArray[n4 - 1], k2)) {
                return n4 - 1;
            }
            if (--n3 < 0) {
                return -1;
            }
            if (n2-- != 0) continue;
            n2 = this.getHashSize() - 1;
        }
        return -1;
    }

    private final int findValue(V v2) {
        int n2 = this.length;
        while (--n2 >= 0) {
            if (this.presenceArray[n2] < 0) continue;
            Intrinsics.checkNotNull(this.valuesArray);
            if (!Intrinsics.areEqual(this.valuesArray[n2], v2)) continue;
            return n2;
        }
        return -1;
    }

    public final int addKey$kotlin_stdlib(K k2) {
        this.checkIsMutable$kotlin_stdlib();
        block0: while (true) {
            int n2 = this.hash(k2);
            int n3 = RangesKt.coerceAtMost(this.maxProbeDistance * 2, this.getHashSize() / 2);
            int n4 = 0;
            while (true) {
                int n5;
                if ((n5 = this.hashArray[n2]) <= 0) {
                    if (this.length >= this.getCapacity$kotlin_stdlib()) {
                        this.ensureExtraCapacity(1);
                        continue block0;
                    }
                    int n6 = this.length;
                    this.length = n6 + 1;
                    int n7 = n6;
                    this.keysArray[n7] = k2;
                    this.presenceArray[n7] = n2;
                    this.hashArray[n2] = n7 + 1;
                    n6 = this.size();
                    this.size = n6 + 1;
                    this.registerModification();
                    if (n4 > this.maxProbeDistance) {
                        this.maxProbeDistance = n4;
                    }
                    return n7;
                }
                if (Intrinsics.areEqual(this.keysArray[n5 - 1], k2)) {
                    return -n5;
                }
                if (++n4 > n3) {
                    this.rehash(this.getHashSize() * 2);
                    continue block0;
                }
                if (n2-- != 0) continue;
                n2 = this.getHashSize() - 1;
            }
            break;
        }
    }

    public final boolean removeKey$kotlin_stdlib(K k2) {
        this.checkIsMutable$kotlin_stdlib();
        int n2 = this.findKey(k2);
        if (n2 < 0) {
            return false;
        }
        this.removeEntryAt(n2);
        return true;
    }

    private final void removeEntryAt(int n2) {
        ListBuilderKt.resetAt(this.keysArray, n2);
        if (this.valuesArray != null) {
            ListBuilderKt.resetAt(this.valuesArray, n2);
        }
        this.removeHashAt(this.presenceArray[n2]);
        this.presenceArray[n2] = -1;
        int n3 = this.size();
        this.size = n3 + -1;
        this.registerModification();
    }

    private final void removeHashAt(int n2) {
        int n3 = n2;
        int n4 = n2;
        int n5 = 0;
        int n6 = RangesKt.coerceAtMost(this.maxProbeDistance * 2, this.getHashSize() / 2);
        do {
            if (n3-- == 0) {
                n3 = this.getHashSize() - 1;
            }
            if (++n5 > this.maxProbeDistance) {
                this.hashArray[n4] = 0;
                return;
            }
            int n7 = this.hashArray[n3];
            if (n7 == 0) {
                this.hashArray[n4] = 0;
                return;
            }
            if (n7 < 0) {
                this.hashArray[n4] = -1;
                n4 = n3;
                n5 = 0;
                continue;
            }
            int n8 = this.hash(this.keysArray[n7 - 1]);
            if ((n8 - n3 & this.getHashSize() - 1) < n5) continue;
            this.hashArray[n4] = n7;
            this.presenceArray[n7 - 1] = n4;
            n4 = n3;
            n5 = 0;
        } while (--n6 >= 0);
        this.hashArray[n4] = -1;
    }

    public final boolean containsEntry$kotlin_stdlib(@NotNull Map.Entry<? extends K, ? extends V> entry) {
        Intrinsics.checkNotNullParameter(entry, "");
        int n2 = this.findKey(entry.getKey());
        if (n2 < 0) {
            return false;
        }
        Intrinsics.checkNotNull(this.valuesArray);
        return Intrinsics.areEqual(this.valuesArray[n2], entry.getValue());
    }

    private final boolean contentEquals(Map<?, ?> map) {
        return this.size() == map.size() && this.containsAllEntries$kotlin_stdlib((Collection)map.entrySet());
    }

    public final boolean containsAllEntries$kotlin_stdlib(@NotNull Collection<?> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        for (Object obj : collection) {
            try {
                if (obj != null && this.containsEntry$kotlin_stdlib((Map.Entry)obj)) continue;
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return true;
    }

    private final boolean putEntry(Map.Entry<? extends K, ? extends V> entry) {
        int n2 = this.addKey$kotlin_stdlib(entry.getKey());
        V[] VArray = this.allocateValuesArray();
        if (n2 >= 0) {
            VArray[n2] = entry.getValue();
            return true;
        }
        V v2 = VArray[-n2 - 1];
        if (!Intrinsics.areEqual(entry.getValue(), v2)) {
            VArray[-n2 - 1] = entry.getValue();
            return true;
        }
        return false;
    }

    private final boolean putAllEntries(Collection<? extends Map.Entry<? extends K, ? extends V>> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        this.ensureExtraCapacity(collection.size());
        Iterator<Map.Entry<K, V>> iterator2 = collection.iterator();
        boolean bl = false;
        while (iterator2.hasNext()) {
            if (!this.putEntry(iterator2.next())) continue;
            bl = true;
        }
        return bl;
    }

    public final boolean removeEntry$kotlin_stdlib(@NotNull Map.Entry<? extends K, ? extends V> entry) {
        Intrinsics.checkNotNullParameter(entry, "");
        this.checkIsMutable$kotlin_stdlib();
        int n2 = this.findKey(entry.getKey());
        if (n2 < 0) {
            return false;
        }
        Intrinsics.checkNotNull(this.valuesArray);
        if (!Intrinsics.areEqual(this.valuesArray[n2], entry.getValue())) {
            return false;
        }
        this.removeEntryAt(n2);
        return true;
    }

    public final boolean removeValue$kotlin_stdlib(V v2) {
        this.checkIsMutable$kotlin_stdlib();
        int n2 = this.findValue(v2);
        if (n2 < 0) {
            return false;
        }
        this.removeEntryAt(n2);
        return true;
    }

    @NotNull
    public final KeysItr<K, V> keysIterator$kotlin_stdlib() {
        return new KeysItr(this);
    }

    @NotNull
    public final ValuesItr<K, V> valuesIterator$kotlin_stdlib() {
        return new ValuesItr(this);
    }

    @NotNull
    public final EntriesItr<K, V> entriesIterator$kotlin_stdlib() {
        return new EntriesItr(this);
    }

    @Override
    public final int size() {
        return this.getSize();
    }

    @Override
    public final Set<K> keySet() {
        return this.getKeys();
    }

    @Override
    public final Collection<V> values() {
        return this.getValues();
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.getEntries();
    }

    static {
        MapBuilder mapBuilder;
        Companion = new Companion(null);
        MapBuilder mapBuilder2 = mapBuilder = new MapBuilder(0);
        boolean bl = false;
        mapBuilder2.isReadOnly = true;
        Empty = mapBuilder;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0007\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lkotlin/collections/builders/MapBuilder$Companion;", "", "<init>", "()V", "MAGIC", "", "INITIAL_CAPACITY", "INITIAL_MAX_PROBE_DISTANCE", "TOMBSTONE", "Empty", "Lkotlin/collections/builders/MapBuilder;", "", "getEmpty$kotlin_stdlib", "()Lkotlin/collections/builders/MapBuilder;", "computeHashSize", "capacity", "computeShift", "hashSize", "kotlin-stdlib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapBuilder getEmpty$kotlin_stdlib() {
            return Empty;
        }

        private final int computeHashSize(int n2) {
            return Integer.highestOneBit(RangesKt.coerceAtLeast(n2, 1) * 3);
        }

        private final int computeShift(int n2) {
            return Integer.numberOfLeadingZeros(n2) + 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0010'\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00032\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00050\u0004B\u001b\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000bH\u0096\u0002J\r\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0012\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013\u00a8\u0006\u0014"}, d2={"Lkotlin/collections/builders/MapBuilder$EntriesItr;", "K", "V", "Lkotlin/collections/builders/MapBuilder$Itr;", "", "", "map", "Lkotlin/collections/builders/MapBuilder;", "<init>", "(Lkotlin/collections/builders/MapBuilder;)V", "next", "Lkotlin/collections/builders/MapBuilder$EntryRef;", "nextHashCode", "", "nextHashCode$kotlin_stdlib", "nextAppendString", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "kotlin-stdlib"})
    public static final class EntriesItr<K, V>
    extends Itr<K, V>
    implements Iterator<Map.Entry<K, V>>,
    KMutableIterator {
        public EntriesItr(@NotNull MapBuilder<K, V> mapBuilder) {
            Intrinsics.checkNotNullParameter(mapBuilder, "");
            super(mapBuilder);
        }

        @Override
        @NotNull
        public EntryRef<K, V> next() {
            this.checkForComodification$kotlin_stdlib();
            if (this.getIndex$kotlin_stdlib() >= this.getMap$kotlin_stdlib().length) {
                throw new NoSuchElementException();
            }
            int n2 = this.getIndex$kotlin_stdlib();
            this.setIndex$kotlin_stdlib(n2 + 1);
            this.setLastIndex$kotlin_stdlib(n2);
            EntryRef entryRef = new EntryRef(this.getMap$kotlin_stdlib(), this.getLastIndex$kotlin_stdlib());
            this.initNext$kotlin_stdlib();
            return entryRef;
        }

        public final int nextHashCode$kotlin_stdlib() {
            if (this.getIndex$kotlin_stdlib() >= this.getMap$kotlin_stdlib().length) {
                throw new NoSuchElementException();
            }
            int n2 = this.getIndex$kotlin_stdlib();
            this.setIndex$kotlin_stdlib(n2 + 1);
            this.setLastIndex$kotlin_stdlib(n2);
            Object object = this.getMap$kotlin_stdlib().keysArray[this.getLastIndex$kotlin_stdlib()];
            int n3 = object != null ? object.hashCode() : 0;
            Object[] objectArray = this.getMap$kotlin_stdlib().valuesArray;
            Intrinsics.checkNotNull(objectArray);
            Object object2 = objectArray[this.getLastIndex$kotlin_stdlib()];
            n2 = n3 ^ (object2 != null ? object2.hashCode() : 0);
            this.initNext$kotlin_stdlib();
            return n2;
        }

        public final void nextAppendString(@NotNull StringBuilder stringBuilder) {
            Intrinsics.checkNotNullParameter(stringBuilder, "");
            if (this.getIndex$kotlin_stdlib() >= this.getMap$kotlin_stdlib().length) {
                throw new NoSuchElementException();
            }
            int n2 = this.getIndex$kotlin_stdlib();
            this.setIndex$kotlin_stdlib(n2 + 1);
            this.setLastIndex$kotlin_stdlib(n2);
            Object object = this.getMap$kotlin_stdlib().keysArray[this.getLastIndex$kotlin_stdlib()];
            StringBuilder stringBuilder2 = object == this.getMap$kotlin_stdlib() ? stringBuilder.append("(this Map)") : stringBuilder.append(object);
            stringBuilder.append('=');
            Object[] objectArray = this.getMap$kotlin_stdlib().valuesArray;
            Intrinsics.checkNotNull(objectArray);
            Object object2 = objectArray[this.getLastIndex$kotlin_stdlib()];
            StringBuilder stringBuilder3 = object2 == this.getMap$kotlin_stdlib() ? stringBuilder.append("(this Map)") : stringBuilder.append(object2);
            this.initNext$kotlin_stdlib();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010'\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B#\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u0010\u001a\u00028\u00032\u0006\u0010\u0011\u001a\u00028\u0003H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00028\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00028\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001c"}, d2={"Lkotlin/collections/builders/MapBuilder$EntryRef;", "K", "V", "", "map", "Lkotlin/collections/builders/MapBuilder;", "index", "", "<init>", "(Lkotlin/collections/builders/MapBuilder;I)V", "expectedModCount", "key", "getKey", "()Ljava/lang/Object;", "value", "getValue", "setValue", "newValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "equals", "", "other", "", "hashCode", "toString", "", "checkForComodification", "", "kotlin-stdlib"})
    public static final class EntryRef<K, V>
    implements Map.Entry<K, V>,
    KMutableMap.Entry {
        @NotNull
        private final MapBuilder<K, V> map;
        private final int index;
        private final int expectedModCount;

        public EntryRef(@NotNull MapBuilder<K, V> mapBuilder, int n2) {
            Intrinsics.checkNotNullParameter(mapBuilder, "");
            this.map = mapBuilder;
            this.index = n2;
            this.expectedModCount = ((MapBuilder)this.map).modCount;
        }

        @Override
        public K getKey() {
            this.checkForComodification();
            return (K)((MapBuilder)this.map).keysArray[this.index];
        }

        @Override
        public V getValue() {
            this.checkForComodification();
            Object[] objectArray = ((MapBuilder)this.map).valuesArray;
            Intrinsics.checkNotNull(objectArray);
            return (V)objectArray[this.index];
        }

        @Override
        public V setValue(V v2) {
            this.checkForComodification();
            this.map.checkIsMutable$kotlin_stdlib();
            Object[] objectArray = ((MapBuilder)this.map).allocateValuesArray();
            Object object = objectArray[this.index];
            objectArray[this.index] = v2;
            return (V)object;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return object instanceof Map.Entry && Intrinsics.areEqual(((Map.Entry)object).getKey(), this.getKey()) && Intrinsics.areEqual(((Map.Entry)object).getValue(), this.getValue());
        }

        @Override
        public int hashCode() {
            K k2 = this.getKey();
            V v2 = this.getValue();
            return (k2 != null ? k2.hashCode() : 0) ^ (v2 != null ? v2.hashCode() : 0);
        }

        @NotNull
        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }

        private final void checkForComodification() {
            if (((MapBuilder)this.map).modCount != this.expectedModCount) {
                throw new ConcurrentModificationException("The backing map has been modified after this entry was obtained.");
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0010\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u00020\u0003B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0015J\r\u0010\u001a\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001bR \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lkotlin/collections/builders/MapBuilder$Itr;", "K", "V", "", "map", "Lkotlin/collections/builders/MapBuilder;", "<init>", "(Lkotlin/collections/builders/MapBuilder;)V", "getMap$kotlin_stdlib", "()Lkotlin/collections/builders/MapBuilder;", "index", "", "getIndex$kotlin_stdlib", "()I", "setIndex$kotlin_stdlib", "(I)V", "lastIndex", "getLastIndex$kotlin_stdlib", "setLastIndex$kotlin_stdlib", "expectedModCount", "initNext", "", "initNext$kotlin_stdlib", "hasNext", "", "remove", "checkForComodification", "checkForComodification$kotlin_stdlib", "kotlin-stdlib"})
    @SourceDebugExtension(value={"SMAP\nMapBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapBuilder.kt\nkotlin/collections/builders/MapBuilder$Itr\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,747:1\n1#2:748\n*E\n"})
    public static class Itr<K, V> {
        @NotNull
        private final MapBuilder<K, V> map;
        private int index;
        private int lastIndex;
        private int expectedModCount;

        public Itr(@NotNull MapBuilder<K, V> mapBuilder) {
            Intrinsics.checkNotNullParameter(mapBuilder, "");
            this.map = mapBuilder;
            this.lastIndex = -1;
            this.expectedModCount = ((MapBuilder)this.map).modCount;
            this.initNext$kotlin_stdlib();
        }

        @NotNull
        public final MapBuilder<K, V> getMap$kotlin_stdlib() {
            return this.map;
        }

        public final int getIndex$kotlin_stdlib() {
            return this.index;
        }

        public final void setIndex$kotlin_stdlib(int n2) {
            this.index = n2;
        }

        public final int getLastIndex$kotlin_stdlib() {
            return this.lastIndex;
        }

        public final void setLastIndex$kotlin_stdlib(int n2) {
            this.lastIndex = n2;
        }

        public final void initNext$kotlin_stdlib() {
            while (this.index < ((MapBuilder)this.map).length && ((MapBuilder)this.map).presenceArray[this.index] < 0) {
                int n2 = this.index;
                this.index = n2 + 1;
            }
        }

        public final boolean hasNext() {
            return this.index < ((MapBuilder)this.map).length;
        }

        public final void remove() {
            this.checkForComodification$kotlin_stdlib();
            if (!(this.lastIndex != -1)) {
                boolean bl = false;
                String string = "Call next() before removing element from the iterator.";
                throw new IllegalStateException(string.toString());
            }
            this.map.checkIsMutable$kotlin_stdlib();
            ((MapBuilder)this.map).removeEntryAt(this.lastIndex);
            this.lastIndex = -1;
            this.expectedModCount = ((MapBuilder)this.map).modCount;
        }

        public final void checkForComodification$kotlin_stdlib() {
            if (((MapBuilder)this.map).modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u001b\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lkotlin/collections/builders/MapBuilder$KeysItr;", "K", "V", "Lkotlin/collections/builders/MapBuilder$Itr;", "", "map", "Lkotlin/collections/builders/MapBuilder;", "<init>", "(Lkotlin/collections/builders/MapBuilder;)V", "next", "()Ljava/lang/Object;", "kotlin-stdlib"})
    public static final class KeysItr<K, V>
    extends Itr<K, V>
    implements Iterator<K>,
    KMutableIterator {
        public KeysItr(@NotNull MapBuilder<K, V> mapBuilder) {
            Intrinsics.checkNotNullParameter(mapBuilder, "");
            super(mapBuilder);
        }

        @Override
        public K next() {
            this.checkForComodification$kotlin_stdlib();
            if (this.getIndex$kotlin_stdlib() >= this.getMap$kotlin_stdlib().length) {
                throw new NoSuchElementException();
            }
            int n2 = this.getIndex$kotlin_stdlib();
            this.setIndex$kotlin_stdlib(n2 + 1);
            this.setLastIndex$kotlin_stdlib(n2);
            Object object = this.getMap$kotlin_stdlib().keysArray[this.getLastIndex$kotlin_stdlib()];
            this.initNext$kotlin_stdlib();
            return (K)object;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004B\u001b\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00028\u0003H\u0096\u0002\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lkotlin/collections/builders/MapBuilder$ValuesItr;", "K", "V", "Lkotlin/collections/builders/MapBuilder$Itr;", "", "map", "Lkotlin/collections/builders/MapBuilder;", "<init>", "(Lkotlin/collections/builders/MapBuilder;)V", "next", "()Ljava/lang/Object;", "kotlin-stdlib"})
    public static final class ValuesItr<K, V>
    extends Itr<K, V>
    implements Iterator<V>,
    KMutableIterator {
        public ValuesItr(@NotNull MapBuilder<K, V> mapBuilder) {
            Intrinsics.checkNotNullParameter(mapBuilder, "");
            super(mapBuilder);
        }

        @Override
        public V next() {
            this.checkForComodification$kotlin_stdlib();
            if (this.getIndex$kotlin_stdlib() >= this.getMap$kotlin_stdlib().length) {
                throw new NoSuchElementException();
            }
            int n2 = this.getIndex$kotlin_stdlib();
            this.setIndex$kotlin_stdlib(n2 + 1);
            this.setLastIndex$kotlin_stdlib(n2);
            Object[] objectArray = this.getMap$kotlin_stdlib().valuesArray;
            Intrinsics.checkNotNull(objectArray);
            Object object = objectArray[this.getLastIndex$kotlin_stdlib()];
            this.initNext$kotlin_stdlib();
            return (V)object;
        }
    }
}

