/*
 * Decompiled with CFR 0.152.
 */
package kotlin.coroutines.jvm.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.coroutines.jvm.internal.BaseContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugMetadata;
import kotlin.coroutines.jvm.internal.ModuleNameRetriever;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0013\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0001\u00a2\u0006\u0002\b\u0003\u001a\u000e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0002H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0002H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u001a\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r*\u00020\u0002H\u0001\u00a2\u0006\u0002\u0010\u000f\"\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"getStackTraceElementImpl", "Ljava/lang/StackTraceElement;", "Lkotlin/coroutines/jvm/internal/BaseContinuationImpl;", "getStackTraceElement", "getDebugMetadataAnnotation", "Lkotlin/coroutines/jvm/internal/DebugMetadata;", "getLabel", "", "checkDebugMetadataVersion", "", "expected", "actual", "getSpilledVariableFieldMapping", "", "", "(Lkotlin/coroutines/jvm/internal/BaseContinuationImpl;)[Ljava/lang/String;", "COROUTINES_DEBUG_METADATA_VERSION", "kotlin-stdlib"})
@SourceDebugExtension(value={"SMAP\nDebugMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugMetadata.kt\nkotlin/coroutines/jvm/internal/DebugMetadataKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,134:1\n37#2:135\n36#2,3:136\n*S KotlinDebug\n*F\n+ 1 DebugMetadata.kt\nkotlin/coroutines/jvm/internal/DebugMetadataKt\n*L\n131#1:135\n131#1:136,3\n*E\n"})
public final class DebugMetadataKt {
    private static final int COROUTINES_DEBUG_METADATA_VERSION = 1;

    @SinceKotlin(version="1.3")
    @JvmName(name="getStackTraceElement")
    @Nullable
    public static final StackTraceElement getStackTraceElement(@NotNull BaseContinuationImpl baseContinuationImpl) {
        Intrinsics.checkNotNullParameter(baseContinuationImpl, "");
        DebugMetadata debugMetadata = DebugMetadataKt.getDebugMetadataAnnotation(baseContinuationImpl);
        if (debugMetadata == null) {
            return null;
        }
        DebugMetadata debugMetadata2 = debugMetadata;
        DebugMetadataKt.checkDebugMetadataVersion(1, debugMetadata2.v());
        int n2 = DebugMetadataKt.getLabel(baseContinuationImpl);
        int n3 = n2 < 0 ? -1 : debugMetadata2.l()[n2];
        String string = ModuleNameRetriever.INSTANCE.getModuleName(baseContinuationImpl);
        String string2 = string == null ? debugMetadata2.c() : string + '/' + debugMetadata2.c();
        return new StackTraceElement(string2, debugMetadata2.m(), debugMetadata2.f(), n3);
    }

    private static final DebugMetadata getDebugMetadataAnnotation(BaseContinuationImpl baseContinuationImpl) {
        return baseContinuationImpl.getClass().getAnnotation(DebugMetadata.class);
    }

    private static final int getLabel(BaseContinuationImpl baseContinuationImpl) {
        int n2;
        try {
            Field field = baseContinuationImpl.getClass().getDeclaredField("label");
            field.setAccessible(true);
            Object object = field.get(baseContinuationImpl);
            Integer n3 = object instanceof Integer ? (Integer)object : null;
            n2 = (n3 != null ? n3 : 0) - 1;
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    private static final void checkDebugMetadataVersion(int n2, int n3) {
        if (n3 > n2) {
            throw new IllegalStateException(("Debug metadata version mismatch. Expected: " + n2 + ", got " + n3 + ". Please update the Kotlin standard library.").toString());
        }
    }

    @SinceKotlin(version="1.3")
    @JvmName(name="getSpilledVariableFieldMapping")
    @Nullable
    public static final String[] getSpilledVariableFieldMapping(@NotNull BaseContinuationImpl baseContinuationImpl) {
        int n2;
        Intrinsics.checkNotNullParameter(baseContinuationImpl, "");
        DebugMetadata debugMetadata = DebugMetadataKt.getDebugMetadataAnnotation(baseContinuationImpl);
        if (debugMetadata == null) {
            return null;
        }
        DebugMetadata debugMetadata2 = debugMetadata;
        DebugMetadataKt.checkDebugMetadataVersion(1, debugMetadata2.v());
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = DebugMetadataKt.getLabel(baseContinuationImpl);
        Object object = debugMetadata2.i();
        int n4 = ((int[])object).length;
        for (n2 = 0; n2 < n4; ++n2) {
            int n5 = n2;
            int n6 = object[n2];
            if (n6 != n3) continue;
            arrayList.add(debugMetadata2.s()[n5]);
            arrayList.add(debugMetadata2.n()[n5]);
        }
        object = arrayList;
        n2 = 0;
        Object object2 = object;
        return object2.toArray(new String[0]);
    }
}

