/*
 * Decompiled with CFR 0.152.
 */
package kotlin.uuid;

import java.io.Serializable;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.SinceKotlin;
import kotlin.ULong;
import kotlin.internal.InlineOnly;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import kotlin.uuid.ExperimentalUuidApi;
import kotlin.uuid.UuidKt;
import kotlin.uuid.UuidKt__UuidKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 #2\u00060\u0001j\u0002`\u0002:\u0001#B\u0019\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\\\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f26\u0010\u0010\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0003\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010\u0014J\\\u0010\u0015\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f26\u0010\u0010\u001a2\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0003\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001fH\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u0005\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\t\u001a\u0004\b\r\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006$"}, d2={"Lkotlin/uuid/Uuid;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "mostSignificantBits", "", "leastSignificantBits", "<init>", "(JJ)V", "getMostSignificantBits$annotations", "()V", "getMostSignificantBits", "()J", "getLeastSignificantBits$annotations", "getLeastSignificantBits", "toLongs", "T", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "toULongs", "Lkotlin/ULong;", "toString", "", "toHexString", "toByteArray", "", "equals", "", "other", "", "hashCode", "", "writeReplace", "Companion", "kotlin-stdlib"})
@SinceKotlin(version="2.0")
@ExperimentalUuidApi
public final class Uuid
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long mostSignificantBits;
    private final long leastSignificantBits;
    @NotNull
    private static final Uuid NIL = new Uuid(0L, 0L);
    public static final int SIZE_BYTES = 16;
    public static final int SIZE_BITS = 128;
    @NotNull
    private static final Comparator<Uuid> LEXICAL_ORDER = Uuid::LEXICAL_ORDER$lambda$0;

    public Uuid(long l2, long l3) {
        this.mostSignificantBits = l2;
        this.leastSignificantBits = l3;
    }

    public final long getMostSignificantBits() {
        return this.mostSignificantBits;
    }

    @PublishedApi
    public static /* synthetic */ void getMostSignificantBits$annotations() {
    }

    public final long getLeastSignificantBits() {
        return this.leastSignificantBits;
    }

    @PublishedApi
    public static /* synthetic */ void getLeastSignificantBits$annotations() {
    }

    @InlineOnly
    private final <T> T toLongs(Function2<? super Long, ? super Long, ? extends T> function2) {
        Intrinsics.checkNotNullParameter(function2, "");
        return function2.invoke(this.getMostSignificantBits(), this.getLeastSignificantBits());
    }

    @InlineOnly
    private final <T> T toULongs(Function2<? super ULong, ? super ULong, ? extends T> function2) {
        Intrinsics.checkNotNullParameter(function2, "");
        return function2.invoke(ULong.box-impl(ULong.constructor-impl(this.getMostSignificantBits())), ULong.box-impl(ULong.constructor-impl(this.getLeastSignificantBits())));
    }

    @NotNull
    public String toString() {
        byte[] byArray = new byte[36];
        UuidKt__UuidKt.access$formatBytesInto(this.leastSignificantBits, byArray, 24, 6);
        byArray[23] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.leastSignificantBits >>> 48, byArray, 19, 2);
        byArray[18] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.mostSignificantBits, byArray, 14, 2);
        byArray[13] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.mostSignificantBits >>> 16, byArray, 9, 2);
        byArray[8] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.mostSignificantBits >>> 32, byArray, 0, 4);
        return StringsKt.decodeToString(byArray);
    }

    @NotNull
    public final String toHexString() {
        byte[] byArray = new byte[32];
        UuidKt__UuidKt.access$formatBytesInto(this.leastSignificantBits, byArray, 16, 8);
        UuidKt__UuidKt.access$formatBytesInto(this.mostSignificantBits, byArray, 0, 8);
        return StringsKt.decodeToString(byArray);
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = new byte[16];
        UuidKt__UuidKt.access$toByteArray(this.mostSignificantBits, byArray, 0);
        UuidKt__UuidKt.access$toByteArray(this.leastSignificantBits, byArray, 8);
        return byArray;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Uuid)) {
            return false;
        }
        return this.mostSignificantBits == ((Uuid)object).mostSignificantBits && this.leastSignificantBits == ((Uuid)object).leastSignificantBits;
    }

    public int hashCode() {
        long l2 = this.mostSignificantBits ^ this.leastSignificantBits;
        return (int)(l2 >> 32) ^ (int)l2;
    }

    private final Object writeReplace() {
        return UuidKt.serializedUuid(this);
    }

    private static final int LEXICAL_ORDER$lambda$0(Uuid uuid, Uuid uuid2) {
        Intrinsics.checkNotNullParameter(uuid, "");
        Intrinsics.checkNotNullParameter(uuid2, "");
        return uuid.mostSignificantBits != uuid2.mostSignificantBits ? Long.compareUnsigned(ULong.constructor-impl(uuid.mostSignificantBits), ULong.constructor-impl(uuid2.mostSignificantBits)) : Long.compareUnsigned(ULong.constructor-impl(uuid.leastSignificantBits), ULong.constructor-impl(uuid2.leastSignificantBits));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u001d\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0018J\u0006\u0010\u001b\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R#\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u001dj\b\u0012\u0004\u0012\u00020\u0005`\u001e\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lkotlin/uuid/Uuid$Companion;", "", "<init>", "()V", "NIL", "Lkotlin/uuid/Uuid;", "getNIL", "()Lkotlin/uuid/Uuid;", "SIZE_BYTES", "", "SIZE_BITS", "fromLongs", "mostSignificantBits", "", "leastSignificantBits", "fromULongs", "Lkotlin/ULong;", "fromULongs-eb3DHEI", "(JJ)Lkotlin/uuid/Uuid;", "fromByteArray", "byteArray", "", "parse", "uuidString", "", "parseHex", "hexString", "random", "LEXICAL_ORDER", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getLEXICAL_ORDER", "()Ljava/util/Comparator;", "Ljava/util/Comparator;", "kotlin-stdlib"})
    @SourceDebugExtension(value={"SMAP\nUuid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uuid.kt\nkotlin/uuid/Uuid$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,452:1\n1#2:453\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Uuid getNIL() {
            return NIL;
        }

        @NotNull
        public final Uuid fromLongs(long l2, long l3) {
            return l2 == 0L && l3 == 0L ? this.getNIL() : new Uuid(l2, l3);
        }

        @NotNull
        public final Uuid fromULongs-eb3DHEI(long l2, long l3) {
            return this.fromLongs(l2, l3);
        }

        @NotNull
        public final Uuid fromByteArray(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter(byArray, "");
            if (!(byArray.length == 16)) {
                boolean bl = false;
                String string = "Expected exactly 16 bytes";
                throw new IllegalArgumentException(string.toString());
            }
            return this.fromLongs(UuidKt__UuidKt.access$toLong(byArray, 0), UuidKt__UuidKt.access$toLong(byArray, 8));
        }

        @NotNull
        public final Uuid parse(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "");
            if (!(string.length() == 36)) {
                boolean bl = false;
                String string2 = "Expected a 36-char string in the standard uuid format.";
                throw new IllegalArgumentException(string2.toString());
            }
            long l2 = HexExtensionsKt.hexToLong$default(string, 0, 8, null, 4, null);
            UuidKt__UuidKt.access$checkHyphenAt(string, 8);
            long l3 = HexExtensionsKt.hexToLong$default(string, 9, 13, null, 4, null);
            UuidKt__UuidKt.access$checkHyphenAt(string, 13);
            long l4 = HexExtensionsKt.hexToLong$default(string, 14, 18, null, 4, null);
            UuidKt__UuidKt.access$checkHyphenAt(string, 18);
            long l5 = HexExtensionsKt.hexToLong$default(string, 19, 23, null, 4, null);
            UuidKt__UuidKt.access$checkHyphenAt(string, 23);
            long l6 = HexExtensionsKt.hexToLong$default(string, 24, 36, null, 4, null);
            long l7 = l2 << 32 | l3 << 16 | l4;
            long l8 = l5 << 48 | l6;
            return this.fromLongs(l7, l8);
        }

        @NotNull
        public final Uuid parseHex(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "");
            if (!(string.length() == 32)) {
                boolean bl = false;
                String string2 = "Expected a 32-char hexadecimal string.";
                throw new IllegalArgumentException(string2.toString());
            }
            long l2 = HexExtensionsKt.hexToLong$default(string, 0, 16, null, 4, null);
            long l3 = HexExtensionsKt.hexToLong$default(string, 16, 32, null, 4, null);
            return this.fromLongs(l2, l3);
        }

        @NotNull
        public final Uuid random() {
            return UuidKt.secureRandomUuid();
        }

        @NotNull
        public final Comparator<Uuid> getLEXICAL_ORDER() {
            return LEXICAL_ORDER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

