/*
 * Decompiled with CFR 0.152.
 */
package kotlin.uuid;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.uuid.ExperimentalUuidApi;
import kotlin.uuid.SecureRandomHolder;
import kotlin.uuid.Uuid;
import kotlin.uuid.UuidKt;
import kotlin.uuid.UuidSerialized;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=5, xi=49, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0001\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0001\u001a\r\u0010\u0005\u001a\u00020\u0001*\u00020\u0006H\u0087\b\u001a\r\u0010\u0007\u001a\u00020\u0006*\u00020\u0001H\u0087\b\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\tH\u0007\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u001a\u0014\u0010\f\u001a\u00020\t*\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\u001c\u0010\f\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\r\u0010\r\u001a\u00020\u000e*\u00020\u000eH\u0080\b\u00a8\u0006\u000f"}, d2={"secureRandomUuid", "Lkotlin/uuid/Uuid;", "serializedUuid", "", "uuid", "toKotlinUuid", "Ljava/util/UUID;", "toJavaUuid", "getUuid", "Ljava/nio/ByteBuffer;", "index", "", "putUuid", "reverseBytes", "", "kotlin-stdlib"}, xs="kotlin/uuid/UuidKt")
@SourceDebugExtension(value={"SMAP\nUuidJVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UuidJVM.kt\nkotlin/uuid/UuidKt__UuidJVMKt\n*L\n1#1,257:1\n257#1:258\n257#1:259\n257#1:260\n257#1:261\n257#1:262\n257#1:263\n257#1:264\n257#1:265\n*S KotlinDebug\n*F\n+ 1 UuidJVM.kt\nkotlin/uuid/UuidKt__UuidJVMKt\n*L\n119#1:258\n120#1:259\n164#1:260\n165#1:261\n204#1:262\n205#1:263\n251#1:264\n252#1:265\n*E\n"})
class UuidKt__UuidJVMKt {
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid secureRandomUuid() {
        byte[] byArray = new byte[16];
        SecureRandomHolder.INSTANCE.getInstance().nextBytes(byArray);
        return UuidKt.uuidFromRandomBytes(byArray);
    }

    @ExperimentalUuidApi
    @NotNull
    public static final Object serializedUuid(@NotNull Uuid uuid) {
        Intrinsics.checkNotNullParameter(uuid, "");
        return new UuidSerialized(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid toKotlinUuid(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter(uUID, "");
        boolean bl = false;
        return Uuid.Companion.fromLongs(uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final UUID toJavaUuid(@NotNull Uuid uuid) {
        Intrinsics.checkNotNullParameter(uuid, "");
        boolean bl = false;
        Uuid uuid2 = uuid;
        long l2 = uuid2.getLeastSignificantBits();
        long l3 = uuid2.getMostSignificantBits();
        boolean bl2 = false;
        return new UUID(l3, l2);
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid getUuid(@NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter(byteBuffer, "");
        if (byteBuffer.position() + 15 >= byteBuffer.limit()) {
            throw new BufferUnderflowException();
        }
        long l2 = byteBuffer.getLong();
        long l3 = byteBuffer.getLong();
        if (Intrinsics.areEqual(byteBuffer.order(), ByteOrder.LITTLE_ENDIAN)) {
            long l4 = l2;
            boolean bl = false;
            l2 = Long.reverseBytes(l4);
            l4 = l3;
            bl = false;
            l3 = Long.reverseBytes(l4);
        }
        return Uuid.Companion.fromLongs(l2, l3);
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid getUuid(@NotNull ByteBuffer byteBuffer, int n2) {
        Intrinsics.checkNotNullParameter(byteBuffer, "");
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + n2);
        }
        if (n2 + 15 >= byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("Not enough bytes to read a uuid at index: " + n2 + ", with limit: " + byteBuffer.limit() + ' ');
        }
        long l2 = byteBuffer.getLong(n2);
        long l3 = byteBuffer.getLong(n2 + 8);
        if (Intrinsics.areEqual(byteBuffer.order(), ByteOrder.LITTLE_ENDIAN)) {
            long l4 = l2;
            boolean bl = false;
            l2 = Long.reverseBytes(l4);
            l4 = l3;
            bl = false;
            l3 = Long.reverseBytes(l4);
        }
        return Uuid.Companion.fromLongs(l2, l3);
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final ByteBuffer putUuid(@NotNull ByteBuffer byteBuffer, @NotNull Uuid uuid) {
        ByteBuffer byteBuffer2;
        Intrinsics.checkNotNullParameter(byteBuffer, "");
        Intrinsics.checkNotNullParameter(uuid, "");
        Uuid uuid2 = uuid;
        long l2 = uuid2.getLeastSignificantBits();
        long l3 = uuid2.getMostSignificantBits();
        boolean bl = false;
        if (byteBuffer.position() + 15 >= byteBuffer.limit()) {
            throw new BufferOverflowException();
        }
        if (Intrinsics.areEqual(byteBuffer.order(), ByteOrder.BIG_ENDIAN)) {
            byteBuffer.putLong(l3);
            byteBuffer2 = byteBuffer.putLong(l2);
        } else {
            long l4 = l3;
            boolean bl2 = false;
            byteBuffer.putLong(Long.reverseBytes(l4));
            l4 = l2;
            bl2 = false;
            byteBuffer2 = byteBuffer.putLong(Long.reverseBytes(l4));
        }
        Intrinsics.checkNotNullExpressionValue(byteBuffer2, "");
        return byteBuffer2;
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final ByteBuffer putUuid(@NotNull ByteBuffer byteBuffer, int n2, @NotNull Uuid uuid) {
        ByteBuffer byteBuffer2;
        Intrinsics.checkNotNullParameter(byteBuffer, "");
        Intrinsics.checkNotNullParameter(uuid, "");
        Uuid uuid2 = uuid;
        long l2 = uuid2.getLeastSignificantBits();
        long l3 = uuid2.getMostSignificantBits();
        boolean bl = false;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + n2);
        }
        if (n2 + 15 >= byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("Not enough capacity to write a uuid at index: " + n2 + ", with limit: " + byteBuffer.limit() + ' ');
        }
        if (Intrinsics.areEqual(byteBuffer.order(), ByteOrder.BIG_ENDIAN)) {
            byteBuffer.putLong(n2, l3);
            byteBuffer2 = byteBuffer.putLong(n2 + 8, l2);
        } else {
            long l4 = l3;
            boolean bl2 = false;
            byteBuffer.putLong(n2, Long.reverseBytes(l4));
            l4 = l2;
            bl2 = false;
            byteBuffer2 = byteBuffer.putLong(n2 + 8, Long.reverseBytes(l4));
        }
        Intrinsics.checkNotNullExpressionValue(byteBuffer2, "");
        return byteBuffer2;
    }

    public static final long reverseBytes(long l2) {
        boolean bl = false;
        return Long.reverseBytes(l2);
    }
}

