/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.error.NoPropertyFileFoundException;
import org.koin.core.registry.PropertyRegistry;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0007H\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u000b"}, d2={"saveProperties", "", "Lorg/koin/core/registry/PropertyRegistry;", "properties", "Ljava/util/Properties;", "loadPropertiesFromFile", "fileName", "", "readDataFromFile", "content", "loadEnvironmentProperties", "koin-core"})
@SourceDebugExtension(value={"SMAP\nPropertyRegistryExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyRegistryExt.kt\norg/koin/core/registry/PropertyRegistryExtKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,58:1\n216#2,2:59\n*S KotlinDebug\n*F\n+ 1 PropertyRegistryExt.kt\norg/koin/core/registry/PropertyRegistryExtKt\n*L\n18#1:59,2\n*E\n"})
public final class PropertyRegistryExtKt {
    public static final void saveProperties(@NotNull PropertyRegistry propertyRegistry, @NotNull Properties properties) {
        Map map;
        Intrinsics.checkNotNullParameter(propertyRegistry, "");
        Intrinsics.checkNotNullParameter(properties, "");
        propertyRegistry.get_koin$koin_core().getLogger().debug("load " + properties.size() + " properties");
        Map map2 = MapsKt.toMap(properties);
        Intrinsics.checkNotNull(map2);
        Map map3 = map = map2;
        boolean bl = false;
        Iterator iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            boolean bl2 = false;
            String string = (String)entry2.getKey();
            String string2 = (String)entry2.getValue();
            propertyRegistry.saveProperty$koin_core(string, string2);
        }
    }

    public static final void loadPropertiesFromFile(@NotNull PropertyRegistry propertyRegistry, @NotNull String string) {
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter(propertyRegistry, "");
        Intrinsics.checkNotNullParameter(string, "");
        propertyRegistry.get_koin$koin_core().getLogger().debug("load properties from " + string);
        URL uRL = Koin.class.getResource(string);
        if (uRL != null) {
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes(uRL2);
            string3 = new String(byArray, charset);
        } else {
            string3 = string2 = null;
        }
        if (string2 == null) {
            throw new NoPropertyFileFoundException("No properties found for file '" + string + '\'');
        }
        propertyRegistry.get_koin$koin_core().getLogger().info("loaded properties from file:'" + string + '\'');
        Properties properties = PropertyRegistryExtKt.readDataFromFile(string2);
        PropertyRegistryExtKt.saveProperties(propertyRegistry, properties);
    }

    private static final Properties readDataFromFile(String string) {
        Properties properties = new Properties();
        String string2 = string;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "");
        properties.load(new ByteArrayInputStream(byArray));
        return properties;
    }

    public static final void loadEnvironmentProperties(@NotNull PropertyRegistry propertyRegistry) {
        Properties properties;
        Intrinsics.checkNotNullParameter(propertyRegistry, "");
        propertyRegistry.get_koin$koin_core().getLogger().debug("load properties from environment");
        Properties properties2 = System.getProperties();
        Intrinsics.checkNotNull(properties2);
        PropertyRegistryExtKt.saveProperties(propertyRegistry, properties2);
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, "");
        Map<String, String> map2 = map;
        Properties properties3 = properties = new Properties();
        properties3.putAll(map2);
        Properties properties4 = properties;
        PropertyRegistryExtKt.saveProperties(propertyRegistry, properties4);
    }
}

