/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.annotation.KoinInternalApi;
import org.koin.core.error.ScopeAlreadyCreatedException;
import org.koin.core.module.Module;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.qualifier.QualifierKt;
import org.koin.core.qualifier.StringQualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00112\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u0010H\u0001J(\u0010\u0019\u001a\u00020\u00112\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u001a\u001a\u00020\b2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0001J\u0019\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u0010H\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u001eJ\r\u0010 \u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\u001dH\u0002J\u0014\u0010#\u001a\u00020\u001d2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\nJ\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0012\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006)"}, d2={"Lorg/koin/core/registry/ScopeRegistry;", "", "_koin", "Lorg/koin/core/Koin;", "<init>", "(Lorg/koin/core/Koin;)V", "_scopeDefinitions", "", "Lorg/koin/core/qualifier/Qualifier;", "scopeDefinitions", "", "getScopeDefinitions", "()Ljava/util/Set;", "_scopes", "", "", "Lorg/koin/core/scope/ScopeID;", "Lorg/koin/core/scope/Scope;", "rootScope", "getRootScope$annotations", "()V", "getRootScope", "()Lorg/koin/core/scope/Scope;", "getScopeOrNull", "scopeId", "createScope", "qualifier", "source", "deleteScope", "", "deleteScope$koin_core", "scope", "close", "close$koin_core", "closeAllScopes", "loadScopes", "modules", "Lorg/koin/core/module/Module;", "loadModule", "module", "Companion", "koin-core"})
@SourceDebugExtension(value={"SMAP\nScopeRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScopeRegistry.kt\norg/koin/core/registry/ScopeRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1#2:116\n37#3,2:117\n13409#4,2:119\n1863#5,2:121\n*S KotlinDebug\n*F\n+ 1 ScopeRegistry.kt\norg/koin/core/registry/ScopeRegistry\n*L\n93#1:117,2\n93#1:119,2\n99#1:121,2\n*E\n"})
public final class ScopeRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Koin _koin;
    @NotNull
    private final Set<Qualifier> _scopeDefinitions;
    @NotNull
    private final Map<String, Scope> _scopes;
    @NotNull
    private final Scope rootScope;
    @NotNull
    private static final String ROOT_SCOPE_ID = "_root_";
    @NotNull
    private static final StringQualifier rootScopeQualifier = QualifierKt._q("_root_");

    public ScopeRegistry(@NotNull Koin koin) {
        Intrinsics.checkNotNullParameter(koin, "");
        this._koin = koin;
        this._scopeDefinitions = KoinPlatformTools.INSTANCE.safeSet();
        this._scopes = KoinPlatformTools.INSTANCE.safeHashMap();
        this.rootScope = new Scope(rootScopeQualifier, ROOT_SCOPE_ID, true, this._koin);
        this._scopeDefinitions.add(this.rootScope.getScopeQualifier());
        this._scopes.put(this.rootScope.getId(), this.rootScope);
    }

    @NotNull
    public final Set<Qualifier> getScopeDefinitions() {
        return this._scopeDefinitions;
    }

    @NotNull
    public final Scope getRootScope() {
        return this.rootScope;
    }

    @KoinInternalApi
    public static /* synthetic */ void getRootScope$annotations() {
    }

    @PublishedApi
    @Nullable
    public final Scope getScopeOrNull(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return this._scopes.get(string);
    }

    @PublishedApi
    @NotNull
    public final Scope createScope(@NotNull String string, @NotNull Qualifier qualifier, @Nullable Object object) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(qualifier, "");
        this._koin.getLogger().debug("| (+) Scope - id:'" + string + "' q:'" + qualifier + '\'');
        if (!this._scopeDefinitions.contains(qualifier)) {
            this._koin.getLogger().debug("| Scope '" + qualifier + "' not defined. Creating it ...");
            this._scopeDefinitions.add(qualifier);
        }
        if (this._scopes.containsKey(string)) {
            throw new ScopeAlreadyCreatedException("Scope with id '" + string + "' is already created");
        }
        Scope scope = new Scope(qualifier, string, false, this._koin, 4, null);
        Object object2 = object;
        if (object2 != null) {
            Object object3 = object2;
            boolean bl = false;
            this._koin.getLogger().debug("|- Scope source set id:'" + string + "' -> " + object);
            scope.setSourceValue(object);
        }
        Scope[] scopeArray = new Scope[]{this.rootScope};
        scope.linkTo(scopeArray);
        this._scopes.put(string, scope);
        return scope;
    }

    public static /* synthetic */ Scope createScope$default(ScopeRegistry scopeRegistry, String string, Qualifier qualifier, Object object, int n2, Object object2) {
        if ((n2 & 4) != 0) {
            object = null;
        }
        return scopeRegistry.createScope(string, qualifier, object);
    }

    public final void deleteScope$koin_core(@NotNull String string) {
        block0: {
            Intrinsics.checkNotNullParameter(string, "");
            Scope scope = this._scopes.get(string);
            if (scope == null) break block0;
            Scope scope2 = scope;
            boolean bl = false;
            this.deleteScope$koin_core(scope2);
        }
    }

    public final void deleteScope$koin_core(@NotNull Scope scope) {
        Intrinsics.checkNotNullParameter(scope, "");
        this._koin.getInstanceRegistry().dropScopeInstances$koin_core(scope);
        this._scopes.remove(scope.getId());
    }

    public final void close$koin_core() {
        this.closeAllScopes();
        this._scopes.clear();
        this._scopeDefinitions.clear();
    }

    private final void closeAllScopes() {
        Scope[] scopeArray = this._scopes.values();
        boolean bl = false;
        Scope[] scopeArray2 = scopeArray;
        scopeArray = scopeArray2.toArray(new Scope[0]);
        bl = false;
        int n2 = scopeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Scope scope;
            Scope scope2 = scope = scopeArray[i2];
            boolean bl2 = false;
            scope2.close();
        }
    }

    public final void loadScopes(@NotNull Set<Module> set2) {
        Intrinsics.checkNotNullParameter(set2, "");
        Iterable iterable = set2;
        boolean bl = false;
        for (Object t2 : iterable) {
            Module module = (Module)t2;
            boolean bl2 = false;
            this.loadModule(module);
        }
    }

    private final void loadModule(Module module) {
        this._scopeDefinitions.addAll((Collection<Qualifier>)module.getScopes());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/koin/core/registry/ScopeRegistry$Companion;", "", "<init>", "()V", "ROOT_SCOPE_ID", "", "rootScopeQualifier", "Lorg/koin/core/qualifier/StringQualifier;", "getRootScopeQualifier$annotations", "getRootScopeQualifier", "()Lorg/koin/core/qualifier/StringQualifier;", "koin-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StringQualifier getRootScopeQualifier() {
            return rootScopeQualifier;
        }

        @PublishedApi
        public static /* synthetic */ void getRootScopeQualifier$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

