/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.Unit;
import kotlin.collections.AbstractList;
import kotlin.collections.AbstractMutableList;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.internal.InlineOnly;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \\*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\\B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0007B\u0017\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\u0005\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0016\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0004H\u0083\b\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0011\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0083\bJ\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u000b\u0010#\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\r\u0010%\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010$J\u000b\u0010&\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\r\u0010'\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010$J\u0013\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00028\u0000\u00a2\u0006\u0002\u0010*J\u0013\u0010+\u001a\u00020\u00152\u0006\u0010)\u001a\u00028\u0000\u00a2\u0006\u0002\u0010*J\u000b\u0010,\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\r\u0010-\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010$J\u000b\u0010.\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\r\u0010/\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010$J\u0015\u00100\u001a\u00020\"2\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00101J\u001d\u00100\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00102J\u001e\u00103\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0002J\u0016\u00104\u001a\u00020\"2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016J\u001e\u00104\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016J\u0016\u00105\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001e\u00106\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010)\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u00107J\u0016\u00108\u001a\u00020\"2\u0006\u0010)\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u00101J\u0015\u00109\u001a\u00020\u00042\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010:J\u0015\u0010;\u001a\u00020\u00042\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010:J\u0015\u0010<\u001a\u00020\"2\u0006\u0010)\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00101J\u0015\u0010=\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010>\u001a\u00020\"2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016J\u0016\u0010?\u001a\u00020\"2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016J\u001d\u0010@\u001a\u00020\"2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\"0BH\u0082\bJ\b\u0010C\u001a\u00020\u0015H\u0016J'\u0010D\u001a\b\u0012\u0004\u0012\u0002HE0\r\"\u0004\b\u0001\u0010E2\f\u0010F\u001a\b\u0012\u0004\u0012\u0002HE0\rH\u0016\u00a2\u0006\u0002\u0010GJ\u0015\u0010D\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0016\u00a2\u0006\u0002\u0010HJ\u0018\u0010I\u001a\u00020\u00152\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u0004H\u0014J\u0018\u0010L\u001a\u00020\u00152\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u0004H\u0002J\u0018\u0010M\u001a\u00020\u00152\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u0004H\u0002J\u0018\u0010N\u001a\u00020\u00152\u0006\u0010O\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u0004H\u0002J\b\u0010Q\u001a\u00020\u0015H\u0002J)\u0010R\u001a\b\u0012\u0004\u0012\u0002HE0\r\"\u0004\b\u0001\u0010E2\f\u0010F\u001a\b\u0012\u0004\u0012\u0002HE0\rH\u0000\u00a2\u0006\u0004\bS\u0010GJ\u0017\u0010R\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0000\u00a2\u0006\u0004\bS\u0010HJ\u001d\u0010T\u001a\u00020\u00152\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bUJM\u0010V\u001a\u00020\u00152>\u0010W\u001a:\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\bY\u0012\b\bZ\u0012\u0004\b\b(\u000b\u0012\u001b\u0012\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r\u00a2\u0006\f\bY\u0012\b\bZ\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\u00150XH\u0000\u00a2\u0006\u0002\b[R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006]"}, d2={"Lkotlin/collections/ArrayDeque;", "E", "Lkotlin/collections/AbstractMutableList;", "initialCapacity", "", "<init>", "(I)V", "()V", "elements", "", "(Ljava/util/Collection;)V", "head", "elementData", "", "", "[Ljava/lang/Object;", "value", "size", "getSize", "()I", "ensureCapacity", "", "minCapacity", "copyElements", "newCapacity", "internalGet", "internalIndex", "(I)Ljava/lang/Object;", "positiveMod", "index", "negativeMod", "incremented", "decremented", "isEmpty", "", "first", "()Ljava/lang/Object;", "firstOrNull", "last", "lastOrNull", "addFirst", "element", "(Ljava/lang/Object;)V", "addLast", "removeFirst", "removeFirstOrNull", "removeLast", "removeLastOrNull", "add", "(Ljava/lang/Object;)Z", "(ILjava/lang/Object;)V", "copyCollectionElements", "addAll", "get", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "contains", "indexOf", "(Ljava/lang/Object;)I", "lastIndexOf", "remove", "removeAt", "removeAll", "retainAll", "filterInPlace", "predicate", "Lkotlin/Function1;", "clear", "toArray", "T", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "()[Ljava/lang/Object;", "removeRange", "fromIndex", "toIndex", "removeRangeShiftPreceding", "removeRangeShiftSucceeding", "nullifyNonEmpty", "internalFromIndex", "internalToIndex", "registerModification", "testToArray", "testToArray$kotlin_stdlib", "testRemoveRange", "testRemoveRange$kotlin_stdlib", "internalStructure", "structure", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "internalStructure$kotlin_stdlib", "Companion", "kotlin-stdlib"})
@SinceKotlin(version="1.4")
@SourceDebugExtension(value={"SMAP\nArrayDeque.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayDeque.kt\nkotlin/collections/ArrayDeque\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,660:1\n476#1,53:665\n476#1,53:718\n37#2:661\n36#2,3:662\n*S KotlinDebug\n*F\n+ 1 ArrayDeque.kt\nkotlin/collections/ArrayDeque\n*L\n471#1:665,53\n473#1:718,53\n46#1:661\n46#1:662,3\n*E\n"})
public final class ArrayDeque<E>
extends AbstractMutableList<E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int head;
    @NotNull
    private Object[] elementData;
    private int size;
    @NotNull
    private static final Object[] emptyElementData = new Object[0];
    private static final int defaultMinCapacity = 10;

    @Override
    public int getSize() {
        return this.size;
    }

    public ArrayDeque(int n2) {
        Object[] objectArray;
        if (n2 == 0) {
            objectArray = emptyElementData;
        } else if (n2 > 0) {
            objectArray = new Object[n2];
        } else {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        this.elementData = objectArray;
    }

    public ArrayDeque() {
        this.elementData = emptyElementData;
    }

    public ArrayDeque(@NotNull Collection<? extends E> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        Collection<E> collection2 = collection;
        boolean bl = false;
        Collection<E> collection3 = collection2;
        this.elementData = collection3.toArray(new Object[0]);
        this.size = this.elementData.length;
        if (this.elementData.length == 0) {
            this.elementData = emptyElementData;
        }
    }

    private final void ensureCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalStateException("Deque is too big.");
        }
        if (n2 <= this.elementData.length) {
            return;
        }
        if (this.elementData == emptyElementData) {
            this.elementData = new Object[RangesKt.coerceAtLeast(n2, 10)];
            return;
        }
        int n3 = AbstractList.Companion.newCapacity$kotlin_stdlib(this.elementData.length, n2);
        this.copyElements(n3);
    }

    private final void copyElements(int n2) {
        Object[] objectArray = new Object[n2];
        ArraysKt.copyInto(this.elementData, objectArray, 0, this.head, this.elementData.length);
        ArraysKt.copyInto(this.elementData, objectArray, this.elementData.length - this.head, 0, this.head);
        this.head = 0;
        this.elementData = objectArray;
    }

    @InlineOnly
    private final E internalGet(int n2) {
        return (E)this.elementData[n2];
    }

    private final int positiveMod(int n2) {
        return n2 >= this.elementData.length ? n2 - this.elementData.length : n2;
    }

    private final int negativeMod(int n2) {
        return n2 < 0 ? n2 + this.elementData.length : n2;
    }

    @InlineOnly
    private final int internalIndex(int n2) {
        return this.positiveMod(this.head + n2);
    }

    private final int incremented(int n2) {
        return n2 == ArraysKt.getLastIndex(this.elementData) ? 0 : n2 + 1;
    }

    private final int decremented(int n2) {
        return n2 == 0 ? ArraysKt.getLastIndex(this.elementData) : n2 - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public final E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("ArrayDeque is empty.");
        }
        return (E)this.elementData[this.head];
    }

    @Nullable
    public final E firstOrNull() {
        return (E)(this.isEmpty() ? null : this.elementData[this.head]);
    }

    public final E last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("ArrayDeque is empty.");
        }
        ArrayDeque arrayDeque = this;
        return (E)this.elementData[arrayDeque.positiveMod(arrayDeque.head + CollectionsKt.getLastIndex(this))];
    }

    @Nullable
    public final E lastOrNull() {
        Object object;
        if (this.isEmpty()) {
            object = null;
        } else {
            ArrayDeque arrayDeque = this;
            object = this.elementData[arrayDeque.positiveMod(arrayDeque.head + CollectionsKt.getLastIndex(this))];
        }
        return (E)object;
    }

    @Override
    public final void addFirst(E e2) {
        this.registerModification();
        this.ensureCapacity(this.size() + 1);
        this.head = this.decremented(this.head);
        this.elementData[this.head] = e2;
        this.size = this.size() + 1;
    }

    @Override
    public final void addLast(E e2) {
        this.registerModification();
        this.ensureCapacity(this.size() + 1);
        ArrayDeque arrayDeque = this;
        this.elementData[arrayDeque.positiveMod((int)(arrayDeque.head + this.size()))] = e2;
        this.size = this.size() + 1;
    }

    @Override
    public final E removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("ArrayDeque is empty.");
        }
        this.registerModification();
        Object object = this.elementData[this.head];
        this.elementData[this.head] = null;
        this.head = this.incremented(this.head);
        this.size = this.size() - 1;
        return (E)object;
    }

    @Nullable
    public final E removeFirstOrNull() {
        return this.isEmpty() ? null : (E)this.removeFirst();
    }

    @Override
    public final E removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("ArrayDeque is empty.");
        }
        this.registerModification();
        ArrayDeque arrayDeque = this;
        int n2 = arrayDeque.positiveMod(arrayDeque.head + CollectionsKt.getLastIndex(this));
        Object object = this.elementData[n2];
        this.elementData[n2] = null;
        this.size = this.size() - 1;
        return (E)object;
    }

    @Nullable
    public final E removeLastOrNull() {
        return this.isEmpty() ? null : (E)this.removeLast();
    }

    @Override
    public boolean add(E e2) {
        this.addLast(e2);
        return true;
    }

    @Override
    public void add(int n2, E e2) {
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(n2, this.size());
        if (n2 == this.size()) {
            this.addLast(e2);
            return;
        }
        if (n2 == 0) {
            this.addFirst(e2);
            return;
        }
        this.registerModification();
        this.ensureCapacity(this.size() + 1);
        ArrayDeque arrayDeque = this;
        int n3 = arrayDeque.positiveMod(arrayDeque.head + n2);
        if (n2 < this.size() + 1 >> 1) {
            Object[] objectArray;
            int n4 = this.decremented(n3);
            int n5 = this.decremented(this.head);
            if (n4 >= this.head) {
                this.elementData[n5] = this.elementData[this.head];
                objectArray = ArraysKt.copyInto(this.elementData, this.elementData, this.head, this.head + 1, n4 + 1);
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, this.head - 1, this.head, this.elementData.length);
                this.elementData[this.elementData.length - 1] = this.elementData[0];
                objectArray = ArraysKt.copyInto(this.elementData, this.elementData, 0, 1, n4 + 1);
            }
            this.elementData[n4] = e2;
            this.head = n5;
        } else {
            Object[] objectArray;
            ArrayDeque arrayDeque2 = this;
            int n6 = arrayDeque2.positiveMod(arrayDeque2.head + this.size());
            if (n3 < n6) {
                objectArray = ArraysKt.copyInto(this.elementData, this.elementData, n3 + 1, n3, n6);
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, 1, 0, n6);
                this.elementData[0] = this.elementData[this.elementData.length - 1];
                objectArray = ArraysKt.copyInto(this.elementData, this.elementData, n3 + 1, n3, this.elementData.length - 1);
            }
            this.elementData[n3] = e2;
        }
        this.size = this.size() + 1;
    }

    private final void copyCollectionElements(int n2, Collection<? extends E> collection) {
        int n3;
        Iterator<E> iterator2 = collection.iterator();
        int n4 = this.elementData.length;
        for (n3 = n2; n3 < n4 && iterator2.hasNext(); ++n3) {
            this.elementData[n3] = iterator2.next();
        }
        n4 = this.head;
        for (n3 = 0; n3 < n4 && iterator2.hasNext(); ++n3) {
            this.elementData[n3] = iterator2.next();
        }
        this.size = this.size() + collection.size();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        if (collection.isEmpty()) {
            return false;
        }
        this.registerModification();
        this.ensureCapacity(this.size() + collection.size());
        ArrayDeque arrayDeque = this;
        this.copyCollectionElements(arrayDeque.positiveMod(arrayDeque.head + this.size()), collection);
        return true;
    }

    @Override
    public boolean addAll(int n2, @NotNull Collection<? extends E> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(n2, this.size());
        if (collection.isEmpty()) {
            return false;
        }
        if (n2 == this.size()) {
            return this.addAll(collection);
        }
        this.registerModification();
        this.ensureCapacity(this.size() + collection.size());
        ArrayDeque arrayDeque = this;
        int n3 = arrayDeque.positiveMod(arrayDeque.head + this.size());
        ArrayDeque arrayDeque2 = this;
        int n4 = arrayDeque2.positiveMod(arrayDeque2.head + n2);
        int n5 = collection.size();
        if (n2 < this.size() + 1 >> 1) {
            Object[] objectArray;
            int n6 = this.head - n5;
            if (n4 >= this.head) {
                if (n6 >= 0) {
                    objectArray = ArraysKt.copyInto(this.elementData, this.elementData, n6, this.head, n4);
                } else {
                    int n7 = this.elementData.length - (n6 += this.elementData.length);
                    int n8 = n4 - this.head;
                    if (n7 >= n8) {
                        objectArray = ArraysKt.copyInto(this.elementData, this.elementData, n6, this.head, n4);
                    } else {
                        ArraysKt.copyInto(this.elementData, this.elementData, n6, this.head, this.head + n7);
                        objectArray = ArraysKt.copyInto(this.elementData, this.elementData, 0, this.head + n7, n4);
                    }
                }
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, n6, this.head, this.elementData.length);
                if (n5 >= n4) {
                    objectArray = ArraysKt.copyInto(this.elementData, this.elementData, this.elementData.length - n5, 0, n4);
                } else {
                    ArraysKt.copyInto(this.elementData, this.elementData, this.elementData.length - n5, 0, n5);
                    objectArray = ArraysKt.copyInto(this.elementData, this.elementData, 0, n5, n4);
                }
            }
            this.head = n6;
            this.copyCollectionElements(this.negativeMod(n4 - n5), collection);
        } else {
            Object[] objectArray;
            int n9 = n4 + n5;
            if (n4 < n3) {
                if (n3 + n5 <= this.elementData.length) {
                    objectArray = ArraysKt.copyInto(this.elementData, this.elementData, n9, n4, n3);
                } else if (n9 >= this.elementData.length) {
                    objectArray = ArraysKt.copyInto(this.elementData, this.elementData, n9 - this.elementData.length, n4, n3);
                } else {
                    int n10 = n3 + n5 - this.elementData.length;
                    ArraysKt.copyInto(this.elementData, this.elementData, 0, n3 - n10, n3);
                    objectArray = ArraysKt.copyInto(this.elementData, this.elementData, n9, n4, n3 - n10);
                }
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, n5, 0, n3);
                if (n9 >= this.elementData.length) {
                    objectArray = ArraysKt.copyInto(this.elementData, this.elementData, n9 - this.elementData.length, n4, this.elementData.length);
                } else {
                    ArraysKt.copyInto(this.elementData, this.elementData, 0, this.elementData.length - n5, this.elementData.length);
                    objectArray = ArraysKt.copyInto(this.elementData, this.elementData, n9, n4, this.elementData.length - n5);
                }
            }
            this.copyCollectionElements(n4, collection);
        }
        return true;
    }

    @Override
    public E get(int n2) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n2, this.size());
        ArrayDeque arrayDeque = this;
        return (E)this.elementData[arrayDeque.positiveMod(arrayDeque.head + n2)];
    }

    @Override
    public E set(int n2, E e2) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n2, this.size());
        ArrayDeque arrayDeque = this;
        int n3 = arrayDeque.positiveMod(arrayDeque.head + n2);
        Object object = this.elementData[n3];
        this.elementData[n3] = e2;
        return (E)object;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public int indexOf(Object object) {
        block4: {
            int n2;
            int n3;
            block3: {
                ArrayDeque arrayDeque = this;
                n3 = arrayDeque.positiveMod(arrayDeque.head + this.size());
                if (this.head >= n3) break block3;
                for (int i2 = this.head; i2 < n3; ++i2) {
                    if (!Intrinsics.areEqual(object, this.elementData[i2])) continue;
                    return i2 - this.head;
                }
                break block4;
            }
            if (this.head < n3) break block4;
            int n4 = this.elementData.length;
            for (n2 = this.head; n2 < n4; ++n2) {
                if (!Intrinsics.areEqual(object, this.elementData[n2])) continue;
                return n2 - this.head;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                if (!Intrinsics.areEqual(object, this.elementData[n2])) continue;
                return n2 + this.elementData.length - this.head;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        ArrayDeque arrayDeque = this;
        int n2 = arrayDeque.positiveMod(arrayDeque.head + this.size());
        if (this.head < n2) {
            int n3 = this.head;
            int n4 = n2 - 1;
            if (n3 <= n4) {
                while (true) {
                    if (Intrinsics.areEqual(object, this.elementData[n4])) {
                        return n4 - this.head;
                    }
                    if (n4 != n3) {
                        --n4;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.head > n2) {
            int n5;
            for (n5 = n2 - 1; -1 < n5; --n5) {
                if (!Intrinsics.areEqual(object, this.elementData[n5])) continue;
                return n5 + this.elementData.length - this.head;
            }
            int n6 = this.head;
            n5 = ArraysKt.getLastIndex(this.elementData);
            if (n6 <= n5) {
                while (true) {
                    if (Intrinsics.areEqual(object, this.elementData[n5])) {
                        return n5 - this.head;
                    }
                    if (n5 == n6) break;
                    --n5;
                }
            }
        }
        return -1;
    }

    @Override
    public boolean remove(Object object) {
        int n2 = this.indexOf(object);
        if (n2 == -1) {
            return false;
        }
        this.remove(n2);
        return true;
    }

    @Override
    public E removeAt(int n2) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n2, this.size());
        if (n2 == CollectionsKt.getLastIndex(this)) {
            return this.removeLast();
        }
        if (n2 == 0) {
            return this.removeFirst();
        }
        this.registerModification();
        ArrayDeque arrayDeque = this;
        int n3 = arrayDeque.positiveMod(arrayDeque.head + n2);
        Object object = this.elementData[n3];
        if (n2 < this.size() >> 1) {
            Object[] objectArray;
            if (n3 >= this.head) {
                objectArray = ArraysKt.copyInto(this.elementData, this.elementData, this.head + 1, this.head, n3);
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, 1, 0, n3);
                this.elementData[0] = this.elementData[this.elementData.length - 1];
                objectArray = ArraysKt.copyInto(this.elementData, this.elementData, this.head + 1, this.head, this.elementData.length - 1);
            }
            this.elementData[this.head] = null;
            this.head = this.incremented(this.head);
        } else {
            Object[] objectArray;
            ArrayDeque arrayDeque2 = this;
            int n4 = arrayDeque2.positiveMod(arrayDeque2.head + CollectionsKt.getLastIndex(this));
            if (n3 <= n4) {
                objectArray = ArraysKt.copyInto(this.elementData, this.elementData, n3, n3 + 1, n4 + 1);
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, n3, n3 + 1, this.elementData.length);
                this.elementData[this.elementData.length - 1] = this.elementData[0];
                objectArray = ArraysKt.copyInto(this.elementData, this.elementData, 0, 1, n4 + 1);
            }
            this.elementData[n4] = null;
        }
        this.size = this.size() - 1;
        return (E)object;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> collection) {
        boolean bl;
        Intrinsics.checkNotNullParameter(collection, "");
        ArrayDeque arrayDeque = this;
        boolean bl2 = false;
        if (arrayDeque.isEmpty() || arrayDeque.elementData.length == 0) {
            bl = false;
        } else {
            ArrayDeque arrayDeque2 = arrayDeque;
            int n2 = arrayDeque2.positiveMod(arrayDeque2.head + arrayDeque.size());
            int n3 = arrayDeque.head;
            boolean bl3 = false;
            if (arrayDeque.head < n2) {
                for (int i2 = arrayDeque.head; i2 < n2; ++i2) {
                    Object object;
                    Object object2 = object = arrayDeque.elementData[i2];
                    boolean bl4 = false;
                    if (!collection.contains(object2)) {
                        arrayDeque.elementData[n3++] = object;
                        continue;
                    }
                    bl3 = true;
                }
                ArraysKt.fill(arrayDeque.elementData, null, n3, n2);
            } else {
                boolean bl5;
                Object object;
                int n4;
                int n5 = arrayDeque.elementData.length;
                for (n4 = arrayDeque.head; n4 < n5; ++n4) {
                    Object object3 = arrayDeque.elementData[n4];
                    arrayDeque.elementData[n4] = null;
                    object = object3;
                    bl5 = false;
                    if (!collection.contains(object)) {
                        arrayDeque.elementData[n3++] = object3;
                        continue;
                    }
                    bl3 = true;
                }
                n3 = arrayDeque.positiveMod(n3);
                for (n4 = 0; n4 < n2; ++n4) {
                    Object object4 = arrayDeque.elementData[n4];
                    arrayDeque.elementData[n4] = null;
                    object = object4;
                    bl5 = false;
                    if (!collection.contains(object)) {
                        arrayDeque.elementData[n3] = object4;
                        n3 = arrayDeque.incremented(n3);
                        continue;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                arrayDeque.registerModification();
                arrayDeque.size = arrayDeque.negativeMod(n3 - arrayDeque.head);
            }
            bl = bl3;
        }
        return bl;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> collection) {
        boolean bl;
        Intrinsics.checkNotNullParameter(collection, "");
        ArrayDeque arrayDeque = this;
        boolean bl2 = false;
        if (arrayDeque.isEmpty() || arrayDeque.elementData.length == 0) {
            bl = false;
        } else {
            ArrayDeque arrayDeque2 = arrayDeque;
            int n2 = arrayDeque2.positiveMod(arrayDeque2.head + arrayDeque.size());
            int n3 = arrayDeque.head;
            boolean bl3 = false;
            if (arrayDeque.head < n2) {
                for (int i2 = arrayDeque.head; i2 < n2; ++i2) {
                    Object object;
                    Object object2 = object = arrayDeque.elementData[i2];
                    boolean bl4 = false;
                    if (collection.contains(object2)) {
                        arrayDeque.elementData[n3++] = object;
                        continue;
                    }
                    bl3 = true;
                }
                ArraysKt.fill(arrayDeque.elementData, null, n3, n2);
            } else {
                boolean bl5;
                Object object;
                int n4;
                int n5 = arrayDeque.elementData.length;
                for (n4 = arrayDeque.head; n4 < n5; ++n4) {
                    Object object3 = arrayDeque.elementData[n4];
                    arrayDeque.elementData[n4] = null;
                    object = object3;
                    bl5 = false;
                    if (collection.contains(object)) {
                        arrayDeque.elementData[n3++] = object3;
                        continue;
                    }
                    bl3 = true;
                }
                n3 = arrayDeque.positiveMod(n3);
                for (n4 = 0; n4 < n2; ++n4) {
                    Object object4 = arrayDeque.elementData[n4];
                    arrayDeque.elementData[n4] = null;
                    object = object4;
                    bl5 = false;
                    if (collection.contains(object)) {
                        arrayDeque.elementData[n3] = object4;
                        n3 = arrayDeque.incremented(n3);
                        continue;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                arrayDeque.registerModification();
                arrayDeque.size = arrayDeque.negativeMod(n3 - arrayDeque.head);
            }
            bl = bl3;
        }
        return bl;
    }

    private final boolean filterInPlace(Function1<? super E, Boolean> function1) {
        boolean bl = false;
        if (this.isEmpty() || this.elementData.length == 0) {
            return false;
        }
        ArrayDeque arrayDeque = this;
        int n2 = arrayDeque.positiveMod(arrayDeque.head + this.size());
        int n3 = this.head;
        boolean bl2 = false;
        if (this.head < n2) {
            for (int i2 = this.head; i2 < n2; ++i2) {
                Object object = this.elementData[i2];
                if (function1.invoke(object).booleanValue()) {
                    this.elementData[n3++] = object;
                    continue;
                }
                bl2 = true;
            }
            ArraysKt.fill(this.elementData, null, n3, n2);
        } else {
            int n4;
            int n5 = this.elementData.length;
            for (n4 = this.head; n4 < n5; ++n4) {
                Object object = this.elementData[n4];
                this.elementData[n4] = null;
                if (function1.invoke(object).booleanValue()) {
                    this.elementData[n3++] = object;
                    continue;
                }
                bl2 = true;
            }
            n3 = this.positiveMod(n3);
            for (n4 = 0; n4 < n2; ++n4) {
                Object object = this.elementData[n4];
                this.elementData[n4] = null;
                if (function1.invoke(object).booleanValue()) {
                    this.elementData[n3] = object;
                    n3 = this.incremented(n3);
                    continue;
                }
                bl2 = true;
            }
        }
        if (bl2) {
            this.registerModification();
            this.size = this.negativeMod(n3 - this.head);
        }
        return bl2;
    }

    @Override
    public void clear() {
        if (!((Collection)this).isEmpty()) {
            this.registerModification();
            ArrayDeque arrayDeque = this;
            int n2 = arrayDeque.positiveMod(arrayDeque.head + this.size());
            this.nullifyNonEmpty(this.head, n2);
        }
        this.head = 0;
        this.size = 0;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, "");
        Object[] objectArray = TArray.length >= this.size() ? TArray : ArraysKt.arrayOfNulls(TArray, this.size());
        ArrayDeque arrayDeque = this;
        int n2 = arrayDeque.positiveMod(arrayDeque.head + this.size());
        if (this.head < n2) {
            ArraysKt.copyInto$default(this.elementData, objectArray, 0, this.head, n2, 2, null);
        } else if (!((Collection)this).isEmpty()) {
            ArraysKt.copyInto(this.elementData, objectArray, 0, this.head, this.elementData.length);
            ArraysKt.copyInto(this.elementData, objectArray, this.elementData.length - this.head, 0, n2);
        }
        return CollectionsKt.terminateCollectionToArray(this.size(), objectArray);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    protected void removeRange(int n2, int n3) {
        int n4;
        AbstractList.Companion.checkRangeIndexes$kotlin_stdlib(n2, n3, this.size());
        int n5 = n4 = n3 - n2;
        if (n5 == 0) {
            return;
        }
        if (n5 == this.size()) {
            this.clear();
            return;
        }
        if (n5 == 1) {
            this.remove(n2);
            return;
        }
        this.registerModification();
        if (n2 < this.size() - n3) {
            this.removeRangeShiftPreceding(n2, n3);
            n5 = this.positiveMod(this.head + n4);
            this.nullifyNonEmpty(this.head, n5);
            this.head = n5;
        } else {
            this.removeRangeShiftSucceeding(n2, n3);
            ArrayDeque arrayDeque = this;
            n5 = arrayDeque.positiveMod(arrayDeque.head + this.size());
            this.nullifyNonEmpty(this.negativeMod(n5 - n4), n5);
        }
        this.size = this.size() - n4;
    }

    private final void removeRangeShiftPreceding(int n2, int n3) {
        int n4;
        ArrayDeque arrayDeque = this;
        int n5 = arrayDeque.positiveMod(arrayDeque.head + (n2 - 1));
        ArrayDeque arrayDeque2 = this;
        int n6 = arrayDeque2.positiveMod(arrayDeque2.head + (n3 - 1));
        for (int i2 = n2; i2 > 0; i2 -= n4) {
            int n7 = n5 + 1;
            int n8 = n6 + 1;
            n4 = Math.min(i2, Math.min(n7, n8));
            ArraysKt.copyInto(this.elementData, this.elementData, n6 - n4 + 1, n5 - n4 + 1, n5 + 1);
            n5 = this.negativeMod(n5 - n4);
            n6 = this.negativeMod(n6 - n4);
        }
    }

    private final void removeRangeShiftSucceeding(int n2, int n3) {
        int n4;
        ArrayDeque arrayDeque = this;
        int n5 = arrayDeque.positiveMod(arrayDeque.head + n3);
        ArrayDeque arrayDeque2 = this;
        int n6 = arrayDeque2.positiveMod(arrayDeque2.head + n2);
        for (int i2 = this.size() - n3; i2 > 0; i2 -= n4) {
            int n7 = this.elementData.length - n5;
            int n8 = this.elementData.length - n6;
            n4 = Math.min(i2, Math.min(n7, n8));
            ArraysKt.copyInto(this.elementData, this.elementData, n6, n5, n5 + n4);
            n5 = this.positiveMod(n5 + n4);
            n6 = this.positiveMod(n6 + n4);
        }
    }

    private final void nullifyNonEmpty(int n2, int n3) {
        if (n2 < n3) {
            ArraysKt.fill(this.elementData, null, n2, n3);
        } else {
            ArraysKt.fill(this.elementData, null, n2, this.elementData.length);
            ArraysKt.fill(this.elementData, null, 0, n3);
        }
    }

    private final void registerModification() {
        ++this.modCount;
    }

    @NotNull
    public final <T> T[] testToArray$kotlin_stdlib(@NotNull T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, "");
        return this.toArray(TArray);
    }

    @NotNull
    public final Object[] testToArray$kotlin_stdlib() {
        return this.toArray();
    }

    public final void testRemoveRange$kotlin_stdlib(int n2, int n3) {
        this.removeRange(n2, n3);
    }

    public final void internalStructure$kotlin_stdlib(@NotNull Function2<? super Integer, ? super Object[], Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, "");
        ArrayDeque arrayDeque = this;
        int n2 = arrayDeque.positiveMod(arrayDeque.head + this.size());
        int n3 = this.isEmpty() || this.head < n2 ? this.head : this.head - this.elementData.length;
        function2.invoke((Integer)n3, (Object[])this.toArray());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkotlin/collections/ArrayDeque$Companion;", "", "<init>", "()V", "emptyElementData", "", "[Ljava/lang/Object;", "defaultMinCapacity", "", "kotlin-stdlib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

