/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Arrays;
import java.util.Iterator;
import java.util.RandomAccess;
import kotlin.Metadata;
import kotlin.collections.AbstractIterator;
import kotlin.collections.AbstractList;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00060\u0003j\u0002`\u0004B\u001f\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\rJ\u0016\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0096\u0002J'\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006\"\u0004\b\u0001\u0010\u00012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006H\u0014\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u0014\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010 \u001a\u00020\tJ\u0013\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\tJ\u0015\u0010'\u001a\u00020\t*\u00020\t2\u0006\u0010&\u001a\u00020\tH\u0082\bR\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006("}, d2={"Lkotlin/collections/RingBuffer;", "T", "Lkotlin/collections/AbstractList;", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "buffer", "", "", "filledSize", "", "<init>", "([Ljava/lang/Object;I)V", "capacity", "(I)V", "[Ljava/lang/Object;", "startIndex", "value", "size", "getSize", "()I", "get", "index", "(I)Ljava/lang/Object;", "isFull", "", "iterator", "", "toArray", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "()[Ljava/lang/Object;", "expanded", "maxCapacity", "add", "", "element", "(Ljava/lang/Object;)V", "removeFirst", "n", "forward", "kotlin-stdlib"})
@SourceDebugExtension(value={"SMAP\nSlidingWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlidingWindow.kt\nkotlin/collections/RingBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n204#1:208\n204#1:209\n204#1:210\n1#2:207\n*S KotlinDebug\n*F\n+ 1 SlidingWindow.kt\nkotlin/collections/RingBuffer\n*L\n106#1:208\n175#1:209\n188#1:210\n*E\n"})
final class RingBuffer<T>
extends AbstractList<T>
implements RandomAccess {
    @NotNull
    private final Object[] buffer;
    private final int capacity;
    private int startIndex;
    private int size;

    public RingBuffer(@NotNull Object[] objectArray, int n2) {
        Intrinsics.checkNotNullParameter(objectArray, "");
        this.buffer = objectArray;
        if (!(n2 >= 0)) {
            boolean bl = false;
            String string = "ring buffer filled size should not be negative but it is " + n2;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(n2 <= this.buffer.length)) {
            boolean bl = false;
            String string = "ring buffer filled size: " + n2 + " cannot be larger than the buffer size: " + this.buffer.length;
            throw new IllegalArgumentException(string.toString());
        }
        this.capacity = this.buffer.length;
        this.size = n2;
    }

    public RingBuffer(int n2) {
        this(new Object[n2], 0);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public T get(int n2) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n2, this.size());
        RingBuffer ringBuffer = this;
        int n3 = this.startIndex;
        boolean bl = false;
        return (T)this.buffer[(n3 + n2) % ringBuffer.capacity];
    }

    public final boolean isFull() {
        return this.size() == this.capacity;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new AbstractIterator<T>(this){
            private int count;
            private int index;
            final /* synthetic */ RingBuffer<T> this$0;
            {
                this.this$0 = ringBuffer;
                this.count = ringBuffer.size();
                this.index = RingBuffer.access$getStartIndex$p(ringBuffer);
            }

            protected void computeNext() {
                if (this.count == 0) {
                    this.done();
                } else {
                    this.setNext(RingBuffer.access$getBuffer$p(this.this$0)[this.index]);
                    RingBuffer<T> ringBuffer = this.this$0;
                    int n2 = this.index;
                    int n3 = 1;
                    boolean bl = false;
                    this.index = (n2 + n3) % RingBuffer.access$getCapacity$p(ringBuffer);
                    int n4 = this.count;
                    this.count = n4 + -1;
                }
            }
        };
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] TArray) {
        int n2;
        T[] TArray2;
        Intrinsics.checkNotNullParameter(TArray, "");
        if (TArray.length < this.size()) {
            T[] TArray3 = Arrays.copyOf(TArray, this.size());
            TArray2 = TArray3;
            Intrinsics.checkNotNullExpressionValue(TArray3, "");
        } else {
            TArray2 = TArray;
        }
        T[] TArray4 = TArray2;
        int n3 = this.size();
        int n4 = 0;
        for (n2 = this.startIndex; n4 < n3 && n2 < this.capacity; ++n4, ++n2) {
            TArray4[n4] = this.buffer[n2];
        }
        n2 = 0;
        while (n4 < n3) {
            TArray4[n4] = this.buffer[n2];
            ++n4;
            ++n2;
        }
        return CollectionsKt.terminateCollectionToArray(n3, TArray4);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @NotNull
    public final RingBuffer<T> expanded(int n2) {
        Object[] objectArray;
        int n3 = RangesKt.coerceAtMost(this.capacity + (this.capacity >> 1) + 1, n2);
        if (this.startIndex == 0) {
            Object[] objectArray2 = Arrays.copyOf(this.buffer, n3);
            objectArray = objectArray2;
            Intrinsics.checkNotNullExpressionValue(objectArray2, "");
        } else {
            objectArray = this.toArray(new Object[n3]);
        }
        Object[] objectArray3 = objectArray;
        return new RingBuffer<T>(objectArray3, this.size());
    }

    public final void add(T t2) {
        if (this.isFull()) {
            throw new IllegalStateException("ring buffer is full");
        }
        RingBuffer ringBuffer = this;
        int n2 = this.startIndex;
        int n3 = this.size();
        boolean bl = false;
        this.buffer[(n2 + n3) % ((RingBuffer)ringBuffer).capacity] = t2;
        int n4 = this.size();
        this.size = n4 + 1;
    }

    public final void removeFirst(int n2) {
        if (!(n2 >= 0)) {
            boolean bl = false;
            String string = "n shouldn't be negative but it is " + n2;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(n2 <= this.size())) {
            boolean bl = false;
            String string = "n shouldn't be greater than the buffer size: n = " + n2 + ", size = " + this.size();
            throw new IllegalArgumentException(string.toString());
        }
        if (n2 > 0) {
            int n3 = this.startIndex;
            RingBuffer ringBuffer = this;
            int n4 = n3;
            boolean bl = false;
            int n5 = (n4 + n2) % ringBuffer.capacity;
            if (n3 > n5) {
                ArraysKt.fill(this.buffer, null, n3, this.capacity);
                ArraysKt.fill(this.buffer, null, 0, n5);
            } else {
                ArraysKt.fill(this.buffer, null, n3, n5);
            }
            this.startIndex = n5;
            this.size = this.size() - n2;
        }
    }

    private final int forward(int n2, int n3) {
        boolean bl = false;
        return (n2 + n3) % this.capacity;
    }

    public static final /* synthetic */ int access$getStartIndex$p(RingBuffer ringBuffer) {
        return ringBuffer.startIndex;
    }

    public static final /* synthetic */ Object[] access$getBuffer$p(RingBuffer ringBuffer) {
        return ringBuffer.buffer;
    }
}

