/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.DeprecatedSinceKotlin;
import kotlin.ExperimentalStdlibApi;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.SinceKotlin;
import kotlin.WasExperimental;
import kotlin.collections.AbstractList;
import kotlin.collections.ArraysKt;
import kotlin.internal.InlineOnly;
import kotlin.internal.LowPriorityInOverloadResolution;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.text.StringsKt__StringNumberConversionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=5, xi=49, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001d\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0081\b\u001a\u001d\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0001H\u0081\b\u001a\u001d\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0081\b\u001a\u001d\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0001H\u0081\b\u001a \u0010\b\u001a\u00020\t*\u0004\u0018\u00010\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a$\u0010\f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a$\u0010\f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a$\u0010\u0011\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a$\u0010\u0011\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a\r\u0010\u0012\u001a\u00020\u0002*\u00020\u0002H\u0087\b\u001a\r\u0010\u0013\u001a\u00020\u0002*\u00020\u0002H\u0087\b\u001a\r\u0010\u0014\u001a\u00020\u0002*\u00020\u0002H\u0087\b\u001a\r\u0010\u0015\u001a\u00020\u0002*\u00020\u0002H\u0087\b\u001a\f\u0010\u0016\u001a\u00020\u0002*\u00020\u0017H\u0007\u001a \u0010\u0016\u001a\u00020\u0002*\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00012\b\b\u0002\u0010\u0019\u001a\u00020\u0001H\u0007\u001a \u0010\u001a\u001a\u00020\u0017*\u00020\u00022\b\b\u0002\u0010\u0018\u001a\u00020\u00012\b\b\u0002\u0010\u0019\u001a\u00020\u0001H\u0007\u001a\f\u0010\u001b\u001a\u00020\u0002*\u00020\u001cH\u0007\u001a*\u0010\u001b\u001a\u00020\u0002*\u00020\u001c2\b\b\u0002\u0010\u0018\u001a\u00020\u00012\b\b\u0002\u0010\u0019\u001a\u00020\u00012\b\b\u0002\u0010\u001d\u001a\u00020\tH\u0007\u001a\f\u0010\u001e\u001a\u00020\u001c*\u00020\u0002H\u0007\u001a*\u0010\u001e\u001a\u00020\u001c*\u00020\u00022\b\b\u0002\u0010\u0018\u001a\u00020\u00012\b\b\u0002\u0010\u0019\u001a\u00020\u00012\b\b\u0002\u0010\u001d\u001a\u00020\tH\u0007\u001a\r\u0010\u001a\u001a\u00020\u0017*\u00020\u0002H\u0087\b\u001a3\u0010\u001a\u001a\u00020\u0017*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00172\b\b\u0002\u0010 \u001a\u00020\u00012\b\b\u0002\u0010\u0018\u001a\u00020\u00012\b\b\u0002\u0010\u0019\u001a\u00020\u0001H\u0087\b\u001a*\u0010!\u001a\u00020\u0002*\u00020\u00022\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0#\"\u0004\u0018\u00010$H\u0087\b\u00a2\u0006\u0002\u0010%\u001a2\u0010!\u001a\u00020\u0002*\u00020&2\u0006\u0010!\u001a\u00020\u00022\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0#\"\u0004\u0018\u00010$H\u0087\b\u00a2\u0006\u0002\u0010'\u001a4\u0010!\u001a\u00020\u0002*\u00020\u00022\b\u0010(\u001a\u0004\u0018\u00010)2\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0#\"\u0004\u0018\u00010$H\u0087\b\u00a2\u0006\u0002\u0010*\u001a<\u0010!\u001a\u00020\u0002*\u00020&2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010!\u001a\u00020\u00022\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0#\"\u0004\u0018\u00010$H\u0087\b\u00a2\u0006\u0002\u0010+\u001a\"\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020-*\u00020.2\u0006\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u00020\u0001\u001a\u0015\u00102\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0001H\u0087\b\u001a\u001d\u00102\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001H\u0087\b\u001a\u001c\u00103\u001a\u00020\t*\u00020\u00022\u0006\u00104\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a$\u00103\u001a\u00020\t*\u00020\u00022\u0006\u00104\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a\u001c\u00105\u001a\u00020\t*\u00020\u00022\u0006\u00106\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a)\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u00012\u0006\u0010;\u001a\u00020<H\u0087\b\u001a\u0019\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020<H\u0087\b\u001a!\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u0001H\u0087\b\u001a\u0011\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u00020\u001cH\u0087\b\u001a\u0011\u00107\u001a\u00020\u00022\u0006\u0010=\u001a\u00020\u0017H\u0087\b\u001a!\u00107\u001a\u00020\u00022\u0006\u0010=\u001a\u00020\u00172\u0006\u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u0001H\u0087\b\u001a!\u00107\u001a\u00020\u00022\u0006\u0010>\u001a\u00020?2\u0006\u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u0001H\u0087\b\u001a\u0011\u00107\u001a\u00020\u00022\u0006\u0010@\u001a\u00020AH\u0087\b\u001a\u0011\u00107\u001a\u00020\u00022\u0006\u0010B\u001a\u00020CH\u0087\b\u001a\u0015\u0010D\u001a\u00020\u0001*\u00020\u00022\u0006\u0010E\u001a\u00020\u0001H\u0087\b\u001a\u0015\u0010F\u001a\u00020\u0001*\u00020\u00022\u0006\u0010E\u001a\u00020\u0001H\u0087\b\u001a\u001d\u0010G\u001a\u00020\u0001*\u00020\u00022\u0006\u0010H\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001H\u0087\b\u001a\u001c\u0010I\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a\u0015\u0010J\u001a\u00020\t*\u00020\u00022\u0006\u0010K\u001a\u00020.H\u0087\b\u001a\u0015\u0010J\u001a\u00020\t*\u00020\u00022\u0006\u0010B\u001a\u00020AH\u0087\b\u001a\u0019\u0010J\u001a\u00020\t*\u0004\u0018\u00010.2\b\u0010\n\u001a\u0004\u0018\u00010.H\u0087\u0004\u001a \u0010J\u001a\u00020\t*\u0004\u0018\u00010.2\b\u0010\n\u001a\u0004\u0018\u00010.2\u0006\u0010\u000b\u001a\u00020\tH\u0007\u001a\r\u0010L\u001a\u00020\u0002*\u00020\u0002H\u0087\b\u001a\u001d\u0010M\u001a\u00020\u0001*\u00020\u00022\u0006\u0010E\u001a\u00020\u00012\u0006\u0010N\u001a\u00020\u0001H\u0087\b\u001a4\u0010O\u001a\u00020\t*\u00020.2\u0006\u0010P\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020.2\u0006\u0010Q\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a4\u0010O\u001a\u00020\t*\u00020\u00022\u0006\u0010P\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010Q\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a\u0015\u0010\u0014\u001a\u00020\u0002*\u00020\u00022\u0006\u0010(\u001a\u00020)H\u0087\b\u001a\u0015\u0010\u0015\u001a\u00020\u0002*\u00020\u00022\u0006\u0010(\u001a\u00020)H\u0087\b\u001a\u0015\u0010\u0012\u001a\u00020\u0002*\u00020\u00022\u0006\u0010(\u001a\u00020)H\u0087\b\u001a\u0015\u0010\u0013\u001a\u00020\u0002*\u00020\u00022\u0006\u0010(\u001a\u00020)H\u0087\b\u001a\u0017\u0010R\u001a\u00020\u001c*\u00020\u00022\b\b\u0002\u0010;\u001a\u00020<H\u0087\b\u001a\u0017\u0010S\u001a\u000200*\u00020\u00022\b\b\u0002\u0010T\u001a\u00020\u0001H\u0087\b\u001a\f\u0010U\u001a\u00020\u0002*\u00020\u0002H\u0007\u001a\u0014\u0010U\u001a\u00020\u0002*\u00020\u00022\u0006\u0010(\u001a\u00020)H\u0007\u001a\f\u0010V\u001a\u00020\u0002*\u00020\u0002H\u0007\u001a\u0014\u0010V\u001a\u00020\u0002*\u00020\u00022\u0006\u0010(\u001a\u00020)H\u0007\u001a\u0012\u0010W\u001a\u00020\u0002*\u00020.2\u0006\u0010X\u001a\u00020\u0001\"%\u0010Y\u001a\u0012\u0012\u0004\u0012\u00020\u00020Zj\b\u0012\u0004\u0012\u00020\u0002`[*\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010]\u00a8\u0006^"}, d2={"nativeIndexOf", "", "", "ch", "", "fromIndex", "str", "nativeLastIndexOf", "equals", "", "other", "ignoreCase", "replace", "oldChar", "newChar", "oldValue", "newValue", "replaceFirst", "toUpperCase", "uppercase", "toLowerCase", "lowercase", "concatToString", "", "startIndex", "endIndex", "toCharArray", "decodeToString", "", "throwOnInvalidSequence", "encodeToByteArray", "destination", "destinationOffset", "format", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "Lkotlin/String$Companion;", "(Lkotlin/jvm/internal/StringCompanionObject;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "locale", "Ljava/util/Locale;", "(Ljava/lang/String;Ljava/util/Locale;[Ljava/lang/Object;)Ljava/lang/String;", "(Lkotlin/jvm/internal/StringCompanionObject;Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "split", "", "", "regex", "Ljava/util/regex/Pattern;", "limit", "substring", "startsWith", "prefix", "endsWith", "suffix", "String", "bytes", "offset", "length", "charset", "Ljava/nio/charset/Charset;", "chars", "codePoints", "", "stringBuffer", "Ljava/lang/StringBuffer;", "stringBuilder", "Ljava/lang/StringBuilder;", "codePointAt", "index", "codePointBefore", "codePointCount", "beginIndex", "compareTo", "contentEquals", "charSequence", "intern", "offsetByCodePoints", "codePointOffset", "regionMatches", "thisOffset", "otherOffset", "toByteArray", "toPattern", "flags", "capitalize", "decapitalize", "repeat", "n", "CASE_INSENSITIVE_ORDER", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getCASE_INSENSITIVE_ORDER", "(Lkotlin/jvm/internal/StringCompanionObject;)Ljava/util/Comparator;", "kotlin-stdlib"}, xs="kotlin/text/StringsKt")
@SourceDebugExtension(value={"SMAP\nStringsJVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringsJVM.kt\nkotlin/text/StringsKt__StringsJVMKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,817:1\n1179#2,2:818\n1#3:820\n*S KotlinDebug\n*F\n+ 1 StringsJVM.kt\nkotlin/text/StringsKt__StringsJVMKt\n*L\n73#1:818,2\n*E\n"})
class StringsKt__StringsJVMKt
extends StringsKt__StringNumberConversionsKt {
    @InlineOnly
    private static final int nativeIndexOf(String string, char c2, int n2) {
        Intrinsics.checkNotNullParameter(string, "");
        return string.indexOf(c2, n2);
    }

    @InlineOnly
    private static final int nativeIndexOf(String string, String string2, int n2) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(string2, "");
        return string.indexOf(string2, n2);
    }

    @InlineOnly
    private static final int nativeLastIndexOf(String string, char c2, int n2) {
        Intrinsics.checkNotNullParameter(string, "");
        return string.lastIndexOf(c2, n2);
    }

    @InlineOnly
    private static final int nativeLastIndexOf(String string, String string2, int n2) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(string2, "");
        return string.lastIndexOf(string2, n2);
    }

    public static final boolean equals(@Nullable String string, @Nullable String string2, boolean bl) {
        if (string == null) {
            return string2 == null;
        }
        return !bl ? string.equals(string2) : string.equalsIgnoreCase(string2);
    }

    public static /* synthetic */ boolean equals$default(String string, String string2, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return StringsKt.equals(string, string2, bl);
    }

    @NotNull
    public static final String replace(@NotNull String string, char c2, char c3, boolean bl) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(string, "");
        if (!bl) {
            String string2 = string.replace(c2, c3);
            Intrinsics.checkNotNullExpressionValue(string2, "");
            return string2;
        }
        int n2 = string.length();
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder(n2);
        boolean bl2 = false;
        CharSequence charSequence = string;
        boolean bl3 = false;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c4;
            char c5 = c4 = charSequence.charAt(i2);
            boolean bl4 = false;
            stringBuilder2.append(CharsKt.equals(c5, c2, bl) ? c3 : c5);
        }
        return stringBuilder.toString();
    }

    public static /* synthetic */ String replace$default(String string, char c2, char c3, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return StringsKt.replace(string, c2, c3, bl);
    }

    @NotNull
    public static final String replace(@NotNull String string, @NotNull String string2, @NotNull String string3, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(string2, "");
        Intrinsics.checkNotNullParameter(string3, "");
        String string4 = string;
        boolean bl2 = false;
        int n2 = StringsKt.indexOf((CharSequence)string4, string2, 0, bl);
        if (n2 < 0) {
            return string4;
        }
        int n3 = string2.length();
        int n4 = RangesKt.coerceAtLeast(n3, 1);
        int n5 = string4.length() - n3 + string3.length();
        if (n5 < 0) {
            throw new OutOfMemoryError();
        }
        StringBuilder stringBuilder = new StringBuilder(n5);
        int n6 = 0;
        do {
            stringBuilder.append(string4, n6, n2).append(string3);
            n6 = n2 + n3;
        } while (n2 < string4.length() && (n2 = StringsKt.indexOf((CharSequence)string4, string2, n2 + n4, bl)) > 0);
        String string5 = stringBuilder.append(string4, n6, string4.length()).toString();
        Intrinsics.checkNotNullExpressionValue(string5, "");
        return string5;
    }

    public static /* synthetic */ String replace$default(String string, String string2, String string3, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return StringsKt.replace(string, string2, string3, bl);
    }

    @NotNull
    public static final String replaceFirst(@NotNull String string, char c2, char c3, boolean bl) {
        String string2;
        Intrinsics.checkNotNullParameter(string, "");
        int n2 = StringsKt.indexOf$default((CharSequence)string, c2, 0, bl, 2, null);
        if (n2 < 0) {
            string2 = string;
        } else {
            String string3 = string;
            int n3 = n2 + 1;
            CharSequence charSequence = String.valueOf(c3);
            string2 = ((Object)StringsKt.replaceRange((CharSequence)string3, n2, n3, charSequence)).toString();
        }
        return string2;
    }

    public static /* synthetic */ String replaceFirst$default(String string, char c2, char c3, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return StringsKt.replaceFirst(string, c2, c3, bl);
    }

    @NotNull
    public static final String replaceFirst(@NotNull String string, @NotNull String string2, @NotNull String string3, boolean bl) {
        String string4;
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(string2, "");
        Intrinsics.checkNotNullParameter(string3, "");
        int n2 = StringsKt.indexOf$default((CharSequence)string, string2, 0, bl, 2, null);
        if (n2 < 0) {
            string4 = string;
        } else {
            String string5 = string;
            int n3 = n2 + string2.length();
            string4 = ((Object)StringsKt.replaceRange((CharSequence)string5, n2, n3, (CharSequence)string3)).toString();
        }
        return string4;
    }

    public static /* synthetic */ String replaceFirst$default(String string, String string2, String string3, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return StringsKt.replaceFirst(string, string2, string3, bl);
    }

    @Deprecated(message="Use uppercase() instead.", replaceWith=@ReplaceWith(expression="uppercase(Locale.getDefault())", imports={"java.util.Locale"}))
    @DeprecatedSinceKotlin(warningSince="1.5", errorSince="2.1")
    @InlineOnly
    private static final String toUpperCase(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        String string2 = string.toUpperCase();
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    @InlineOnly
    private static final String uppercase(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @Deprecated(message="Use lowercase() instead.", replaceWith=@ReplaceWith(expression="lowercase(Locale.getDefault())", imports={"java.util.Locale"}))
    @DeprecatedSinceKotlin(warningSince="1.5", errorSince="2.1")
    @InlineOnly
    private static final String toLowerCase(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    @InlineOnly
    private static final String lowercase(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @SinceKotlin(version="1.4")
    @NotNull
    public static final String concatToString(@NotNull char[] cArray) {
        Intrinsics.checkNotNullParameter(cArray, "");
        return new String(cArray);
    }

    @SinceKotlin(version="1.4")
    @NotNull
    public static final String concatToString(@NotNull char[] cArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(cArray, "");
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(n2, n3, cArray.length);
        return new String(cArray, n2, n3 - n2);
    }

    public static /* synthetic */ String concatToString$default(char[] cArray, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = cArray.length;
        }
        return StringsKt.concatToString(cArray, n2, n3);
    }

    @SinceKotlin(version="1.4")
    @NotNull
    public static final char[] toCharArray(@NotNull String string, int n2, int n3) {
        Intrinsics.checkNotNullParameter(string, "");
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(n2, n3, string.length());
        String string2 = string;
        char[] cArray = new char[n3 - n2];
        int n4 = 0;
        string2.getChars(n2, n3, cArray, n4);
        return cArray;
    }

    public static /* synthetic */ char[] toCharArray$default(String string, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = string.length();
        }
        return StringsKt.toCharArray(string, n2, n3);
    }

    @SinceKotlin(version="1.4")
    @NotNull
    public static final String decodeToString(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "");
        return new String(byArray, Charsets.UTF_8);
    }

    @SinceKotlin(version="1.4")
    @NotNull
    public static final String decodeToString(@NotNull byte[] byArray, int n2, int n3, boolean bl) {
        Intrinsics.checkNotNullParameter(byArray, "");
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(n2, n3, byArray.length);
        if (!bl) {
            return new String(byArray, n2, n3 - n2, Charsets.UTF_8);
        }
        CharsetDecoder charsetDecoder = Charsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        String string = charsetDecoder.decode(ByteBuffer.wrap(byArray, n2, n3 - n2)).toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    public static /* synthetic */ String decodeToString$default(byte[] byArray, int n2, int n3, boolean bl, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = byArray.length;
        }
        if ((n4 & 4) != 0) {
            bl = false;
        }
        return StringsKt.decodeToString(byArray, n2, n3, bl);
    }

    @SinceKotlin(version="1.4")
    @NotNull
    public static final byte[] encodeToByteArray(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "");
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SinceKotlin(version="1.4")
    @NotNull
    public static final byte[] encodeToByteArray(@NotNull String string, int n2, int n3, boolean bl) {
        byte[] byArray;
        byte[] byArray2;
        Intrinsics.checkNotNullParameter(string, "");
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(n2, n3, string.length());
        if (!bl) {
            String string2 = string.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue(string2, "");
            String string3 = string2;
            Charset charset = Charsets.UTF_8;
            Intrinsics.checkNotNull(string3);
            byte[] byArray3 = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray3, "");
            return byArray3;
        }
        CharsetEncoder charsetEncoder = Charsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string, n2, n3));
        if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
            int n4 = byteBuffer.remaining();
            byte[] byArray4 = byteBuffer.array();
            Intrinsics.checkNotNull(byArray4);
            if (n4 == byArray4.length) {
                byte[] byArray5 = byteBuffer.array();
                Intrinsics.checkNotNull(byArray5);
                byArray2 = byArray5;
                return byArray2;
            }
        }
        byte[] byArray6 = byArray = new byte[byteBuffer.remaining()];
        boolean bl2 = false;
        byteBuffer.get(byArray6);
        byArray2 = byArray;
        return byArray2;
    }

    public static /* synthetic */ byte[] encodeToByteArray$default(String string, int n2, int n3, boolean bl, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = string.length();
        }
        if ((n4 & 4) != 0) {
            bl = false;
        }
        return StringsKt.encodeToByteArray(string, n2, n3, bl);
    }

    @InlineOnly
    private static final char[] toCharArray(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "");
        return cArray;
    }

    @InlineOnly
    private static final char[] toCharArray(String string, char[] cArray, int n2, int n3, int n4) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(cArray, "");
        string.getChars(n3, n4, cArray, n2);
        return cArray;
    }

    static /* synthetic */ char[] toCharArray$default(String string, char[] cArray, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 2) != 0) {
            n2 = 0;
        }
        if ((n5 & 4) != 0) {
            n3 = 0;
        }
        if ((n5 & 8) != 0) {
            n4 = string.length();
        }
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(cArray, "");
        string.getChars(n3, n4, cArray, n2);
        return cArray;
    }

    @InlineOnly
    private static final String format(String string, Object ... objectArray) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(objectArray, "");
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @InlineOnly
    private static final String format(StringCompanionObject stringCompanionObject, String string, Object ... objectArray) {
        Intrinsics.checkNotNullParameter(stringCompanionObject, "");
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(objectArray, "");
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @SinceKotlin(version="1.4")
    @InlineOnly
    private static final String format(String string, Locale locale, Object ... objectArray) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(objectArray, "");
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @SinceKotlin(version="1.4")
    @InlineOnly
    private static final String format(StringCompanionObject stringCompanionObject, Locale locale, String string, Object ... objectArray) {
        Intrinsics.checkNotNullParameter(stringCompanionObject, "");
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(objectArray, "");
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @NotNull
    public static final List<String> split(@NotNull CharSequence charSequence, @NotNull Pattern pattern, int n2) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Intrinsics.checkNotNullParameter(pattern, "");
        StringsKt.requireNonNegativeLimit(n2);
        String[] stringArray = pattern.split(charSequence, n2 == 0 ? -1 : n2);
        Intrinsics.checkNotNullExpressionValue(stringArray, "");
        return ArraysKt.asList((Object[])stringArray);
    }

    public static /* synthetic */ List split$default(CharSequence charSequence, Pattern pattern, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return StringsKt.split(charSequence, pattern, n2);
    }

    @InlineOnly
    private static final String substring(String string, int n2) {
        Intrinsics.checkNotNullParameter(string, "");
        String string2 = string.substring(n2);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @InlineOnly
    private static final String substring(String string, int n2, int n3) {
        Intrinsics.checkNotNullParameter(string, "");
        String string2 = string.substring(n2, n3);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    public static final boolean startsWith(@NotNull String string, @NotNull String string2, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(string2, "");
        if (!bl) {
            return string.startsWith(string2);
        }
        return StringsKt.regionMatches(string, 0, string2, 0, string2.length(), bl);
    }

    public static /* synthetic */ boolean startsWith$default(String string, String string2, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return StringsKt.startsWith(string, string2, bl);
    }

    public static final boolean startsWith(@NotNull String string, @NotNull String string2, int n2, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(string2, "");
        if (!bl) {
            return string.startsWith(string2, n2);
        }
        return StringsKt.regionMatches(string, n2, string2, 0, string2.length(), bl);
    }

    public static /* synthetic */ boolean startsWith$default(String string, String string2, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = false;
        }
        return StringsKt.startsWith(string, string2, n2, bl);
    }

    public static final boolean endsWith(@NotNull String string, @NotNull String string2, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(string2, "");
        if (!bl) {
            return string.endsWith(string2);
        }
        return StringsKt.regionMatches(string, string.length() - string2.length(), string2, 0, string2.length(), true);
    }

    public static /* synthetic */ boolean endsWith$default(String string, String string2, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return StringsKt.endsWith(string, string2, bl);
    }

    @InlineOnly
    private static final String String(byte[] byArray, int n2, int n3, Charset charset) {
        Intrinsics.checkNotNullParameter(byArray, "");
        Intrinsics.checkNotNullParameter(charset, "");
        return new String(byArray, n2, n3, charset);
    }

    @InlineOnly
    private static final String String(byte[] byArray, Charset charset) {
        Intrinsics.checkNotNullParameter(byArray, "");
        Intrinsics.checkNotNullParameter(charset, "");
        return new String(byArray, charset);
    }

    @InlineOnly
    private static final String String(byte[] byArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byArray, "");
        return new String(byArray, n2, n3, Charsets.UTF_8);
    }

    @InlineOnly
    private static final String String(byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "");
        return new String(byArray, Charsets.UTF_8);
    }

    @InlineOnly
    private static final String String(char[] cArray) {
        Intrinsics.checkNotNullParameter(cArray, "");
        return new String(cArray);
    }

    @InlineOnly
    private static final String String(char[] cArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(cArray, "");
        return new String(cArray, n2, n3);
    }

    @InlineOnly
    private static final String String(int[] nArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(nArray, "");
        return new String(nArray, n2, n3);
    }

    @InlineOnly
    private static final String String(StringBuffer stringBuffer) {
        Intrinsics.checkNotNullParameter(stringBuffer, "");
        return new String(stringBuffer);
    }

    @InlineOnly
    private static final String String(StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter(stringBuilder, "");
        return new String(stringBuilder);
    }

    @InlineOnly
    private static final int codePointAt(String string, int n2) {
        Intrinsics.checkNotNullParameter(string, "");
        return string.codePointAt(n2);
    }

    @InlineOnly
    private static final int codePointBefore(String string, int n2) {
        Intrinsics.checkNotNullParameter(string, "");
        return string.codePointBefore(n2);
    }

    @InlineOnly
    private static final int codePointCount(String string, int n2, int n3) {
        Intrinsics.checkNotNullParameter(string, "");
        return string.codePointCount(n2, n3);
    }

    public static final int compareTo(@NotNull String string, @NotNull String string2, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(string2, "");
        if (bl) {
            return string.compareToIgnoreCase(string2);
        }
        return string.compareTo(string2);
    }

    public static /* synthetic */ int compareTo$default(String string, String string2, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return StringsKt.compareTo(string, string2, bl);
    }

    @InlineOnly
    private static final boolean contentEquals(String string, CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(charSequence, "");
        return string.contentEquals(charSequence);
    }

    @InlineOnly
    private static final boolean contentEquals(String string, StringBuffer stringBuffer) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(stringBuffer, "");
        return string.contentEquals(stringBuffer);
    }

    @SinceKotlin(version="1.5")
    public static final boolean contentEquals(@Nullable CharSequence charSequence, @Nullable CharSequence charSequence2) {
        return charSequence instanceof String && charSequence2 != null ? ((String)charSequence).contentEquals(charSequence2) : StringsKt.contentEqualsImpl(charSequence, charSequence2);
    }

    @SinceKotlin(version="1.5")
    public static final boolean contentEquals(@Nullable CharSequence charSequence, @Nullable CharSequence charSequence2, boolean bl) {
        return bl ? StringsKt.contentEqualsIgnoreCaseImpl(charSequence, charSequence2) : StringsKt.contentEquals(charSequence, charSequence2);
    }

    @InlineOnly
    private static final String intern(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        String string2 = string.intern();
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @InlineOnly
    private static final int offsetByCodePoints(String string, int n2, int n3) {
        Intrinsics.checkNotNullParameter(string, "");
        return string.offsetByCodePoints(n2, n3);
    }

    public static final boolean regionMatches(@NotNull CharSequence charSequence, int n2, @NotNull CharSequence charSequence2, int n3, int n4, boolean bl) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Intrinsics.checkNotNullParameter(charSequence2, "");
        if (charSequence instanceof String && charSequence2 instanceof String) {
            return StringsKt.regionMatches((String)charSequence, n2, (String)charSequence2, n3, n4, bl);
        }
        return StringsKt.regionMatchesImpl(charSequence, n2, charSequence2, n3, n4, bl);
    }

    public static /* synthetic */ boolean regionMatches$default(CharSequence charSequence, int n2, CharSequence charSequence2, int n3, int n4, boolean bl, int n5, Object object) {
        if ((n5 & 0x10) != 0) {
            bl = false;
        }
        return StringsKt.regionMatches(charSequence, n2, charSequence2, n3, n4, bl);
    }

    public static final boolean regionMatches(@NotNull String string, int n2, @NotNull String string2, int n3, int n4, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(string2, "");
        return !bl ? string.regionMatches(n2, string2, n3, n4) : string.regionMatches(bl, n2, string2, n3, n4);
    }

    public static /* synthetic */ boolean regionMatches$default(String string, int n2, String string2, int n3, int n4, boolean bl, int n5, Object object) {
        if ((n5 & 0x10) != 0) {
            bl = false;
        }
        return StringsKt.regionMatches(string, n2, string2, n3, n4, bl);
    }

    @Deprecated(message="Use lowercase() instead.", replaceWith=@ReplaceWith(expression="lowercase(locale)", imports={}))
    @DeprecatedSinceKotlin(warningSince="1.5", errorSince="2.1")
    @InlineOnly
    private static final String toLowerCase(String string, Locale locale) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(locale, "");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    @InlineOnly
    private static final String lowercase(String string, Locale locale) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(locale, "");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @Deprecated(message="Use uppercase() instead.", replaceWith=@ReplaceWith(expression="uppercase(locale)", imports={}))
    @DeprecatedSinceKotlin(warningSince="1.5", errorSince="2.1")
    @InlineOnly
    private static final String toUpperCase(String string, Locale locale) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(locale, "");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalStdlibApi.class})
    @InlineOnly
    private static final String uppercase(String string, Locale locale) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(locale, "");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    @InlineOnly
    private static final byte[] toByteArray(String string, Charset charset) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(charset, "");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "");
        return byArray;
    }

    static /* synthetic */ byte[] toByteArray$default(String string, Charset charset, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(charset, "");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "");
        return byArray;
    }

    @InlineOnly
    private static final Pattern toPattern(String string, int n2) {
        Intrinsics.checkNotNullParameter(string, "");
        Pattern pattern = Pattern.compile(string, n2);
        Intrinsics.checkNotNullExpressionValue(pattern, "");
        return pattern;
    }

    static /* synthetic */ Pattern toPattern$default(String string, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 0;
        }
        Intrinsics.checkNotNullParameter(string, "");
        Pattern pattern = Pattern.compile(string, n2);
        Intrinsics.checkNotNullExpressionValue(pattern, "");
        return pattern;
    }

    @Deprecated(message="Use replaceFirstChar instead.", replaceWith=@ReplaceWith(expression="replaceFirstChar { if (it.isLowerCase()) it.titlecase(Locale.getDefault()) else it.toString() }", imports={"java.util.Locale"}))
    @DeprecatedSinceKotlin(warningSince="1.5")
    @NotNull
    public static final String capitalize(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "");
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "");
        return StringsKt.capitalize(string, locale);
    }

    @Deprecated(message="Use replaceFirstChar instead.", replaceWith=@ReplaceWith(expression="replaceFirstChar { if (it.isLowerCase()) it.titlecase(locale) else it.toString() }", imports={}))
    @DeprecatedSinceKotlin(warningSince="1.5")
    @SinceKotlin(version="1.4")
    @LowPriorityInOverloadResolution
    @NotNull
    public static final String capitalize(@NotNull String string, @NotNull Locale locale) {
        char c2;
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(locale, "");
        if (((CharSequence)string).length() > 0 && Character.isLowerCase(c2 = string.charAt(0))) {
            int n2;
            String string2;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2;
            StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            char c3 = Character.toTitleCase(c2);
            if (c3 != Character.toUpperCase(c2)) {
                stringBuilder = stringBuilder3.append(c3);
            } else {
                string2 = string;
                n2 = 0;
                int n3 = 1;
                String string3 = string2.substring(n2, n3);
                Intrinsics.checkNotNullExpressionValue(string3, "");
                string2 = string3;
                Intrinsics.checkNotNull(string2);
                String string4 = string2.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue(string4, "");
                stringBuilder = stringBuilder3.append(string4);
            }
            string2 = string;
            n2 = 1;
            String string5 = string2.substring(n2);
            Intrinsics.checkNotNullExpressionValue(string5, "");
            stringBuilder3.append(string5);
            return stringBuilder2.toString();
        }
        return string;
    }

    @Deprecated(message="Use replaceFirstChar instead.", replaceWith=@ReplaceWith(expression="replaceFirstChar { it.lowercase(Locale.getDefault()) }", imports={"java.util.Locale"}))
    @DeprecatedSinceKotlin(warningSince="1.5")
    @NotNull
    public static final String decapitalize(@NotNull String string) {
        String string2;
        Intrinsics.checkNotNullParameter(string, "");
        if (((CharSequence)string).length() > 0 && !Character.isLowerCase(string.charAt(0))) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = string;
            int n2 = 0;
            int n3 = 1;
            String string4 = string3.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue(string4, "");
            string3 = string4;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "");
            Locale locale2 = locale;
            Intrinsics.checkNotNull(string3);
            String string5 = string3.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue(string5, "");
            StringBuilder stringBuilder2 = stringBuilder.append(string5);
            string3 = string;
            int n4 = 1;
            String string6 = string3.substring(n4);
            Intrinsics.checkNotNullExpressionValue(string6, "");
            string2 = stringBuilder2.append(string6).toString();
        } else {
            string2 = string;
        }
        return string2;
    }

    @Deprecated(message="Use replaceFirstChar instead.", replaceWith=@ReplaceWith(expression="replaceFirstChar { it.lowercase(locale) }", imports={}))
    @DeprecatedSinceKotlin(warningSince="1.5")
    @SinceKotlin(version="1.4")
    @LowPriorityInOverloadResolution
    @NotNull
    public static final String decapitalize(@NotNull String string, @NotNull Locale locale) {
        String string2;
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(locale, "");
        if (((CharSequence)string).length() > 0 && !Character.isLowerCase(string.charAt(0))) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = string;
            int n2 = 0;
            int n3 = 1;
            String string4 = string3.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue(string4, "");
            string3 = string4;
            Intrinsics.checkNotNull(string3);
            String string5 = string3.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string5, "");
            StringBuilder stringBuilder2 = stringBuilder.append(string5);
            string3 = string;
            n2 = 1;
            String string6 = string3.substring(n2);
            Intrinsics.checkNotNullExpressionValue(string6, "");
            string2 = stringBuilder2.append(string6).toString();
        } else {
            string2 = string;
        }
        return string2;
    }

    @NotNull
    public static final String repeat(@NotNull CharSequence charSequence, int n2) {
        String string;
        Intrinsics.checkNotNullParameter(charSequence, "");
        if (!(n2 >= 0)) {
            boolean bl = false;
            String string2 = "Count 'n' must be non-negative, but was " + n2 + '.';
            throw new IllegalArgumentException(string2.toString());
        }
        block0 : switch (n2) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = ((Object)charSequence).toString();
                break;
            }
            default: {
                switch (charSequence.length()) {
                    case 0: {
                        string = "";
                        break block0;
                    }
                    case 1: {
                        char c2 = charSequence.charAt(0);
                        boolean bl = false;
                        int n3 = 0;
                        char[] cArray = new char[n2];
                        while (n3 < n2) {
                            int n4 = n3++;
                            cArray[n4] = c2;
                        }
                        char[] cArray2 = cArray;
                        string = new String(cArray2);
                        break block0;
                    }
                }
                StringBuilder stringBuilder = new StringBuilder(n2 * charSequence.length());
                int n5 = 1;
                if (n5 <= n2) {
                    while (true) {
                        stringBuilder.append(charSequence);
                        if (n5 == n2) break;
                        ++n5;
                    }
                }
                String string3 = stringBuilder.toString();
                Intrinsics.checkNotNull(string3);
                string = string3;
            }
        }
        return string;
    }

    @NotNull
    public static final Comparator<String> getCASE_INSENSITIVE_ORDER(@NotNull StringCompanionObject stringCompanionObject) {
        Intrinsics.checkNotNullParameter(stringCompanionObject, "");
        Comparator comparator = String.CASE_INSENSITIVE_ORDER;
        Intrinsics.checkNotNullExpressionValue(comparator, "");
        return comparator;
    }
}

