/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.logger.Level;
import org.koin.core.logger.Logger;
import org.koin.core.module.KoinApplicationDslMarker;
import org.koin.core.module.Module;
import org.koin.core.time.DurationExtKt;
import org.koin.mp.KoinPlatformTools;

@KoinApplicationDslMarker
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u001f\u0010\n\u001a\u00020\u00002\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\f\"\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\n\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0002J\u001a\u0010\u0013\u001a\u00020\u00002\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00010\u0015J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0010J\u001b\u0010\u001d\u001a\u00020\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/koin/core/KoinApplication;", "", "<init>", "()V", "koin", "Lorg/koin/core/Koin;", "getKoin", "()Lorg/koin/core/Koin;", "allowOverride", "", "modules", "Lorg/koin/core/module/Module;", "", "([Lorg/koin/core/module/Module;)Lorg/koin/core/KoinApplication;", "", "createEagerInstances", "", "override", "loadModules", "properties", "values", "", "", "logger", "Lorg/koin/core/logger/Logger;", "printLogger", "level", "Lorg/koin/core/logger/Level;", "close", "unloadModules", "unloadModules$koin_core", "module", "Companion", "koin-core"})
@SourceDebugExtension(value={"SMAP\nKoinApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KoinApplication.kt\norg/koin/core/KoinApplication\n+ 2 Logger.kt\norg/koin/core/logger/Logger\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,140:1\n43#2:141\n18#3,4:142\n50#3,7:146\n*S KotlinDebug\n*F\n+ 1 KoinApplication.kt\norg/koin/core/KoinApplication\n*L\n61#1:141\n62#1:142,4\n62#1:146,7\n*E\n"})
public final class KoinApplication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Koin koin = new Koin();
    private boolean allowOverride = true;

    private KoinApplication() {
    }

    @NotNull
    public final Koin getKoin() {
        return this.koin;
    }

    @NotNull
    public final KoinApplication modules(@NotNull Module module) {
        Intrinsics.checkNotNullParameter(module, "");
        return this.modules(CollectionsKt.listOf(module));
    }

    @NotNull
    public final KoinApplication modules(Module ... moduleArray) {
        Intrinsics.checkNotNullParameter(moduleArray, "");
        return this.modules(ArraysKt.toList(moduleArray));
    }

    @NotNull
    public final KoinApplication modules(@NotNull List<Module> list) {
        Intrinsics.checkNotNullParameter(list, "");
        Logger logger = this.koin.getLogger();
        Level level = Level.INFO;
        int n2 = 0;
        if (logger.getLevel().compareTo((Enum)level) <= 0) {
            n2 = 0;
            TimeSource.Monotonic monotonic = TimeSource.Monotonic.INSTANCE;
            boolean bl = false;
            long l2 = monotonic.markNow-z9LOYto();
            boolean bl2 = false;
            this.loadModules(list);
            long l3 = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc(l2);
            n2 = this.koin.getInstanceRegistry().size();
            this.koin.getLogger().display(Level.INFO, "Started " + n2 + " definitions in " + DurationExtKt.getInMs-LRDsOJo(l3) + " ms");
        } else {
            this.loadModules(list);
        }
        return this;
    }

    public final void createEagerInstances() {
        this.koin.createEagerInstances();
    }

    public final void allowOverride(boolean bl) {
        this.allowOverride = bl;
    }

    private final void loadModules(List<Module> list) {
        this.koin.loadModules(list, this.allowOverride, false);
    }

    @NotNull
    public final KoinApplication properties(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, "");
        this.koin.getPropertyRegistry().saveProperties(map);
        return this;
    }

    @NotNull
    public final KoinApplication logger(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(logger, "");
        this.koin.setupLogger(logger);
        return this;
    }

    @NotNull
    public final KoinApplication printLogger(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, "");
        this.koin.setupLogger(KoinPlatformTools.INSTANCE.defaultLogger(level));
        return this;
    }

    public static /* synthetic */ KoinApplication printLogger$default(KoinApplication koinApplication, Level level, int n2, Object object) {
        if ((n2 & 1) != 0) {
            level = Level.INFO;
        }
        return koinApplication.printLogger(level);
    }

    public final void close() {
        this.koin.close();
    }

    public final void unloadModules$koin_core(@NotNull List<Module> list) {
        Intrinsics.checkNotNullParameter(list, "");
        this.koin.unloadModules(list);
    }

    public final void unloadModules$koin_core(@NotNull Module module) {
        Intrinsics.checkNotNullParameter(module, "");
        this.koin.unloadModules(CollectionsKt.listOf(module));
    }

    public /* synthetic */ KoinApplication(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lorg/koin/core/KoinApplication$Companion;", "", "<init>", "()V", "init", "Lorg/koin/core/KoinApplication;", "koin-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KoinApplication init() {
            KoinApplication koinApplication = new KoinApplication(null);
            return koinApplication;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

