/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.mixins.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.player.ETFPlayerFeatureRenderer;
import traben.entity_texture_features.features.player.ETFPlayerSkinHolder;
import traben.entity_texture_features.features.player.ETFPlayerTexture;
import traben.entity_texture_features.features.state.ETFEntityRenderState;
import traben.entity_texture_features.features.state.HoldsETFRenderState;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;

@Mixin(value={AvatarRenderer.class})
public abstract class MixinPlayerEntityRenderer<AvatarlikeEntity extends Avatar>
extends LivingEntityRenderer<AvatarlikeEntity, AvatarRenderState, PlayerModel>
implements ETFPlayerSkinHolder {
    @Unique
    private ETFPlayerTexture etf$ETFPlayerTexture = null;

    @Shadow
    protected abstract void submitNameTag(AvatarRenderState var1, PoseStack var2, SubmitNodeCollector var3, CameraRenderState var4);

    public MixinPlayerEntityRenderer(EntityRendererProvider.Context ctx, PlayerModel model, float shadowRadius) {
        super(ctx, (EntityModel)model, shadowRadius);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;Z)V"}, at={@At(value="TAIL")})
    private void etf$addFeatures(EntityRendererProvider.Context ctx, boolean slim, CallbackInfo ci) {
        this.addLayer(new ETFPlayerFeatureRenderer(this));
    }

    @Inject(method={"renderHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;ILnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/model/geom/ModelPart;Z)V"}, at={@At(value="TAIL")})
    private void etf$renderHandFeatures(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int i, ResourceLocation resourceLocation, ModelPart modelPart, boolean bl, CallbackInfo ci) {
        for (ETFPlayerTexture skin : ETFManager.getInstance().PLAYER_TEXTURE_MAP.values()) {
            ResourceLocation enchant;
            if (!skin.getOriginal().equals((Object)resourceLocation)) continue;
            ResourceLocation emissive = skin.getBaseTextureEmissiveIdentifierOrNullForNone();
            if (emissive != null) {
                ETFUtils2.submitEmissiveModelPart(poseStack, submitNodeCollector, modelPart, emissive);
            }
            if ((enchant = skin.baseEnchantIdentifier) == null) break;
            ETFUtils2.submitEnchantedModelPart(poseStack, submitNodeCollector, i, modelPart, enchant);
            break;
        }
    }

    @Unique
    private void etf$renderOnce(PoseStack matrixStack, VertexConsumer consumer, int light, AbstractClientPlayer player, ModelPart armAndSleeve) {
        armAndSleeve.render(matrixStack, consumer, light, OverlayTexture.NO_OVERLAY);
    }

    @Inject(method={"getTextureLocation(Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="RETURN")}, cancellable=true)
    private void etf$getTexture(AvatarRenderState playerRenderState, CallbackInfoReturnable<ResourceLocation> cir) {
        ETFEntity eTFEntity;
        ETFEntityRenderState state = ((HoldsETFRenderState)playerRenderState).etf$getState();
        if (state == null || !((eTFEntity = state.entity()) instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer abstractClientPlayerEntity = (AbstractClientPlayer)eTFEntity;
        if (ETF.config().getConfig().skinFeaturesEnabled) {
            ResourceLocation texture;
            this.etf$ETFPlayerTexture = ETFManager.getInstance().getPlayerTexture((Player)abstractClientPlayerEntity, (ResourceLocation)cir.getReturnValue());
            if (this.etf$ETFPlayerTexture != null && this.etf$ETFPlayerTexture.hasFeatures && (texture = this.etf$ETFPlayerTexture.getBaseTextureIdentifierOrNullForVanilla((Player)abstractClientPlayerEntity)) != null) {
                cir.setReturnValue((Object)texture);
            }
        } else {
            this.etf$ETFPlayerTexture = null;
        }
    }

    @Override
    @Nullable
    public ETFPlayerTexture etf$getETFPlayerTexture() {
        return this.etf$ETFPlayerTexture;
    }
}

