/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.mixins.entity.renderer;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EnderDragonRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.utils.ETFUtils2;

@Mixin(value={EnderDragonRenderer.class})
public abstract class MixinEnderDragonEntityRenderer
extends EntityRenderer<EnderDragon, EnderDragonRenderState> {
    @Final
    @Shadow
    private static ResourceLocation DRAGON_LOCATION;
    @Final
    @Shadow
    private static ResourceLocation DRAGON_EYES_LOCATION;
    @Final
    @Shadow
    private static RenderType RENDER_TYPE;
    @Final
    @Shadow
    private static RenderType DECAL;
    @Final
    @Shadow
    private static RenderType EYES;

    protected MixinEnderDragonEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @ModifyArg(method={"submit(Lnet/minecraft/client/renderer/entity/state/EnderDragonRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/OrderedSubmitNodeCollector;submitModel(Lnet/minecraft/client/model/Model;Ljava/lang/Object;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/RenderType;IIILnet/minecraft/client/renderer/texture/TextureAtlasSprite;ILnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;)V"))
    private RenderType etf$returnAlteredTexture(RenderType texturedRenderLayer) {
        return MixinEnderDragonEntityRenderer.getType(texturedRenderLayer);
    }

    @ModifyArg(method={"submit(Lnet/minecraft/client/renderer/entity/state/EnderDragonRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/SubmitNodeCollector;submitModel(Lnet/minecraft/client/model/Model;Ljava/lang/Object;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/RenderType;IIILnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;)V"))
    private RenderType etf$returnAlteredTexture2(RenderType texturedRenderLayer) {
        return MixinEnderDragonEntityRenderer.getType(texturedRenderLayer);
    }

    @Unique
    @Nullable
    private static RenderType getType(RenderType texturedRenderLayer) {
        if (ETF.config().getConfig().canDoCustomTextures()) {
            try {
                if (DECAL.equals(texturedRenderLayer)) {
                    return RenderType.entityDecal((ResourceLocation)DRAGON_LOCATION);
                }
                if (RENDER_TYPE.equals(texturedRenderLayer)) {
                    return RenderType.entityCutoutNoCull((ResourceLocation)DRAGON_LOCATION);
                }
                if (EYES.equals(texturedRenderLayer)) {
                    return RenderType.eyes((ResourceLocation)DRAGON_EYES_LOCATION);
                }
            }
            catch (Exception e) {
                ETFUtils2.logError(e.toString(), false);
            }
        }
        return texturedRenderLayer;
    }
}

